/*
 * Decompiled with CFR 0.152.
 */
package org.aselect.server.cross.selectorhandler;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.logging.Level;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletResponse;
import org.aselect.server.config.ASelectConfigManager;
import org.aselect.server.config.Version;
import org.aselect.server.cross.CrossASelectManager;
import org.aselect.server.cross.ISelectorHandler;
import org.aselect.server.log.ASelectSystemLogger;
import org.aselect.server.sam.ASelectSAMAgent;
import org.aselect.server.session.SessionManager;
import org.aselect.system.communication.client.raw.RawCommunicator;
import org.aselect.system.exception.ASelectCommunicationException;
import org.aselect.system.exception.ASelectConfigException;
import org.aselect.system.exception.ASelectException;
import org.aselect.system.exception.ASelectSAMException;
import org.aselect.system.logging.SystemLogger;
import org.aselect.system.sam.agent.SAMResource;
import org.aselect.system.utils.Utils;

public class IdpSelectorHandler
implements ISelectorHandler {
    private static final String MODULE = "IdpSelectorHandler";
    private CrossASelectManager _crossASelectManager;
    private ASelectConfigManager _configManager;
    private ASelectSystemLogger _systemLogger;
    private RawCommunicator _oCommunicator;
    private String _sMyServerId = null;
    private String _sFriendlyName = null;
    private String _sHTMLSelectForm = null;
    private String _sIdPQueryServerId = null;
    private String _sIdPQueryServerResourceGroup = null;
    private String _sIdPQueryServerRequest = null;
    private String _sIdPQueryServerSharedSecret = null;
    private static final int COOKIE_AGE = 31536000;
    private static final String _sHtmlTemplateName = "idpcrossselect.html";

    public void init(Object object) throws ASelectException {
        String string = "init()";
        try {
            this._crossASelectManager = CrossASelectManager.getHandle();
            this._configManager = ASelectConfigManager.getHandle();
            this._systemLogger = ASelectSystemLogger.getHandle();
            this._oCommunicator = new RawCommunicator((SystemLogger)this._systemLogger);
            Object object2 = this._configManager.getSection(null, "aselect");
            this._sMyServerId = this._configManager.getParam(object2, "server_id");
            this._sFriendlyName = this._configManager.getParam(object2, "organization_friendly_name");
            Object object3 = null;
            try {
                object3 = this._configManager.getSection(object, "idp_query_server");
            }
            catch (ASelectConfigException aSelectConfigException) {
                this._systemLogger.log(Level.CONFIG, MODULE, string, "no section 'idp_query_server' found.");
                throw aSelectConfigException;
            }
            try {
                this._sIdPQueryServerId = this._configManager.getParam(object3, "id");
            }
            catch (ASelectConfigException aSelectConfigException) {
                this._systemLogger.log(Level.CONFIG, MODULE, string, "no param 'resourcegroup' found.");
                throw aSelectConfigException;
            }
            try {
                this._sIdPQueryServerRequest = this._configManager.getParam(object3, "request");
            }
            catch (ASelectConfigException aSelectConfigException) {
                this._systemLogger.log(Level.CONFIG, MODULE, string, "no param 'request' found.");
                throw aSelectConfigException;
            }
            try {
                this._sIdPQueryServerSharedSecret = this._configManager.getParam(object3, "shared_secret");
            }
            catch (ASelectConfigException aSelectConfigException) {
                this._systemLogger.log(Level.CONFIG, MODULE, string, "no param 'shared_secret' found, using none.");
            }
            this.getIdpQueryServerResourceGroup();
            this.loadHTMLTemplates();
        }
        catch (ASelectException aSelectException) {
            throw aSelectException;
        }
        catch (Exception exception) {
            this._systemLogger.log(Level.SEVERE, MODULE, string, "Could not initialize the default selector handler", (Throwable)exception);
            throw new ASelectException("0001", (Throwable)exception);
        }
    }

    public Hashtable getRemoteServerId(Hashtable hashtable, HttpServletResponse httpServletResponse, PrintWriter printWriter) throws ASelectException {
        String string = "IdpSelectorHandler.getRemoteServerId()";
        Hashtable<String, String> hashtable2 = null;
        String string2 = (String)hashtable.get("remote_organization");
        String string3 = (String)hashtable.get("home_idp");
        String string4 = (String)hashtable.get("home_organization");
        String string5 = (String)hashtable.get("user_id");
        this._systemLogger.log(Level.FINER, MODULE, string, "remote_organization: " + string2);
        this._systemLogger.log(Level.FINER, MODULE, string, "home_idp: " + string3);
        this._systemLogger.log(Level.FINER, MODULE, string, "home_organization: " + string4);
        this._systemLogger.log(Level.FINER, MODULE, string, "user_id: " + string5);
        if (string2 != null && !string2.equalsIgnoreCase("")) {
            hashtable2 = new Hashtable();
            hashtable2.put("organization_id", string2);
            if (string4 != null && !string4.equalsIgnoreCase("")) {
                hashtable2.put("home_idp", string4);
                if (string5 != null) {
                    hashtable2.put("user_id", string5);
                }
            }
            return hashtable2;
        }
        if (string5 != null) {
            hashtable2 = new Hashtable<String, String>();
            hashtable2.put("user_id", string5);
            hashtable2.put("organization_id", this._sIdPQueryServerId);
            return hashtable2;
        }
        if (string3 == null || string3.equalsIgnoreCase("")) {
            Hashtable hashtable3 = this.handleIdpApiCall();
            String string6 = (String)hashtable.get("aselect_home_idp");
            this.showSelectForm(hashtable, printWriter, hashtable3, string6);
        } else {
            hashtable2 = new Hashtable();
            Cookie cookie = new Cookie("aselect_home_idp", string3);
            cookie.setMaxAge(31536000);
            httpServletResponse.addCookie(cookie);
            Hashtable hashtable4 = this.handleIdpApiCall();
            hashtable2.put("organization_id", this._sIdPQueryServerId);
            String string7 = (String)hashtable4.get(string3);
            hashtable2.put("home_idp", string7);
            if (string5 != null) {
                hashtable2.put("user_id", string5);
            }
        }
        return hashtable2;
    }

    private void showSelectForm(Hashtable hashtable, PrintWriter printWriter, Hashtable hashtable2, String string) throws ASelectException {
        String string2 = "showSelectForm()";
        try {
            String string3 = this._sHTMLSelectForm;
            String string4 = null;
            String string5 = (String)hashtable.get("rid");
            String string6 = (String)hashtable.get("my_url");
            try {
                string4 = this.getIdpQueryServerUrl();
            }
            catch (ASelectException aSelectException) {
                this._systemLogger.log(Level.WARNING, MODULE, string2, "Error occured during retrieving IdpQueryUrl");
                throw aSelectException;
            }
            String string7 = string6 + "?request=error" + "&result_code=" + "0040" + "&a-select-server=" + this._sMyServerId + "&rid=" + (String)hashtable.get("rid");
            string3 = Utils.replaceString((String)string3, (String)"[rid]", (String)string5);
            string3 = Utils.replaceString((String)string3, (String)"[aselect_url]", (String)string6);
            string3 = Utils.replaceString((String)string3, (String)"[request]", (String)"cross_login");
            string3 = Utils.replaceString((String)string3, (String)"[a-select-server]", (String)this._sMyServerId);
            string3 = Utils.replaceString((String)string3, (String)"[remote_server]", (String)string4);
            string3 = Utils.replaceString((String)string3, (String)"[cancel]", (String)string7);
            string3 = Utils.replaceString((String)string3, (String)"[available_home_idps]", (String)this.getRemoteServerHTML(hashtable2, string));
            Hashtable hashtable3 = SessionManager.getHandle().getSessionContext(string5);
            if (hashtable3 != null) {
                string3 = this._configManager.updateTemplate(string3, hashtable3);
            }
            printWriter.println(string3);
        }
        catch (ASelectException aSelectException) {
            throw aSelectException;
        }
        catch (Exception exception) {
            this._systemLogger.log(Level.SEVERE, MODULE, string2, "Unexpected runtime error occured.", (Throwable)exception);
            throw new ASelectException("0001");
        }
    }

    private String getRemoteServerHTML(Hashtable hashtable, String string) {
        String string2 = "getRemoteServerHTML()";
        String string3 = null;
        String string4 = null;
        Enumeration enumeration = hashtable.keys();
        ArrayList arrayList = Collections.list(enumeration);
        Collections.sort(arrayList);
        enumeration = Collections.enumeration(arrayList);
        while (enumeration.hasMoreElements()) {
            string4 = (String)enumeration.nextElement();
            if (string != null && string.equals(string4)) {
                string3 = string3 + "<OPTION VALUE='" + string4 + "' selected=\"selected\">" + string4 + "</OPTION>\n";
                continue;
            }
            string3 = string3 + "<OPTION VALUE='" + string4 + "'>" + string4 + "</OPTION>\n";
        }
        this._systemLogger.log(Level.FINER, MODULE, string2, "Leaving function.");
        return string3;
    }

    private void loadHTMLTemplates() throws ASelectException {
        String string = "loadHTMLTemplates()";
        try {
            String string2 = this._configManager.getWorkingdir() + File.separator + "conf" + File.separator + "html" + File.separator;
            this._sHTMLSelectForm = this.loadHTMLTemplate(string2 + _sHtmlTemplateName);
            this._sHTMLSelectForm = Utils.replaceString((String)this._sHTMLSelectForm, (String)"[version]", (String)Version.getVersion());
            this._sHTMLSelectForm = Utils.replaceString((String)this._sHTMLSelectForm, (String)"[organization_friendly]", (String)this._sFriendlyName);
        }
        catch (ASelectException aSelectException) {
            throw aSelectException;
        }
        catch (Exception exception) {
            this._systemLogger.log(Level.SEVERE, MODULE, string, "Unexpected runtime error occurred :", (Throwable)exception);
            throw new ASelectException("0101");
        }
    }

    private String loadHTMLTemplate(String string) throws ASelectException {
        String string2 = new String();
        BufferedReader bufferedReader = null;
        String string3 = "loadHTMLTemplate()";
        try {
            String string4;
            bufferedReader = new BufferedReader(new InputStreamReader(new FileInputStream(string)));
            while ((string4 = bufferedReader.readLine()) != null) {
                string2 = string2 + string4 + "\n";
            }
        }
        catch (Exception exception) {
            StringBuffer stringBuffer = new StringBuffer("Could not load '");
            stringBuffer.append(string).append("'HTML template.");
            this._systemLogger.log(Level.WARNING, MODULE, string3, stringBuffer.toString(), (Throwable)exception);
            throw new ASelectException("4009", (Throwable)exception);
        }
        finally {
            try {
                bufferedReader.close();
            }
            catch (Exception exception) {
                StringBuffer stringBuffer = new StringBuffer("Could not close '");
                stringBuffer.append(string).append("' FileInputStream.");
                this._systemLogger.log(Level.WARNING, MODULE, string3, stringBuffer.toString(), (Throwable)exception);
            }
        }
        return string2;
    }

    private void getIdpQueryServerResourceGroup() throws ASelectException {
        String string = "getIdpQueryServerResourceGroup()";
        if (!this._crossASelectManager.getRemoteServers().containsKey(this._sIdPQueryServerId)) {
            this._systemLogger.log(Level.WARNING, MODULE, string, "There's no 'organization' found within the remote_servers section with id: '" + this._sIdPQueryServerId + "'");
            throw new ASelectException("4011");
        }
        try {
            Object object = this._configManager.getSection(null, "cross_aselect");
            Object object2 = this._configManager.getSection(object, "remote_servers");
            Object object3 = this._configManager.getSection(object2, "organization", "id=" + this._sIdPQueryServerId);
            this._sIdPQueryServerResourceGroup = this._configManager.getParam(object3, "resourcegroup");
        }
        catch (ASelectConfigException aSelectConfigException) {
            this._systemLogger.log(Level.WARNING, MODULE, string, "Error occured by retrieving 'resourcegroup' of the remote organization with id: '" + this._sIdPQueryServerId + "'");
            throw aSelectConfigException;
        }
        catch (Exception exception) {
            this._systemLogger.log(Level.SEVERE, MODULE, string, "Unexpected runtime error occured.", (Throwable)exception);
            throw new ASelectException("0001");
        }
    }

    private String getIdpQueryServerUrl() throws ASelectException {
        String string = "getUrl()";
        String string2 = null;
        SAMResource sAMResource = null;
        try {
            try {
                sAMResource = ASelectSAMAgent.getHandle().getActiveResource(this._sIdPQueryServerResourceGroup);
            }
            catch (ASelectSAMException aSelectSAMException) {
                this._systemLogger.log(Level.WARNING, MODULE, string, "Error occured during retrieving active resource in resourcegroup: '" + this._sIdPQueryServerResourceGroup + "'.");
                throw new ASelectException("0001");
            }
            Object object = sAMResource.getAttributes();
            try {
                string2 = this._configManager.getParam(object, "url");
            }
            catch (ASelectConfigException aSelectConfigException) {
                this._systemLogger.log(Level.WARNING, MODULE, string, "No resource retrieved for: '" + this._sIdPQueryServerResourceGroup + "'.");
                throw new ASelectException("0001");
            }
        }
        catch (ASelectException aSelectException) {
            throw aSelectException;
        }
        catch (Exception exception) {
            this._systemLogger.log(Level.WARNING, MODULE, string, "Exception occured", (Throwable)exception);
            throw new ASelectException("0001");
        }
        return string2;
    }

    private Hashtable handleIdpApiCall() throws ASelectException {
        String string = "handleIdpApiCall()";
        Hashtable hashtable = null;
        String string2 = this.getIdpQueryServerUrl();
        Hashtable<String, String> hashtable2 = new Hashtable<String, String>();
        hashtable2.put("request", this._sIdPQueryServerRequest);
        if (this._sIdPQueryServerSharedSecret != null) {
            hashtable2.put("shared_secret", this._sIdPQueryServerSharedSecret);
        }
        try {
            hashtable = this._oCommunicator.sendMessage(hashtable2, string2);
        }
        catch (ASelectCommunicationException aSelectCommunicationException) {
            this._systemLogger.log(Level.WARNING, MODULE, string, "Error occured during communication");
            throw new ASelectException("4006");
        }
        String string3 = (String)hashtable.get("result_code");
        if (string3 == null || !string3.trim().equalsIgnoreCase("0000")) {
            this._systemLogger.log(Level.WARNING, MODULE, string, "Invalid result from remote A-Selectserver: " + string3);
            throw new ASelectException("4006");
        }
        String string4 = (String)hashtable.get("result");
        String string5 = null;
        try {
            string5 = URLDecoder.decode(string4, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            this._systemLogger.log(Level.WARNING, MODULE, string, "");
            throw new ASelectException("4006");
        }
        Hashtable hashtable3 = Utils.convertCGIMessage((String)string5);
        return hashtable3;
    }
}

