/*
 * Decompiled with CFR 0.152.
 */
package org.aselect.authspserver.authsp.radius;

import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.security.MessageDigest;
import java.util.Random;
import java.util.logging.Level;
import org.aselect.authspserver.authsp.radius.AbstractRADIUSProtocolHandler;
import org.aselect.system.utils.Utils;

public class RADIUSCHAPProtocolHandler
extends AbstractRADIUSProtocolHandler {
    private byte _bIdentifier;
    private byte[] _baRandom;
    private DatagramSocket _listenSocket = null;
    private int _iSocketTimeout = 10000;
    private String _sErrorCode;
    private final String MODULE = "RADIUSPAPProtocolHandler";

    public String authenticate(String string) {
        String string2 = "authenticate()";
        this._sErrorCode = "900";
        try {
            int n;
            byte[] byArray = new byte[512];
            this._baRandom = new byte[16];
            if (!this._bFullUid && (n = this._sUid.indexOf(64)) > 0) {
                this._sUid = this._sUid.substring(0, n);
            }
            this._listenSocket = new DatagramSocket();
            DatagramPacket datagramPacket = new DatagramPacket(byArray, byArray.length);
            this.composeRequest(string, datagramPacket);
            if (this._sErrorCode != "000") {
                try {
                    this._listenSocket.close();
                }
                catch (Exception exception) {
                    this._systemLogger.log(Level.SEVERE, "RADIUSPAPProtocolHandler", string2, "exception while closing connection with RADIUS server at " + this._sRadiusServer + ": ", (Throwable)exception);
                }
                return this._sErrorCode;
            }
            this._listenSocket.setSoTimeout(this._iSocketTimeout);
            this._listenSocket.send(datagramPacket);
            this._listenSocket.receive(datagramPacket);
            this.handleResponse(datagramPacket);
            try {
                this._listenSocket.close();
            }
            catch (Exception exception) {
                this._systemLogger.log(Level.SEVERE, "RADIUSPAPProtocolHandler", string2, "exception while closing connection with RADIUS server at " + this._sRadiusServer + ": ", (Throwable)exception);
            }
        }
        catch (Exception exception) {
            this._systemLogger.log(Level.WARNING, "RADIUSPAPProtocolHandler", string2, "error in RADIUS communication", (Throwable)exception);
            try {
                this._listenSocket.close();
            }
            catch (Exception exception2) {
                this._systemLogger.log(Level.SEVERE, "RADIUSPAPProtocolHandler", string2, "exception while closing connection with RADIUS  server at " + this._sRadiusServer + ": ", (Throwable)exception2);
            }
            this._systemLogger.log(Level.SEVERE, "RADIUSPAPProtocolHandler", string2, "exception while authenticating user " + this._sUid + " with with RADIUS " + "server at " + this._sRadiusServer + ": ", (Throwable)exception);
            this._sErrorCode = "900";
        }
        return this._sErrorCode;
    }

    public void composeRequest(String string, DatagramPacket datagramPacket) throws Exception {
        String string2 = "composeRequest()";
        this._sErrorCode = "100";
        try {
            byte[] byArray = new byte[16];
            byte by = 0;
            int n = 0;
            MessageDigest messageDigest = MessageDigest.getInstance("MD5");
            datagramPacket.setAddress(InetAddress.getByName(this._sRadiusServer));
            datagramPacket.setPort(this._iPort);
            Random random = new Random();
            random.nextBytes(this._baRandom);
            this._bIdentifier = (byte)random.nextInt();
            random.nextBytes(byArray);
            messageDigest.update(by);
            messageDigest.update(string.getBytes());
            messageDigest.update(byArray);
            byte[] byArray2 = messageDigest.digest();
            byte[] byArray3 = datagramPacket.getData();
            byArray3[n++] = 1;
            byArray3[n++] = this._bIdentifier;
            byArray3[n++] = 0;
            byArray3[n++] = 0;
            System.arraycopy(this._baRandom, 0, byArray3, n, this._baRandom.length);
            n += this._baRandom.length;
            byArray3[n++] = 1;
            byArray3[n++] = (byte)(this._sUid.length() + 2);
            byte[] byArray4 = this._sUid.getBytes();
            System.arraycopy(byArray4, 0, byArray3, n, this._sUid.length());
            n += this._sUid.length();
            byArray3[n++] = 3;
            byArray3[n++] = 19;
            byArray3[n++] = by;
            System.arraycopy(byArray2, 0, byArray3, n, 16);
            n += 16;
            byArray3[n++] = 60;
            byArray3[n++] = 18;
            System.arraycopy(byArray, 0, byArray3, n, 16);
            byArray3[2] = (byte)((n += 16) >> 8);
            byArray3[3] = (byte)(n & 0xFF);
            datagramPacket.setData(byArray3);
            this._sErrorCode = "000";
        }
        catch (Exception exception) {
            this._systemLogger.log(Level.SEVERE, "RADIUSPAPProtocolHandler", string2, "INTERNAL ERROR", (Throwable)exception);
            throw exception;
        }
    }

    public void handleResponse(DatagramPacket datagramPacket) {
        String string = "handleResponse()";
        this._sErrorCode = "100";
        try {
            byte[] byArray = datagramPacket.getData();
            int n = 0;
            if (byArray[n++] != 2) {
                StringBuffer stringBuffer = new StringBuffer("RADIUS returned ACCESS DENIED for user: ");
                stringBuffer.append(this._sUid);
                this._systemLogger.log(Level.FINE, "RADIUSPAPProtocolHandler", string, stringBuffer.toString());
                this._sErrorCode = "800";
                return;
            }
            if (byArray[n++] != this._bIdentifier) {
                StringBuffer stringBuffer = new StringBuffer("RADIUS Identifier mismatch for user: ");
                stringBuffer.append(this._sUid);
                this._systemLogger.log(Level.FINE, "RADIUSPAPProtocolHandler", string, stringBuffer.toString());
                this._sErrorCode = "900";
                return;
            }
            int n2 = (byArray[2] & 0xFF) * 256 + (byArray[3] & 0xFF);
            byte[] byArray2 = new byte[16];
            System.arraycopy(byArray, n += 2, byArray2, 0, 16);
            byte[] byArray3 = new byte[n2 - 4 - 16];
            System.arraycopy(byArray, 20, byArray3, 0, byArray3.length);
            MessageDigest messageDigest = MessageDigest.getInstance("MD5");
            messageDigest.update((byte)2);
            messageDigest.update(this._bIdentifier);
            messageDigest.update(byArray[2]);
            messageDigest.update(byArray[3]);
            messageDigest.update(this._baRandom);
            messageDigest.update(byArray3);
            messageDigest.update(this._sSharedSecret.getBytes());
            byte[] byArray4 = messageDigest.digest();
            for (int i = 0; i < 16; ++i) {
                if (byArray2[i] == byArray4[i]) continue;
                StringBuffer stringBuffer = new StringBuffer("RADIUS Authenticator mismatchnServer\r\n");
                stringBuffer.append("Authenticator: ");
                stringBuffer.append(Utils.toHexString((byte[])byArray2));
                stringBuffer.append("\r\n Computed Authenticator: ");
                stringBuffer.append(Utils.toHexString((byte[])byArray4));
                this._systemLogger.log(Level.FINE, "RADIUSPAPProtocolHandler", string, stringBuffer.toString());
                this._systemLogger.log(Level.WARNING, "RADIUSPAPProtocolHandler", string, "RADIUS Authenticator mismatch");
                this._sErrorCode = "900";
                return;
            }
            this._sErrorCode = "000";
        }
        catch (Exception exception) {
            this._systemLogger.log(Level.SEVERE, "RADIUSPAPProtocolHandler", string, "INTERNAL ERROR", (Throwable)exception);
            this._sErrorCode = "100";
        }
    }
}

