/*
 * Decompiled with CFR 0.152.
 */
package org.aselect.authspserver.authsp.radius;

import java.util.Hashtable;
import java.util.logging.Level;
import org.aselect.authspserver.authsp.radius.IRADIUSProtocolHandler;
import org.aselect.authspserver.config.AuthSPConfigManager;
import org.aselect.system.exception.ASelectConfigException;
import org.aselect.system.logging.SystemLogger;

public class RADIUSProtocolHandlerFactory {
    private static final String MODULE = "RADIUSProtocolHandlerFactory";

    static IRADIUSProtocolHandler instantiateProtocolHandler(Object object, String string, SystemLogger systemLogger) {
        String string2 = "instantiateProtocolHandler()";
        try {
            Hashtable hashtable = RADIUSProtocolHandlerFactory.getContext(object, string, systemLogger);
            if (hashtable == null) {
                return null;
            }
            String string3 = (String)hashtable.get("radius_server");
            Integer n = (Integer)hashtable.get("port");
            String string4 = (String)hashtable.get("shared_secret");
            Boolean bl = (Boolean)hashtable.get("full_uid");
            String string5 = (String)hashtable.get("handler");
            Class<?> clazz = Class.forName(string5);
            IRADIUSProtocolHandler iRADIUSProtocolHandler = (IRADIUSProtocolHandler)clazz.newInstance();
            if (!iRADIUSProtocolHandler.init(string3, n, string4, bl, string, systemLogger)) {
                return null;
            }
            return iRADIUSProtocolHandler;
        }
        catch (Exception exception) {
            systemLogger.log(Level.SEVERE, MODULE, string2, "INTERNE ERROR", (Throwable)exception);
            return null;
        }
    }

    static Hashtable getContext(Object object, String string, SystemLogger systemLogger) {
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        String string2 = "getContext()";
        AuthSPConfigManager authSPConfigManager = AuthSPConfigManager.getHandle();
        try {
            CharSequence charSequence;
            int n;
            int n2 = string.indexOf(64);
            if (n2 <= 0) {
                StringBuffer stringBuffer = new StringBuffer("invalid user id (").append(string).append(") ");
                stringBuffer.append("User id should be [user]@[realm].");
                systemLogger.log(Level.SEVERE, MODULE, string2, stringBuffer.toString());
                return null;
            }
            String string3 = string.substring(n2);
            if (string3.length() <= 0) {
                StringBuffer stringBuffer = new StringBuffer("could not determine realm for user id ");
                stringBuffer.append(string).append(". Should be [user]@[realm].");
                systemLogger.log(Level.SEVERE, MODULE, string2, stringBuffer.toString());
                return null;
            }
            Object object2 = null;
            try {
                object2 = authSPConfigManager.getSection(object, "back-end_server", "realm=" + string3);
            }
            catch (ASelectConfigException aSelectConfigException) {
                object2 = null;
            }
            try {
                if (object2 == null) {
                    object2 = authSPConfigManager.getSection(object, "back-end_server", "realm=*");
                }
            }
            catch (ASelectConfigException aSelectConfigException) {
                object2 = null;
            }
            if (object2 == null) {
                try {
                    object2 = authSPConfigManager.getSection(object, "back-end_server");
                }
                catch (ASelectConfigException aSelectConfigException) {
                    object2 = null;
                }
                while (object2 != null) {
                    try {
                        authSPConfigManager.getParam(object2, "realm");
                    }
                    catch (ASelectConfigException aSelectConfigException) {
                        break;
                    }
                    object2 = authSPConfigManager.getNextSection(object2);
                }
                if (object2 != null) {
                    StringBuffer stringBuffer = new StringBuffer("no radius server defined for realm ");
                    stringBuffer.append(string3).append(" while authenticating ");
                    stringBuffer.append(string);
                    systemLogger.log(Level.SEVERE, MODULE, string2, stringBuffer.toString());
                    return null;
                }
            }
            String string4 = null;
            try {
                string4 = authSPConfigManager.getParam(object2, "host");
            }
            catch (ASelectConfigException aSelectConfigException) {
                StringBuffer stringBuffer = new StringBuffer("no radius server defined for realm ");
                stringBuffer.append(string3).append(" while authenticating ");
                stringBuffer.append(string);
                systemLogger.log(Level.SEVERE, MODULE, string2, stringBuffer.toString());
                return null;
            }
            String string5 = null;
            try {
                string5 = authSPConfigManager.getParam(object2, "port");
                n = Integer.parseInt(string5);
            }
            catch (ASelectConfigException aSelectConfigException) {
                n = 1812;
            }
            String string6 = null;
            try {
                string6 = authSPConfigManager.getParam(object2, "shared_secret");
            }
            catch (ASelectConfigException aSelectConfigException) {
                StringBuffer stringBuffer = new StringBuffer("no shared_secret defined for realm ");
                stringBuffer.append(string3).append(" while authenticating ");
                stringBuffer.append(string);
                systemLogger.log(Level.SEVERE, MODULE, string2, stringBuffer.toString());
                return null;
            }
            boolean bl = false;
            String string7 = null;
            try {
                string7 = authSPConfigManager.getParam(object2, "full_uid");
            }
            catch (ASelectConfigException aSelectConfigException) {
                string7 = "false";
                StringBuffer stringBuffer = new StringBuffer("No 'full_uid' defined for realm ");
                stringBuffer.append(string3);
                stringBuffer.append("; using default: full_uid = ");
                stringBuffer.append(string7);
                systemLogger.log(Level.CONFIG, MODULE, string2, stringBuffer.toString(), (Throwable)aSelectConfigException);
            }
            if (string7.equalsIgnoreCase("true")) {
                bl = true;
            } else if (string7.equalsIgnoreCase("false")) {
                bl = false;
            } else {
                charSequence = new StringBuffer("Invalid 'full_uid' config item defined for realm ");
                ((StringBuffer)charSequence).append(string3);
                ((StringBuffer)charSequence).append(" : ");
                ((StringBuffer)charSequence).append(string7);
                ((StringBuffer)charSequence).append("; using default: full_uid = false");
                systemLogger.log(Level.CONFIG, MODULE, string2, ((StringBuffer)charSequence).toString());
            }
            try {
                string5 = authSPConfigManager.getParam(object2, "method");
            }
            catch (ASelectConfigException aSelectConfigException) {
                StringBuffer stringBuffer = new StringBuffer("no method defined for realm ");
                stringBuffer.append(string3).append(" while authenticating ");
                stringBuffer.append(string);
                systemLogger.log(Level.SEVERE, MODULE, string2, stringBuffer.toString());
                return null;
            }
            charSequence = null;
            try {
                charSequence = authSPConfigManager.getParam(object, string5 + "_protocolhandler");
            }
            catch (ASelectConfigException aSelectConfigException) {
                StringBuffer stringBuffer = new StringBuffer("no protocol handler defined for realm");
                stringBuffer.append(string3).append(" while authenticating ");
                stringBuffer.append(string);
                systemLogger.log(Level.SEVERE, MODULE, string2, stringBuffer.toString());
                return null;
            }
            hashtable.put("radius_server", string4);
            hashtable.put("port", new Integer(n));
            hashtable.put("shared_secret", string6);
            hashtable.put("full_uid", new Boolean(bl));
            hashtable.put("handler", charSequence);
            return hashtable;
        }
        catch (Exception exception) {
            systemLogger.log(Level.SEVERE, MODULE, string2, "INTERNAL ERROR", (Throwable)exception);
            return null;
        }
    }
}

