/*
 * Decompiled with CFR 0.152.
 */
package org.aselect.authspserver.authsp.radius;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.Hashtable;
import java.util.Properties;
import java.util.logging.Level;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.aselect.authspserver.authsp.radius.IRADIUSProtocolHandler;
import org.aselect.authspserver.authsp.radius.RADIUSProtocolHandlerFactory;
import org.aselect.authspserver.config.AuthSPConfigManager;
import org.aselect.authspserver.crypto.CryptoEngine;
import org.aselect.authspserver.log.AuthSPAuthenticationLogger;
import org.aselect.authspserver.log.AuthSPSystemLogger;
import org.aselect.system.exception.ASelectConfigException;
import org.aselect.system.exception.ASelectException;
import org.aselect.system.logging.SystemLogger;
import org.aselect.system.servlet.ASelectHttpServlet;
import org.aselect.system.utils.Utils;

public class RadiusAuthSP
extends ASelectHttpServlet {
    private CryptoEngine _cryptoEngine;
    private String _sWorkingDir;
    private AuthSPAuthenticationLogger _authenticationLogger;
    private AuthSPSystemLogger _systemLogger;
    private String _sFailureHandling;
    private String _sErrorHtmlTemplate;
    private String _sAuthenticateHtmlTemplate;
    private Properties _oErrorProperties;
    private String _sFriendlyName;
    private int _iAllowedRetries;
    private AuthSPConfigManager _configManager;
    private Object _oAuthSPConfig;
    private final String MODULE = "RadiusAuthSP";
    private final String VERSION = "A-Select RADIUS AuthSP 1.5";
    private static final String DEFAULT_FAILUREHANDLING = "aselect";

    public void init(ServletConfig servletConfig) throws ServletException {
        String string = "init()";
        try {
            super.init(servletConfig);
            this._authenticationLogger = AuthSPAuthenticationLogger.getHandle();
            this._systemLogger = AuthSPSystemLogger.getHandle();
            StringBuffer stringBuffer = new StringBuffer("Starting : ");
            stringBuffer.append("RadiusAuthSP");
            this._systemLogger.log(Level.INFO, "RadiusAuthSP", string, stringBuffer.toString());
            this._configManager = AuthSPConfigManager.getHandle();
            String string2 = servletConfig.getInitParameter("config_id");
            if (string2 == null) {
                this._systemLogger.log(Level.SEVERE, "RadiusAuthSP", string, "No 'config_id' found as init-parameter in web.xml.");
                throw new ASelectException("100");
            }
            ServletContext servletContext = servletConfig.getServletContext();
            this._sWorkingDir = (String)servletContext.getAttribute("working_dir");
            if (this._sWorkingDir == null) {
                this._systemLogger.log(Level.SEVERE, "RadiusAuthSP", string, "working_dir attribute not found in servlet context. ");
                throw new ServletException("100");
            }
            this._systemLogger.log(Level.INFO, "RadiusAuthSP", string, "Successfully loaded 'working_dir'");
            this._sFriendlyName = (String)servletContext.getAttribute("friendly_name");
            if (this._sFriendlyName == null) {
                this._systemLogger.log(Level.SEVERE, "RadiusAuthSP", string, "friendly_name not found in servlet context. ");
                throw new ServletException("100");
            }
            this._systemLogger.log(Level.INFO, "RadiusAuthSP", string, "Successfully loaded 'friendly_name'.");
            this._cryptoEngine = (CryptoEngine)servletContext.getAttribute("CryptoEngine");
            if (this._cryptoEngine == null) {
                this._systemLogger.log(Level.SEVERE, "RadiusAuthSP", string, "Crypto Engine not found in servlet context. ");
                throw new ServletException("100");
            }
            this._systemLogger.log(Level.INFO, "RadiusAuthSP", string, "Successfully loaded CryptoEngine.");
            try {
                this._oAuthSPConfig = this._configManager.getSection(null, "authsp", "id=" + string2);
            }
            catch (ASelectConfigException aSelectConfigException) {
                this._systemLogger.log(Level.SEVERE, "RadiusAuthSP", string, "No valid 'authsp' config section found with id='" + string2 + "'.");
                throw new ASelectException("100", (Throwable)aSelectConfigException);
            }
            StringBuffer stringBuffer2 = new StringBuffer(this._sWorkingDir);
            stringBuffer2.append(File.separator);
            stringBuffer2.append("conf");
            stringBuffer2.append(File.separator);
            stringBuffer2.append(string2);
            stringBuffer2.append(File.separator);
            stringBuffer2.append("errors");
            stringBuffer2.append(File.separator);
            stringBuffer2.append("errors.conf");
            File file = new File(stringBuffer2.toString());
            if (!file.exists()) {
                StringBuffer stringBuffer3 = new StringBuffer("The error configuration file does not exist: \"");
                stringBuffer3.append(stringBuffer2.toString()).append("\".");
                this._systemLogger.log(Level.WARNING, "RadiusAuthSP", string, stringBuffer3.toString());
                throw new ASelectException("100");
            }
            this._oErrorProperties = new Properties();
            this._oErrorProperties.load(new FileInputStream(stringBuffer2.toString()));
            stringBuffer = new StringBuffer("Successfully loaded ");
            stringBuffer.append(this._oErrorProperties.size());
            stringBuffer.append(" error messages from: \"");
            stringBuffer.append(stringBuffer2.toString()).append("\".");
            this._systemLogger.log(Level.INFO, "RadiusAuthSP", string, stringBuffer.toString());
            this._sErrorHtmlTemplate = this._configManager.loadHTMLTemplate(this._sWorkingDir, "error.html", string2, this._sFriendlyName, "A-Select RADIUS AuthSP 1.5");
            this._systemLogger.log(Level.INFO, "RadiusAuthSP", string, "Successfully loaded 'error.html' template.");
            this._sAuthenticateHtmlTemplate = this._configManager.loadHTMLTemplate(this._sWorkingDir, "authenticate.html", string2, this._sFriendlyName, "A-Select RADIUS AuthSP 1.5");
            this._systemLogger.log(Level.INFO, "RadiusAuthSP", string, "Successfully loaded 'authenticate.html' template.");
            try {
                this._iAllowedRetries = Integer.parseInt(this._configManager.getParam(this._oAuthSPConfig, "allowed_retries"));
            }
            catch (ASelectConfigException aSelectConfigException) {
                this._systemLogger.log(Level.SEVERE, "RadiusAuthSP", string, "Could not find 'allowed_retries' in configuration", (Throwable)aSelectConfigException);
                throw new ASelectException("100");
            }
            catch (NumberFormatException numberFormatException) {
                this._systemLogger.log(Level.WARNING, "RadiusAuthSP", string, "Invalid 'allowed_retries' parameter found in configuration", (Throwable)numberFormatException);
                throw new ASelectException("100", (Throwable)numberFormatException);
            }
            try {
                this._sFailureHandling = this._configManager.getParam(this._oAuthSPConfig, "failure_handling");
            }
            catch (ASelectConfigException aSelectConfigException) {
                this._sFailureHandling = DEFAULT_FAILUREHANDLING;
                this._systemLogger.log(Level.CONFIG, "RadiusAuthSP", string, "No 'failure_handling' parameter found in configuration, using default: aselect", (Throwable)aSelectConfigException);
            }
            if (!this._sFailureHandling.equalsIgnoreCase(DEFAULT_FAILUREHANDLING) && !this._sFailureHandling.equalsIgnoreCase("local")) {
                StringBuffer stringBuffer4 = new StringBuffer("Invalid 'failure_handling' parameter found in configuration: '");
                stringBuffer4.append(this._sFailureHandling);
                stringBuffer4.append("', using default: aselect");
                this._sFailureHandling = DEFAULT_FAILUREHANDLING;
                this._systemLogger.log(Level.CONFIG, "RadiusAuthSP", string, stringBuffer4.toString());
            }
            stringBuffer = new StringBuffer("Successfully started ");
            stringBuffer.append("A-Select RADIUS AuthSP 1.5").append(".");
            this._systemLogger.log(Level.INFO, "RadiusAuthSP", string, stringBuffer.toString());
        }
        catch (ASelectException aSelectException) {
            this._systemLogger.log(Level.SEVERE, "RadiusAuthSP", string, "Could not initialize", (Throwable)aSelectException);
            throw new ServletException("Could not initialize.", (Throwable)aSelectException);
        }
        catch (Exception exception) {
            this._systemLogger.log(Level.SEVERE, "RadiusAuthSP", string, "Could not initialize due to internal error", (Throwable)exception);
            throw new ServletException("Could not initialize due to internal error.", (Throwable)exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doGet(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        String string = "doGet()";
        PrintWriter printWriter = null;
        String string2 = "";
        try {
            String string3;
            httpServletResponse.setContentType("text/html");
            printWriter = httpServletResponse.getWriter();
            this.setDisableCachingHttpHeaders(httpServletRequest, httpServletResponse);
            string2 = httpServletRequest.getQueryString();
            Hashtable hashtable = Utils.convertCGIMessage((String)string2);
            String string4 = httpServletRequest.getRequestURL().toString();
            hashtable.put("my_url", string4);
            String string5 = (String)hashtable.get("rid");
            String string6 = (String)hashtable.get("as_url");
            String string7 = (String)hashtable.get("uid");
            String string8 = (String)hashtable.get("a-select-server");
            String string9 = (String)hashtable.get("signature");
            if (string5 == null || string6 == null || string7 == null || string8 == null || string9 == null) {
                throw new ASelectException("200");
            }
            String string10 = (String)hashtable.get("country");
            if (string10 == null || string10.trim().length() < 1) {
                string10 = null;
            }
            if ((string3 = (String)hashtable.get("language")) == null || string3.trim().length() < 1) {
                string3 = null;
            }
            string6 = URLDecoder.decode(string6, "UTF-8");
            string7 = URLDecoder.decode(string7, "UTF-8");
            string9 = URLDecoder.decode(string9, "UTF-8");
            StringBuffer stringBuffer = new StringBuffer(string5);
            stringBuffer.append(string6);
            stringBuffer.append(string7);
            stringBuffer.append(string8);
            if (string10 != null) {
                stringBuffer.append(string10);
            }
            if (string3 != null) {
                stringBuffer.append(string3);
            }
            if (!this._cryptoEngine.verifySignature(string8, stringBuffer.toString(), string9)) {
                StringBuffer stringBuffer2 = new StringBuffer("Invalid signature from A-Select Server '");
                stringBuffer2.append(string8);
                stringBuffer2.append("' for user: ");
                stringBuffer2.append(string7);
                this._systemLogger.log(Level.WARNING, "RadiusAuthSP", string, stringBuffer2.toString());
                throw new ASelectException("200");
            }
            if (RADIUSProtocolHandlerFactory.getContext(this._oAuthSPConfig, string7, (SystemLogger)this._systemLogger) == null) {
                throw new ASelectException("900");
            }
            hashtable.put("as_url", string6);
            hashtable.put("uid", string7);
            hashtable.put("signature", string9);
            hashtable.put("retry_counter", "1");
            if (string10 != null) {
                hashtable.put("country", string10);
            }
            if (string3 != null) {
                hashtable.put("language", string3);
            }
            this.showAuthenticateForm(printWriter, " ", " ", hashtable);
        }
        catch (ASelectException aSelectException) {
            this._systemLogger.log(Level.WARNING, "RadiusAuthSP", string, "Sending error to client", (Throwable)aSelectException);
            this.handleResult(httpServletRequest, httpServletResponse, printWriter, aSelectException.getMessage());
        }
        catch (IOException iOException) {
            this._systemLogger.log(Level.WARNING, "RadiusAuthSP", string, "Error sending response", (Throwable)iOException);
            if (!httpServletResponse.isCommitted()) {
                httpServletResponse.sendError(500);
            }
        }
        catch (Exception exception) {
            this._systemLogger.log(Level.SEVERE, "RadiusAuthSP", string, "Could not process request due to internal error", (Throwable)exception);
            this.handleResult(httpServletRequest, httpServletResponse, printWriter, "900");
        }
        finally {
            if (printWriter != null) {
                printWriter.close();
                printWriter = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doPost(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        String string = "doPost()";
        PrintWriter printWriter = null;
        try {
            String string2;
            printWriter = httpServletResponse.getWriter();
            httpServletResponse.setContentType("text/html");
            this.setDisableCachingHttpHeaders(httpServletRequest, httpServletResponse);
            String string3 = httpServletRequest.getRequestURL().toString();
            String string4 = httpServletRequest.getParameter("rid");
            String string5 = httpServletRequest.getParameter("as_url");
            String string6 = httpServletRequest.getParameter("uid");
            String string7 = httpServletRequest.getParameter("a-select-server");
            String string8 = httpServletRequest.getParameter("password");
            String string9 = httpServletRequest.getParameter("signature");
            String string10 = httpServletRequest.getParameter("retry_counter");
            if (string4 == null || string5 == null || string6 == null || string8 == null || string9 == null || string7 == null) {
                this._systemLogger.log(Level.WARNING, "RadiusAuthSP", string, "Invalid request received: one or more mandatory parameters missing.");
                throw new ASelectException("200");
            }
            String string11 = httpServletRequest.getParameter("country");
            if (string11 == null || string11.trim().length() < 1) {
                string11 = null;
            }
            if ((string2 = httpServletRequest.getParameter("language")) == null || string2.trim().length() < 1) {
                string2 = null;
            }
            if ((string8 = string8.trim()).length() < 1) {
                Hashtable<String, String> hashtable = new Hashtable<String, String>();
                hashtable.put("my_url", string3);
                hashtable.put("rid", string4);
                hashtable.put("a-select-server", string7);
                hashtable.put("as_url", string5);
                hashtable.put("uid", string6);
                hashtable.put("signature", string9);
                hashtable.put("retry_counter", string10);
                if (string11 != null) {
                    hashtable.put("country", string11);
                }
                if (string2 != null) {
                    hashtable.put("language", string2);
                }
                this.showAuthenticateForm(printWriter, " ", " ", hashtable);
                return;
            }
            StringBuffer stringBuffer = new StringBuffer(string4);
            stringBuffer.append(string5);
            stringBuffer.append(string6);
            stringBuffer.append(string7);
            if (string11 != null) {
                stringBuffer.append(string11);
            }
            if (string2 != null) {
                stringBuffer.append(string2);
            }
            if (!this._cryptoEngine.verifySignature(string7, stringBuffer.toString(), string9)) {
                StringBuffer stringBuffer2 = new StringBuffer("Invalid signature from A-Select Server '");
                stringBuffer2.append(string7);
                stringBuffer2.append("' for user: ");
                stringBuffer2.append(string6);
                this._systemLogger.log(Level.WARNING, "RadiusAuthSP", string, stringBuffer2.toString());
                throw new ASelectException("200");
            }
            int n = -1;
            try {
                n = Integer.parseInt(string10);
            }
            catch (NumberFormatException numberFormatException) {
                StringBuffer stringBuffer3 = new StringBuffer("Invalid retry counter parameter in request '");
                stringBuffer3.append(string10);
                stringBuffer3.append("' for user: ");
                stringBuffer3.append(string6);
                this._systemLogger.log(Level.WARNING, "RadiusAuthSP", string, stringBuffer3.toString(), (Throwable)numberFormatException);
                throw new ASelectException("200", (Throwable)numberFormatException);
            }
            IRADIUSProtocolHandler iRADIUSProtocolHandler = RADIUSProtocolHandlerFactory.instantiateProtocolHandler(this._oAuthSPConfig, string6, (SystemLogger)this._systemLogger);
            if (iRADIUSProtocolHandler == null) {
                throw new ASelectException("900");
            }
            String string12 = iRADIUSProtocolHandler.authenticate(string8);
            if (string12.equals("800") && n < this._iAllowedRetries) {
                Hashtable<String, String> hashtable = new Hashtable<String, String>();
                hashtable.put("my_url", string3);
                hashtable.put("as_url", string5);
                hashtable.put("uid", string6);
                hashtable.put("rid", string4);
                hashtable.put("a-select-server", string7);
                hashtable.put("retry_counter", String.valueOf(n + 1));
                hashtable.put("signature", string9);
                if (string11 != null) {
                    hashtable.put("country", string11);
                }
                if (string2 != null) {
                    hashtable.put("language", string2);
                }
                this.showAuthenticateForm(printWriter, "800", this._configManager.getErrorMessage("800", this._oErrorProperties), hashtable);
                return;
            }
            if (string12.equals("000")) {
                this._authenticationLogger.log(new Object[]{"RadiusAuthSP", string6, httpServletRequest.getRemoteAddr(), string7, "granted"});
            } else {
                this._authenticationLogger.log(new Object[]{"RadiusAuthSP", string6, httpServletRequest.getRemoteAddr(), string7, "denied"});
            }
            this.handleResult(httpServletRequest, httpServletResponse, printWriter, string12);
        }
        catch (ASelectException aSelectException) {
            this._systemLogger.log(Level.WARNING, "RadiusAuthSP", string, "Sending error to client", (Throwable)aSelectException);
            this.handleResult(httpServletRequest, httpServletResponse, printWriter, aSelectException.getMessage());
        }
        catch (IOException iOException) {
            this._systemLogger.log(Level.WARNING, "RadiusAuthSP", string, "Error sending response", (Throwable)iOException);
            if (!httpServletResponse.isCommitted()) {
                httpServletResponse.sendError(500);
            }
        }
        catch (Exception exception) {
            this._systemLogger.log(Level.SEVERE, "RadiusAuthSP", string, "Could not process request due to internal error", (Throwable)exception);
            this.handleResult(httpServletRequest, httpServletResponse, printWriter, "900");
        }
        finally {
            if (printWriter != null) {
                printWriter.close();
                printWriter = null;
            }
        }
    }

    protected boolean isRestartableServlet() {
        return false;
    }

    private void showAuthenticateForm(PrintWriter printWriter, String string, String string2, Hashtable hashtable) {
        String string3 = new String(this._sAuthenticateHtmlTemplate);
        String string4 = (String)hashtable.get("my_url");
        String string5 = (String)hashtable.get("rid");
        String string6 = (String)hashtable.get("as_url");
        String string7 = (String)hashtable.get("uid");
        String string8 = (String)hashtable.get("a-select-server");
        String string9 = (String)hashtable.get("signature");
        String string10 = (String)hashtable.get("retry_counter");
        String string11 = (String)hashtable.get("country");
        String string12 = (String)hashtable.get("language");
        string3 = Utils.replaceString((String)string3, (String)"[error]", (String)string);
        string3 = Utils.replaceString((String)string3, (String)"[rid]", (String)string5);
        string3 = Utils.replaceString((String)string3, (String)"[as_url]", (String)string6);
        string3 = Utils.replaceString((String)string3, (String)"[uid]", (String)string7);
        string3 = Utils.replaceString((String)string3, (String)"[radius_server]", (String)string4);
        string3 = Utils.replaceString((String)string3, (String)"[a-select-server]", (String)string8);
        string3 = Utils.replaceString((String)string3, (String)"[signature]", (String)string9);
        string3 = Utils.replaceString((String)string3, (String)"[error_message]", (String)string2);
        string3 = Utils.replaceString((String)string3, (String)"[retry_counter]", (String)string10);
        string3 = string11 != null ? Utils.replaceString((String)string3, (String)"[country]", (String)string11) : Utils.replaceString((String)string3, (String)"[country]", (String)"");
        string3 = string12 != null ? Utils.replaceString((String)string3, (String)"[language]", (String)string12) : Utils.replaceString((String)string3, (String)"[language]", (String)"");
        printWriter.println(string3);
    }

    private void handleResult(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, PrintWriter printWriter, String string) throws IOException {
        String string2 = "handleResult()";
        try {
            if (this._sFailureHandling.equalsIgnoreCase(DEFAULT_FAILUREHANDLING) || string.equals("000")) {
                String string3 = httpServletRequest.getParameter("rid");
                String string4 = httpServletRequest.getParameter("as_url");
                String string5 = httpServletRequest.getParameter("a-select-server");
                if (string3 == null || string4 == null || string5 == null) {
                    this.showErrorPage(printWriter, this._sErrorHtmlTemplate, string, this._configManager.getErrorMessage(string, this._oErrorProperties));
                } else {
                    StringBuffer stringBuffer = new StringBuffer(string3);
                    stringBuffer.append(string4).append(string).append(string5);
                    String string6 = this._cryptoEngine.generateSignature(stringBuffer.toString());
                    string6 = URLEncoder.encode(string6, "UTF-8");
                    stringBuffer = new StringBuffer(string4);
                    stringBuffer.append("&rid=").append(string3);
                    stringBuffer.append("&result_code=").append(string);
                    stringBuffer.append("&signature=").append(string6);
                    stringBuffer.append("&a-select-server=").append(string5);
                    httpServletResponse.sendRedirect(stringBuffer.toString());
                }
            } else {
                this.showErrorPage(printWriter, this._sErrorHtmlTemplate, string, this._configManager.getErrorMessage(string, this._oErrorProperties));
            }
        }
        catch (ASelectException aSelectException) {
            this._systemLogger.log(Level.WARNING, "RadiusAuthSP", string2, "Could not generate Radius AuthSP signature", (Throwable)aSelectException);
            this.showErrorPage(printWriter, this._sErrorHtmlTemplate, "900", this._configManager.getErrorMessage(string, this._oErrorProperties));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            this._systemLogger.log(Level.WARNING, "RadiusAuthSP", string2, "Could not encode Radius AuthSP signature", (Throwable)unsupportedEncodingException);
            this.showErrorPage(printWriter, this._sErrorHtmlTemplate, "900", this._configManager.getErrorMessage(string, this._oErrorProperties));
        }
    }
}

