/*
 * Decompiled with CFR 0.152.
 */
package org.aselect.server.authspprotocol.handler;

import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.Hashtable;
import java.util.logging.Level;
import org.aselect.server.authspprotocol.IAuthSPProtocolHandler;
import org.aselect.server.config.ASelectConfigManager;
import org.aselect.server.crypto.CryptoEngine;
import org.aselect.server.log.ASelectAuthenticationLogger;
import org.aselect.server.log.ASelectSystemLogger;
import org.aselect.server.session.SessionManager;
import org.aselect.system.exception.ASelectAuthSPException;

public class NullAuthSP
implements IAuthSPProtocolHandler {
    private static final String MODULE = "NullAuthSP";
    private static final String ERROR_NO_ERROR = "000";
    private static final String ERROR_ACCESS_DENIED = "800";
    private ASelectConfigManager _configManager;
    private SessionManager _sessionManager;
    private CryptoEngine _cryptoEngine;
    private ASelectSystemLogger _systemLogger;
    private ASelectAuthenticationLogger _authenticationLogger;
    private String _sAuthSP;
    private String _sAuthSPUrl;
    private String _sServerId;

    public void init(Object object, Object object2) throws ASelectAuthSPException {
        String string = "init()";
        Object object3 = null;
        try {
            this._systemLogger = ASelectSystemLogger.getHandle();
            this._authenticationLogger = ASelectAuthenticationLogger.getHandle();
            this._configManager = ASelectConfigManager.getHandle();
            this._sessionManager = SessionManager.getHandle();
            this._cryptoEngine = CryptoEngine.getHandle();
            try {
                this._sAuthSP = this._configManager.getParam(object, "id");
            }
            catch (Exception exception) {
                throw new ASelectAuthSPException("No valid 'id' config item found in authsp section", (Throwable)exception);
            }
            try {
                this._sAuthSPUrl = this._configManager.getParam(object2, "url");
            }
            catch (Exception exception) {
                StringBuffer stringBuffer = new StringBuffer("No valid 'url' config item found in resource section of authsp with id='");
                stringBuffer.append(this._sAuthSP);
                stringBuffer.append("'");
                throw new ASelectAuthSPException(stringBuffer.toString(), (Throwable)exception);
            }
            try {
                object3 = this._configManager.getSection(null, "aselect");
            }
            catch (Exception exception) {
                throw new ASelectAuthSPException("No main 'aselect' config section found", (Throwable)exception);
            }
            try {
                this._sServerId = this._configManager.getParam(object3, "server_id");
            }
            catch (Exception exception) {
                throw new ASelectAuthSPException("No valid 'server_id' config item found in main 'aselect' section", (Throwable)exception);
            }
        }
        catch (ASelectAuthSPException aSelectAuthSPException) {
            this._systemLogger.log(Level.WARNING, MODULE, string, "Could not initialize", (Throwable)aSelectAuthSPException);
            throw new ASelectAuthSPException("4009", (Throwable)aSelectAuthSPException);
        }
        catch (Exception exception) {
            this._systemLogger.log(Level.SEVERE, MODULE, string, "Could not initialize", (Throwable)exception);
            throw new ASelectAuthSPException("0001", (Throwable)exception);
        }
    }

    public Hashtable computeAuthenticationRequest(String string) {
        String string2 = "computeAuthenticationRequest()";
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        hashtable.put("result", "0001");
        try {
            String string3;
            String string4;
            Hashtable hashtable2 = this._sessionManager.getSessionContext(string);
            if (hashtable2 == null) {
                StringBuffer stringBuffer = new StringBuffer("Could not fetch session context for rid: ");
                stringBuffer.append(string);
                this._systemLogger.log(Level.WARNING, MODULE, string2, stringBuffer.toString());
                throw new ASelectAuthSPException("0003");
            }
            StringBuffer stringBuffer = new StringBuffer((String)hashtable2.get("my_url"));
            stringBuffer.append("?authsp=").append(this._sAuthSP);
            String string5 = stringBuffer.toString();
            Hashtable hashtable3 = (Hashtable)hashtable2.get("allowed_user_authsps");
            if (hashtable3 == null) {
                this._systemLogger.log(Level.WARNING, MODULE, string2, "allowed_user_authsps missing in session context");
                throw new ASelectAuthSPException("0003");
            }
            String string6 = (String)hashtable3.get(this._sAuthSP);
            if (string6 == null) {
                this._systemLogger.log(Level.WARNING, MODULE, string2, "missing NullAuthSP user attributes ");
                throw new ASelectAuthSPException("0003");
            }
            String string7 = (String)hashtable2.get("country");
            if (string7 == null || string7.trim().length() < 1) {
                string7 = null;
            }
            if ((string4 = (String)hashtable2.get("language")) == null || string4.trim().length() < 1) {
                string4 = null;
            }
            StringBuffer stringBuffer2 = new StringBuffer(string);
            stringBuffer2.append(string5);
            stringBuffer2.append(string6);
            stringBuffer2.append(this._sServerId);
            if (string7 != null) {
                stringBuffer2.append(string7);
            }
            if (string4 != null) {
                stringBuffer2.append(string4);
            }
            if ((string3 = this._cryptoEngine.generateSignature(this._sAuthSP, stringBuffer2.toString())) == null) {
                StringBuffer stringBuffer3 = new StringBuffer("Could not generate signature for authsp: ");
                stringBuffer3.append(this._sAuthSP);
                this._systemLogger.log(Level.WARNING, MODULE, string2, stringBuffer3.toString());
                throw new ASelectAuthSPException("0003");
            }
            string3 = URLEncoder.encode(string3, "UTF-8");
            string6 = URLEncoder.encode(string6, "UTF-8");
            string5 = URLEncoder.encode(string5, "UTF-8");
            StringBuffer stringBuffer4 = new StringBuffer(this._sAuthSPUrl);
            stringBuffer4.append("?as_url=").append(string5);
            stringBuffer4.append("&rid=").append(string);
            stringBuffer4.append("&uid=").append(string6);
            stringBuffer4.append("&a-select-server=").append(this._sServerId);
            if (string7 != null) {
                stringBuffer4.append("&country=").append(string7);
            }
            if (string4 != null) {
                stringBuffer4.append("&language=").append(string4);
            }
            stringBuffer4.append("&signature=").append(string3);
            hashtable.put("redirect_url", stringBuffer4.toString());
            hashtable.put("result", "0000");
        }
        catch (ASelectAuthSPException aSelectAuthSPException) {
            hashtable.put("result", aSelectAuthSPException.getMessage());
        }
        catch (Exception exception) {
            this._systemLogger.log(Level.SEVERE, MODULE, string2, "Could not initialize", (Throwable)exception);
            hashtable.put("result", "0003");
        }
        return hashtable;
    }

    public Hashtable verifyAuthenticationResponse(Hashtable hashtable) {
        String string = "verifyAuthenticationResponse()";
        String string2 = null;
        String string3 = null;
        StringBuffer stringBuffer = null;
        String string4 = null;
        String string5 = null;
        Hashtable<String, String> hashtable2 = new Hashtable<String, String>();
        hashtable2.put("result", "0001");
        try {
            String string6 = (String)hashtable.get("rid");
            String string7 = (String)hashtable.get("my_url");
            String string8 = (String)hashtable.get("result_code");
            String string9 = (String)hashtable.get("a-select-server");
            String string10 = (String)hashtable.get("signature");
            if (string6 == null || string8 == null || string10 == null || string9 == null) {
                this._systemLogger.log(Level.WARNING, MODULE, string, "Incorrect AuthSP response, missing one or more required parameters.");
                throw new ASelectAuthSPException("000a");
            }
            StringBuffer stringBuffer2 = new StringBuffer(string7);
            stringBuffer2.append("?authsp=");
            stringBuffer2.append(this._sAuthSP);
            string7 = stringBuffer2.toString();
            string10 = URLDecoder.decode(string10, "UTF-8");
            StringBuffer stringBuffer3 = new StringBuffer(string6);
            stringBuffer3.append(string7);
            stringBuffer3.append(string8);
            stringBuffer3.append(string9);
            if (!this._cryptoEngine.verifySignature(this._sAuthSP, stringBuffer3.toString(), string10)) {
                this._systemLogger.log(Level.WARNING, MODULE, string, "Invalid signature in response from AuthSP");
                throw new ASelectAuthSPException("000a");
            }
            Hashtable hashtable3 = this._sessionManager.getSessionContext(string6);
            if (hashtable3 == null) {
                this._systemLogger.log(Level.WARNING, MODULE, string, "Session expired -> SessionContext not available for rid: ");
                throw new ASelectAuthSPException("0102");
            }
            string2 = (String)hashtable3.get("user_id");
            string3 = (String)hashtable3.get("app_id");
            string4 = (String)hashtable3.get("organization");
            stringBuffer = new StringBuffer(string4);
            stringBuffer.append(this._sAuthSP).append(",");
            if (!string8.equalsIgnoreCase(ERROR_NO_ERROR)) {
                if (string8.equalsIgnoreCase(ERROR_ACCESS_DENIED)) {
                    this._authenticationLogger.log(new Object[]{MODULE, string2, hashtable.get("client_ip"), string4, string3, "denied"});
                    throw new ASelectAuthSPException("000b");
                }
                StringBuffer stringBuffer4 = new StringBuffer("AuthSP returned errorcode: ");
                stringBuffer4.append(string8);
                this._systemLogger.log(Level.WARNING, MODULE, string, stringBuffer4.toString());
                throw new ASelectAuthSPException("0003");
            }
            this._authenticationLogger.log(new Object[]{MODULE, string2, hashtable.get("client_ip"), string4, string3, "granted"});
            hashtable2.put("rid", string6);
            string5 = "0000";
            hashtable2.put("result", string5);
        }
        catch (ASelectAuthSPException aSelectAuthSPException) {
            string5 = aSelectAuthSPException.getMessage();
            hashtable2.put("result", aSelectAuthSPException.getMessage());
        }
        catch (Exception exception) {
            this._systemLogger.log(Level.SEVERE, MODULE, string, "INTERNAL ERROR", (Throwable)exception);
            string5 = "0003";
            hashtable2.put("result", string5);
        }
        return hashtable2;
    }
}

