/*
 * Decompiled with CFR 0.152.
 */
package cryptix.jce.provider.dh;

import cryptix.jce.provider.dh.DHPrivateKeyCryptix;
import cryptix.jce.provider.dh.DHPublicKeyCryptix;
import cryptix.jce.util.Group;
import cryptix.jce.util.Precomputed;
import java.math.BigInteger;
import java.security.InvalidAlgorithmParameterException;
import java.security.KeyPair;
import java.security.KeyPairGeneratorSpi;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.spec.DHParameterSpec;

public final class DHKeyPairGenerator
extends KeyPairGeneratorSpi {
    private static final BigInteger ZERO = BigInteger.valueOf(0L);
    private static final BigInteger ONE = BigInteger.valueOf(1L);
    private static final int KEYSIZE_MIN = 384;
    private static final int KEYSIZE_MAX = 16384;
    private static final int KEYSIZE_DEFAULT = 16384;
    private static final int CERTAINTY = 80;
    private SecureRandom random;
    private BigInteger p;
    private BigInteger g;
    private int xLen;
    private boolean initialized = false;

    public void initialize(int keysize, SecureRandom random) {
        if (keysize < 384 || keysize > 16384) {
            throw new IllegalArgumentException("keysize: invalid size (" + keysize + ")");
        }
        Group group = Precomputed.getStrongGroup((int)keysize);
        if (group == null) {
            throw new RuntimeException("keysize: sorry, no parameters available");
        }
        this.p = group.getP();
        this.g = group.getG();
        this.xLen = this.p.bitLength() - 1;
        this.random = random;
        this.initialized = true;
    }

    public void initialize(AlgorithmParameterSpec params, SecureRandom random) throws InvalidAlgorithmParameterException {
        if (!(params instanceof DHParameterSpec)) {
            throw new InvalidAlgorithmParameterException();
        }
        DHParameterSpec dhps = (DHParameterSpec)params;
        BigInteger p = dhps.getP();
        BigInteger g = dhps.getG();
        int l = dhps.getL();
        this.p = p;
        this.g = g;
        this.xLen = l == 0 ? p.bitLength() - 1 : l;
        this.random = random;
        this.initialized = true;
    }

    /*
     * WARNING - void declaration
     */
    public KeyPair generateKeyPair() {
        void x;
        BigInteger bigInteger;
        if (!this.initialized) {
            this.initialize();
        }
        while ((bigInteger = new BigInteger(this.xLen, this.random)).compareTo(ZERO) != 1 || bigInteger.compareTo(this.p.subtract(ONE)) != -1) {
        }
        BigInteger y = this.g.modPow((BigInteger)x, this.p);
        DHParameterSpec params = new DHParameterSpec(this.p, this.g);
        DHPrivateKeyCryptix priv = new DHPrivateKeyCryptix((BigInteger)x, params);
        DHPublicKeyCryptix pub = new DHPublicKeyCryptix(y, params);
        return new KeyPair(pub, priv);
    }

    private void initialize() {
        this.initialize(16384, new SecureRandom());
    }
}

