/*
 * Decompiled with CFR 0.152.
 */
package cryptix.jce.provider.util;

import java.math.BigInteger;

public final class Util {
    public static byte[] toFixedLenByteArray(BigInteger x, int resultByteLen) {
        int x_off;
        if (x.signum() != 1) {
            throw new IllegalArgumentException("BigInteger not positive.");
        }
        byte[] x_bytes = x.toByteArray();
        int x_len = x_bytes.length;
        if (x_len <= 0) {
            throw new IllegalArgumentException("BigInteger too small.");
        }
        int n = x_off = x_bytes[0] == 0 ? 1 : 0;
        if ((x_len -= x_off) > resultByteLen) {
            throw new IllegalArgumentException("BigInteger too large.");
        }
        byte[] res_bytes = new byte[resultByteLen];
        int res_off = resultByteLen - x_len;
        System.arraycopy(x_bytes, x_off, res_bytes, res_off, x_len);
        return res_bytes;
    }

    private Util() {
    }
}

