/*
 * Decompiled with CFR 0.152.
 */
package org.aselect.server.request.handler.shibboleth;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.URLEncoder;
import java.util.Hashtable;
import java.util.Vector;
import java.util.logging.Level;
import javax.servlet.ServletConfig;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.aselect.server.request.RequestState;
import org.aselect.server.request.handler.AbstractRequestHandler;
import org.aselect.system.exception.ASelectConfigException;
import org.aselect.system.exception.ASelectException;
import org.aselect.system.utils.Utils;

public class ShibbolethWAYFProfile
extends AbstractRequestHandler {
    private static final String MODULE = "ShibbolethWAYFProfile";
    private static final String COOKIENAME = "idp";
    private String _sCookieDomain;
    private String _sTemplate;
    private long _lTimeOffset;
    private Vector _vIdPs;
    private Hashtable _htIdPs;

    public void init(ServletConfig servletConfig, Object object) throws ASelectException {
        String string = "init()";
        try {
            String string2;
            String string3;
            Object object2;
            super.init(servletConfig, object);
            Object object3 = null;
            try {
                object3 = this._configManager.getSection(object, "time");
            }
            catch (ASelectConfigException aSelectConfigException) {
                this._systemLogger.log(Level.WARNING, MODULE, string, "No config section 'time' found", (Throwable)aSelectConfigException);
                throw new ASelectException("4009", (Throwable)aSelectConfigException);
            }
            String string4 = null;
            try {
                string4 = this._configManager.getParam(object3, "offset");
                this._lTimeOffset = Long.parseLong(string4);
                this._lTimeOffset *= 1000L;
            }
            catch (NumberFormatException numberFormatException) {
                this._systemLogger.log(Level.WARNING, MODULE, string, "Configured time offset isn't a number: " + string4, (Throwable)numberFormatException);
                throw new ASelectException("4009", (Throwable)numberFormatException);
            }
            catch (ASelectConfigException aSelectConfigException) {
                this._systemLogger.log(Level.WARNING, MODULE, string, "No config item 'offset' found in section 'time'", (Throwable)aSelectConfigException);
                throw new ASelectException("4009", (Throwable)aSelectConfigException);
            }
            Object object4 = null;
            try {
                object4 = this._configManager.getSection(object, "cookie");
            }
            catch (ASelectConfigException aSelectConfigException) {
                this._systemLogger.log(Level.CONFIG, MODULE, string, "No optional config section 'cookie' found", (Throwable)aSelectConfigException);
            }
            try {
                if (object4 != null) {
                    this._sCookieDomain = this._configManager.getParam(object4, "domain");
                    this._sCookieDomain = "." + this._sCookieDomain;
                    object2 = new StringBuffer("The following cookie domain will be used for setting cookies: ");
                    ((StringBuffer)object2).append(this._sCookieDomain);
                    this._systemLogger.log(Level.INFO, MODULE, string, ((StringBuffer)object2).toString());
                }
            }
            catch (ASelectConfigException aSelectConfigException) {
                this._systemLogger.log(Level.WARNING, MODULE, string, "No config item 'domain' found in section 'cookie'", (Throwable)aSelectConfigException);
                throw new ASelectException("4009", (Throwable)aSelectConfigException);
            }
            object2 = null;
            try {
                object2 = this._configManager.getSection(object, "identity_providers");
            }
            catch (ASelectConfigException aSelectConfigException) {
                this._systemLogger.log(Level.WARNING, MODULE, string, "No config section 'identity_providers' found", (Throwable)aSelectConfigException);
                throw new ASelectException("4009", (Throwable)aSelectConfigException);
            }
            Object object5 = null;
            try {
                object5 = this._configManager.getSection(object2, COOKIENAME);
            }
            catch (ASelectConfigException aSelectConfigException) {
                this._systemLogger.log(Level.WARNING, MODULE, string, "Not even one config section 'idp' found in the 'identity_providers' section", (Throwable)aSelectConfigException);
                throw new ASelectException("4009", (Throwable)aSelectConfigException);
            }
            this._vIdPs = new Vector();
            this._htIdPs = new Hashtable();
            while (object5 != null) {
                string3 = null;
                try {
                    string3 = this._configManager.getParam(object5, "alias");
                }
                catch (ASelectConfigException aSelectConfigException) {
                    this._systemLogger.log(Level.WARNING, MODULE, string, "Not even one config item 'alias' found in 'idp' section", (Throwable)aSelectConfigException);
                    throw new ASelectException("4009", (Throwable)aSelectConfigException);
                }
                string2 = null;
                try {
                    string2 = this._configManager.getParam(object5, "url");
                }
                catch (ASelectConfigException aSelectConfigException) {
                    this._systemLogger.log(Level.WARNING, MODULE, string, "Not even one config item 'url' found in 'idp' section", (Throwable)aSelectConfigException);
                    throw new ASelectException("4009", (Throwable)aSelectConfigException);
                }
                if (this._htIdPs.contains(string3)) {
                    this._systemLogger.log(Level.WARNING, MODULE, string, "Identity Provider alias isn't unique: " + string3);
                    throw new ASelectException("4009");
                }
                if (this._htIdPs.containsKey(string2)) {
                    this._systemLogger.log(Level.WARNING, MODULE, string, "Identity Provider url isn't unique: " + string2);
                    throw new ASelectException("4009");
                }
                this._htIdPs.put(string2, string3);
                this._vIdPs.add(string2);
                object5 = this._configManager.getNextSection(object5);
            }
            string3 = null;
            try {
                string3 = this._configManager.getParam(object, "template");
            }
            catch (ASelectConfigException aSelectConfigException) {
                this._systemLogger.log(Level.WARNING, MODULE, string, "No config item 'template' found", (Throwable)aSelectConfigException);
                throw new ASelectException("4009", (Throwable)aSelectConfigException);
            }
            string2 = this._configManager.getWorkingdir();
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(string2);
            if (!string2.endsWith(File.separator)) {
                stringBuffer.append(File.separator);
            }
            stringBuffer.append("conf");
            stringBuffer.append(File.separator);
            stringBuffer.append("html");
            stringBuffer.append(File.separator);
            stringBuffer.append(string3);
            File file = new File(stringBuffer.toString());
            if (!file.exists()) {
                this._systemLogger.log(Level.WARNING, MODULE, string, "Configured template does not exists: " + stringBuffer.toString());
                throw new ASelectException("4009");
            }
            this._sTemplate = this.readTemplate(file);
        }
        catch (ASelectException aSelectException) {
            throw aSelectException;
        }
        catch (Exception exception) {
            this._systemLogger.log(Level.SEVERE, MODULE, string, "Could not initialize", (Throwable)exception);
            throw new ASelectException("0001", (Throwable)exception);
        }
    }

    public RequestState process(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ASelectException {
        String string = "process()";
        try {
            String string2;
            String string3 = httpServletRequest.getParameter("providerId");
            if (string3 == null) {
                this._systemLogger.log(Level.WARNING, MODULE, string, "Missing request parameter 'providerId'");
                throw new ASelectException("0030");
            }
            String string4 = httpServletRequest.getParameter("shire");
            if (string4 == null) {
                this._systemLogger.log(Level.WARNING, MODULE, string, "Missing request parameter 'shire'");
                throw new ASelectException("0030");
            }
            String string5 = httpServletRequest.getParameter("target");
            if (string5 == null) {
                this._systemLogger.log(Level.WARNING, MODULE, string, "Missing request parameter 'target'");
                throw new ASelectException("0030");
            }
            String string6 = httpServletRequest.getParameter("time");
            if (string6 != null) {
                long l = 0L;
                try {
                    long l2 = Long.parseLong(string6);
                    l = System.currentTimeMillis() - (l2 *= 1000L);
                    if (l < 0L) {
                        l *= -1L;
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    this._systemLogger.log(Level.WARNING, MODULE, string, "Request item 'time' isn't a number: " + string6);
                    throw new ASelectException("0030", (Throwable)numberFormatException);
                }
                if (l > this._lTimeOffset) {
                    StringBuffer stringBuffer = new StringBuffer();
                    stringBuffer.append("Request not accepted; Time offset is '");
                    stringBuffer.append(l);
                    stringBuffer.append("' , it may be: ");
                    stringBuffer.append(this._lTimeOffset);
                    this._systemLogger.log(Level.FINE, MODULE, string, stringBuffer.toString());
                    throw new ASelectException("0030");
                }
            }
            if ((string2 = httpServletRequest.getParameter(COOKIENAME)) != null) {
                if (!this._vIdPs.contains(string2)) {
                    this._systemLogger.log(Level.WARNING, MODULE, string, "Unknown IdP in request: " + string2);
                    throw new ASelectException("0030");
                }
                this.handleSubmit(string2, string5, string4, string3, httpServletResponse);
            } else {
                String string7 = null;
                Cookie[] cookieArray = httpServletRequest.getCookies();
                if (cookieArray != null) {
                    for (int i = 0; i < cookieArray.length; ++i) {
                        String string8 = cookieArray[i].getName();
                        if (!string8.equals(COOKIENAME)) continue;
                        String string9 = cookieArray[i].getValue();
                        int n = string8.length();
                        if (string8.charAt(0) == '\"' && string8.charAt(n - 1) == '\"') {
                            string8 = string8.substring(1, n - 1);
                        }
                        if (!this._vIdPs.contains(string9)) {
                            StringBuffer stringBuffer = new StringBuffer("Invalid '");
                            stringBuffer.append(COOKIENAME);
                            stringBuffer.append("' cookie, unknown value: ");
                            stringBuffer.append(string9);
                            this._systemLogger.log(Level.WARNING, MODULE, string, stringBuffer.toString());
                            throw new ASelectException("0030");
                        }
                        string7 = string9;
                    }
                }
                String string10 = httpServletRequest.getRequestURL().toString();
                this.handleShowForm(string7, string10, string5, string4, string3, httpServletResponse);
            }
        }
        catch (ASelectException aSelectException) {
            throw aSelectException;
        }
        catch (Exception exception) {
            this._systemLogger.log(Level.SEVERE, MODULE, string, "Could not process", (Throwable)exception);
            throw new ASelectException("0001", (Throwable)exception);
        }
        return new RequestState(null);
    }

    public void destroy() {
    }

    private void handleShowForm(String string, String string2, String string3, String string4, String string5, HttpServletResponse httpServletResponse) throws ASelectException {
        String string6 = "handleSubmit()";
        PrintWriter printWriter = null;
        try {
            printWriter = httpServletResponse.getWriter();
            String string7 = this._sTemplate;
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = 0; i < this._vIdPs.size(); ++i) {
                String string8 = (String)this._vIdPs.get(i);
                String string9 = (String)this._htIdPs.get(string8);
                stringBuffer.append("<OPTION VALUE=");
                stringBuffer.append(string8);
                if (string != null && string8.equals(string)) {
                    stringBuffer.append(" SELECTED");
                }
                stringBuffer.append(">");
                stringBuffer.append(string9);
                stringBuffer.append("</OPTION>");
            }
            string7 = Utils.replaceString((String)string7, (String)"[target]", (String)string3);
            string7 = Utils.replaceString((String)string7, (String)"[shire]", (String)string4);
            string7 = Utils.replaceString((String)string7, (String)"[providerid]", (String)string5);
            string7 = Utils.replaceString((String)string7, (String)"[action]", (String)string2);
            string7 = Utils.replaceString((String)string7, (String)"[options]", (String)stringBuffer.toString());
            printWriter.print(string7);
        }
        catch (Exception exception) {
            this._systemLogger.log(Level.SEVERE, MODULE, string6, "Could not show form", (Throwable)exception);
            throw new ASelectException("0001", (Throwable)exception);
        }
        finally {
            if (printWriter != null) {
                printWriter.close();
            }
        }
    }

    private void handleSubmit(String string, String string2, String string3, String string4, HttpServletResponse httpServletResponse) throws ASelectException {
        String string5 = "handleSubmit()";
        try {
            Cookie cookie = new Cookie(COOKIENAME, string);
            if (this._sCookieDomain != null) {
                cookie.setDomain(this._sCookieDomain);
            }
            httpServletResponse.addCookie(cookie);
            if (!string.endsWith("?")) {
                string = string + "?";
            }
            long l = System.currentTimeMillis() / 1000L;
            StringBuffer stringBuffer = new StringBuffer(string);
            stringBuffer.append("target=").append(URLEncoder.encode(string2, "UTF-8"));
            stringBuffer.append("&shire=").append(URLEncoder.encode(string3, "UTF-8"));
            stringBuffer.append("&providerId=").append(URLEncoder.encode(string4, "UTF-8"));
            stringBuffer.append("&time=").append(l);
            httpServletResponse.sendRedirect(stringBuffer.toString());
        }
        catch (Exception exception) {
            this._systemLogger.log(Level.SEVERE, MODULE, string5, "Could not handle form request", (Throwable)exception);
            throw new ASelectException("0001", (Throwable)exception);
        }
    }

    private String readTemplate(File file) throws ASelectException {
        String string = "readTemplate()";
        BufferedReader bufferedReader = null;
        String string2 = null;
        StringBuffer stringBuffer = new StringBuffer();
        try {
            bufferedReader = new BufferedReader(new InputStreamReader(new FileInputStream(file)));
            while ((string2 = bufferedReader.readLine()) != null) {
                stringBuffer.append(string2);
                stringBuffer.append("\n");
            }
        }
        catch (Exception exception) {
            this._systemLogger.log(Level.SEVERE, MODULE, string, "Could not read template", (Throwable)exception);
            throw new ASelectException("0001", (Throwable)exception);
        }
        finally {
            try {
                if (bufferedReader != null) {
                    bufferedReader.close();
                }
            }
            catch (IOException iOException) {
                this._systemLogger.log(Level.FINE, MODULE, string, "Could not close BufferedReader", (Throwable)iOException);
            }
        }
        return stringBuffer.toString();
    }
}

