/*
 * Decompiled with CFR 0.152.
 */
package org.aselect.system.communication.client.soap12;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.io.StringReader;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.logging.Level;
import org.apache.xerces.dom.DocumentImpl;
import org.apache.xerces.parsers.DOMParser;
import org.aselect.system.communication.client.IClientCommunicator;
import org.aselect.system.exception.ASelectCommunicationException;
import org.aselect.system.logging.SystemLogger;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class SOAP12Communicator
implements IClientCommunicator {
    private static final String CONTENT_TYPE = "application/soap+xml; charset=utf-8";
    private static final String URI_SOAP12_ENV = "http://www.w3.org/2003/05/soap-envelope";
    private static final String URI_SOAP12_ENC = "http://www.w3.org/2003/05/soap-encoding";
    private static final String URI_ASELECT_ENV = "";
    private String _sCallMethod;
    private SystemLogger _systemLogger;
    private final String MODULE = "SOAP12Communicator";

    public SOAP12Communicator(String string, SystemLogger systemLogger) {
        this._sCallMethod = string;
        this._systemLogger = systemLogger;
    }

    public Hashtable sendMessage(Hashtable hashtable, String string) throws ASelectCommunicationException {
        Hashtable hashtable2 = new Hashtable();
        String string2 = null;
        String string3 = null;
        Element element = null;
        String string4 = "sendMessage()";
        string2 = this.createMessage(hashtable, string);
        try {
            string3 = this.send(string2, string);
        }
        catch (MalformedURLException malformedURLException) {
            StringBuffer stringBuffer = new StringBuffer("Invalid URL: ");
            stringBuffer.append(malformedURLException.getMessage());
            stringBuffer.append(" errorcode: ");
            stringBuffer.append("4007");
            this._systemLogger.log(Level.WARNING, "SOAP12Communicator", string4, stringBuffer.toString(), malformedURLException);
            throw new ASelectCommunicationException("4007", malformedURLException);
        }
        element = this.parse(string3);
        hashtable2 = this.xmlBody2Hashtable(element, string);
        return hashtable2;
    }

    private String createMessage(Hashtable hashtable, String string) {
        String string2 = "createMessage";
        StringBuffer stringBuffer = new StringBuffer();
        if (hashtable != null || !string.equals(URI_ASELECT_ENV)) {
            stringBuffer.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
            stringBuffer.append("<env:Envelope xmlns:env=\"").append(URI_SOAP12_ENV).append("\" ");
            stringBuffer.append("xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" ");
            stringBuffer.append("xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\">\n");
            stringBuffer.append("\t<env:Body>\n");
            stringBuffer.append("\t\t<m:").append(this._sCallMethod).append(" xmlns:m=\"").append(string);
            stringBuffer.append(URI_ASELECT_ENV);
            stringBuffer.append("\" env:encodingStyle=\"");
            stringBuffer.append(URI_SOAP12_ENC);
            stringBuffer.append("\">\n");
            Iterator iterator = hashtable.keySet().iterator();
            String string3 = null;
            while (iterator.hasNext()) {
                string3 = (String)iterator.next();
                Object v = hashtable.get(string3);
                if (v instanceof String) {
                    stringBuffer.append("\t\t\t<m:").append(string3).append(">");
                    stringBuffer.append(this.normalize((String)v));
                    stringBuffer.append("</m:").append(string3).append(">\n");
                    continue;
                }
                if (v instanceof String[]) {
                    String[] stringArray = (String[])v;
                    stringBuffer.append("\t\t\t<m:").append(string3);
                    stringBuffer.append(" enc:itemType=\"xsd:string\" enc:arraySize=\"");
                    stringBuffer.append(stringArray.length).append("\" xmlns:enc=\"").append(URI_SOAP12_ENC).append("\">\n");
                    for (int i = 0; i < stringArray.length; ++i) {
                        stringBuffer.append("\t\t\t\t<m:item xsi:type=\"xsd:string\">");
                        stringBuffer.append(this.normalize(stringArray[i]));
                        stringBuffer.append("</m:item>\n");
                    }
                    stringBuffer.append("\t\t\t</m:").append(string3).append(">\n");
                    continue;
                }
                this._systemLogger.log(Level.INFO, "SOAP12Communicator", string2, "Unknown object found in Hashtable");
            }
            stringBuffer.append("\t\t</m:").append(this._sCallMethod).append(">\n");
            stringBuffer.append("\t</env:Body>\n");
            stringBuffer.append("</env:Envelope>");
        }
        return stringBuffer.toString();
    }

    private String send(String string, String string2) throws MalformedURLException, ASelectCommunicationException {
        StringBuffer stringBuffer = new StringBuffer();
        String string3 = "send()";
        URL uRL = null;
        HttpURLConnection httpURLConnection = null;
        uRL = new URL(string2);
        try {
            httpURLConnection = (HttpURLConnection)uRL.openConnection();
            httpURLConnection.setDoOutput(true);
            httpURLConnection.setRequestProperty("Content-Type", CONTENT_TYPE);
            httpURLConnection.setRequestProperty("Accept", CONTENT_TYPE);
            PrintStream printStream = new PrintStream(httpURLConnection.getOutputStream());
            printStream.println(string);
            printStream.println("\r\n\r\n");
            printStream.close();
            int n = 0;
            byte[] byArray = new byte[512];
            DataInputStream dataInputStream = null;
            int n2 = httpURLConnection.getResponseCode();
            switch (n2) {
                case 200: {
                    dataInputStream = new DataInputStream(httpURLConnection.getInputStream());
                    while ((n = dataInputStream.read(byArray)) != -1) {
                        stringBuffer.append(new String(byArray, 0, n));
                        Arrays.fill(byArray, (byte)0);
                    }
                    dataInputStream.close();
                    break;
                }
                case 400: {
                    this._systemLogger.log(Level.INFO, "SOAP12Communicator", string3, httpURLConnection.getHeaderField(0));
                    break;
                }
                case 500: {
                    StringBuffer stringBuffer2 = new StringBuffer("Internal server error at target host. errorcode: ");
                    stringBuffer2.append("0001");
                    this._systemLogger.log(Level.WARNING, "SOAP12Communicator", string3, stringBuffer2.toString());
                    break;
                }
                default: {
                    StringBuffer stringBuffer3 = new StringBuffer("Invalid response from target host: \"");
                    stringBuffer3.append(httpURLConnection.getHeaderField(0));
                    stringBuffer3.append(" \". errorcode: ");
                    stringBuffer3.append("0001");
                    this._systemLogger.log(Level.WARNING, "SOAP12Communicator", string3, stringBuffer3.toString());
                    break;
                }
            }
        }
        catch (UnknownHostException unknownHostException) {
            StringBuffer stringBuffer4 = new StringBuffer("Target host unknown: \"");
            stringBuffer4.append(string2);
            stringBuffer4.append("\" errorcode: ");
            stringBuffer4.append("4007");
            this._systemLogger.log(Level.WARNING, "SOAP12Communicator", string3, stringBuffer4.toString(), unknownHostException);
            throw new ASelectCommunicationException("4007", unknownHostException);
        }
        catch (IOException iOException) {
            StringBuffer stringBuffer5 = new StringBuffer("Could not open connection with host: \"");
            stringBuffer5.append(string2);
            stringBuffer5.append("\" errorcode: ");
            stringBuffer5.append("4006");
            this._systemLogger.log(Level.WARNING, "SOAP12Communicator", string3, stringBuffer5.toString(), iOException);
            throw new ASelectCommunicationException("4006", iOException);
        }
        return stringBuffer.toString();
    }

    private Element parse(String string) throws ASelectCommunicationException {
        Element element = null;
        String string2 = "parse()";
        if (!string.equals(URI_ASELECT_ENV)) {
            try {
                Node node;
                DOMParser dOMParser = new DOMParser();
                dOMParser.setErrorHandler((ErrorHandler)new DefaultHandler());
                dOMParser.parse(new InputSource(new StringReader(string)));
                DocumentImpl documentImpl = (DocumentImpl)dOMParser.getDocument();
                NodeList nodeList = documentImpl.getDocumentElement().getElementsByTagNameNS(URI_SOAP12_ENV, "Body");
                if (nodeList.getLength() == 1 && (node = nodeList.item(0)) instanceof Element) {
                    element = (Element)node;
                }
            }
            catch (SAXException sAXException) {
                StringBuffer stringBuffer = new StringBuffer("Error during parsing: ");
                stringBuffer.append(sAXException.getMessage());
                stringBuffer.append(" errorcode: ");
                stringBuffer.append("4008");
                this._systemLogger.log(Level.WARNING, "SOAP12Communicator", string2, stringBuffer.toString(), sAXException);
                throw new ASelectCommunicationException("4008", sAXException);
            }
            catch (IOException iOException) {
                StringBuffer stringBuffer = new StringBuffer("Error reading message from inputstream: ");
                stringBuffer.append(iOException.getMessage());
                stringBuffer.append(" errorcode: ");
                stringBuffer.append("4006");
                this._systemLogger.log(Level.WARNING, "SOAP12Communicator", string2, stringBuffer.toString(), iOException);
                throw new ASelectCommunicationException("4006", iOException);
            }
        }
        return element;
    }

    private Hashtable xmlBody2Hashtable(Element element, String string) throws ASelectCommunicationException {
        String string2 = "xmlBody2Hashtable";
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        if (element != null) {
            String string3 = null;
            String string4 = null;
            NodeList nodeList = null;
            NodeList nodeList2 = null;
            nodeList2 = element.getElementsByTagNameNS(string + URI_ASELECT_ENV, this._sCallMethod + "Response");
            if (nodeList2.getLength() == 1) {
                nodeList2 = nodeList2.item(0).getChildNodes();
                for (int i = 0; i < nodeList2.getLength(); ++i) {
                    if (!nodeList2.item(i).hasChildNodes()) continue;
                    nodeList = nodeList2.item(i).getChildNodes();
                    if (nodeList.getLength() == 1) {
                        if (nodeList.item(0).getNodeType() != 3) continue;
                        string3 = nodeList2.item(i).getLocalName();
                        string4 = nodeList.item(0).getNodeValue();
                        hashtable.put(string3, string4);
                        continue;
                    }
                    if (nodeList2.item(i).getNodeType() != 1) continue;
                    Element element2 = (Element)nodeList2.item(i);
                    String[] stringArray = this.resolveArray(element2, nodeList);
                    string3 = element2.getLocalName();
                    hashtable.put(string3, stringArray);
                }
            } else {
                this._systemLogger.log(Level.INFO, "SOAP12Communicator", string2, "Invalid SOAP-RPC body");
            }
        }
        return hashtable;
    }

    private String[] resolveArray(Element element, NodeList nodeList) throws ASelectCommunicationException {
        String[] stringArray = null;
        String string = "resolveArray()";
        String string2 = element.getAttributeNS(URI_SOAP12_ENC, "itemType");
        if (string2.equalsIgnoreCase("xsd:string")) {
            String string3 = element.getAttributeNS(URI_SOAP12_ENC, "arraySize");
            try {
                int n = new Integer(string3);
                int n2 = 0;
                stringArray = new String[n];
                for (int i = 0; i < nodeList.getLength(); ++i) {
                    Node node;
                    if (nodeList.item(i).getNodeType() != 1 || (node = nodeList.item(i).getFirstChild()).getNodeType() != 3 || n2 >= n) continue;
                    stringArray[n2++] = node.getNodeValue();
                }
            }
            catch (NumberFormatException numberFormatException) {
                StringBuffer stringBuffer = new StringBuffer("Error during resolving array (invalid 'arraySize'): ");
                stringBuffer.append(numberFormatException.getMessage());
                stringBuffer.append(" errorcode: ");
                stringBuffer.append("4008");
                this._systemLogger.log(Level.WARNING, "SOAP12Communicator", string, stringBuffer.toString(), numberFormatException);
                throw new ASelectCommunicationException("4008", numberFormatException);
            }
        }
        return stringArray;
    }

    private String normalize(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        block6: for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '<': {
                    stringBuffer.append("&lt;");
                    continue block6;
                }
                case '>': {
                    stringBuffer.append("&gt;");
                    continue block6;
                }
                case '&': {
                    stringBuffer.append("&amp;");
                    continue block6;
                }
                case '\"': {
                    stringBuffer.append("&quot;");
                    continue block6;
                }
                default: {
                    stringBuffer.append(c);
                }
            }
        }
        return stringBuffer.toString();
    }
}

