/*
 * Decompiled with CFR 0.152.
 */
package org.aselect.system.communication.server;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.ProtocolException;
import java.net.Socket;
import java.util.Hashtable;
import java.util.StringTokenizer;
import org.aselect.system.communication.server.IProtocolRequest;

public class TCPProtocolRequest
implements IProtocolRequest {
    private Hashtable _htHeaders = new Hashtable();
    private Hashtable _htProperties = new Hashtable();
    private InputStream _isInput;
    private StringBuffer _sbInputBuffer = new StringBuffer();

    public TCPProtocolRequest(Socket socket) throws IOException {
        this._isInput = socket.getInputStream();
        this.readRequest(socket);
    }

    public String getProtocolName() {
        return (String)this._htProperties.get("ProtocolName");
    }

    public String getProperty(String string) {
        String string2 = null;
        if (string.equalsIgnoreCase("QueryString")) {
            if (this._htProperties.containsKey(string)) {
                string2 = (String)this._htProperties.get(string);
            }
        } else if (this._htHeaders.containsKey(string)) {
            string2 = (String)this._htHeaders.get(string);
        }
        return string2;
    }

    public String getTarget() {
        return (String)this._htProperties.get("Target");
    }

    public InputStream getInputStream() throws IOException {
        return new ByteArrayInputStream(this._sbInputBuffer.toString().getBytes());
    }

    private void readRequest(Socket socket) throws IOException {
        String string = null;
        StringBuffer stringBuffer = new StringBuffer();
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(this._isInput));
        string = bufferedReader.readLine();
        if (string == null) {
            throw new EOFException("TCPProtocolRequest.readRequest()::End of stream");
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        if (!stringTokenizer.hasMoreTokens()) {
            throw new ProtocolException("TCPProtocolRequest.readRequest()::No content in request");
        }
        String string2 = stringTokenizer.nextToken();
        if (string2.equals("POST")) {
            if (!stringTokenizer.hasMoreTokens()) {
                throw new ProtocolException("TCPProtocolRequest.readRequest()::No URL in request");
            }
            stringTokenizer.nextToken();
            if (!stringTokenizer.hasMoreTokens()) {
                throw new ProtocolException("TCPProtocolRequest.readRequest()::No ProtocolName in request");
            }
            this._htProperties.put("ProtocolName", stringTokenizer.nextToken());
            stringBuffer.append("http:/");
            string = bufferedReader.readLine();
            while (string != null && !string.equals("")) {
                String[] stringArray = string.split(": ");
                if (stringArray.length == 2) {
                    this._htHeaders.put(stringArray[0], stringArray[1]);
                }
                string = bufferedReader.readLine();
            }
            string = bufferedReader.readLine();
            while (string != null && !string.equals("")) {
                this._sbInputBuffer.append(string);
                string = bufferedReader.readLine();
            }
        } else if (string2.equals("GET")) {
            if (!stringTokenizer.hasMoreTokens()) {
                throw new ProtocolException("TCPProtocolRequest.readRequest()::No URL in request");
            }
            String string3 = stringTokenizer.nextToken();
            String string4 = null;
            int n = string3.indexOf("?");
            if (++n > 0) {
                string4 = string3.substring(n, string3.length());
            }
            if (string4 == null) {
                string4 = "";
            }
            this._htProperties.put("QueryString", string4);
            this._htProperties.put("ProtocolName", "RAW");
        } else {
            this._htProperties.put("QueryString", string);
            this._htProperties.put("ProtocolName", "RAW");
        }
        stringBuffer.append(socket.getLocalSocketAddress().toString());
        this._htProperties.put("Target", stringBuffer.toString());
    }

    public String getMessage() {
        return this._sbInputBuffer.toString();
    }
}

