/*
 * Decompiled with CFR 0.152.
 */
package org.aselect.system.configmanager.handler;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.DateFormat;
import java.util.Date;
import java.util.logging.Level;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.xml.serialize.OutputFormat;
import org.apache.xml.serialize.XMLSerializer;
import org.aselect.system.configmanager.IConfigHandler;
import org.aselect.system.db.SQLDatabaseConnector;
import org.aselect.system.exception.ASelectConfigException;
import org.aselect.system.exception.ASelectDatabaseException;
import org.aselect.system.logging.SystemLogger;
import org.w3c.dom.Comment;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class XMLConfigHandler
implements IConfigHandler {
    private static final String MODULE = "XMLConfigHandler";
    private static final String ID_COLUMN = "id";
    private static final String DATA_COLUMN = "data";
    private Document _oDomDocument;
    private File _fConfig;
    private String _sDatabaseTableName;
    private String _sConfigId;
    private SystemLogger _oSystemLogger;
    private SQLDatabaseConnector _sdcConnector;

    public XMLConfigHandler(SystemLogger systemLogger) {
        this._oSystemLogger = systemLogger;
        this._oDomDocument = null;
    }

    public void init(File file) throws ASelectConfigException {
        StringBuffer stringBuffer = new StringBuffer();
        String string = ".init()";
        try {
            this._fConfig = file;
            this._oDomDocument = this.parseXML(this._fConfig);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            stringBuffer.append("Parser incorrect configured.");
            stringBuffer.append(parserConfigurationException.getMessage());
            this._oSystemLogger.log(Level.SEVERE, MODULE, string, stringBuffer.toString());
            throw new ASelectConfigException("4004", parserConfigurationException);
        }
        catch (SAXException sAXException) {
            stringBuffer.append("Error during SAX Parsing.");
            stringBuffer.append(sAXException.getMessage());
            this._oSystemLogger.log(Level.SEVERE, MODULE, string, stringBuffer.toString());
            throw new ASelectConfigException("4004", sAXException);
        }
        catch (IOException iOException) {
            stringBuffer.append("Error while opening XML config file.");
            stringBuffer.append(iOException.getMessage());
            this._oSystemLogger.log(Level.SEVERE, MODULE, string, stringBuffer.toString());
            throw new ASelectConfigException("4002", iOException);
        }
        catch (Exception exception) {
            stringBuffer.append(exception.getMessage());
            this._oSystemLogger.log(Level.SEVERE, MODULE, string, stringBuffer.toString());
            throw new ASelectConfigException("0001", exception);
        }
    }

    public void init(String string, String string2, String string3, String string4, String string5, String string6) throws ASelectConfigException {
        StringBuffer stringBuffer = new StringBuffer();
        String string7 = "init()";
        String string8 = null;
        Statement statement = null;
        try {
            this._sdcConnector = new SQLDatabaseConnector(string5, string, string2, string3, this._oSystemLogger);
            this._sConfigId = string6;
            this._sDatabaseTableName = string4;
            StringBuffer stringBuffer2 = new StringBuffer("Select ");
            stringBuffer2.append(DATA_COLUMN);
            stringBuffer2.append(" FROM ");
            stringBuffer2.append(this._sDatabaseTableName);
            stringBuffer2.append(" WHERE ").append(ID_COLUMN);
            stringBuffer2.append("='").append(this._sConfigId).append("'");
            statement = this._sdcConnector.connect();
            if (statement != null) {
                ResultSet resultSet = this._sdcConnector.executeQuery(statement, stringBuffer2.toString());
                if (resultSet.next()) {
                    string8 = resultSet.getString(1);
                }
            } else {
                stringBuffer.append("Could not connect to database: ");
                stringBuffer.append(string3);
                this._oSystemLogger.log(Level.SEVERE, MODULE, string7, stringBuffer.toString());
                throw new ASelectConfigException("4002");
            }
            this._sdcConnector.disconnect(statement);
            this._oDomDocument = this.parseXML(string8.getBytes("UTF-8"));
        }
        catch (ParserConfigurationException parserConfigurationException) {
            stringBuffer.append("Parser configuration is wrong: ");
            stringBuffer.append(parserConfigurationException.getMessage());
            this._oSystemLogger.log(Level.SEVERE, MODULE, string7, stringBuffer.toString());
            throw new ASelectConfigException("4004", parserConfigurationException);
        }
        catch (SAXException sAXException) {
            stringBuffer.append("Error during SAX parsing: ");
            stringBuffer.append(sAXException.getMessage());
            this._oSystemLogger.log(Level.SEVERE, MODULE, string7, stringBuffer.toString());
            throw new ASelectConfigException("4004", sAXException);
        }
        catch (IOException iOException) {
            stringBuffer.append("Could not open XML object: ");
            stringBuffer.append(iOException.getMessage());
            this._oSystemLogger.log(Level.SEVERE, MODULE, string7, stringBuffer.toString());
            throw new ASelectConfigException("4004", iOException);
        }
        catch (ASelectDatabaseException aSelectDatabaseException) {
            stringBuffer.append("Could connect to database: ");
            stringBuffer.append(aSelectDatabaseException.getMessage());
            this._oSystemLogger.log(Level.SEVERE, MODULE, string7, stringBuffer.toString());
            throw new ASelectConfigException("4002", aSelectDatabaseException);
        }
        catch (SQLException sQLException) {
            stringBuffer.append("Could not execute database query: ");
            stringBuffer.append(sQLException.getMessage());
            this._oSystemLogger.log(Level.SEVERE, MODULE, string7, stringBuffer.toString());
            throw new ASelectConfigException("4002", sQLException);
        }
        catch (Exception exception) {
            stringBuffer.append(exception.getMessage());
            this._oSystemLogger.log(Level.SEVERE, MODULE, string7, stringBuffer.toString());
            throw new ASelectConfigException("0001", exception);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public synchronized Object getSection(Object object, String string, String string2) throws ASelectConfigException {
        StringBuffer stringBuffer = new StringBuffer();
        String string3 = "getSection()";
        Node node = null;
        Element element = null;
        if (object != null) {
            if (!(object instanceof Element)) {
                stringBuffer.append("Root section invalid, is not of type: Element");
                this._oSystemLogger.log(Level.WARNING, MODULE, string3, stringBuffer.toString());
                throw new ASelectConfigException("0001");
            }
            element = (Element)object;
        } else {
            element = this._oDomDocument.getDocumentElement();
        }
        if (string2 == null) {
            stringBuffer.append("No section ID supplied.");
            this._oSystemLogger.log(Level.WARNING, MODULE, string3, stringBuffer.toString());
            throw new ASelectConfigException("0001");
        }
        node = this.getSubSectionByID(element, string, string2);
        if (node != null) {
            return node;
        }
        stringBuffer.append("Section not found, rootSection=");
        stringBuffer.append(element.getNodeName());
        stringBuffer.append(" section type=");
        stringBuffer.append(string);
        stringBuffer.append(" section id: ");
        stringBuffer.append(string2);
        this._oSystemLogger.log(Level.FINE, MODULE, string3, stringBuffer.toString());
        throw new ASelectConfigException("4005");
    }

    /*
     * Enabled aggressive block sorting
     */
    public synchronized Object getSection(Object object, String string) throws ASelectConfigException {
        StringBuffer stringBuffer = new StringBuffer();
        String string2 = "getSection()";
        Node node = null;
        Element element = null;
        if (object != null) {
            if (!(object instanceof Element)) {
                stringBuffer.append("Root section invalid, is not of type: Element");
                this._oSystemLogger.log(Level.WARNING, MODULE, string2, stringBuffer.toString());
                throw new ASelectConfigException("0001");
            }
            element = (Element)object;
        } else {
            element = this._oDomDocument.getDocumentElement();
        }
        if (string == null) {
            stringBuffer.append("No section Type supplied.");
            this._oSystemLogger.log(Level.WARNING, MODULE, string2, stringBuffer.toString());
            throw new ASelectConfigException("0001");
        }
        node = this.getSubSection(element, string);
        if (node != null) {
            return node;
        }
        stringBuffer.append("Section not found, rootSection=");
        stringBuffer.append(element.getNodeName());
        stringBuffer.append(" sectionType=");
        stringBuffer.append(string);
        this._oSystemLogger.log(Level.FINE, MODULE, string2, stringBuffer.toString());
        throw new ASelectConfigException("4005");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized Object setSection(Object object, String string) throws ASelectConfigException {
        StringBuffer stringBuffer = new StringBuffer();
        String string2 = "setSection()";
        Element element = null;
        Element element2 = null;
        if (object != null) {
            if (!(object instanceof Element)) {
                stringBuffer.append("Root section invalid, is not of type: Element");
                this._oSystemLogger.log(Level.WARNING, MODULE, string2, stringBuffer.toString());
                throw new ASelectConfigException("0001");
            }
            element = (Element)object;
        } else {
            element = this._oDomDocument.getDocumentElement();
        }
        if (string == null) {
            stringBuffer.append("No section Type supplied.");
            this._oSystemLogger.log(Level.WARNING, MODULE, string2, stringBuffer.toString());
            throw new ASelectConfigException("0001");
        }
        element2 = this._oDomDocument.createElement(string);
        try {
            element.appendChild(element2);
            return element2;
        }
        catch (DOMException dOMException) {
            stringBuffer.append("Error setting section: ");
            stringBuffer.append(string);
            stringBuffer.append(": ");
            stringBuffer.append(dOMException.getMessage());
            this._oSystemLogger.log(Level.WARNING, MODULE, string2, stringBuffer.toString());
            throw new ASelectConfigException("0001", dOMException);
        }
        catch (Exception exception) {
            stringBuffer.append("Error setting section: ");
            stringBuffer.append(string);
            stringBuffer.append(": ");
            stringBuffer.append(exception.getMessage());
            this._oSystemLogger.log(Level.SEVERE, MODULE, string2, stringBuffer.toString());
            throw new ASelectConfigException("0001", exception);
        }
    }

    public synchronized String getParam(Object object, String string) throws ASelectConfigException {
        StringBuffer stringBuffer = new StringBuffer();
        String string2 = "getParam()";
        String string3 = null;
        Node node = null;
        Node node2 = null;
        Node node3 = null;
        Node node4 = null;
        NodeList nodeList = null;
        NodeList nodeList2 = null;
        NamedNodeMap namedNodeMap = null;
        if (object == null) {
            stringBuffer.append("Supplied section is null.");
            this._oSystemLogger.log(Level.WARNING, MODULE, string2, stringBuffer.toString());
            throw new ASelectConfigException("4005");
        }
        if (!(object instanceof Node)) {
            stringBuffer.append("Supplied section is of type Node.");
            this._oSystemLogger.log(Level.WARNING, MODULE, string2, stringBuffer.toString());
            throw new ASelectConfigException("4005");
        }
        try {
            node2 = (Node)object;
            if (node2.hasAttributes() && (node = (namedNodeMap = node2.getAttributes()).getNamedItem(string)) != null) {
                string3 = node.getNodeValue();
            }
            if (string3 == null) {
                nodeList2 = node2.getChildNodes();
                for (int i = 0; i < nodeList2.getLength(); ++i) {
                    node3 = nodeList2.item(i);
                    if (node3 == null || !node3.getNodeName().equalsIgnoreCase(string)) continue;
                    nodeList = node3.getChildNodes();
                    if (nodeList.getLength() == 0) {
                        if (string3 != null) continue;
                        string3 = new String("");
                        continue;
                    }
                    for (int j = 0; j < nodeList.getLength(); ++j) {
                        node4 = nodeList.item(j);
                        if (node4.getNodeType() != 3 || (string3 = node4.getNodeValue()) != null) continue;
                        string3 = new String("");
                    }
                }
            }
        }
        catch (Exception exception) {
            stringBuffer.append("Error retrieving parameter: ");
            stringBuffer.append(string);
            this._oSystemLogger.log(Level.SEVERE, MODULE, string2, stringBuffer.toString());
            throw new ASelectConfigException("0001", exception);
        }
        if (string3 == null) {
            stringBuffer.append("Error retrieving parameter: ");
            stringBuffer.append(string);
            this._oSystemLogger.log(Level.FINE, MODULE, string2, stringBuffer.toString());
            throw new ASelectConfigException("4005");
        }
        return string3;
    }

    public synchronized boolean setParam(Object object, String string, String string2, boolean bl) throws ASelectConfigException {
        StringBuffer stringBuffer = new StringBuffer();
        String string3 = "setParam()";
        boolean bl2 = false;
        if (object == null) {
            stringBuffer.append("Supplied oRootSection is null.");
            this._oSystemLogger.log(Level.WARNING, MODULE, string3, stringBuffer.toString());
            throw new ASelectConfigException("4005");
        }
        if (!(object instanceof Element)) {
            stringBuffer.append("Supplied oRootSection is not a Element.");
            this._oSystemLogger.log(Level.WARNING, MODULE, string3, stringBuffer.toString());
            throw new ASelectConfigException("4005");
        }
        if (string == null) {
            stringBuffer.append("Supplied sConfigItem is null.");
            this._oSystemLogger.log(Level.WARNING, MODULE, string3, stringBuffer.toString());
            throw new ASelectConfigException("4005");
        }
        if (string2 == null) {
            stringBuffer.append("Supplied sConfigValue is null.");
            this._oSystemLogger.log(Level.WARNING, MODULE, string3, stringBuffer.toString());
            throw new ASelectConfigException("4005");
        }
        try {
            if (bl) {
                this.setParamAsAtribute(object, string, string2);
                bl2 = true;
            } else {
                this.setParamAsChild(object, string, string2);
                bl2 = true;
            }
        }
        catch (DOMException dOMException) {
            stringBuffer.append("XML DOM Error while setting parameter: ");
            stringBuffer.append(string);
            stringBuffer.append(": ");
            stringBuffer.append(dOMException.getMessage());
            this._oSystemLogger.log(Level.WARNING, MODULE, string3, stringBuffer.toString());
            throw new ASelectConfigException("0001", dOMException);
        }
        catch (Exception exception) {
            stringBuffer.append("Error while setting parameter: ");
            stringBuffer.append(string);
            stringBuffer.append(": ");
            stringBuffer.append(exception.getMessage());
            this._oSystemLogger.log(Level.WARNING, MODULE, string3, stringBuffer.toString());
            throw new ASelectConfigException("0001", exception);
        }
        return bl2;
    }

    public synchronized Object getNextSection(Object object) throws ASelectConfigException {
        String string = "getNextSection()";
        Node node = null;
        if (object == null) {
            this._oSystemLogger.log(Level.WARNING, MODULE, string, "Supplied section is null.");
            throw new ASelectConfigException("0001");
        }
        node = (Node)object;
        String string2 = node.getNodeName();
        for (node = node.getNextSibling(); !(node == null || node.getNodeType() == 1 && node.getNodeName().equals(string2)); node = node.getNextSibling()) {
        }
        return node;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized boolean removeSection(Object object, String string) throws ASelectConfigException {
        StringBuffer stringBuffer = new StringBuffer();
        String string2 = "removeSection()";
        Node node = null;
        Element element = null;
        boolean bl = false;
        try {
            if (object != null) {
                if (!(element instanceof Element)) {
                    this._oSystemLogger.log(Level.WARNING, MODULE, string2, "Root section invalid, is not of type: Element");
                    throw new ASelectConfigException("0001");
                }
                element = (Element)object;
            } else {
                element = this._oDomDocument.getDocumentElement();
            }
            if (string == null) {
                this._oSystemLogger.log(Level.WARNING, MODULE, string2, "Section type is null.");
                throw new ASelectConfigException("0001");
            }
            node = this.getSubSection(element, string);
            if (node == null) {
                stringBuffer.append("Section not found. Root: '");
                stringBuffer.append(element);
                stringBuffer.append("' section type: '");
                stringBuffer.append(string);
                stringBuffer.append("'.");
                this._oSystemLogger.log(Level.FINE, MODULE, string2, stringBuffer.toString());
                throw new ASelectConfigException("4005");
            }
            element.removeChild(node);
            return true;
        }
        catch (ASelectConfigException aSelectConfigException) {
            throw aSelectConfigException;
        }
        catch (DOMException dOMException) {
            stringBuffer.append("XML DOM error while removing section '");
            stringBuffer.append(string);
            stringBuffer.append("': \"");
            stringBuffer.append(dOMException.getMessage());
            stringBuffer.append("\"");
            this._oSystemLogger.log(Level.WARNING, MODULE, string2, stringBuffer.toString());
            throw new ASelectConfigException("4004", dOMException);
        }
        catch (Exception exception) {
            stringBuffer.append("Error removing section: ");
            stringBuffer.append(string);
            stringBuffer.append(": ");
            stringBuffer.append(exception.getMessage());
            this._oSystemLogger.log(Level.WARNING, MODULE, string2, stringBuffer.toString(), exception);
            throw new ASelectConfigException("0001", exception);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized boolean removeSection(Object object, String string, String string2) throws ASelectConfigException {
        StringBuffer stringBuffer = new StringBuffer();
        String string3 = "removeSection()";
        Node node = null;
        Element element = null;
        boolean bl = false;
        try {
            if (object != null) {
                if (!(element instanceof Element)) {
                    stringBuffer.append("Root section invalid, is not of type: Element");
                    this._oSystemLogger.log(Level.WARNING, MODULE, string3, stringBuffer.toString());
                    throw new ASelectConfigException("0001");
                }
                element = (Element)object;
            } else {
                element = this._oDomDocument.getDocumentElement();
            }
            node = this.getSubSectionByID(element, string, string2);
            if (node == null) {
                stringBuffer.append("Section not found. Root: '");
                stringBuffer.append(element);
                stringBuffer.append("' section type: '");
                stringBuffer.append(string);
                stringBuffer.append("' section id: '");
                stringBuffer.append("'.");
                this._oSystemLogger.log(Level.FINE, MODULE, string3, stringBuffer.toString());
                throw new ASelectConfigException("4005");
            }
            element.removeChild(node);
            return true;
        }
        catch (ASelectConfigException aSelectConfigException) {
            throw aSelectConfigException;
        }
        catch (DOMException dOMException) {
            stringBuffer.append("XML DOM error while removing section: sSectionType=");
            stringBuffer.append(string);
            stringBuffer.append(", sSectionID=");
            stringBuffer.append(string2);
            stringBuffer.append(": ");
            stringBuffer.append(dOMException.getMessage());
            this._oSystemLogger.log(Level.WARNING, MODULE, string3, stringBuffer.toString());
            throw new ASelectConfigException("0001", dOMException);
        }
        catch (Exception exception) {
            stringBuffer.append("Error removing section: sSectionType=");
            stringBuffer.append(string);
            stringBuffer.append(", sSectionID=");
            stringBuffer.append(string2);
            stringBuffer.append(": ");
            stringBuffer.append(exception.getMessage());
            this._oSystemLogger.log(Level.WARNING, MODULE, string3, stringBuffer.toString(), exception);
            throw new ASelectConfigException("0001", exception);
        }
    }

    public synchronized void saveConfig() throws ASelectConfigException {
        String string = "saveConfig()";
        boolean bl = false;
        Date date = null;
        StringBuffer stringBuffer = null;
        Element element = null;
        Node node = null;
        Comment comment = null;
        OutputStream outputStream = null;
        Statement statement = null;
        String string2 = null;
        date = new Date(System.currentTimeMillis());
        stringBuffer = new StringBuffer(" Configuration changes saved on ");
        stringBuffer.append(DateFormat.getDateInstance().format(date));
        stringBuffer.append(". ");
        element = this._oDomDocument.getDocumentElement();
        for (node = element.getFirstChild(); !bl && node != null; node = node.getNextSibling()) {
            if (node.getNodeType() != 8 || !(string2 = node.getNodeValue()).trim().startsWith("Configuration changes saved on")) continue;
            node.setNodeValue(stringBuffer.toString());
            bl = true;
        }
        if (!bl) {
            comment = this._oDomDocument.createComment(stringBuffer.toString());
            element.insertBefore(comment, element.getFirstChild());
        }
        if (this._fConfig == null) {
            outputStream = new ByteArrayOutputStream();
            this.serializeTo(outputStream);
            StringBuffer stringBuffer2 = new StringBuffer("UPDATE ");
            stringBuffer2.append(this._sDatabaseTableName).append(" SET ");
            stringBuffer2.append(DATA_COLUMN).append("='");
            stringBuffer2.append(outputStream.toString()).append("' WHERE ");
            stringBuffer2.append(ID_COLUMN).append("='");
            stringBuffer2.append(this._fConfig).append("'");
            try {
                outputStream.close();
            }
            catch (IOException iOException) {
                this._oSystemLogger.log(Level.WARNING, MODULE, string, "Error closing XML outputstream", iOException);
                throw new ASelectConfigException("4003", iOException);
            }
            try {
                statement = this._sdcConnector.connect();
                if (statement == null) {
                    this._oSystemLogger.log(Level.SEVERE, MODULE, string, "No SQL statement could be created.");
                    throw new ASelectConfigException("4006");
                }
                this._sdcConnector.executeUpdate(statement, stringBuffer2.toString());
                this._sdcConnector.disconnect(statement);
            }
            catch (ASelectDatabaseException aSelectDatabaseException) {
                this._oSystemLogger.log(Level.SEVERE, MODULE, string, "Database error while writing XML configuration", aSelectDatabaseException);
                throw new ASelectConfigException("4006", aSelectDatabaseException);
            }
        }
        try {
            outputStream = new FileOutputStream(this._fConfig);
            this.serializeTo(outputStream);
            outputStream.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            StringBuffer stringBuffer3 = new StringBuffer("Error while opening XML config file: \"");
            stringBuffer3.append(this._fConfig.getPath()).append("\"");
            this._oSystemLogger.log(Level.SEVERE, MODULE, string, stringBuffer3.toString(), fileNotFoundException);
            throw new ASelectConfigException("4002", fileNotFoundException);
        }
        catch (IOException iOException) {
            StringBuffer stringBuffer4 = new StringBuffer("Error while closing XML config file: \"");
            stringBuffer4.append(this._fConfig.getPath()).append("\"");
            this._oSystemLogger.log(Level.WARNING, MODULE, string, stringBuffer4.toString(), iOException);
            throw new ASelectConfigException("4003", iOException);
        }
    }

    public synchronized void importConfig(File file) throws ASelectConfigException {
        StringBuffer stringBuffer = new StringBuffer();
        String string = "importConfig()";
        try {
            Document document = this.parseXML(file);
            this.importConfig(document);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            stringBuffer.append("Wrong parse configuration, while parsing the XML config file.");
            this._oSystemLogger.log(Level.WARNING, MODULE, string, stringBuffer.toString());
            throw new ASelectConfigException("0001");
        }
        catch (SAXException sAXException) {
            stringBuffer.append("Error while SAX parsing the XML config file.");
            this._oSystemLogger.log(Level.WARNING, MODULE, string, stringBuffer.toString());
            throw new ASelectConfigException("4002");
        }
        catch (IOException iOException) {
            stringBuffer.append("Error while opening XML config file.");
            this._oSystemLogger.log(Level.WARNING, MODULE, string, stringBuffer.toString());
            throw new ASelectConfigException("4002");
        }
    }

    private synchronized void setParamAsAtribute(Object object, String string, String string2) throws DOMException {
        Element element = (Element)object;
        element.setAttribute(string, string2);
    }

    private synchronized void setParamAsChild(Object object, String string, String string2) throws DOMException {
        boolean bl = false;
        Element element = null;
        NodeList nodeList = null;
        Node node = null;
        Node node2 = null;
        NodeList nodeList2 = null;
        Text text = null;
        Element element2 = null;
        element = (Element)object;
        nodeList = element.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            node = nodeList.item(i);
            if (node == null || !node.getNodeName().equalsIgnoreCase(string)) continue;
            nodeList2 = node.getChildNodes();
            for (int j = 0; j < nodeList2.getLength(); ++j) {
                node2 = nodeList2.item(j);
                if (node2.getNodeType() != 3) continue;
                node2.setNodeValue(string2);
                bl = true;
            }
        }
        if (!bl) {
            text = this._oDomDocument.createTextNode(string2);
            element2 = this._oDomDocument.createElement(string);
            element2.appendChild(text);
            element.appendChild(element2);
        }
    }

    private void serializeTo(OutputStream outputStream) throws ASelectConfigException {
        String string = "serializeTo()";
        try {
            OutputFormat outputFormat = new OutputFormat(this._oDomDocument);
            outputFormat.setIndenting(true);
            outputFormat.setLineWidth(80);
            XMLSerializer xMLSerializer = new XMLSerializer(outputStream, outputFormat);
            xMLSerializer.setNamespaces(true);
            xMLSerializer.serialize(this._oDomDocument.getDocumentElement());
        }
        catch (IOException iOException) {
            this._oSystemLogger.log(Level.WARNING, MODULE, string, "Error serializing XML data.", iOException);
            throw new ASelectConfigException("4006", iOException);
        }
    }

    private Document parseXML(File file) throws ParserConfigurationException, SAXException, IOException {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        return documentBuilder.parse(file);
    }

    private Document parseXML(byte[] byArray) throws ParserConfigurationException, SAXException, IOException {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        InputSource inputSource = new InputSource(byteArrayInputStream);
        return documentBuilder.parse(inputSource);
    }

    private Node getSubSectionByID(Node node, String string, String string2) throws ASelectConfigException {
        StringBuffer stringBuffer = new StringBuffer();
        String string3 = "getSubSectionByID()";
        Element element = null;
        Element element2 = null;
        Node node2 = null;
        String[] stringArray = null;
        if (node == null) {
            stringBuffer.append("Supplied nRootSection is null.");
            this._oSystemLogger.log(Level.WARNING, MODULE, string3, stringBuffer.toString());
            throw new ASelectConfigException("4005");
        }
        if (string == null) {
            stringBuffer.append("Supplied sSectionType is null.");
            this._oSystemLogger.log(Level.WARNING, MODULE, string3, stringBuffer.toString());
            throw new ASelectConfigException("4005");
        }
        stringArray = string2.split("=");
        if (stringArray.length != 2) {
            stringBuffer.append("sSectionID isn't correct (must contain only one '='): ");
            stringBuffer.append(stringArray);
            this._oSystemLogger.log(Level.WARNING, MODULE, string3, stringBuffer.toString());
            throw new ASelectConfigException("4005");
        }
        String string4 = stringArray[0];
        String string5 = stringArray[1];
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            node2 = nodeList.item(i);
            if (node2.getNodeType() != 1 || !(element2 = (Element)node2).getNodeName().equalsIgnoreCase(string) || !element2.hasAttributes() || !element2.getAttribute(string4).equalsIgnoreCase(string5)) continue;
            element = element2;
            i = nodeList.getLength();
        }
        return element;
    }

    private Node getSubSection(Node node, String string) throws ASelectConfigException {
        StringBuffer stringBuffer = new StringBuffer();
        String string2 = "getSubSection()";
        Element element = null;
        Node node2 = null;
        if (node == null) {
            stringBuffer.append("Supplied nRootSection is null.");
            this._oSystemLogger.log(Level.WARNING, MODULE, string2, stringBuffer.toString());
            throw new ASelectConfigException("4005");
        }
        if (node.getNodeType() != 1) {
            stringBuffer.append("The supplied root section has an incorrect type: ");
            stringBuffer.append(node.getNodeType());
            this._oSystemLogger.log(Level.WARNING, MODULE, string2, stringBuffer.toString());
            throw new ASelectConfigException("0001");
        }
        if (string == null) {
            stringBuffer.append("Supplied sSectionType is null.");
            this._oSystemLogger.log(Level.WARNING, MODULE, string2, stringBuffer.toString());
            throw new ASelectConfigException("4005");
        }
        element = (Element)node;
        if (element.hasChildNodes()) {
            for (node2 = element.getFirstChild(); node2 != null; node2 = node2.getNextSibling()) {
                if (node2.getNodeType() != 1 || !node2.getNodeName().equals(string)) continue;
                return node2;
            }
        }
        return null;
    }

    private void importConfig(Document document) {
        NodeList nodeList = document.getDocumentElement().getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (node.getNodeType() != 1) continue;
            this._oDomDocument.getDocumentElement().appendChild(this._oDomDocument.importNode(node, true));
        }
    }
}

