/*
 * Decompiled with CFR 0.152.
 */
package org.aselect.system.sam.agent;

import java.util.logging.Level;
import org.aselect.system.configmanager.ConfigManager;
import org.aselect.system.exception.ASelectSAMException;
import org.aselect.system.logging.SystemLogger;
import org.aselect.system.sam.agent.ISAMPollingMethod;

public class SAMResource {
    private static final String MODULE = "SAMResource";
    private SystemLogger _oSystemLogger;
    private String _sId;
    private Object _oConfiguredAttributesSection;
    private boolean _bLive;
    private PollingThread _oPollingThread;
    private long _lInterval;
    private boolean _bRunThread;
    private ISAMPollingMethod _oSAMPollingMethod;

    public void init(Object object, ConfigManager configManager, SystemLogger systemLogger) throws ASelectSAMException {
        block13: {
            String string = "init()";
            this._oConfiguredAttributesSection = object;
            this._oSystemLogger = systemLogger;
            String string2 = null;
            Object object2 = null;
            Class<?> clazz = null;
            String string3 = null;
            this._bLive = true;
            try {
                StringBuffer stringBuffer;
                try {
                    this._sId = configManager.getParam(object, "id");
                }
                catch (Exception exception) {
                    this._oSystemLogger.log(Level.SEVERE, MODULE, string, "Error resolving config item 'id' in 'resource' section.", exception);
                    throw new ASelectSAMException("4009", exception);
                }
                try {
                    string2 = configManager.getParam(object, "polling");
                }
                catch (Exception exception) {
                    this._oSystemLogger.log(Level.CONFIG, MODULE, string, "No config item 'polling' is found, disabling polling.", exception);
                }
                if (string2 == null) break block13;
                try {
                    object2 = configManager.getSection(object, "pollingmethod", "id=" + string2);
                }
                catch (Exception exception) {
                    stringBuffer = new StringBuffer("No config item 'pollingmethod' is found, disabling polling for resource: ");
                    stringBuffer.append(this._sId);
                    this._oSystemLogger.log(Level.CONFIG, MODULE, string, stringBuffer.toString(), exception);
                }
                if (object2 == null) break block13;
                try {
                    clazz = Class.forName(configManager.getParam(object2, "class"));
                }
                catch (Exception exception) {
                    stringBuffer = new StringBuffer("No config item 'class' is found or isn't a correct polling class.");
                    stringBuffer.append(this._sId);
                    this._oSystemLogger.log(Level.SEVERE, MODULE, string, stringBuffer.toString(), exception);
                    throw new ASelectSAMException("4009", exception);
                }
                try {
                    string3 = configManager.getParam(object, "interval");
                }
                catch (Exception exception) {
                    stringBuffer = new StringBuffer("No config item 'interval' is found for resource with id: '");
                    stringBuffer.append(this._sId);
                    stringBuffer.append("'");
                    this._oSystemLogger.log(Level.INFO, MODULE, string, stringBuffer.toString(), exception);
                    throw new ASelectSAMException("4009", exception);
                }
                this._oSAMPollingMethod = (ISAMPollingMethod)clazz.newInstance();
                this._oSAMPollingMethod.init(object, object2, configManager, this._oSystemLogger);
                this._lInterval = Long.parseLong(string3) * 1000L;
                this._bRunThread = true;
                this._oPollingThread = new PollingThread();
                this._oPollingThread.start();
            }
            catch (ASelectSAMException aSelectSAMException) {
                throw aSelectSAMException;
            }
            catch (Exception exception) {
                StringBuffer stringBuffer = new StringBuffer("Could not initialize the resource with id: '");
                stringBuffer.append(this._sId);
                stringBuffer.append("'.");
                this._oSystemLogger.log(Level.SEVERE, MODULE, string, stringBuffer.toString(), exception);
                throw new ASelectSAMException("4009", exception);
            }
        }
    }

    public boolean live() {
        return this._bLive;
    }

    public Object getAttributes() {
        return this._oConfiguredAttributesSection;
    }

    public void destroy() {
        this._bRunThread = false;
        this._bLive = false;
        try {
            this._oPollingThread.interrupt();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private class PollingThread
    extends Thread {
        private PollingThread() {
        }

        public void run() {
            String string = "run()";
            while (SAMResource.this._bRunThread) {
                try {
                    SAMResource.this._bLive = SAMResource.this._oSAMPollingMethod.poll();
                    if (!SAMResource.this._bLive) {
                        StringBuffer stringBuffer = new StringBuffer(SAMResource.MODULE);
                        stringBuffer.append(":PollingThread.run() -> ");
                        stringBuffer.append("Resource '");
                        stringBuffer.append(SAMResource.this._sId);
                        stringBuffer.append("' is currently unavailable.");
                        SAMResource.this._oSystemLogger.log(Level.WARNING, SAMResource.MODULE, string, stringBuffer.toString());
                    }
                    PollingThread.sleep(SAMResource.this._lInterval);
                }
                catch (Exception exception) {}
            }
        }
    }
}

