/*
 * Decompiled with CFR 0.152.
 */
package org.aselect.system.utils;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.text.StringCharacterIterator;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;

public class Utils {
    private static final char[] _hexChars = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    private static final String ENCODED_BRACES = "%5B%5D";

    public static int fromDigit(char c) {
        if (c >= '0' && c <= '9') {
            return c - 48;
        }
        if (c >= 'A' && c <= 'F') {
            return c - 65 + 10;
        }
        if (c >= 'a' && c <= 'f') {
            return c - 97 + 10;
        }
        throw new IllegalArgumentException("invalid hex digit '" + c + "'");
    }

    public static String toHexString(byte[] byArray) {
        int n = byArray.length;
        char[] cArray = new char[n * 2];
        int n2 = 0;
        int n3 = 0;
        while (n2 < n) {
            byte by = byArray[n2++];
            cArray[n3++] = _hexChars[by >>> 4 & 0xF];
            cArray[n3++] = _hexChars[by & 0xF];
        }
        return new String(cArray);
    }

    public static byte[] stringToHex(String string) {
        int n = string.length();
        byte[] byArray = new byte[(n + 1) / 2];
        int n2 = 0;
        int n3 = 0;
        if (n % 2 == 1) {
            byArray[n3++] = (byte)Utils.fromDigit(string.charAt(n2++));
        }
        while (n2 < n) {
            byArray[n3++] = (byte)(Utils.fromDigit(string.charAt(n2++)) << 4 | Utils.fromDigit(string.charAt(n2++)));
        }
        return byArray;
    }

    public static String prefixString(String string, String string2, int n) {
        String string3 = string2;
        while (string3.length() < n) {
            string3 = string + string3;
        }
        return string3;
    }

    public static String replaceString(String string, String string2, String string3) {
        StringBuffer stringBuffer = new StringBuffer(string);
        while (stringBuffer.indexOf(string2) != -1) {
            int n = stringBuffer.indexOf(string2);
            int n2 = n + string2.length();
            stringBuffer = stringBuffer.delete(n, n2);
            stringBuffer = stringBuffer.insert(n, string3);
        }
        return stringBuffer.toString();
    }

    public static Hashtable convertCGIMessage(String string) {
        StringTokenizer stringTokenizer = null;
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        if (string != null) {
            stringTokenizer = new StringTokenizer(string, "&");
            while (stringTokenizer.hasMoreElements()) {
                String string2;
                int n;
                String string3 = (String)stringTokenizer.nextElement();
                if (string3.trim().equals("") || (n = string3.indexOf(61)) == -1) continue;
                String string4 = string3.substring(0, n);
                try {
                    string2 = string3.substring(n + 1);
                }
                catch (Exception exception) {
                    string2 = "";
                }
                if (string4 == null || string2 == null) continue;
                hashtable.put(string4, string2);
            }
        }
        return hashtable;
    }

    public static String hashtable2CGIMessage(Hashtable hashtable) throws UnsupportedEncodingException {
        boolean bl;
        StringBuffer stringBuffer = new StringBuffer();
        Enumeration enumeration = hashtable.keys();
        boolean bl2 = bl = !enumeration.hasMoreElements();
        while (!bl) {
            Object object;
            String string = (String)enumeration.nextElement();
            Object v = hashtable.get(string);
            if (v instanceof String) {
                stringBuffer.append(string);
                stringBuffer.append("=");
                object = URLEncoder.encode((String)v, "UTF-8");
                stringBuffer.append((String)object);
            } else if (v instanceof String[]) {
                object = (String[])v;
                for (int i = 0; i < ((String[])object).length; ++i) {
                    stringBuffer.append(string).append(ENCODED_BRACES);
                    stringBuffer.append("=");
                    String string2 = URLEncoder.encode(object[i], "UTF-8");
                    stringBuffer.append(string2);
                    if (i >= ((String[])object).length - 1) continue;
                    stringBuffer.append("&");
                }
            }
            if (enumeration.hasMoreElements()) {
                stringBuffer.append("&");
                continue;
            }
            bl = true;
        }
        return stringBuffer.toString();
    }

    public static boolean matchWildcardMask(String string, String string2) {
        if (string.length() == 0) {
            return string2.length() == 0 || string2.equals("*") || string2.equals("?");
        }
        int n = 0;
        StringCharacterIterator stringCharacterIterator = new StringCharacterIterator(string2);
        char c = stringCharacterIterator.first();
        while (c != '\uffff' && n < string.length()) {
            if (c == '?') {
                ++n;
            } else {
                if (c == '*') {
                    int n2 = stringCharacterIterator.getIndex() + 1;
                    if (n2 >= string2.length()) {
                        return true;
                    }
                    String string3 = string2.substring(n2);
                    while (n < string.length()) {
                        if (Utils.matchWildcardMask(string.substring(n), string3)) {
                            return true;
                        }
                        ++n;
                    }
                    return false;
                }
                if (c == string.charAt(n)) {
                    ++n;
                } else {
                    return false;
                }
            }
            c = stringCharacterIterator.next();
        }
        return n == string.length();
    }
}

