/*
 * Decompiled with CFR 0.152.
 */
package org.aselect.server.udb.jdbc;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.logging.Level;
import org.aselect.server.config.ASelectConfigManager;
import org.aselect.server.log.ASelectAuthenticationLogger;
import org.aselect.server.log.ASelectSystemLogger;
import org.aselect.server.sam.ASelectSAMAgent;
import org.aselect.server.udb.IUDBConnector;
import org.aselect.system.exception.ASelectConfigException;
import org.aselect.system.exception.ASelectSAMException;
import org.aselect.system.exception.ASelectUDBException;
import org.aselect.system.sam.agent.SAMResource;

public class JDBCConnector
implements IUDBConnector {
    private static final String MODULE = "JDBCConnector";
    private ASelectSystemLogger _oASelectSystemLogger;
    private ASelectAuthenticationLogger _oASelectAuthenticationLogger;
    private String _sUsersTableName;
    private String _sUserIdColumn;
    private Hashtable _htConfiguredAuthSPs;
    private String _sUDBResourceGroup;
    private ASelectConfigManager _oASelectConfigManager;
    private ASelectSAMAgent _oASelectSAMAgent;

    public void init(Object object) throws ASelectUDBException {
        String string = "init()";
        this._oASelectConfigManager = ASelectConfigManager.getHandle();
        this._oASelectSystemLogger = ASelectSystemLogger.getHandle();
        this._oASelectAuthenticationLogger = ASelectAuthenticationLogger.getHandle();
        this._oASelectSAMAgent = ASelectSAMAgent.getHandle();
        this._htConfiguredAuthSPs = new Hashtable();
        Object object2 = null;
        Object object3 = null;
        String string2 = null;
        try {
            try {
                this._sUsersTableName = this._oASelectConfigManager.getParam(object, "users_table");
            }
            catch (Exception exception) {
                this._oASelectSystemLogger.log(Level.WARNING, MODULE, string, "No config item 'users_table' found", (Throwable)exception);
                throw new ASelectUDBException("4009", (Throwable)exception);
            }
            try {
                this._sUserIdColumn = this._oASelectConfigManager.getParam(object, "users_table_id_column");
            }
            catch (Exception exception) {
                this._oASelectSystemLogger.log(Level.WARNING, MODULE, string, "No config item 'users_table_id_column' found", (Throwable)exception);
                throw new ASelectUDBException("4009", (Throwable)exception);
            }
            try {
                this._sUDBResourceGroup = this._oASelectConfigManager.getParam(object, "resourcegroup");
            }
            catch (ASelectConfigException aSelectConfigException) {
                this._oASelectSystemLogger.log(Level.WARNING, MODULE, string, "No 'resourcegroup' config item found in udb 'connector' config section.", (Throwable)aSelectConfigException);
                throw new ASelectUDBException("4009", (Throwable)aSelectConfigException);
            }
            Connection connection = this.getConnection();
            try {
                if (connection != null) {
                    connection.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                object2 = this._oASelectConfigManager.getSection(null, "authsps");
            }
            catch (Exception exception) {
                this._oASelectSystemLogger.log(Level.WARNING, MODULE, string, "No config section 'authsps' found in main A-Select config", (Throwable)exception);
                throw new ASelectUDBException("4009", (Throwable)exception);
            }
            try {
                object3 = this._oASelectConfigManager.getSection(object2, "authsp");
            }
            catch (Exception exception) {
                this._oASelectSystemLogger.log(Level.WARNING, MODULE, string, "No config section 'authsps' found in main A-Select config", (Throwable)exception);
                throw new ASelectUDBException("4009", (Throwable)exception);
            }
            while (object3 != null) {
                try {
                    string2 = this._oASelectConfigManager.getParam(object3, "id");
                }
                catch (Exception exception) {
                    this._oASelectSystemLogger.log(Level.WARNING, MODULE, string, "No config item 'id' found in 'authsp' section", (Throwable)exception);
                    throw new ASelectUDBException("4009", (Throwable)exception);
                }
                this._htConfiguredAuthSPs.put(string2.toUpperCase(), string2);
                object3 = this._oASelectConfigManager.getNextSection(object3);
            }
        }
        catch (ASelectUDBException aSelectUDBException) {
            throw aSelectUDBException;
        }
        catch (Exception exception) {
            this._oASelectSystemLogger.log(Level.SEVERE, MODULE, string, "Could not initialize JDBC UDB Connector", (Throwable)exception);
            throw new ASelectUDBException("4009", (Throwable)exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Hashtable getUserProfile(String string) {
        String string2 = "getUserProfile()";
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        Hashtable<String, String> hashtable2 = new Hashtable<String, String>();
        Hashtable<String, String> hashtable3 = new Hashtable<String, String>();
        Connection connection = null;
        Statement statement = null;
        ResultSet resultSet = null;
        ResultSetMetaData resultSetMetaData = null;
        hashtable.put("result_code", "0003");
        try {
            String string3;
            String string4;
            connection = this.getConnection();
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("SELECT * FROM ");
            stringBuffer.append(this._sUsersTableName);
            stringBuffer.append(" WHERE ");
            stringBuffer.append(this._sUserIdColumn);
            stringBuffer.append("=?");
            try {
                statement = connection.prepareStatement(stringBuffer.toString());
                statement.setString(1, string);
                resultSet = statement.executeQuery();
            }
            catch (Exception exception) {
                this._oASelectSystemLogger.log(Level.SEVERE, MODULE, string2, "Could not execute query: " + stringBuffer.toString(), (Throwable)exception);
                throw new ASelectUDBException("0060", (Throwable)exception);
            }
            if (!resultSet.next()) {
                this.logAuthentication(string, "0002", "denied");
                throw new ASelectUDBException("0002");
            }
            resultSetMetaData = resultSet.getMetaData();
            int n = resultSetMetaData.getColumnCount();
            for (int i = 1; i <= n; ++i) {
                string4 = resultSetMetaData.getColumnName(i);
                string3 = resultSet.getString(i);
                if (string3 == null) {
                    string3 = "";
                }
                hashtable3.put(string4.toUpperCase(), string3);
            }
            String string5 = (String)hashtable3.get("ASELECTACCOUNTENABLED");
            if (string5 == null) {
                this.logAuthentication(string, "0008", "denied");
                throw new ASelectUDBException("0008");
            }
            if (string5.equalsIgnoreCase("false")) {
                this.logAuthentication(string, "0008", "denied");
                throw new ASelectUDBException("0008");
            }
            string4 = null;
            string3 = null;
            Enumeration enumeration = hashtable3.keys();
            while (enumeration.hasMoreElements()) {
                String string6;
                string4 = (String)enumeration.nextElement();
                string3 = (String)hashtable3.get(string4);
                if (!string4.startsWith("ASELECT") || !string4.endsWith("REGISTERED") || !string3.equalsIgnoreCase("TRUE")) continue;
                String string7 = string4.substring(7, string4.length() - 10);
                StringBuffer stringBuffer2 = new StringBuffer("ASELECT");
                stringBuffer2.append(string7);
                stringBuffer2.append("USERATTRIBUTES");
                string3 = (String)hashtable3.get(stringBuffer2.toString());
                if (string3 == null) {
                    string3 = "";
                }
                if ((string6 = (String)this._htConfiguredAuthSPs.get(string7)) == null) continue;
                hashtable2.put(string6, string3);
            }
            if (hashtable2.size() == 0) {
                this._oASelectSystemLogger.log(Level.FINE, MODULE, string2, "No user attributes found for user: " + string);
                throw new ASelectUDBException("0003");
            }
            hashtable.put("user_authsps", hashtable2);
            hashtable.put("result_code", "0000");
        }
        catch (ASelectUDBException aSelectUDBException) {
            hashtable.put("result_code", aSelectUDBException.getMessage());
        }
        catch (Exception exception) {
            this._oASelectSystemLogger.log(Level.SEVERE, MODULE, string2, "Failed to fetch profile of user: " + string, (Throwable)exception);
            hashtable.put("result_code", "0060");
        }
        finally {
            try {
                if (resultSet != null) {
                    resultSet.close();
                }
                if (statement != null) {
                    statement.close();
                }
                if (connection != null) {
                    connection.close();
                }
            }
            catch (Exception exception) {}
        }
        return hashtable;
    }

    public String getUserAttributes(String string, String string2) throws ASelectUDBException {
        String string3 = "getUserAttributes()";
        String string4 = null;
        Connection connection = null;
        Statement statement = null;
        ResultSet resultSet = null;
        ResultSetMetaData resultSetMetaData = null;
        try {
            connection = this.getConnection();
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("SELECT * FROM ");
            stringBuffer.append(this._sUsersTableName);
            stringBuffer.append(" WHERE ");
            stringBuffer.append(this._sUserIdColumn);
            stringBuffer.append("=?");
            statement = connection.prepareStatement(stringBuffer.toString());
            statement.setString(1, string);
            resultSet = statement.executeQuery();
            if (resultSet.next()) {
                resultSetMetaData = resultSet.getMetaData();
                int n = resultSetMetaData.getColumnCount();
                for (int i = 1; i <= n; ++i) {
                    String string5;
                    String string6 = resultSetMetaData.getColumnName(i);
                    StringBuffer stringBuffer2 = new StringBuffer("ASELECT");
                    stringBuffer2.append(string2);
                    stringBuffer2.append("USERATTRIBUTES");
                    if (!string6.equalsIgnoreCase(stringBuffer2.toString())) continue;
                    string4 = string5 = resultSet.getString(i);
                    i = n;
                }
                if (string4 == null) {
                    StringBuffer stringBuffer3 = new StringBuffer("User attributes for AuthSP: '");
                    stringBuffer3.append(string2).append("' not found for user: '");
                    stringBuffer3.append(string).append("'");
                    this._oASelectSystemLogger.log(Level.FINE, MODULE, string3, stringBuffer3.toString());
                }
            } else {
                StringBuffer stringBuffer4 = new StringBuffer("User not found: '");
                stringBuffer4.append(string).append("'");
                this._oASelectSystemLogger.log(Level.FINE, MODULE, string3, stringBuffer4.toString(), (Throwable)new ASelectUDBException("0002"));
            }
        }
        catch (SQLException sQLException) {
            this._oASelectSystemLogger.log(Level.WARNING, MODULE, string3, "Could not execute database query", (Throwable)sQLException);
            throw new ASelectUDBException("0060", (Throwable)sQLException);
        }
        catch (ASelectUDBException aSelectUDBException) {
            throw aSelectUDBException;
        }
        catch (ASelectSAMException aSelectSAMException) {
            throw new ASelectUDBException(aSelectSAMException.getMessage(), (Throwable)aSelectSAMException);
        }
        finally {
            try {
                if (resultSet != null) {
                    resultSet.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (statement != null) {
                    statement.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (connection != null) {
                    connection.close();
                }
            }
            catch (Exception exception) {}
        }
        return string4;
    }

    public boolean isUserEnabled(String string) throws ASelectUDBException {
        String string2 = "isUserEnabled()";
        boolean bl = false;
        Connection connection = null;
        Statement statement = null;
        ResultSet resultSet = null;
        ResultSetMetaData resultSetMetaData = null;
        try {
            connection = this.getConnection();
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("SELECT * FROM ");
            stringBuffer.append(this._sUsersTableName);
            stringBuffer.append(" WHERE ");
            stringBuffer.append(this._sUserIdColumn);
            stringBuffer.append("=?");
            statement = connection.prepareStatement(stringBuffer.toString());
            statement.setString(1, string);
            resultSet = statement.executeQuery();
            if (resultSet.next()) {
                resultSetMetaData = resultSet.getMetaData();
                int n = resultSetMetaData.getColumnCount();
                for (int i = 1; i <= n; ++i) {
                    String string3 = resultSetMetaData.getColumnName(i);
                    if (!string3.equalsIgnoreCase("ASELECTACCOUNTENABLED")) continue;
                    String string4 = resultSet.getString(i);
                    if (string4 != null && string4.equalsIgnoreCase("true")) {
                        bl = true;
                        i = n;
                        continue;
                    }
                    i = n;
                }
                if (!bl) {
                    StringBuffer stringBuffer2 = new StringBuffer("User not A-Select enabled: '");
                    stringBuffer2.append(string).append("'");
                    this._oASelectSystemLogger.log(Level.FINE, MODULE, string2, stringBuffer2.toString(), (Throwable)new ASelectUDBException("0008"));
                }
            } else {
                StringBuffer stringBuffer3 = new StringBuffer("User not found: '");
                stringBuffer3.append(string).append("'");
                this._oASelectSystemLogger.log(Level.FINE, MODULE, string2, stringBuffer3.toString(), (Throwable)new ASelectUDBException("0002"));
            }
        }
        catch (SQLException sQLException) {
            this._oASelectSystemLogger.log(Level.WARNING, MODULE, string2, "Could not execute database query", (Throwable)sQLException);
            throw new ASelectUDBException("0060", (Throwable)sQLException);
        }
        catch (ASelectUDBException aSelectUDBException) {
            throw aSelectUDBException;
        }
        catch (ASelectSAMException aSelectSAMException) {
            throw new ASelectUDBException(aSelectSAMException.getMessage(), (Throwable)aSelectSAMException);
        }
        finally {
            try {
                if (resultSet != null) {
                    resultSet.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (statement != null) {
                    statement.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (connection != null) {
                    connection.close();
                }
            }
            catch (Exception exception) {}
        }
        return bl;
    }

    private Connection getConnection() throws ASelectUDBException, ASelectSAMException {
        String string = "getConnection()";
        Connection connection = null;
        SAMResource sAMResource = null;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        String string5 = null;
        Object object = null;
        try {
            sAMResource = this._oASelectSAMAgent.getActiveResource(this._sUDBResourceGroup);
        }
        catch (ASelectSAMException aSelectSAMException) {
            StringBuffer stringBuffer = new StringBuffer("No active resource found in udb resourcegroup: ");
            stringBuffer.append(this._sUDBResourceGroup);
            this._oASelectSystemLogger.log(Level.WARNING, MODULE, string, stringBuffer.toString(), (Throwable)aSelectSAMException);
            throw aSelectSAMException;
        }
        object = sAMResource.getAttributes();
        try {
            string2 = this._oASelectConfigManager.getParam(object, "driver");
        }
        catch (Exception exception) {
            this._oASelectSystemLogger.log(Level.WARNING, MODULE, string, "No config item 'driver' found", (Throwable)exception);
            throw new ASelectUDBException("4011", (Throwable)exception);
        }
        try {
            Class.forName(string2);
        }
        catch (Exception exception) {
            StringBuffer stringBuffer = new StringBuffer("Can't initialize driver: ");
            stringBuffer.append(string2);
            this._oASelectSystemLogger.log(Level.WARNING, MODULE, string, stringBuffer.toString(), (Throwable)exception);
            throw new ASelectUDBException("0001", (Throwable)exception);
        }
        try {
            string4 = this._oASelectConfigManager.getParam(object, "password");
        }
        catch (Exception exception) {
            string4 = "";
            this._oASelectSystemLogger.log(Level.CONFIG, MODULE, string, "No or empty config item 'security_principal_password' found, using empty password. Don't use this in a live production environment.", (Throwable)exception);
        }
        try {
            string5 = this._oASelectConfigManager.getParam(object, "url");
        }
        catch (Exception exception) {
            this._oASelectSystemLogger.log(Level.WARNING, MODULE, string, "No config item 'url' found", (Throwable)exception);
            throw new ASelectUDBException("4011", (Throwable)exception);
        }
        try {
            string3 = this._oASelectConfigManager.getParam(object, "username");
        }
        catch (Exception exception) {
            this._oASelectSystemLogger.log(Level.WARNING, MODULE, string, "No config item 'security_principal_name' found", (Throwable)exception);
            throw new ASelectUDBException("4011", (Throwable)exception);
        }
        try {
            connection = DriverManager.getConnection(string5, string3, string4);
        }
        catch (SQLException sQLException) {
            StringBuffer stringBuffer = new StringBuffer("Could not open connection to: ");
            stringBuffer.append(string5);
            this._oASelectSystemLogger.log(Level.WARNING, MODULE, string, stringBuffer.toString(), (Throwable)sQLException);
            throw new ASelectUDBException("4006", (Throwable)sQLException);
        }
        return connection;
    }

    private void logAuthentication(String string, String string2, String string3) {
        this._oASelectAuthenticationLogger.log(new Object[]{MODULE, string, null, null, null, string3, string2});
    }
}

