/*
 * Decompiled with CFR 0.152.
 */
package org.aselect.authspserver.crypto;

import java.io.File;
import java.io.FileInputStream;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.Security;
import java.security.Signature;
import java.security.cert.X509Certificate;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.logging.Level;
import org.aselect.authspserver.config.AuthSPConfigManager;
import org.aselect.authspserver.log.AuthSPSystemLogger;
import org.aselect.system.exception.ASelectConfigException;
import org.aselect.system.exception.ASelectException;
import org.aselect.system.utils.BASE64Decoder;
import org.aselect.system.utils.BASE64Encoder;

public class CryptoEngine {
    private static final String MODULE = "CryptoEngine";
    private static final String SERVER_KEYSTORE_NAME = "authsp.keystore";
    private static final String PUBLIC_KEYSTORE_NAME = "aselect.keystore";
    private static final String KEY_ALIAS = "authsp_sign";
    private final String DEFAULT_SIGNATURE_ALGORITHM = "SHA1withRSA";
    private PrivateKey _oPrivateKey = null;
    private PublicKey _oPublicKey = null;
    private AuthSPConfigManager _oAuthSPConfigManager = null;
    private AuthSPSystemLogger _systemLogger = null;
    private Hashtable _htPublicKeys = null;
    private String _sSignatureAlgorithm = null;
    private Provider _oSignatureProvider = null;

    public CryptoEngine(String string, AuthSPSystemLogger authSPSystemLogger) throws ASelectException {
        this._systemLogger = authSPSystemLogger;
        this._htPublicKeys = new Hashtable();
        String string2 = "CryptoEngine()";
        try {
            this._oAuthSPConfigManager = AuthSPConfigManager.getHandle();
            Object object = null;
            try {
                object = this._oAuthSPConfigManager.getSection(null, "authspserver");
            }
            catch (ASelectConfigException aSelectConfigException) {
                this._systemLogger.log(Level.SEVERE, MODULE, string2, "Could not find aselect config section in config file", aSelectConfigException);
                throw aSelectConfigException;
            }
            Object object2 = null;
            try {
                object2 = this._oAuthSPConfigManager.getSection(object, "crypto");
            }
            catch (ASelectConfigException aSelectConfigException) {
                this._systemLogger.log(Level.WARNING, MODULE, string2, "Could not find crypto config section in config file", aSelectConfigException);
                throw aSelectConfigException;
            }
            Object object3 = null;
            try {
                object3 = this._oAuthSPConfigManager.getSection(object2, "providers");
            }
            catch (ASelectConfigException aSelectConfigException) {
                this._systemLogger.log(Level.CONFIG, MODULE, string2, "Could not find 'providers' config section in configuration. No providers specified", aSelectConfigException);
            }
            Object object4 = null;
            Hashtable<String, Provider> hashtable = new Hashtable<String, Provider>();
            if (object3 != null) {
                try {
                    object4 = this._oAuthSPConfigManager.getSection(object3, "provider");
                }
                catch (ASelectConfigException aSelectConfigException) {
                    this._systemLogger.log(Level.CONFIG, MODULE, string2, "Could not find a 'provider' config section in config file. No providers specified", aSelectConfigException);
                    throw new ASelectException("4009", (Throwable)aSelectConfigException);
                }
                while (object4 != null) {
                    String string3 = null;
                    try {
                        string3 = this._oAuthSPConfigManager.getParam(object4, "id");
                    }
                    catch (ASelectConfigException aSelectConfigException) {
                        this._systemLogger.log(Level.CONFIG, MODULE, string2, "No valid 'id' config item found", aSelectConfigException);
                        throw new ASelectException("4009", (Throwable)aSelectConfigException);
                    }
                    String string4 = null;
                    try {
                        string4 = this._oAuthSPConfigManager.getParam(object4, "class");
                    }
                    catch (ASelectConfigException aSelectConfigException) {
                        this._systemLogger.log(Level.CONFIG, MODULE, string2, "No valid 'class' config item found", aSelectConfigException);
                        throw new ASelectException("4009", (Throwable)aSelectConfigException);
                    }
                    Provider provider = null;
                    try {
                        provider = (Provider)Class.forName(string4).newInstance();
                    }
                    catch (Exception exception) {
                        StringBuffer stringBuffer = new StringBuffer("The configured provider is not a valid Provider class: ");
                        stringBuffer.append(string4);
                        this._systemLogger.log(Level.CONFIG, MODULE, string2, string4, exception);
                        throw new ASelectException("4009", (Throwable)exception);
                    }
                    Security.addProvider(provider);
                    hashtable.put(string3, provider);
                    object4 = this._oAuthSPConfigManager.getNextSection(object4);
                }
            }
            this.readSignatureConfig(object2, hashtable);
            this.loadDefaultKeys(string);
            this.loadPublicKeys(string);
            if (this._htPublicKeys.size() == 0) {
                this._systemLogger.log(Level.CONFIG, MODULE, string2, "No public keys of any A-Select Server found.");
            }
        }
        catch (ASelectException aSelectException) {
            this._systemLogger.log(Level.SEVERE, MODULE, string2, "Could not initialize", aSelectException);
            throw aSelectException;
        }
        catch (Exception exception) {
            this._systemLogger.log(Level.SEVERE, MODULE, string2, "Could not initialise due to internal error", exception);
            throw new ASelectException("0001");
        }
    }

    public synchronized String generateSignature(String string) throws ASelectException {
        String string2 = "generateSignature()";
        String string3 = null;
        try {
            Signature signature = null;
            signature = this._oSignatureProvider != null ? Signature.getInstance(this._sSignatureAlgorithm, this._oSignatureProvider) : Signature.getInstance(this._sSignatureAlgorithm);
            signature.initSign(this._oPrivateKey);
            signature.update(string.getBytes());
            byte[] byArray = signature.sign();
            BASE64Encoder bASE64Encoder = new BASE64Encoder();
            string3 = bASE64Encoder.encode(byArray);
        }
        catch (Exception exception) {
            StringBuffer stringBuffer = new StringBuffer("Could not compute signature for data: \"");
            stringBuffer.append(string).append("\"");
            this._systemLogger.log(Level.WARNING, MODULE, string2, stringBuffer.toString(), exception);
            throw new ASelectException("0001");
        }
        return string3;
    }

    public synchronized boolean verifySignature(String string, String string2, String string3) {
        String string4 = "verifySignature()";
        boolean bl = false;
        string = string.toLowerCase();
        try {
            Signature signature = null;
            signature = this._oSignatureProvider != null ? Signature.getInstance(this._sSignatureAlgorithm, this._oSignatureProvider) : Signature.getInstance(this._sSignatureAlgorithm);
            PublicKey publicKey = (PublicKey)this._htPublicKeys.get(string);
            if (publicKey == null) {
                StringBuffer stringBuffer = new StringBuffer("Could not find public key with alias: ");
                stringBuffer.append(string);
                this._systemLogger.log(Level.WARNING, MODULE, string4, stringBuffer.toString());
                return bl;
            }
            signature.initVerify(publicKey);
            signature.update(string2.getBytes());
            BASE64Decoder bASE64Decoder = new BASE64Decoder();
            bl = signature.verify(bASE64Decoder.decodeBuffer(string3));
            if (!bl) {
                StringBuffer stringBuffer = new StringBuffer("Could not verify Signature '");
                stringBuffer.append(string3);
                stringBuffer.append("' for data: '");
                stringBuffer.append(string2);
                stringBuffer.append("' with a public key with Alias: ");
                stringBuffer.append(string);
                this._systemLogger.log(Level.FINE, MODULE, string4, stringBuffer.toString());
            }
        }
        catch (Exception exception) {
            StringBuffer stringBuffer = new StringBuffer("Could not verify signature for data: '");
            stringBuffer.append(string2);
            stringBuffer.append("' signature: '");
            stringBuffer.append(string3);
            stringBuffer.append("' alias: ");
            stringBuffer.append(string);
            this._systemLogger.log(Level.WARNING, MODULE, string4, stringBuffer.toString(), exception);
        }
        return bl;
    }

    public String getDescription() {
        return MODULE;
    }

    public synchronized boolean verifyMySignature(String string, String string2) {
        String string3 = "verifyMySignature()";
        boolean bl = false;
        try {
            Signature signature = null;
            signature = this._oSignatureProvider != null ? Signature.getInstance(this._sSignatureAlgorithm, this._oSignatureProvider) : Signature.getInstance(this._sSignatureAlgorithm);
            signature.initVerify(this._oPublicKey);
            signature.update(string.getBytes());
            BASE64Decoder bASE64Decoder = new BASE64Decoder();
            bl = signature.verify(bASE64Decoder.decodeBuffer(string2));
            if (!bl) {
                StringBuffer stringBuffer = new StringBuffer("Signature '");
                stringBuffer.append(string2);
                stringBuffer.append("' is invalid for data: ");
                stringBuffer.append(string);
                this._systemLogger.log(Level.FINE, MODULE, string3, stringBuffer.toString());
            }
        }
        catch (Exception exception) {
            StringBuffer stringBuffer = new StringBuffer("Error while verifying data: '");
            stringBuffer.append(string);
            stringBuffer.append("' with signature: '");
            stringBuffer.append(string2).append("'");
            this._systemLogger.log(Level.SEVERE, MODULE, string3, stringBuffer.toString(), exception);
        }
        return bl;
    }

    private void loadDefaultKeys(String string) throws ASelectException {
        String string2 = "loadDefaultKeys()";
        Object object = null;
        String string3 = null;
        try {
            AuthSPConfigManager authSPConfigManager = AuthSPConfigManager.getHandle();
            try {
                object = authSPConfigManager.getSection(null, "authspserver");
            }
            catch (ASelectConfigException aSelectConfigException) {
                this._systemLogger.log(Level.WARNING, MODULE, string2, "No 'authspserver' config section found", aSelectConfigException);
                throw new ASelectException("4009", (Throwable)aSelectConfigException);
            }
            try {
                string3 = authSPConfigManager.getParam(object, "keystore_password");
            }
            catch (ASelectConfigException aSelectConfigException) {
                this._systemLogger.log(Level.WARNING, MODULE, string2, "No 'keystore_password' config item in 'authspserver' section found.", aSelectConfigException);
                throw new ASelectException("4009", (Throwable)aSelectConfigException);
            }
            if (string3 == null) {
                this._systemLogger.log(Level.WARNING, MODULE, string2, "Missing 'keystore_password' config item in AuthSP Server configuration.");
                throw new ASelectException("4009");
            }
            StringBuffer stringBuffer = new StringBuffer(string);
            stringBuffer.append(File.separator);
            stringBuffer.append("keystores");
            stringBuffer.append(File.separator);
            stringBuffer.append(SERVER_KEYSTORE_NAME);
            File file = new File(stringBuffer.toString());
            if (!file.exists()) {
                StringBuffer stringBuffer2 = new StringBuffer("Keystore cannot be found: ");
                stringBuffer2.append(stringBuffer.toString());
                this._systemLogger.log(Level.SEVERE, MODULE, string2, stringBuffer2.toString());
                throw new ASelectException("4005");
            }
            KeyStore keyStore = KeyStore.getInstance("JKS");
            keyStore.load(new FileInputStream(stringBuffer.toString()), null);
            char[] cArray = string3.toCharArray();
            this._oPrivateKey = (PrivateKey)keyStore.getKey(KEY_ALIAS, cArray);
            X509Certificate x509Certificate = (X509Certificate)keyStore.getCertificate(KEY_ALIAS);
            this._oPublicKey = x509Certificate.getPublicKey();
        }
        catch (ASelectException aSelectException) {
            throw aSelectException;
        }
        catch (Exception exception) {
            StringBuffer stringBuffer = new StringBuffer("Error loading private key from directory: '");
            stringBuffer.append(string).append("'");
            this._systemLogger.log(Level.WARNING, MODULE, string2, stringBuffer.toString(), exception);
            throw new ASelectException("0001", (Throwable)exception);
        }
    }

    private void loadPublicKeys(String string) throws ASelectException {
        String string2 = "loadPublicKeys()";
        try {
            StringBuffer stringBuffer = new StringBuffer(string);
            stringBuffer.append(File.separator);
            stringBuffer.append("keystores");
            stringBuffer.append(File.separator);
            stringBuffer.append(PUBLIC_KEYSTORE_NAME);
            File file = new File(stringBuffer.toString());
            if (!file.exists()) {
                StringBuffer stringBuffer2 = new StringBuffer("Keystore cannot be found: ");
                stringBuffer2.append(stringBuffer.toString());
                this._systemLogger.log(Level.WARNING, MODULE, string2, stringBuffer2.toString());
                throw new ASelectException("4005");
            }
            KeyStore keyStore = KeyStore.getInstance("JKS");
            keyStore.load(new FileInputStream(stringBuffer.toString()), null);
            Enumeration<String> enumeration = keyStore.aliases();
            while (enumeration.hasMoreElements()) {
                String string3 = enumeration.nextElement();
                string3 = string3.toLowerCase();
                X509Certificate x509Certificate = (X509Certificate)keyStore.getCertificate(string3);
                PublicKey publicKey = x509Certificate.getPublicKey();
                this._htPublicKeys.put(string3, publicKey);
            }
        }
        catch (ASelectException aSelectException) {
            throw aSelectException;
        }
        catch (Exception exception) {
            StringBuffer stringBuffer = new StringBuffer(" Error loading public keys from directory: '");
            stringBuffer.append(string);
            stringBuffer.append("'");
            this._systemLogger.log(Level.WARNING, MODULE, string2, stringBuffer.toString(), exception);
            throw new ASelectException("0001", (Throwable)exception);
        }
    }

    private void readSignatureConfig(Object object, Hashtable hashtable) throws ASelectException {
        String string = "readSignatureConfig()";
        String string2 = null;
        Object object2 = null;
        try {
            object2 = this._oAuthSPConfigManager.getSection(object, "signature_algorithm");
        }
        catch (ASelectConfigException aSelectConfigException) {
            object2 = null;
            this._sSignatureAlgorithm = "SHA1withRSA";
            this._systemLogger.log(Level.CONFIG, MODULE, string, "Could not retrieve 'signature_algorithm' config section in crypto config section. Using default algorithm and provider.", aSelectConfigException);
        }
        if (object2 != null) {
            try {
                this._sSignatureAlgorithm = this._oAuthSPConfigManager.getParam(object2, "algorithm");
            }
            catch (ASelectConfigException aSelectConfigException) {
                this._sSignatureAlgorithm = "SHA1withRSA";
                StringBuffer stringBuffer = new StringBuffer("Could not retrieve 'algorithm' config parameter in crypto config section. Using default algorithm: ");
                stringBuffer.append(this._sSignatureAlgorithm);
                this._systemLogger.log(Level.CONFIG, MODULE, string, stringBuffer.toString());
            }
        }
        if (object2 != null) {
            try {
                string2 = this._oAuthSPConfigManager.getParam(object2, "provider");
            }
            catch (ASelectConfigException aSelectConfigException) {
                string2 = null;
                this._systemLogger.log(Level.CONFIG, MODULE, string, "Could not retrieve 'provider' config section in crypto config section. Using default provider.", aSelectConfigException);
            }
            if (string2 != null) {
                StringBuffer stringBuffer;
                if (!hashtable.containsKey(string2)) {
                    stringBuffer = new StringBuffer("Unknown 'provider': ");
                    stringBuffer.append(string2);
                    this._systemLogger.log(Level.SEVERE, MODULE, string, stringBuffer.toString());
                    throw new ASelectException("4009");
                }
                this._oSignatureProvider = (Provider)hashtable.get(string2);
                stringBuffer = new StringBuffer("Using provider '");
                stringBuffer.append(string2);
                stringBuffer.append("' for signature generation");
                this._systemLogger.log(Level.INFO, MODULE, string, stringBuffer.toString());
            }
        }
    }
}

