/*
 * Decompiled with CFR 0.152.
 */
package org.aselect.system.communication.client.raw;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.logging.Level;
import org.aselect.system.communication.client.IClientCommunicator;
import org.aselect.system.exception.ASelectCommunicationException;
import org.aselect.system.logging.SystemLogger;

public class RawCommunicator
implements IClientCommunicator {
    private SystemLogger _systemLogger;
    private static final String ENCODED_BRACES = "%5B%5D";
    private final String MODULE = "RawCommunicator";

    public RawCommunicator(SystemLogger systemLogger) {
        this._systemLogger = systemLogger;
    }

    public Hashtable sendMessage(Hashtable hashtable, String string) throws ASelectCommunicationException {
        Hashtable hashtable2 = new Hashtable();
        try {
            String string2 = RawCommunicator.hashtable2CGIMessage(hashtable);
            String string3 = this.sendRequestToASelectServer(string, string2);
            if (string3 != null) {
                hashtable2 = this.convertCGIMessage(string3);
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            this._systemLogger.log(Level.WARNING, "RawCommunicator", "sendMessage()", "Could not URL encode/decode one or more values", unsupportedEncodingException);
            throw new ASelectCommunicationException("0001");
        }
        return hashtable2;
    }

    private String sendRequestToASelectServer(String string, String string2) throws ASelectCommunicationException {
        String string3 = "";
        URL uRL = null;
        BufferedReader bufferedReader = null;
        String string4 = "sendRequestToASelectServer()";
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer = new StringBuffer(string);
        stringBuffer.append("?");
        stringBuffer.append(string2);
        try {
            uRL = new URL(stringBuffer.toString());
            bufferedReader = new BufferedReader(new InputStreamReader(uRL.openStream()), 16000);
            string3 = bufferedReader.readLine();
            bufferedReader.close();
            if (string3 != null) {
                string3 = string3.trim();
            }
        }
        catch (MalformedURLException malformedURLException) {
            stringBuffer = new StringBuffer("Invalid URL: \"");
            stringBuffer.append(string);
            stringBuffer.append("\" errorcode: ");
            stringBuffer.append("4007");
            this._systemLogger.log(Level.WARNING, "RawCommunicator", string4, stringBuffer.toString(), malformedURLException);
            throw new ASelectCommunicationException("4007", malformedURLException);
        }
        catch (IOException iOException) {
            stringBuffer = new StringBuffer("Error communicating with A-Select Server: \"");
            stringBuffer.append(string);
            stringBuffer.append("\" errorcode: ");
            stringBuffer.append("4006");
            this._systemLogger.log(Level.WARNING, "RawCommunicator", string4, stringBuffer.toString(), iOException);
            throw new ASelectCommunicationException("4006", iOException);
        }
        return string3;
    }

    private static String hashtable2CGIMessage(Hashtable hashtable) throws UnsupportedEncodingException {
        boolean bl;
        StringBuffer stringBuffer = new StringBuffer();
        Enumeration enumeration = hashtable.keys();
        boolean bl2 = bl = !enumeration.hasMoreElements();
        while (!bl) {
            Object object;
            String string = (String)enumeration.nextElement();
            Object v = hashtable.get(string);
            if (v instanceof String) {
                stringBuffer.append(string);
                stringBuffer.append("=");
                object = URLEncoder.encode((String)v, "UTF-8");
                stringBuffer.append((String)object);
            } else if (v instanceof String[]) {
                object = (String[])v;
                for (int i = 0; i < ((String[])object).length; ++i) {
                    stringBuffer.append(string).append(ENCODED_BRACES);
                    stringBuffer.append("=");
                    String string2 = URLEncoder.encode(object[i], "UTF-8");
                    stringBuffer.append(string2);
                    if (i >= ((String[])object).length - 1) continue;
                    stringBuffer.append("&");
                }
            }
            if (enumeration.hasMoreElements()) {
                stringBuffer.append("&");
                continue;
            }
            bl = true;
        }
        return stringBuffer.toString();
    }

    public Hashtable convertCGIMessage(String string) throws UnsupportedEncodingException {
        StringTokenizer stringTokenizer = null;
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        Hashtable<String, Object> hashtable2 = new Hashtable<String, Object>();
        if (string != null) {
            Object object;
            stringTokenizer = new StringTokenizer(string, "&");
            while (stringTokenizer.hasMoreElements()) {
                String string2;
                int n;
                String string3 = (String)stringTokenizer.nextElement();
                if (string3.trim().equals("") || (n = string3.indexOf(61)) == -1) continue;
                String string4 = string3.substring(0, n);
                try {
                    string2 = string3.substring(n + 1);
                }
                catch (Exception exception) {
                    string2 = "";
                }
                if (string4 == null || string2 == null) continue;
                string2 = URLDecoder.decode(string2, "UTF-8");
                if (string4.endsWith(ENCODED_BRACES)) {
                    string4 = string4.substring(0, string4.lastIndexOf(ENCODED_BRACES));
                    object = null;
                    if (hashtable2.containsKey(string4)) {
                        object = (Vector)hashtable2.get(string4);
                        ((Vector)object).add(string2);
                    } else {
                        object = new Vector();
                        ((Vector)object).add(string2);
                    }
                    hashtable2.put(string4, object);
                    continue;
                }
                hashtable.put(string4, string2);
            }
            if (!hashtable2.isEmpty()) {
                object = hashtable2.keys();
                while (object.hasMoreElements()) {
                    String string5 = (String)object.nextElement();
                    Vector vector = (Vector)hashtable2.get(string5);
                    String[] stringArray = new String[vector.size()];
                    try {
                        stringArray = vector.toArray(stringArray);
                    }
                    catch (Exception exception) {
                        this._systemLogger.log(Level.WARNING, "RawCommunicator", "convertCGIMessage()", "Could not convert Vector to array", exception);
                    }
                    hashtable.put(string5, stringArray);
                }
            }
        }
        return hashtable;
    }
}

