/*
 * Decompiled with CFR 0.152.
 */
package org.aselect.system.communication.server;

import java.io.IOException;
import java.io.OutputStream;
import java.net.Socket;
import java.util.Hashtable;
import java.util.Iterator;
import org.aselect.system.communication.server.IProtocolResponse;

public class TCPProtocolResponse
implements IProtocolResponse {
    private Hashtable _htHeaders;
    private Socket _oSocket;
    private String _sStatusCode;
    private String _sProtocolName;

    public TCPProtocolResponse(Socket socket, String string) {
        this._oSocket = socket;
        this._sProtocolName = string;
        this._sStatusCode = null;
        this._htHeaders = new Hashtable();
    }

    public void setProperty(String string, String string2) {
        if (string.equalsIgnoreCase("Status")) {
            try {
                switch (Integer.parseInt(string2)) {
                    case 200: {
                        this._sStatusCode = this._sProtocolName + " 200 OK";
                    }
                    case 400: {
                        this._sStatusCode = this._sProtocolName + " 400 Bad Request";
                    }
                    case 500: {
                        this._sStatusCode = this._sProtocolName + " 500 Internal Server Error";
                    }
                }
                StringBuffer stringBuffer = new StringBuffer(this._sProtocolName);
                stringBuffer.append(" ").append(string2);
                this._sStatusCode = stringBuffer.toString();
            }
            catch (NumberFormatException numberFormatException) {
                StringBuffer stringBuffer = new StringBuffer(this._sProtocolName);
                stringBuffer.append(" ").append(string2);
                this._sStatusCode = stringBuffer.toString();
            }
        } else {
            this._htHeaders.put(string, string2);
        }
    }

    public OutputStream getOutputStream() throws IOException {
        OutputStream outputStream = this._oSocket.getOutputStream();
        if (outputStream != null) {
            if (!this._htHeaders.isEmpty()) {
                if (this._sStatusCode == null) {
                    this.setProperty("Status", "200");
                }
                outputStream.write((this._sStatusCode + "\r\n").getBytes());
                StringBuffer stringBuffer = new StringBuffer();
                Iterator iterator = this._htHeaders.keySet().iterator();
                while (iterator.hasNext()) {
                    String string = (String)iterator.next();
                    stringBuffer.append(string);
                    stringBuffer.append(": ");
                    stringBuffer.append(this._htHeaders.get(string));
                    stringBuffer.append("\r\n");
                    outputStream.write(stringBuffer.toString().getBytes());
                }
                outputStream.write("\r\n".getBytes());
                this._htHeaders = new Hashtable();
            }
        } else {
            throw new IOException("Can't retrieve OutputStream from Socket.");
        }
        return outputStream;
    }
}

