/*
 * Decompiled with CFR 0.152.
 */
package org.aselect.system.configmanager;

import java.io.File;
import java.util.logging.Level;
import org.aselect.system.configmanager.IConfigHandler;
import org.aselect.system.configmanager.handler.XMLConfigHandler;
import org.aselect.system.exception.ASelectConfigException;
import org.aselect.system.logging.SystemLogger;

public class ConfigManager {
    private static final String MODULE = "ConfigManager";
    private IConfigHandler _oConfigHandler = null;
    private SystemLogger _oSystemLogger = null;

    public void init(String string, SystemLogger systemLogger) throws ASelectConfigException {
        StringBuffer stringBuffer = new StringBuffer();
        String string2 = "init()";
        try {
            this._oSystemLogger = systemLogger;
            File file = new File(string);
            if (file != null && file.exists()) {
                this._oConfigHandler = this.resolveConfigHandler(file);
                if (this._oConfigHandler == null) {
                    stringBuffer.append("Can't open file: ");
                    stringBuffer.append(string);
                    this._oSystemLogger.log(Level.SEVERE, MODULE, string2, stringBuffer.toString());
                    throw new ASelectConfigException("4002");
                }
            } else {
                stringBuffer.append("File doesn't exist: ");
                stringBuffer.append(string);
                this._oSystemLogger.log(Level.SEVERE, MODULE, string2, stringBuffer.toString());
                throw new ASelectConfigException("4005");
            }
            this._oConfigHandler.init(file);
        }
        catch (ASelectConfigException aSelectConfigException) {
            throw aSelectConfigException;
        }
        catch (Exception exception) {
            stringBuffer.append(exception.getMessage());
            this._oSystemLogger.log(Level.SEVERE, MODULE, string2, stringBuffer.toString());
            throw new ASelectConfigException("0001", exception);
        }
    }

    public void init(String string, String string2, String string3, String string4, String string5, String string6, SystemLogger systemLogger) throws ASelectConfigException {
        StringBuffer stringBuffer = new StringBuffer();
        String string7 = "init()";
        try {
            this._oSystemLogger = systemLogger;
            if (string == null || string2 == null || string3 == null || string4 == null || string5 == null || string6 == null) {
                stringBuffer.append("One or more required arguments are null.");
                this._oSystemLogger.log(Level.SEVERE, MODULE, string7, stringBuffer.toString());
                throw new ASelectConfigException("4002");
            }
            this._oConfigHandler = this.resolveConfigHandler();
            if (this._oConfigHandler == null) {
                stringBuffer.append("Can't resolve configuration from database.");
                this._oSystemLogger.log(Level.SEVERE, MODULE, string7, stringBuffer.toString());
                throw new ASelectConfigException("4002");
            }
            this._oConfigHandler.init(string2, string3, string4, string5, string, string6);
        }
        catch (Exception exception) {
            stringBuffer.append("Error initializing using database configuration: ");
            stringBuffer.append(exception.getMessage());
            this._oSystemLogger.log(Level.SEVERE, MODULE, string7, stringBuffer.toString());
            throw new ASelectConfigException("0001", exception);
        }
    }

    public Object getSection(Object object, String string, String string2) throws ASelectConfigException {
        return this._oConfigHandler.getSection(object, string, string2);
    }

    public Object getSection(Object object, String string) throws ASelectConfigException {
        return this._oConfigHandler.getSection(object, string);
    }

    public Object setSection(Object object, String string) throws ASelectConfigException {
        return this._oConfigHandler.setSection(object, string);
    }

    public boolean removeSection(Object object, String string) throws ASelectConfigException {
        return this._oConfigHandler.removeSection(object, string);
    }

    public boolean removeSection(Object object, String string, String string2) throws ASelectConfigException {
        return this._oConfigHandler.removeSection(object, string, string2);
    }

    public String getParam(Object object, String string) throws ASelectConfigException {
        return this._oConfigHandler.getParam(object, string);
    }

    public boolean setParam(Object object, String string, String string2, boolean bl) throws ASelectConfigException {
        return this._oConfigHandler.setParam(object, string, string2, bl);
    }

    public Object getNextSection(Object object) throws ASelectConfigException {
        return this._oConfigHandler.getNextSection(object);
    }

    public void saveConfig() throws ASelectConfigException {
        this._oConfigHandler.saveConfig();
    }

    public void importConfig(File file) throws ASelectConfigException {
        String string = "importConfig()";
        if (file == null) {
            this._oSystemLogger.log(Level.WARNING, MODULE, string, "File object is null.");
            throw new ASelectConfigException("4002");
        }
        this._oConfigHandler.importConfig(file);
    }

    private IConfigHandler resolveConfigHandler(File file) {
        String string = "resolveConfigHandler()";
        XMLConfigHandler xMLConfigHandler = null;
        int n = -1;
        String string2 = null;
        String string3 = null;
        string2 = file.getName();
        if (string2 == null) {
            this._oSystemLogger.log(Level.SEVERE, MODULE, string, "Filename is null.");
        }
        n = string2.lastIndexOf(".");
        string3 = file.getName().substring(n + 1);
        xMLConfigHandler = string3.equalsIgnoreCase("XML") ? new XMLConfigHandler(this._oSystemLogger) : new XMLConfigHandler(this._oSystemLogger);
        return xMLConfigHandler;
    }

    private IConfigHandler resolveConfigHandler() {
        return new XMLConfigHandler(this._oSystemLogger);
    }
}

