/*
 * Decompiled with CFR 0.152.
 */
package org.aselect.system.sam.service;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.logging.Level;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.aselect.system.communication.server.Communicator;
import org.aselect.system.communication.server.IInputMessage;
import org.aselect.system.communication.server.IMessageCreatorInterface;
import org.aselect.system.communication.server.IOutputMessage;
import org.aselect.system.communication.server.ServletRequestWrapper;
import org.aselect.system.communication.server.ServletResponseWrapper;
import org.aselect.system.communication.server.raw.RawMessageCreator;
import org.aselect.system.communication.server.soap11.SOAP11MessageCreator;
import org.aselect.system.communication.server.soap12.SOAP12MessageCreator;
import org.aselect.system.exception.ASelectCommunicationException;
import org.aselect.system.logging.SystemLogger;
import org.aselect.system.utils.Utils;

public abstract class SAMServiceServlet
extends HttpServlet {
    protected Hashtable _htOIDs;
    protected String _sWorkingDir;
    protected String _sSAMServiceForm;
    protected String _sSAMServiceStatusForm;
    private static final String MODULE = "SAMServiceServlet";
    private String _sContextUrl;

    public void init(ServletConfig servletConfig) throws ServletException {
        StringBuffer stringBuffer = new StringBuffer();
        String string = "init()";
        try {
            super.init(servletConfig);
            this._sWorkingDir = servletConfig.getInitParameter("working_dir");
            if (this._sWorkingDir == null) {
                throw new Exception("No working_dir init-param found in web.xml");
            }
            if (!this._sWorkingDir.endsWith(File.separator)) {
                this._sWorkingDir = this._sWorkingDir + File.separator;
            }
            this._sWorkingDir = this._sWorkingDir + "html" + File.separator;
            File file = new File(this._sWorkingDir);
            if (!file.exists()) {
                StringBuffer stringBuffer2 = new StringBuffer("No valid template directory found: ");
                stringBuffer2.append(this._sWorkingDir);
                throw new Exception(stringBuffer2.toString());
            }
            String string2 = this._sWorkingDir + "samservice.html";
            File file2 = new File(string2);
            if (!file2.exists()) {
                StringBuffer stringBuffer3 = new StringBuffer("No valid samservice template directory found: ");
                stringBuffer3.append(string2);
                throw new Exception(stringBuffer3.toString());
            }
            this._sSAMServiceForm = this.loadTemplateFile(string2);
            String string3 = this._sWorkingDir + "samservice_status.html";
            File file3 = new File(string3);
            if (!file3.exists()) {
                StringBuffer stringBuffer4 = new StringBuffer("No valid samservice status template directory found: ");
                stringBuffer4.append(string3);
                throw new Exception(stringBuffer4.toString());
            }
            this._sSAMServiceStatusForm = this.loadTemplateFile(string3);
            this.getServletContext().setAttribute("inittime", (Object)new Long(System.currentTimeMillis()));
            this._htOIDs = new Hashtable();
            this._htOIDs.put("1.3.6.1.4.1.15396.10.10.2.1.1", "a-select.statistics.sysDescr");
            this._htOIDs.put("1.3.6.1.4.1.15396.10.10.2.1.2", "a-select.statistics.version");
            this._htOIDs.put("1.3.6.1.4.1.15396.10.10.2.1.3", "a-select.statistics.operational");
            this._htOIDs.put("1.3.6.1.4.1.15396.10.10.2.1.4", "a-select.statistics.uptime");
            this._htOIDs.put("1.3.6.1.4.1.15396.10.10.2.1.5", "a-select.statistics.load");
            this._htOIDs.put("1.3.6.1.4.1.15396.10.10.2.1.6", "a-select.statistics.wwwDescr");
            this._htOIDs.put("1.3.6.1.4.1.15396.10.10.2.1.7", "a-select.statistics.cpus");
            this._htOIDs.put("1.3.6.1.4.1.15396.10.10.2.1.8", "a-select.statistics.freeMem");
            this._htOIDs.put("1.3.6.1.4.1.15396.10.10.2.1.9", "a-select.statistics.maxMem");
            this._htOIDs.put("1.3.6.1.4.1.15396.10.10.2.1.10", "a-select.statistics.totalMem");
        }
        catch (Exception exception) {
            stringBuffer.append(exception.getMessage());
            this.getSystemLogger().log(Level.SEVERE, MODULE, string, stringBuffer.toString());
            throw new ServletException(stringBuffer.toString(), (Throwable)exception);
        }
    }

    public void destroy() {
        super.destroy();
    }

    protected abstract SystemLogger getSystemLogger();

    protected abstract Hashtable getSAMInfo();

    protected String getContextUrl() {
        return this._sContextUrl;
    }

    protected abstract int operational();

    protected abstract String getSysDescr();

    protected abstract String getVersion();

    protected Hashtable getCommonSAMInfo() {
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        hashtable.put("1.3.6.1.4.1.15396.10.10.2.1.1", this.getSysDescr());
        hashtable.put("1.3.6.1.4.1.15396.10.10.2.1.2", this.getVersion());
        hashtable.put("1.3.6.1.4.1.15396.10.10.2.1.3", "" + this.operational());
        Long l = (Long)this.getServletContext().getAttribute("inittime");
        long l2 = System.currentTimeMillis() - l;
        long l3 = l2 / 86400000L;
        long l4 = l2 % 86400000L / 3600000L;
        long l5 = l2 % 3600000L / 60000L;
        long l6 = l2 % 3600000L % 60000L / 1000L;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(l3);
        stringBuffer.append(":");
        stringBuffer.append(l4);
        stringBuffer.append(":");
        stringBuffer.append(l5);
        stringBuffer.append(":");
        stringBuffer.append(l6);
        hashtable.put("1.3.6.1.4.1.15396.10.10.2.1.4", stringBuffer.toString());
        hashtable.put("1.3.6.1.4.1.15396.10.10.2.1.5", "-1");
        hashtable.put("1.3.6.1.4.1.15396.10.10.2.1.6", this.getServletContext().getServerInfo());
        hashtable.put("1.3.6.1.4.1.15396.10.10.2.1.7", "" + Runtime.getRuntime().availableProcessors());
        hashtable.put("1.3.6.1.4.1.15396.10.10.2.1.8", "" + Runtime.getRuntime().freeMemory());
        hashtable.put("1.3.6.1.4.1.15396.10.10.2.1.9", "" + Runtime.getRuntime().maxMemory());
        hashtable.put("1.3.6.1.4.1.15396.10.10.2.1.10", "" + Runtime.getRuntime().totalMemory());
        return hashtable;
    }

    protected void service(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        block12: {
            String string = "service()";
            IMessageCreatorInterface iMessageCreatorInterface = null;
            Communicator communicator = null;
            try {
                this.setDisableCachingHttpHeaders(httpServletRequest, httpServletResponse);
                this._sContextUrl = httpServletRequest.getContextPath();
                String string2 = httpServletRequest.getMethod();
                if (string2.equalsIgnoreCase("GET")) {
                    String string3 = httpServletRequest.getQueryString();
                    if (string3 != null) {
                        if (string3.equalsIgnoreCase("status")) {
                            httpServletResponse.setContentType("text/html");
                            this.showSAMStatusPage(httpServletResponse.getWriter(), this.getSAMInfo());
                        } else {
                            iMessageCreatorInterface = new RawMessageCreator(this.getSystemLogger());
                            communicator = new Communicator(iMessageCreatorInterface);
                            this.processRequest(communicator, httpServletRequest, httpServletResponse);
                        }
                    } else {
                        httpServletResponse.setContentType("text/html");
                        String string4 = httpServletRequest.getRequestURL().append("?status").toString();
                        this.showSAMPage(httpServletResponse.getWriter(), string4);
                    }
                } else if (string2.equalsIgnoreCase("POST")) {
                    String string5 = httpServletRequest.getContentType();
                    String string6 = httpServletRequest.getRequestURL().toString();
                    if (string5.indexOf("text/xml") > -1) {
                        iMessageCreatorInterface = new SOAP11MessageCreator(string6, "Status", this.getSystemLogger());
                    } else if (string5.indexOf("application/soap+xml") > -1) {
                        iMessageCreatorInterface = new SOAP12MessageCreator(string6, "Status", this.getSystemLogger());
                    }
                    communicator = new Communicator(iMessageCreatorInterface);
                    this.processRequest(communicator, httpServletRequest, httpServletResponse);
                }
            }
            catch (Exception exception) {
                this.getSystemLogger().log(Level.SEVERE, MODULE, string, "Internal error", exception);
                if (httpServletResponse.isCommitted()) break block12;
                httpServletResponse.sendError(500, "Internal error");
            }
        }
    }

    private void processRequest(Communicator communicator, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        StringBuffer stringBuffer = new StringBuffer();
        String string = "processRequest()";
        ServletRequestWrapper servletRequestWrapper = new ServletRequestWrapper(httpServletRequest);
        ServletResponseWrapper servletResponseWrapper = new ServletResponseWrapper(httpServletResponse);
        try {
            Object object;
            if (!communicator.init(servletRequestWrapper, servletResponseWrapper)) {
                throw new Exception("Could not parse SAM Request");
            }
            IInputMessage iInputMessage = communicator.getInputMessage();
            String[] stringArray = iInputMessage.getArray("get");
            Hashtable hashtable = this.getSAMInfo();
            Hashtable hashtable2 = new Hashtable();
            for (int i = 0; i < stringArray.length; ++i) {
                if (stringArray[i].endsWith(".*")) {
                    stringArray[i] = stringArray[i].substring(0, stringArray[i].length() - 1);
                }
                if (stringArray[i].endsWith(".")) {
                    Enumeration enumeration = hashtable.keys();
                    while (enumeration.hasMoreElements()) {
                        object = (String)enumeration.nextElement();
                        if (!object.startsWith(stringArray[i])) continue;
                        hashtable2.put(object, hashtable.get(object));
                    }
                    continue;
                }
                if (!hashtable.containsKey(stringArray[i])) continue;
                hashtable2.put(stringArray[i], hashtable.get(stringArray[i]));
            }
            IOutputMessage iOutputMessage = communicator.getOutputMessage();
            int n = hashtable2.size();
            object = new String[n];
            Enumeration enumeration = hashtable2.keys();
            for (int i = 0; i < n; ++i) {
                String string2 = (String)enumeration.nextElement();
                StringBuffer stringBuffer2 = new StringBuffer(string2);
                stringBuffer2.append("=");
                stringBuffer2.append((String)hashtable2.get(string2));
                object[i] = stringBuffer2.toString();
            }
            iOutputMessage.setParam("samversion", "1.0");
            iOutputMessage.setParam("get", (String[])object);
            if (!communicator.send()) {
                throw new Exception("Could not send response message");
            }
        }
        catch (ASelectCommunicationException aSelectCommunicationException) {
            stringBuffer.append("could not read incomming message");
            this.getSystemLogger().log(Level.WARNING, MODULE, string, stringBuffer.toString(), aSelectCommunicationException);
        }
        catch (Exception exception) {
            stringBuffer.append(exception.getMessage());
            this.getSystemLogger().log(Level.WARNING, MODULE, string, stringBuffer.toString());
        }
    }

    private void setDisableCachingHttpHeaders(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        if (httpServletRequest.getProtocol().equalsIgnoreCase("HTTP/1.0")) {
            httpServletResponse.setHeader("Pragma", "no-cache");
        } else if (httpServletRequest.getProtocol().equalsIgnoreCase("HTTP/1.1")) {
            httpServletResponse.setHeader("Cache-Control", "no-store, no-cache, must-revalidate");
        }
        httpServletResponse.setHeader("Expires", "-1");
    }

    private void showSAMStatusPage(PrintWriter printWriter, Hashtable hashtable) {
        String string = this._sSAMServiceStatusForm;
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            StringBuffer stringBuffer = new StringBuffer("[");
            stringBuffer.append(string2);
            stringBuffer.append(".name]");
            String string3 = "";
            if (this._htOIDs.containsKey(string2)) {
                string3 = (String)this._htOIDs.get(string2);
            }
            string = Utils.replaceString(string, stringBuffer.toString(), string3);
            StringBuffer stringBuffer2 = new StringBuffer("[");
            stringBuffer2.append(string2);
            stringBuffer2.append(".value]");
            String string4 = (String)hashtable.get(string2);
            string = Utils.replaceString(string, stringBuffer2.toString(), string4);
        }
        printWriter.println(string);
    }

    private void showSAMPage(PrintWriter printWriter, String string) {
        String string2 = this._sSAMServiceForm;
        string2 = Utils.replaceString(string2, "[samservice_status_url]", string);
        printWriter.println(string2);
    }

    private String loadTemplateFile(String string) throws Exception {
        String string2 = null;
        String string3 = null;
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(new FileInputStream(string)));
        string3 = "\r\n";
        StringBuffer stringBuffer = new StringBuffer();
        while ((string2 = bufferedReader.readLine()) != null) {
            stringBuffer.append(string2).append(string3);
        }
        bufferedReader.close();
        return stringBuffer.toString();
    }
}

