/*
 * Decompiled with CFR 0.152.
 */
package org.aselect.system.storagemanager.handler;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.Hashtable;
import java.util.logging.Level;
import org.aselect.system.configmanager.ConfigManager;
import org.aselect.system.exception.ASelectConfigException;
import org.aselect.system.exception.ASelectSAMException;
import org.aselect.system.exception.ASelectStorageException;
import org.aselect.system.logging.SystemLogger;
import org.aselect.system.sam.agent.SAMAgent;
import org.aselect.system.sam.agent.SAMResource;
import org.aselect.system.storagemanager.IStorageHandler;

public class JDBCStorageHandler
implements IStorageHandler {
    private static final String MODULE = "JDBCStorageHandler";
    private Connection _oActiveConnection;
    private SAMResource _oActiveResource;
    private String _sTableName;
    private String _sResourceGroup;
    private String _sContextKeyHash;
    private String _sContextTimestamp;
    private String _sContextKey;
    private String _sContextValue;
    private SystemLogger _systemLogger;
    private ConfigManager _oConfigManager;
    private SAMAgent _oSAMAgent;

    public void init(Object object, ConfigManager configManager, SystemLogger systemLogger, SAMAgent sAMAgent) throws ASelectStorageException {
        String string = "init()";
        Object object2 = null;
        try {
            this._systemLogger = systemLogger;
            this._oConfigManager = configManager;
            this._oSAMAgent = sAMAgent;
            try {
                this._sResourceGroup = configManager.getParam(object, "resourcegroup");
            }
            catch (ASelectConfigException aSelectConfigException) {
                this._systemLogger.log(Level.WARNING, MODULE, string, "No valid 'resourcegroup' section found", aSelectConfigException);
                throw new ASelectStorageException("4009", aSelectConfigException);
            }
            try {
                object2 = configManager.getSection(object, "table");
            }
            catch (ASelectConfigException aSelectConfigException) {
                this._systemLogger.log(Level.WARNING, MODULE, string, "No valid 'table' config section found", aSelectConfigException);
                throw new ASelectStorageException("4009", aSelectConfigException);
            }
            try {
                this._sTableName = configManager.getParam(object2, "name");
            }
            catch (ASelectConfigException aSelectConfigException) {
                this._systemLogger.log(Level.WARNING, MODULE, string, "No valid 'name' config item in 'table' section found", aSelectConfigException);
                throw new ASelectStorageException("4009", aSelectConfigException);
            }
            try {
                this._sContextKeyHash = configManager.getParam(object2, "hash");
            }
            catch (ASelectConfigException aSelectConfigException) {
                this._systemLogger.log(Level.WARNING, MODULE, string, "No valid 'hash' config item in 'table' section found", aSelectConfigException);
                throw new ASelectStorageException("4009", aSelectConfigException);
            }
            try {
                this._sContextTimestamp = configManager.getParam(object2, "timestamp");
            }
            catch (ASelectConfigException aSelectConfigException) {
                this._systemLogger.log(Level.WARNING, MODULE, string, "No valid 'timestamp' config item in 'table' section found", aSelectConfigException);
                throw new ASelectStorageException("4009", aSelectConfigException);
            }
            try {
                this._sContextKey = configManager.getParam(object2, "key");
            }
            catch (ASelectConfigException aSelectConfigException) {
                this._systemLogger.log(Level.WARNING, MODULE, string, "No valid 'key' config item in 'table' section found", aSelectConfigException);
                throw new ASelectStorageException("4009", aSelectConfigException);
            }
            try {
                this._sContextValue = configManager.getParam(object2, "value");
            }
            catch (ASelectConfigException aSelectConfigException) {
                this._systemLogger.log(Level.WARNING, MODULE, string, "No valid 'value' config item in 'table' section found", aSelectConfigException);
                throw new ASelectStorageException("4009", aSelectConfigException);
            }
            this.getConnection();
        }
        catch (ASelectStorageException aSelectStorageException) {
            throw aSelectStorageException;
        }
        catch (Exception exception) {
            this._systemLogger.log(Level.SEVERE, MODULE, string, "The JDBC IStorageHandler could not be initialized", exception);
            throw new ASelectStorageException("0001");
        }
    }

    public Object get(Object object) throws ASelectStorageException {
        Object object2;
        String string;
        block16: {
            string = "get()";
            object2 = null;
            Statement statement = null;
            ResultSet resultSet = null;
            try {
                int n = object.hashCode();
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append("SELECT ").append(this._sContextValue).append(" ");
                stringBuffer.append("FROM ").append(this._sTableName).append(" ");
                stringBuffer.append("WHERE ").append(this._sContextKeyHash).append(" = ?");
                Connection connection = this.getConnection();
                statement = connection.prepareStatement(stringBuffer.toString());
                statement.setInt(1, n);
                resultSet = statement.executeQuery();
                if (resultSet.next()) {
                    object2 = JDBCStorageHandler.decode(resultSet.getBytes(this._sContextValue));
                    break block16;
                }
                this._systemLogger.log(Level.FINE, MODULE, string, "The supplied key is not mapped to any value.");
                throw new ASelectStorageException("6003");
            }
            catch (IOException iOException) {
                this._systemLogger.log(Level.WARNING, MODULE, string, "Could not decode the object from the database", iOException);
                throw new ASelectStorageException("6002", iOException);
            }
            catch (ClassNotFoundException classNotFoundException) {
                this._systemLogger.log(Level.WARNING, MODULE, string, "Could not decode the object from the database", classNotFoundException);
                throw new ASelectStorageException("6002", classNotFoundException);
            }
            catch (NullPointerException nullPointerException) {
                this._systemLogger.log(Level.WARNING, MODULE, string, "Empty (null) key-object was supplied", nullPointerException);
                throw new ASelectStorageException("6002", nullPointerException);
            }
            catch (Exception exception) {
                this._systemLogger.log(Level.WARNING, MODULE, string, "Could not retrieve the object from the database", exception);
                throw new ASelectStorageException("6002", exception);
            }
            finally {
                try {
                    if (resultSet != null) {
                        resultSet.close();
                        resultSet = null;
                    }
                    if (statement != null) {
                        statement.close();
                        statement = null;
                    }
                }
                catch (SQLException sQLException) {
                    this._systemLogger.log(Level.FINE, MODULE, string, "Could not close database resource.", sQLException);
                }
            }
        }
        if (object2 == null) {
            this._systemLogger.log(Level.WARNING, MODULE, string, "The supplied key is not mapped to any value", new ASelectStorageException("6002"));
            throw new ASelectStorageException("6002");
        }
        return object2;
    }

    public long getTimestamp(Object object) throws ASelectStorageException {
        long l;
        String string;
        block16: {
            string = "getTimestamp()";
            l = 0L;
            Statement statement = null;
            ResultSet resultSet = null;
            StringBuffer stringBuffer = new StringBuffer();
            try {
                int n = object.hashCode();
                stringBuffer.append("SELECT ").append(this._sContextTimestamp).append(" ");
                stringBuffer.append("FROM ").append(this._sTableName).append(" ");
                stringBuffer.append("WHERE ").append(this._sContextKeyHash).append(" = ?");
                Connection connection = this.getConnection();
                statement = connection.prepareStatement(stringBuffer.toString());
                statement.setInt(1, n);
                resultSet = statement.executeQuery();
                if (resultSet.next()) {
                    Timestamp timestamp = resultSet.getTimestamp(1);
                    l = timestamp.getTime();
                    break block16;
                }
                StringBuffer stringBuffer2 = new StringBuffer("The supplied key is not mapped to any value - key: ");
                stringBuffer2.append(object);
                this._systemLogger.log(Level.FINE, MODULE, string, stringBuffer2.toString());
                throw new ASelectStorageException("6003");
            }
            catch (ASelectStorageException aSelectStorageException) {
                throw aSelectStorageException;
            }
            catch (SQLException sQLException) {
                StringBuffer stringBuffer3 = new StringBuffer("Could not resolve the timestamp from the JDBC database by executing the query: ");
                stringBuffer3.append(stringBuffer.toString());
                this._systemLogger.log(Level.FINE, MODULE, string, stringBuffer3.toString(), sQLException);
                throw new ASelectStorageException("6002", sQLException);
            }
            catch (NullPointerException nullPointerException) {
                this._systemLogger.log(Level.WARNING, MODULE, string, "Empty (null) key-object was supplied", nullPointerException);
                throw new ASelectStorageException("6002", nullPointerException);
            }
            catch (Exception exception) {
                this._systemLogger.log(Level.WARNING, MODULE, string, "Could not retrieve the object from the database", exception);
                throw new ASelectStorageException("6002", exception);
            }
            finally {
                try {
                    if (resultSet != null) {
                        resultSet.close();
                        resultSet = null;
                    }
                    if (statement != null) {
                        statement.close();
                        statement = null;
                    }
                }
                catch (SQLException sQLException) {
                    this._systemLogger.log(Level.FINE, MODULE, string, "Could not close database resource.", sQLException);
                }
            }
        }
        if (l == 0L) {
            this._systemLogger.log(Level.WARNING, MODULE, string, "The supplied key is not mapped to any value", new ASelectStorageException("6002"));
            throw new ASelectStorageException("6002");
        }
        return l;
    }

    public long getCount() throws ASelectStorageException {
        long l = -1L;
        StringBuffer stringBuffer = null;
        String string = "getCount()";
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            stringBuffer = new StringBuffer();
            stringBuffer.append("SELECT COUNT(*) ");
            stringBuffer.append("FROM ").append(this._sTableName);
            Connection connection = this.getConnection();
            statement = connection.prepareStatement(stringBuffer.toString());
            resultSet = statement.executeQuery();
            while (resultSet.next()) {
                l = resultSet.getLong(1);
            }
        }
        catch (Exception exception) {
            this._systemLogger.log(Level.WARNING, MODULE, string, "An error occured while retrieving objects from the database", exception);
            throw new ASelectStorageException("6002", exception);
        }
        finally {
            try {
                if (resultSet != null) {
                    resultSet.close();
                    resultSet = null;
                }
                if (statement != null) {
                    statement.close();
                    statement = null;
                }
            }
            catch (SQLException sQLException) {
                this._systemLogger.log(Level.FINE, MODULE, string, "Could not close database resource.", sQLException);
            }
        }
        return l;
    }

    public Hashtable getAll() throws ASelectStorageException {
        Hashtable<Object, Object> hashtable = new Hashtable<Object, Object>();
        StringBuffer stringBuffer = null;
        String string = "getAll()";
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            stringBuffer = new StringBuffer();
            stringBuffer.append("SELECT * ");
            stringBuffer.append("FROM ").append(this._sTableName);
            Connection connection = this.getConnection();
            statement = connection.prepareStatement(stringBuffer.toString());
            resultSet = statement.executeQuery();
            while (resultSet.next()) {
                Object object = JDBCStorageHandler.decode(resultSet.getBytes(this._sContextKey));
                Object object2 = JDBCStorageHandler.decode(resultSet.getBytes(this._sContextValue));
                hashtable.put(object, object2);
            }
        }
        catch (IOException iOException) {
            this._systemLogger.log(Level.WARNING, MODULE, string, "Could not decode one or more objects", iOException);
            throw new ASelectStorageException("6002", iOException);
        }
        catch (ClassNotFoundException classNotFoundException) {
            this._systemLogger.log(Level.WARNING, MODULE, string, "Could not decode one or more objects", classNotFoundException);
            throw new ASelectStorageException("6002", classNotFoundException);
        }
        catch (Exception exception) {
            this._systemLogger.log(Level.WARNING, MODULE, string, "An error occured while retrieving objects from the database", exception);
            throw new ASelectStorageException("6002", exception);
        }
        finally {
            try {
                if (resultSet != null) {
                    resultSet.close();
                    resultSet = null;
                }
                if (statement != null) {
                    statement.close();
                    statement = null;
                }
            }
            catch (SQLException sQLException) {
                this._systemLogger.log(Level.FINE, MODULE, string, "Could not close database resource.", sQLException);
            }
        }
        return hashtable;
    }

    public void put(Object object, Object object2, Long l) throws ASelectStorageException {
        String string = "put()";
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            int n = object.hashCode();
            Timestamp timestamp = new Timestamp(l);
            byte[] byArray = JDBCStorageHandler.encode(object);
            byte[] byArray2 = JDBCStorageHandler.encode(object2);
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("SELECT ").append(this._sContextTimestamp).append(" ");
            stringBuffer.append("FROM ").append(this._sTableName).append(" ");
            stringBuffer.append("WHERE ").append(this._sContextKeyHash).append(" = ?");
            Connection connection = this.getConnection();
            statement = connection.prepareStatement(stringBuffer.toString());
            statement.setInt(1, n);
            resultSet = statement.executeQuery();
            if (resultSet.next()) {
                stringBuffer = new StringBuffer();
                stringBuffer.append("UPDATE ").append(this._sTableName).append(" ");
                stringBuffer.append("SET ").append(this._sContextValue).append(" = ?, ").append(this._sContextTimestamp).append(" = ? ");
                stringBuffer.append("WHERE ").append(this._sContextKeyHash).append(" = ?");
                try {
                    statement.close();
                    statement = null;
                }
                catch (SQLException sQLException) {
                    this._systemLogger.log(Level.FINE, MODULE, string, "Could not close database resource", sQLException);
                }
                statement = connection.prepareStatement(stringBuffer.toString());
                statement.setBytes(1, byArray2);
                statement.setTimestamp(2, timestamp);
                statement.setInt(3, n);
            } else {
                stringBuffer = new StringBuffer();
                stringBuffer.append("INSERT INTO ").append(this._sTableName).append(" ");
                stringBuffer.append("VALUES (?,?,?,?)");
                try {
                    statement.close();
                    statement = null;
                }
                catch (SQLException sQLException) {
                    this._systemLogger.log(Level.FINE, MODULE, string, "Could not close database resource", sQLException);
                }
                statement = connection.prepareStatement(stringBuffer.toString());
                statement.setInt(1, n);
                statement.setTimestamp(2, timestamp);
                statement.setBytes(3, byArray);
                statement.setBytes(4, byArray2);
            }
            statement.executeUpdate();
        }
        catch (IOException iOException) {
            this._systemLogger.log(Level.WARNING, MODULE, string, "Could not decode one or more objects that were retrieved from the database", iOException);
            throw new ASelectStorageException("6004", iOException);
        }
        catch (Exception exception) {
            this._systemLogger.log(Level.WARNING, MODULE, string, "An error occured while inserting objects into the database", exception);
            throw new ASelectStorageException("6004", exception);
        }
        finally {
            try {
                if (resultSet != null) {
                    resultSet.close();
                    resultSet = null;
                }
                if (statement != null) {
                    statement.close();
                    statement = null;
                }
            }
            catch (SQLException sQLException) {
                this._systemLogger.log(Level.FINE, MODULE, string, "Could not close database resource", sQLException);
            }
        }
    }

    public void remove(Object object) throws ASelectStorageException {
        String string = "remove()";
        StringBuffer stringBuffer = null;
        Statement statement = null;
        try {
            int n = object.hashCode();
            stringBuffer = new StringBuffer();
            stringBuffer.append("DELETE FROM ").append(this._sTableName).append(" ");
            stringBuffer.append("WHERE ").append(this._sContextKeyHash).append(" = ?");
            Connection connection = null;
            try {
                connection = this.getConnection();
            }
            catch (ASelectStorageException aSelectStorageException) {
                this._systemLogger.log(Level.WARNING, MODULE, string, "Could not connect", aSelectStorageException);
                throw aSelectStorageException;
            }
            statement = connection.prepareStatement(stringBuffer.toString());
            statement.setInt(1, n);
            if (statement.executeUpdate() == 0) {
                StringBuffer stringBuffer2 = new StringBuffer("Could not remove object: ");
                stringBuffer2.append(object);
                this._systemLogger.log(Level.WARNING, MODULE, string, stringBuffer2.toString());
                throw new ASelectStorageException("6003");
            }
        }
        catch (ASelectStorageException aSelectStorageException) {
            throw aSelectStorageException;
        }
        catch (Exception exception) {
            this._systemLogger.log(Level.WARNING, MODULE, string, "An error occured while removing an object from the database", exception);
            throw new ASelectStorageException("6005", exception);
        }
        finally {
            try {
                if (statement != null) {
                    statement.close();
                    statement = null;
                }
            }
            catch (SQLException sQLException) {
                this._systemLogger.log(Level.FINE, MODULE, string, "Could not close database resource.", sQLException);
            }
        }
    }

    public void removeAll() throws ASelectStorageException {
        String string = "removeAll()";
        StringBuffer stringBuffer = null;
        Statement statement = null;
        try {
            stringBuffer = new StringBuffer();
            stringBuffer.append("DELETE FROM ").append(this._sTableName);
            Connection connection = this.getConnection();
            statement = connection.prepareStatement(stringBuffer.toString());
            statement.executeUpdate();
        }
        catch (ASelectStorageException aSelectStorageException) {
            this._systemLogger.log(Level.WARNING, MODULE, string, "Could not decode one or more objects that were retrieved from the database.", aSelectStorageException);
            throw aSelectStorageException;
        }
        catch (Exception exception) {
            this._systemLogger.log(Level.WARNING, MODULE, string, "An error occured while removing objects from the database", exception);
            throw new ASelectStorageException("6005", exception);
        }
        finally {
            try {
                if (statement != null) {
                    statement.close();
                    statement = null;
                }
            }
            catch (SQLException sQLException) {
                this._systemLogger.log(Level.FINE, MODULE, string, "Could not close database resource", sQLException);
            }
        }
    }

    public void cleanup(Long l) throws ASelectStorageException {
        String string = "cleanup()";
        StringBuffer stringBuffer = null;
        Statement statement = null;
        try {
            Timestamp timestamp = new Timestamp(l);
            stringBuffer = new StringBuffer();
            stringBuffer.append("DELETE FROM ").append(this._sTableName).append(" ");
            stringBuffer.append("WHERE ").append(this._sContextTimestamp).append(" <= ?");
            Connection connection = this.getConnection();
            statement = connection.prepareStatement(stringBuffer.toString());
            statement.setTimestamp(1, timestamp);
            statement.executeUpdate();
        }
        catch (Exception exception) {
            this._systemLogger.log(Level.WARNING, MODULE, string, "An error occured while cleaning up the database", exception);
            throw new ASelectStorageException("6006", exception);
        }
        finally {
            try {
                if (statement != null) {
                    statement.close();
                    statement = null;
                }
            }
            catch (SQLException sQLException) {
                this._systemLogger.log(Level.FINE, MODULE, string, "Could not close database resource.", sQLException);
            }
        }
    }

    public void destroy() {
        try {
            if (this._oActiveConnection != null) {
                this._oActiveConnection.close();
                this._oActiveConnection = null;
            }
        }
        catch (Exception exception) {
            this._systemLogger.log(Level.FINE, MODULE, "destroy()", "An error occured while trying to destroy the module", exception);
        }
    }

    public boolean isMaximum(long l) throws ASelectStorageException {
        String string = "isMaximum()";
        boolean bl = false;
        Statement statement = null;
        ResultSet resultSet = null;
        StringBuffer stringBuffer = new StringBuffer("SELECT count(*) FROM ");
        stringBuffer.append(this._sTableName);
        long l2 = -1L;
        try {
            Connection connection = this.getConnection();
            statement = connection.createStatement();
            resultSet = statement.executeQuery(stringBuffer.toString());
            if (resultSet.next()) {
                l2 = resultSet.getLong(1);
            }
            if (l2 == l) {
                bl = true;
            }
        }
        catch (SQLException sQLException) {
            StringBuffer stringBuffer2 = new StringBuffer("Could not resolve the maximum number of items by executing the query: ");
            stringBuffer2.append(stringBuffer.toString());
            this._systemLogger.log(Level.FINE, MODULE, "isMaximum()", stringBuffer2.toString(), sQLException);
            throw new ASelectStorageException("6002", sQLException);
        }
        catch (Exception exception) {
            this._systemLogger.log(Level.FINE, MODULE, "isMaximum()", "Error during resolve of the maximum number of items", exception);
            throw new ASelectStorageException("0001", exception);
        }
        finally {
            try {
                if (resultSet != null) {
                    resultSet.close();
                    resultSet = null;
                }
                if (statement != null) {
                    statement.close();
                    statement = null;
                }
            }
            catch (SQLException sQLException) {
                this._systemLogger.log(Level.FINE, MODULE, string, "Could not close database resource", sQLException);
            }
        }
        return bl;
    }

    public boolean containsKey(Object object) throws ASelectStorageException {
        String string = "containsKey()";
        boolean bl = false;
        Statement statement = null;
        ResultSet resultSet = null;
        StringBuffer stringBuffer = new StringBuffer("SELECT * FROM ");
        stringBuffer.append(this._sTableName);
        stringBuffer.append(" WHERE ");
        stringBuffer.append(this._sContextKeyHash);
        stringBuffer.append(" = ?");
        try {
            int n = object.hashCode();
            Connection connection = this.getConnection();
            statement = connection.prepareStatement(stringBuffer.toString());
            statement.setInt(1, n);
            resultSet = statement.executeQuery();
            bl = resultSet.next();
        }
        catch (ASelectStorageException aSelectStorageException) {
            throw aSelectStorageException;
        }
        catch (SQLException sQLException) {
            StringBuffer stringBuffer2 = new StringBuffer("Could not execute query: ");
            stringBuffer2.append(stringBuffer.toString());
            this._systemLogger.log(Level.FINE, MODULE, "containsKey()", stringBuffer2.toString(), sQLException);
            throw new ASelectStorageException("6002", sQLException);
        }
        catch (Exception exception) {
            this._systemLogger.log(Level.FINE, MODULE, "containsKey()", "Error during resolve of the maximum number of items", exception);
            throw new ASelectStorageException("0001", exception);
        }
        finally {
            try {
                if (resultSet != null) {
                    resultSet.close();
                    resultSet = null;
                }
                if (statement != null) {
                    statement.close();
                    statement = null;
                }
            }
            catch (SQLException sQLException) {
                this._systemLogger.log(Level.FINE, MODULE, string, "Could not close database resource", sQLException);
            }
        }
        return bl;
    }

    private Connection getConnection() throws ASelectStorageException {
        block25: {
            String string = "getConnection()";
            String string2 = null;
            String string3 = null;
            String string4 = null;
            String string5 = null;
            try {
                Object object;
                if (this._oActiveResource == null || !this._oActiveResource.live()) {
                    this._oActiveResource = this._oSAMAgent.getActiveResource(this._sResourceGroup);
                    object = this._oActiveResource.getAttributes();
                    try {
                        string3 = this._oConfigManager.getParam(object, "driver");
                    }
                    catch (ASelectConfigException aSelectConfigException) {
                        this._systemLogger.log(Level.WARNING, MODULE, string, "No valid 'driver' config item found", aSelectConfigException);
                        throw new ASelectStorageException("4005", aSelectConfigException);
                    }
                    try {
                        string4 = this._oConfigManager.getParam(object, "username");
                    }
                    catch (ASelectConfigException aSelectConfigException) {
                        this._systemLogger.log(Level.WARNING, MODULE, string, "No valid 'username' config item found", aSelectConfigException);
                        throw new ASelectStorageException("4005", aSelectConfigException);
                    }
                    try {
                        string2 = this._oConfigManager.getParam(object, "password");
                    }
                    catch (ASelectConfigException aSelectConfigException) {
                        string2 = "";
                        this._systemLogger.log(Level.CONFIG, MODULE, string, "Invalid or empty password found in config, using empty password", aSelectConfigException);
                    }
                    try {
                        string5 = this._oConfigManager.getParam(object, "url");
                    }
                    catch (ASelectConfigException aSelectConfigException) {
                        this._systemLogger.log(Level.WARNING, MODULE, string, "No valid 'url' config item found", aSelectConfigException);
                        throw new ASelectStorageException("4005", aSelectConfigException);
                    }
                    try {
                        Class.forName(string3);
                    }
                    catch (Exception exception) {
                        StringBuffer stringBuffer = new StringBuffer("Could not initialze the JDBC Driver: ");
                        stringBuffer.append(string3);
                        this._systemLogger.log(Level.WARNING, MODULE, string, stringBuffer.toString(), exception);
                        throw new ASelectStorageException("5001", exception);
                    }
                    try {
                        this._oActiveConnection = DriverManager.getConnection(string5, string4, string2);
                    }
                    catch (Exception exception) {
                        StringBuffer stringBuffer = new StringBuffer("Could not create a connection with: ");
                        stringBuffer.append(string5);
                        stringBuffer.append(", driver: ");
                        stringBuffer.append(string3);
                        this._systemLogger.log(Level.WARNING, MODULE, string, stringBuffer.toString(), exception);
                        throw new ASelectStorageException("5001", exception);
                    }
                }
                if (!this._oActiveConnection.isClosed()) break block25;
                object = this._oActiveResource.getAttributes();
                try {
                    string4 = this._oConfigManager.getParam(object, "username");
                }
                catch (ASelectConfigException aSelectConfigException) {
                    this._systemLogger.log(Level.WARNING, MODULE, string, "No valid 'username' config item found", aSelectConfigException);
                    throw new ASelectStorageException("4005", aSelectConfigException);
                }
                try {
                    string2 = this._oConfigManager.getParam(object, "password");
                }
                catch (ASelectConfigException aSelectConfigException) {
                    string2 = "";
                    this._systemLogger.log(Level.CONFIG, MODULE, string, "Invalid or empty password found in config, using empty password", aSelectConfigException);
                }
                try {
                    string5 = this._oConfigManager.getParam(object, "url");
                }
                catch (ASelectConfigException aSelectConfigException) {
                    this._systemLogger.log(Level.WARNING, MODULE, string, "No valid 'url' config item found", aSelectConfigException);
                    throw new ASelectStorageException("4005", aSelectConfigException);
                }
                try {
                    this._oActiveConnection = DriverManager.getConnection(string5, string4, string2);
                }
                catch (Exception exception) {
                    StringBuffer stringBuffer = new StringBuffer("Could not create a connection with: ");
                    stringBuffer.append(string5);
                    this._systemLogger.log(Level.WARNING, MODULE, string, stringBuffer.toString(), exception);
                    throw new ASelectStorageException("5001", exception);
                }
            }
            catch (ASelectStorageException aSelectStorageException) {
                throw aSelectStorageException;
            }
            catch (ASelectSAMException aSelectSAMException) {
                this._oActiveResource = null;
                StringBuffer stringBuffer = new StringBuffer("No resource was available, original cause: ");
                stringBuffer.append(aSelectSAMException.getMessage());
                this._systemLogger.log(Level.WARNING, MODULE, string, stringBuffer.toString(), aSelectSAMException);
                throw new ASelectStorageException("6009", aSelectSAMException);
            }
            catch (Exception exception) {
                this._systemLogger.log(Level.WARNING, MODULE, string, "An error occured while trying to connect to the database", exception);
                throw new ASelectStorageException("6009", exception);
            }
        }
        return this._oActiveConnection;
    }

    private static byte[] encode(Object object) throws IOException {
        byte[] byArray = null;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
        objectOutputStream.writeObject(object);
        objectOutputStream.close();
        byArray = byteArrayOutputStream.toByteArray();
        byteArrayOutputStream.close();
        if (byArray == null) {
            throw new IOException("No bytes have been encoded.");
        }
        return byArray;
    }

    private static Object decode(byte[] byArray) throws IOException, ClassNotFoundException {
        Object object = null;
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        ObjectInputStream objectInputStream = new ObjectInputStream(byteArrayInputStream);
        object = objectInputStream.readObject();
        objectInputStream.close();
        byteArrayInputStream.close();
        if (object == null) {
            throw new IOException("No bytes have been decoded.");
        }
        return object;
    }
}

