/*
 * Decompiled with CFR 0.152.
 */
package org.aselect.server.request.handler.sfs;

import java.util.logging.Level;
import javax.servlet.ServletConfig;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.aselect.server.request.RequestState;
import org.aselect.server.request.handler.AbstractRequestHandler;
import org.aselect.server.request.handler.sfs.authentication.IRequestHandler;
import org.aselect.server.request.handler.sfs.authentication.RequestHandlerFactory;
import org.aselect.system.exception.ASelectConfigException;
import org.aselect.system.exception.ASelectException;

public class ASelectAuthenticationProfile
extends AbstractRequestHandler {
    private static final String MODULE = "ASelectAuthenticationProfile";
    private RequestHandlerFactory _oRequestHandlerFactory;
    private String _sMyServerID;
    private String _sMyOrg;

    public void init(ServletConfig servletConfig, Object object) throws ASelectException {
        String string = "init()";
        try {
            super.init(servletConfig, object);
            Object object2 = null;
            try {
                object2 = this._configManager.getSection(null, "aselect");
            }
            catch (ASelectConfigException aSelectConfigException) {
                this._systemLogger.log(Level.WARNING, MODULE, string, "Could not find 'aselect' config section in config file", (Throwable)aSelectConfigException);
                throw aSelectConfigException;
            }
            try {
                this._sMyServerID = this._configManager.getParam(object2, "server_id");
            }
            catch (ASelectConfigException aSelectConfigException) {
                this._systemLogger.log(Level.WARNING, MODULE, string, "Could not retrieve 'server_id' config parameter in 'aselect' config section", (Throwable)aSelectConfigException);
                throw aSelectConfigException;
            }
            try {
                this._sMyOrg = this._configManager.getParam(object2, "organization");
            }
            catch (ASelectConfigException aSelectConfigException) {
                this._systemLogger.log(Level.WARNING, MODULE, string, "Could not retrieve 'organization' config parameter in 'aselect' config section", (Throwable)aSelectConfigException);
                throw aSelectConfigException;
            }
            this._oRequestHandlerFactory = RequestHandlerFactory.getHandle();
            this._oRequestHandlerFactory.init(this._sMyServerID, this._sMyOrg);
        }
        catch (ASelectException aSelectException) {
            throw aSelectException;
        }
        catch (Exception exception) {
            this._systemLogger.log(Level.SEVERE, MODULE, string, "Could not initialize", (Throwable)exception);
            throw new ASelectException("0001", (Throwable)exception);
        }
    }

    public RequestState process(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ASelectException {
        String string = "process()";
        this._systemLogger.log(Level.FINER, MODULE, "ASelectAuthenticationProfile.process()", "SFS Authentication Profile request: " + httpServletRequest.getRequestURI().toString() + "?" + httpServletRequest.getQueryString());
        try {
            IRequestHandler iRequestHandler = this._oRequestHandlerFactory.createRequestHandler(httpServletRequest, httpServletResponse);
            iRequestHandler.processRequest();
        }
        catch (ASelectException aSelectException) {
            throw aSelectException;
        }
        catch (Exception exception) {
            this._systemLogger.log(Level.SEVERE, MODULE, string, "Internal error", (Throwable)exception);
            throw new ASelectException("0001", (Throwable)exception);
        }
        return new RequestState(null);
    }

    public void destroy() {
    }
}

