/*
 * Decompiled with CFR 0.152.
 */
package org.aselect.server.request.handler.sfs.authentication;

import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.Hashtable;
import java.util.logging.Level;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.aselect.server.config.ASelectConfigManager;
import org.aselect.server.cross.CrossASelectManager;
import org.aselect.server.crypto.CryptoEngine;
import org.aselect.server.log.ASelectAuthenticationLogger;
import org.aselect.server.log.ASelectSystemLogger;
import org.aselect.server.request.handler.sfs.authentication.AbstractBrowserRequestHandler;
import org.aselect.server.sam.ASelectSAMAgent;
import org.aselect.server.tgt.TGTIssuer;
import org.aselect.system.communication.client.raw.RawCommunicator;
import org.aselect.system.exception.ASelectCommunicationException;
import org.aselect.system.exception.ASelectConfigException;
import org.aselect.system.exception.ASelectException;
import org.aselect.system.exception.ASelectSAMException;
import org.aselect.system.logging.SystemLogger;

public class ASelectBrowserHandler
extends AbstractBrowserRequestHandler {
    private ASelectAuthenticationLogger _authenticationLogger;
    private CrossASelectManager _crossASelectManager;
    private CryptoEngine _cryptoEngine;
    private static Hashtable _htSFSOrganizations = null;

    public ASelectBrowserHandler(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, String string, String string2) {
        super(httpServletRequest, httpServletResponse, string, string2);
        this._sModule = "ASelectBrowserHandler";
        this._authenticationLogger = ASelectAuthenticationLogger.getHandle();
        this._crossASelectManager = CrossASelectManager.getHandle();
        this._cryptoEngine = CryptoEngine.getHandle();
    }

    public void processBrowserRequest(Hashtable hashtable, HttpServletResponse httpServletResponse, PrintWriter printWriter) throws ASelectException {
        if (hashtable.get("aselect_credentials") == null) {
            throw new ASelectException("0030");
        }
        this.handleCrossAuthenticateResponse(hashtable, this._servletResponse);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void handleCrossAuthenticateResponse(Hashtable hashtable, HttpServletResponse httpServletResponse) throws ASelectException {
        String string = "handleCrossAuthenticateResponse()";
        try {
            Hashtable hashtable2;
            String string2;
            String string3 = null;
            String string4 = null;
            String string5 = null;
            string3 = (String)hashtable.get("rid");
            string4 = (String)hashtable.get("local_rid");
            string5 = (String)hashtable.get("aselect_credentials");
            if (string5 == null || string3 == null || string4 == null) {
                this._systemLogger.log(Level.INFO, this._sModule, string, "Invalid parameters");
                throw new ASelectCommunicationException("0030");
            }
            Hashtable hashtable3 = this._sessionManager.getSessionContext(string4);
            if (hashtable3 == null) {
                this._systemLogger.log(Level.WARNING, this._sModule, string, "Unknown session in response from cross aselect server");
                throw new ASelectCommunicationException("0030");
            }
            String string6 = (String)hashtable3.get("remote_organization");
            if (!string6.equals(string2 = (String)(hashtable2 = this.verifyRemoteCredentials(string5, string3, string6)).get("organization"))) {
                string6 = string2 + "@" + string6;
            }
            String string7 = (String)hashtable2.get("result_code");
            String string8 = (String)hashtable2.get("uid");
            if (string7 == null) {
                this._authenticationLogger.log(new Object[]{"Cross", string8, (String)hashtable.get("client_ip"), string6, hashtable3.get("app_id"), "granted"});
                TGTIssuer tGTIssuer = new TGTIssuer(this._sMyServerId);
                String string9 = (String)hashtable.get("aselect_credentials_tgt");
                tGTIssuer.issueCrossTGT(string4, null, hashtable2, httpServletResponse, string9, this._servletRequest);
                return;
            }
            if (string7.equals("0040")) {
                this._authenticationLogger.log(new Object[]{"Cross", string8, (String)hashtable.get("client_ip"), string6, hashtable3.get("app_id"), "denied", string7});
                TGTIssuer tGTIssuer = new TGTIssuer(this._sMyServerId);
                tGTIssuer.issueErrorTGT(string4, string7, httpServletResponse);
                return;
            }
            this._authenticationLogger.log(new Object[]{"Cross", string8, (String)hashtable.get("client_ip"), string6, hashtable3.get("app_id"), "denied", string7});
            throw new ASelectException("000b");
        }
        catch (ASelectException aSelectException) {
            throw aSelectException;
        }
        catch (Exception exception) {
            this._systemLogger.log(Level.WARNING, this._sModule, string, "Internal error", (Throwable)exception);
            throw new ASelectException("0001", (Throwable)exception);
        }
    }

    public static String getSFSRelay(String string) throws ASelectConfigException {
        String string2 = "getSFSRelay()";
        String string3 = null;
        if (_htSFSOrganizations == null) {
            ASelectConfigManager aSelectConfigManager = ASelectConfigManager.getHandle();
            ASelectSystemLogger aSelectSystemLogger = ASelectSystemLogger.getHandle();
            String string4 = "SFS";
            Object object = null;
            try {
                object = aSelectConfigManager.getSection(null, "sfs");
            }
            catch (ASelectConfigException aSelectConfigException) {
                aSelectSystemLogger.log(Level.CONFIG, string4, string2, "No extra sfs configuration found, skipping.");
            }
            _htSFSOrganizations = new Hashtable();
            if (object != null) {
                Object object2 = null;
                try {
                    object2 = aSelectConfigManager.getSection(object, "idp");
                }
                catch (ASelectConfigException aSelectConfigException) {
                    aSelectSystemLogger.log(Level.INFO, string4, string2, "No \"idp\" entries configured in \"sfs\" section.");
                    object2 = null;
                }
                while (object2 != null) {
                    String string5 = aSelectConfigManager.getParam(object2, "organization");
                    try {
                        String string6 = aSelectConfigManager.getParam(object2, "type");
                        if (string6.equals("aselect")) {
                            string3 = aSelectConfigManager.getParam(object2, "relay");
                            _htSFSOrganizations.put(string5, string3);
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    object2 = aSelectConfigManager.getNextSection(object2);
                }
            }
        }
        string3 = (String)_htSFSOrganizations.get(string);
        return string3;
    }

    private Hashtable verifyRemoteCredentials(String string, String string2, String string3) throws ASelectException {
        String string4;
        String string5;
        Object object;
        Object object2;
        CrossASelectManager crossASelectManager;
        String string6 = "verifyRemoteCredentials()";
        try {
            crossASelectManager = CrossASelectManager.getHandle();
            object2 = crossASelectManager.getRemoteParam(string3, "resourcegroup");
            if (object2 == null) {
                object = ASelectBrowserHandler.getSFSRelay(string3);
                if (object != null) {
                    object2 = this._crossASelectManager.getRemoteParam((String)object, "resourcegroup");
                    string3 = object;
                } else {
                    this._systemLogger.log(Level.SEVERE, this._sModule, string6, "No remote server and no relay found for: " + string3);
                }
            }
            object = ASelectSAMAgent.getHandle().getActiveResource((String)object2);
            Object object3 = object.getAttributes();
            string5 = this._configManager.getParam(object3, "url");
            string4 = crossASelectManager.getRemoteParam(string3, "server");
        }
        catch (ASelectSAMException aSelectSAMException) {
            this._systemLogger.log(Level.SEVERE, this._sModule, string6, "Failed to read SAM", (Throwable)aSelectSAMException);
            throw aSelectSAMException;
        }
        catch (ASelectConfigException aSelectConfigException) {
            this._systemLogger.log(Level.SEVERE, this._sModule, string6, "Failed to read config", (Throwable)aSelectConfigException);
            throw aSelectConfigException;
        }
        crossASelectManager = new RawCommunicator((SystemLogger)this._systemLogger);
        object2 = new Hashtable();
        object = new Hashtable();
        ((Hashtable)object2).put("request", "verify_credentials");
        ((Hashtable)object2).put("rid", string2);
        ((Hashtable)object2).put("aselect_credentials", string);
        ((Hashtable)object2).put("a-select-server", string4);
        Object object4 = ASelectConfigManager.getHandle().getSection(null, "aselect");
        String string7 = ASelectConfigManager.getHandle().getParam(object4, "organization");
        ((Hashtable)object2).put("local_organization", string7);
        if (this._crossASelectManager.useRemoteSigning()) {
            this._cryptoEngine.signRequest((Hashtable)object2);
        }
        if (((Hashtable)(object = crossASelectManager.sendMessage((Hashtable)object2, string5))).isEmpty()) {
            this._systemLogger.log(Level.WARNING, this._sModule, string6, "Could not reach remote A-Select Server: " + string5);
            throw new ASelectException("0001");
        }
        String string8 = (String)((Hashtable)object).get("result_code");
        if (string8 == null) {
            StringBuffer stringBuffer = new StringBuffer("Invalid response from remote A-Select Server '");
            stringBuffer.append(string4);
            stringBuffer.append("' (missing: 'result_code')");
            this._systemLogger.log(Level.WARNING, this._sModule, string6, stringBuffer.toString());
            throw new ASelectException("0001");
        }
        String string9 = (String)((Hashtable)object).get("uid");
        if (string9 != null) {
            try {
                string9 = URLDecoder.decode(string9, "UTF-8");
                string9 = URLDecoder.decode(string9, "UTF-8");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
        if (!string8.equals("0000")) {
            StringBuffer stringBuffer = new StringBuffer("Remote A-Select Server '");
            stringBuffer.append(string4);
            stringBuffer.append("' returned error: ");
            stringBuffer.append(string8);
            this._systemLogger.log(Level.WARNING, this._sModule, string6, stringBuffer.toString());
            Hashtable<String, String> hashtable = new Hashtable<String, String>();
            hashtable.put("result_code", string8);
            if (string9 != null) {
                hashtable.put("uid", string9);
            } else {
                hashtable.put("uid", "");
            }
            return hashtable;
        }
        if (string9 == null) {
            StringBuffer stringBuffer = new StringBuffer("Remote A-Select Server '");
            stringBuffer.append(string4);
            stringBuffer.append("' did not return 'uid'");
            this._systemLogger.log(Level.WARNING, this._sModule, string6, stringBuffer.toString());
            throw new ASelectException("0004");
        }
        try {
            string9 = URLDecoder.decode(string9, "UTF-8");
            string9 = URLDecoder.decode(string9, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        String string10 = (String)((Hashtable)object).get("organization");
        if (string10 == null) {
            StringBuffer stringBuffer = new StringBuffer("Remote A-Select Server '");
            stringBuffer.append(string4);
            stringBuffer.append("' did not return 'organization'");
            this._systemLogger.log(Level.WARNING, this._sModule, string6, stringBuffer.toString());
            throw new ASelectException("0004");
        }
        String string11 = (String)((Hashtable)object).get("authsp_level");
        if (string11 == null) {
            StringBuffer stringBuffer = new StringBuffer("Remote A-Select Server '");
            stringBuffer.append(string4);
            stringBuffer.append("' did not return 'authsp_level'");
            this._systemLogger.log(Level.WARNING, this._sModule, string6, stringBuffer.toString());
            throw new ASelectException("0004");
        }
        String string12 = (String)((Hashtable)object).get("authsp");
        if (string12 == null) {
            StringBuffer stringBuffer = new StringBuffer("Remote A-Select Server '");
            stringBuffer.append(string4);
            stringBuffer.append("' did not return 'authsp'");
            this._systemLogger.log(Level.WARNING, this._sModule, string6, stringBuffer.toString());
            throw new ASelectException("0004");
        }
        String string13 = (String)((Hashtable)object).get("app_level");
        if (string13 == null) {
            StringBuffer stringBuffer = new StringBuffer("Remote A-Select Server '");
            stringBuffer.append(string4);
            stringBuffer.append("' did not return 'app_level'");
            this._systemLogger.log(Level.WARNING, this._sModule, string6, stringBuffer.toString());
            throw new ASelectException("0004");
        }
        String string14 = (String)((Hashtable)object).get("tgt_exp_time");
        if (string14 == null) {
            StringBuffer stringBuffer = new StringBuffer("Remote A-Select Server '");
            stringBuffer.append(string4);
            stringBuffer.append("' did not return 'tgt_exp_time'");
            this._systemLogger.log(Level.WARNING, this._sModule, string6, stringBuffer.toString());
            throw new ASelectException("0004");
        }
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        hashtable.put("uid", string9);
        hashtable.put("organization", string10);
        hashtable.put("authsp_level", string11);
        hashtable.put("authsp", string12);
        hashtable.put("app_level", string13);
        hashtable.put("a-select-server", string4);
        hashtable.put("tgt_exp_time", new Long(string14));
        String string15 = (String)((Hashtable)object).get("attributes");
        if (string15 != null) {
            hashtable.put("attributes", string15);
        }
        return hashtable;
    }
}

