/*
 * Decompiled with CFR 0.152.
 */
package org.aselect.server.request.handler.sfs.authentication;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import java.util.logging.Level;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.aselect.server.application.ApplicationManager;
import org.aselect.server.authspprotocol.IAuthSPDirectLoginProtocolHandler;
import org.aselect.server.authspprotocol.IAuthSPProtocolHandler;
import org.aselect.server.authspprotocol.handler.AuthSPHandlerManager;
import org.aselect.server.config.ASelectConfigManager;
import org.aselect.server.cross.CrossASelectManager;
import org.aselect.server.crypto.CryptoEngine;
import org.aselect.server.log.ASelectAuthenticationLogger;
import org.aselect.server.request.handler.sfs.authentication.ASelectBrowserHandler;
import org.aselect.server.request.handler.sfs.authentication.AbstractBrowserRequestHandler;
import org.aselect.server.sam.ASelectSAMAgent;
import org.aselect.server.tgt.TGTIssuer;
import org.aselect.server.udb.IUDBConnector;
import org.aselect.server.udb.UDBConnectorFactory;
import org.aselect.system.communication.client.raw.RawCommunicator;
import org.aselect.system.exception.ASelectCommunicationException;
import org.aselect.system.exception.ASelectConfigException;
import org.aselect.system.exception.ASelectException;
import org.aselect.system.exception.ASelectSAMException;
import org.aselect.system.exception.ASelectStorageException;
import org.aselect.system.logging.SystemLogger;
import org.aselect.system.sam.agent.SAMResource;
import org.aselect.system.utils.Utils;

public class ApplicationBrowserHandler
extends AbstractBrowserRequestHandler {
    private Hashtable _htSessionContext;
    private ApplicationManager _applicationManager;
    private CrossASelectManager _crossASelectManager;
    private AuthSPHandlerManager _authspHandlerManager;
    private CryptoEngine _cryptoEngine;
    private ASelectConfigManager _configManager;

    public ApplicationBrowserHandler(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, String string, String string2) {
        super(httpServletRequest, httpServletResponse, string, string2);
        this._sModule = "ApplicationBrowserHandler()";
        this._applicationManager = ApplicationManager.getHandle();
        this._authspHandlerManager = AuthSPHandlerManager.getHandle();
        this._crossASelectManager = CrossASelectManager.getHandle();
        this._cryptoEngine = CryptoEngine.getHandle();
        this._configManager = ASelectConfigManager.getHandle();
    }

    public void processBrowserRequest(Hashtable hashtable, HttpServletResponse httpServletResponse, PrintWriter printWriter) throws ASelectException {
        String string = "processBrowserRequest()";
        String string2 = (String)hashtable.get("request");
        if (string2 == null) {
            if (hashtable.containsKey("aselect_credentials_uid")) {
                this.showUserInfo(hashtable, this._servletResponse);
            } else {
                String string3 = this._configManager.getForm("serverinfo");
                string3 = Utils.replaceString((String)string3, (String)"[message]", (String)" ");
                printWriter.println(string3);
            }
        } else if (string2.equals("logout") || string2.equals("cross_logout")) {
            this.handleLogout(hashtable, this._servletResponse, printWriter);
        } else {
            String string4 = (String)hashtable.get("rid");
            if (string4 == null) {
                this._systemLogger.log(Level.WARNING, this._sModule, string, "Missing RID parameter");
                throw new ASelectCommunicationException("0030");
            }
            this._htSessionContext = this._sessionManager.getSessionContext(string4);
            if (this._htSessionContext == null) {
                this._systemLogger.log(Level.WARNING, this._sModule, string, "Invalid RID: " + string4);
                throw new ASelectException("0030");
            }
            String string5 = (String)this._htSessionContext.get("direct_authsp");
            if (string5 != null && string2.indexOf("direct_login") < 0) {
                this._systemLogger.log(Level.WARNING, this._sModule, string, "Probably tampered request with rid='" + string4 + "'");
                throw new ASelectException("0030");
            }
            if (string2.equals("login1")) {
                this.handleLogin1(hashtable, this._servletResponse, printWriter);
            } else if (string2.equals("login2")) {
                this.handleLogin2(hashtable, this._servletResponse, printWriter);
            } else if (string2.equals("login3")) {
                this.handleLogin3(hashtable, this._servletResponse, printWriter);
            } else if (string2.equals("cross_login")) {
                this.handleCrossLogin(hashtable, this._servletResponse, printWriter);
            } else if (string2.equals("ip_login")) {
                this.handleIPLogin1(hashtable, this._servletResponse, printWriter);
            } else if (string2.indexOf("direct_login") >= 0) {
                this.handleDirectLogin(hashtable, this._servletResponse, printWriter);
            } else if (string2.equals("create_tgt")) {
                this.handleCreateTGT(hashtable, this._servletResponse);
            } else {
                throw new ASelectException("0030");
            }
        }
    }

    private void handleDirectLogin(Hashtable hashtable, HttpServletResponse httpServletResponse, PrintWriter printWriter) throws ASelectException {
        String string = "handleDirectLogin()";
        String string2 = null;
        try {
            String string3;
            string2 = (String)hashtable.get("rid");
            String string4 = (String)this._htSessionContext.get("direct_authsp");
            if (string4 == null) {
                this._systemLogger.log(Level.WARNING, this._sModule, string, "Probably tampered request with rid='" + string2 + "'");
                throw new ASelectException("0030");
            }
            IAuthSPDirectLoginProtocolHandler iAuthSPDirectLoginProtocolHandler = this._authspHandlerManager.getAuthSPDirectLoginProtocolHandler(string4);
            if (this._configManager.isSingleSignOn() && hashtable.containsKey("aselect_credentials_tgt") && hashtable.containsKey("aselect_credentials_uid") && hashtable.containsKey("aselect_credentials_server_id")) {
                string3 = (String)hashtable.get("aselect_credentials_tgt");
                String string5 = (String)hashtable.get("aselect_credentials_uid");
                String string6 = (String)hashtable.get("aselect_credentials_server_id");
                String string7 = (String)this._htSessionContext.get("forced_uid");
                String string8 = (String)this._htSessionContext.get("forced_organization");
                if (string7 != null && !string5.equals(string7) || string8 != null) {
                    this._tgtManager.remove((Object)string3);
                } else {
                    Serializable serializable;
                    if (this.checkCredentials(string3, string5, string6) && !((Boolean)(serializable = (Boolean)this._htSessionContext.get("forced_authenticate"))).booleanValue()) {
                        String string9 = this._htSessionContext.get("remote_session") == null ? (String)this._htSessionContext.get("app_url") : (String)this._htSessionContext.get("local_as_url");
                        Hashtable hashtable2 = this._tgtManager.getTGT(string3);
                        String string10 = (String)this._htSessionContext.get("app_id");
                        if (string10 != null) {
                            hashtable2.put("app_id", string10);
                        } else {
                            hashtable2.remove("app_id");
                        }
                        String string11 = (String)this._htSessionContext.get("local_organization");
                        if (string11 != null) {
                            hashtable2.put("local_organization", string11);
                        } else {
                            hashtable2.remove("local_organization");
                        }
                        hashtable2.put("rid", string2);
                        this._tgtManager.updateTGT(string3, hashtable2);
                        String string12 = (String)hashtable2.get("local_organization");
                        if (string12 == null) {
                            string12 = (String)hashtable2.get("app_id");
                        }
                        ASelectAuthenticationLogger.getHandle().log(new Object[]{"SSO", string5, (String)hashtable.get("client_ip"), hashtable2.get("organization"), string12, "updated"});
                        TGTIssuer tGTIssuer = new TGTIssuer(this._sMyServerId);
                        tGTIssuer.sendRedirect(string9, string3, string2, httpServletResponse);
                        this._sessionManager.killSession(string2);
                        return;
                    }
                    serializable = this._tgtManager.getTGT(string3);
                    String string13 = (String)((Hashtable)serializable).get("proxy_organization");
                    if (string13 == null) {
                        string13 = (String)((Hashtable)serializable).get("organization");
                    }
                    if (!string13.equals(this._sMyOrg)) {
                        this._htSessionContext.put("forced_uid", string5);
                        this._htSessionContext.put("forced_organization", string13);
                        this.handleCrossLogin(hashtable, httpServletResponse, printWriter);
                        return;
                    }
                    hashtable.put("user_id", string5);
                    iAuthSPDirectLoginProtocolHandler.handleDirectLoginRequest(hashtable, httpServletResponse, printWriter, this._sMyServerId, this._servletRequest);
                    return;
                }
            }
            if (!this._configManager.isUDBEnabled() || this._htSessionContext.containsKey("forced_organization")) {
                this.handleCrossLogin(hashtable, httpServletResponse, printWriter);
                return;
            }
            string3 = (String)this._htSessionContext.get("forced_uid");
            if (string3 != null) {
                hashtable.put("user_id", string3);
                iAuthSPDirectLoginProtocolHandler.handleDirectLoginRequest(hashtable, httpServletResponse, printWriter, this._sMyServerId, this._servletRequest);
                return;
            }
            iAuthSPDirectLoginProtocolHandler.handleDirectLoginRequest(hashtable, httpServletResponse, printWriter, this._sMyServerId, this._servletRequest);
            if (!this._sessionManager.createSession(string2, this._htSessionContext)) {
                throw new ASelectException("0070");
            }
        }
        catch (ASelectException aSelectException) {
            throw aSelectException;
        }
        catch (Exception exception) {
            this._systemLogger.log(Level.WARNING, this._sModule, string, "Internal error: ", (Throwable)exception);
            throw new ASelectException("0001", (Throwable)exception);
        }
    }

    private void handleLogin1(Hashtable hashtable, HttpServletResponse httpServletResponse, PrintWriter printWriter) throws ASelectException {
        String string = "handleLogin1()";
        String string2 = null;
        String string3 = this._configManager.getForm("login");
        try {
            String string4;
            String string5;
            string2 = (String)hashtable.get("rid");
            if (this._configManager.isSingleSignOn() && hashtable.containsKey("aselect_credentials_tgt") && hashtable.containsKey("aselect_credentials_uid") && hashtable.containsKey("aselect_credentials_server_id")) {
                string5 = (String)hashtable.get("aselect_credentials_tgt");
                string4 = (String)hashtable.get("aselect_credentials_uid");
                String string6 = (String)hashtable.get("aselect_credentials_server_id");
                String string7 = (String)this._htSessionContext.get("forced_uid");
                String string8 = (String)this._htSessionContext.get("forced_organization");
                if (string7 != null && !string4.equals(string7) || string8 != null) {
                    this._tgtManager.remove((Object)string5);
                } else {
                    Serializable serializable;
                    if (this.checkCredentials(string5, string4, string6) && !((Boolean)(serializable = (Boolean)this._htSessionContext.get("forced_authenticate"))).booleanValue()) {
                        String string9 = this._htSessionContext.get("remote_session") == null ? (String)this._htSessionContext.get("app_url") : (String)this._htSessionContext.get("local_as_url");
                        Hashtable hashtable2 = this._tgtManager.getTGT(string5);
                        String string10 = (String)this._htSessionContext.get("app_id");
                        if (string10 != null) {
                            hashtable2.put("app_id", string10);
                        } else {
                            hashtable2.remove("app_id");
                        }
                        String string11 = (String)this._htSessionContext.get("local_organization");
                        if (string11 != null) {
                            hashtable2.put("local_organization", string11);
                        } else {
                            hashtable2.remove("local_organization");
                        }
                        hashtable2.put("rid", string2);
                        this._tgtManager.updateTGT(string5, hashtable2);
                        String string12 = (String)hashtable2.get("local_organization");
                        if (string12 == null) {
                            string12 = (String)hashtable2.get("app_id");
                        }
                        ASelectAuthenticationLogger.getHandle().log(new Object[]{"SSO", string4, (String)hashtable.get("client_ip"), hashtable2.get("organization"), string12, "updated"});
                        TGTIssuer tGTIssuer = new TGTIssuer(this._sMyServerId);
                        tGTIssuer.sendRedirect(string9, string5, string2, httpServletResponse);
                        this._sessionManager.killSession(string2);
                        return;
                    }
                    serializable = this._tgtManager.getTGT(string5);
                    String string13 = (String)((Hashtable)serializable).get("proxy_organization");
                    if (string13 == null) {
                        string13 = (String)((Hashtable)serializable).get("organization");
                    }
                    if (!string13.equals(this._sMyOrg)) {
                        this._htSessionContext.put("forced_uid", string4);
                        this._htSessionContext.put("forced_organization", string13);
                        this.handleCrossLogin(hashtable, httpServletResponse, printWriter);
                        return;
                    }
                    hashtable.put("user_id", string4);
                    this.handleLogin2(hashtable, httpServletResponse, printWriter);
                    return;
                }
            }
            if ((string5 = (String)this._htSessionContext.get("forced_uid")) != null) {
                hashtable.put("user_id", string5);
            }
            if ((string4 = (String)this._htSessionContext.get("login_url")) != null) {
                StringBuffer stringBuffer = new StringBuffer(string4);
                stringBuffer.append("&rid=").append(string2);
                stringBuffer.append("&a-select-server=").append(this._sMyServerId);
                httpServletResponse.sendRedirect(stringBuffer.toString());
                return;
            }
            if (!this._configManager.isUDBEnabled() || this._htSessionContext.containsKey("forced_organization")) {
                this.handleCrossLogin(hashtable, httpServletResponse, printWriter);
                return;
            }
            if (string5 != null) {
                this.handleLogin2(hashtable, httpServletResponse, printWriter);
                return;
            }
            string3 = Utils.replaceString((String)string3, (String)"[rid]", (String)string2);
            string3 = Utils.replaceString((String)string3, (String)"[aselect_url]", (String)((String)hashtable.get("my_url")));
            string3 = Utils.replaceString((String)string3, (String)"[a-select-server]", (String)this._sMyServerId);
            string3 = Utils.replaceString((String)string3, (String)"[request]", (String)"login2");
            string3 = Utils.replaceString((String)string3, (String)"[cross_request]", (String)"cross_login");
            StringBuffer stringBuffer = new StringBuffer((String)hashtable.get("my_url")).append("?request=error").append("&result_code=").append("0040").append("&a-select-server=").append(this._sMyServerId).append("&rid=").append(string2);
            string3 = Utils.replaceString((String)string3, (String)"[cancel]", (String)stringBuffer.toString());
            string3 = this._configManager.updateTemplate(string3, this._htSessionContext);
            printWriter.println(string3);
        }
        catch (ASelectException aSelectException) {
            throw aSelectException;
        }
        catch (Exception exception) {
            this._systemLogger.log(Level.WARNING, this._sModule, string, "Internal error.", (Throwable)exception);
            throw new ASelectException("0001", (Throwable)exception);
        }
    }

    private void handleLogin2(Hashtable hashtable, HttpServletResponse httpServletResponse, PrintWriter printWriter) throws ASelectException {
        String string = null;
        String string2 = null;
        String string3 = "handleLogin2()";
        try {
            String string4;
            string = (String)hashtable.get("rid");
            string2 = (String)hashtable.get("user_id");
            if (string2 == null) {
                this._systemLogger.log(Level.WARNING, this._sModule, string3, "Invalid request, missing parmeter 'user_id'");
                throw new ASelectCommunicationException("0030");
            }
            try {
                string2 = URLDecoder.decode(string2, "UTF-8");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                this._systemLogger.log(Level.WARNING, this._sModule, string3, "Failed to decode user id.", (Throwable)unsupportedEncodingException);
                throw new ASelectException("0001", (Throwable)unsupportedEncodingException);
            }
            try {
                this.getAuthsps(string, string2);
            }
            catch (ASelectException aSelectException) {
                if (this._crossASelectManager.isCrossSelectorEnabled() && this._configManager.isCrossFallBackEnabled()) {
                    this.handleCrossLogin(hashtable, httpServletResponse, printWriter);
                    return;
                }
                this._systemLogger.log(Level.WARNING, this._sModule, string3, "Failed to retrieve AuthSPs of user " + string2);
                throw aSelectException;
            }
            Hashtable hashtable2 = (Hashtable)this._htSessionContext.get("allowed_user_authsps");
            if (hashtable2.size() == 1) {
                try {
                    string4 = this._configManager.getParam(this._configManager.getSection(null, "authsps"), "always_show_select_form");
                    if (string4.equalsIgnoreCase("false")) {
                        hashtable.put("authsp", hashtable2.keys().nextElement());
                        this.handleLogin3(hashtable, httpServletResponse, printWriter);
                        return;
                    }
                }
                catch (ASelectConfigException aSelectConfigException) {
                    this._systemLogger.log(Level.WARNING, this._sModule, string3, "Failed to retrieve config 'always_show_select_form'. Using default (yes).", (Throwable)aSelectConfigException);
                }
            }
            string4 = this._configManager.getForm("select");
            string4 = Utils.replaceString((String)string4, (String)"[rid]", (String)string);
            string4 = Utils.replaceString((String)string4, (String)"[a-select-server]", (String)this._sMyServerId);
            string4 = Utils.replaceString((String)string4, (String)"[user_id]", (String)string2);
            string4 = Utils.replaceString((String)string4, (String)"[aselect_url]", (String)((String)hashtable.get("my_url")));
            string4 = Utils.replaceString((String)string4, (String)"[request]", (String)"login3");
            String string5 = "";
            String string6 = "";
            Enumeration enumeration = hashtable2.keys();
            StringBuffer stringBuffer = new StringBuffer();
            while (enumeration.hasMoreElements()) {
                try {
                    string6 = (String)enumeration.nextElement();
                    Object object = this._configManager.getSection(this._configManager.getSection(null, "authsps"), "authsp", "id=" + string6);
                    string5 = this._configManager.getParam(object, "friendly_name");
                    stringBuffer.append("<OPTION VALUE=");
                    stringBuffer.append(string6);
                    stringBuffer.append(">");
                    stringBuffer.append(string5);
                    stringBuffer.append("</OPTION>");
                }
                catch (ASelectConfigException aSelectConfigException) {
                    this._systemLogger.log(Level.WARNING, this._sModule, string3, "Failed to retrieve config for AuthSPs.", (Throwable)aSelectConfigException);
                    throw aSelectConfigException;
                }
            }
            string4 = Utils.replaceString((String)string4, (String)"[allowed_user_authsps]", (String)stringBuffer.toString());
            stringBuffer = new StringBuffer((String)hashtable.get("my_url")).append("?request=error").append("&result_code=").append("0040").append("&a-select-server=").append(this._sMyServerId).append("&rid=").append(string);
            string4 = Utils.replaceString((String)string4, (String)"[cancel]", (String)stringBuffer.toString());
            string4 = this._configManager.updateTemplate(string4, this._htSessionContext);
            printWriter.println(string4);
        }
        catch (ASelectException aSelectException) {
            throw aSelectException;
        }
        catch (Exception exception) {
            this._systemLogger.log(Level.WARNING, this._sModule, string3, "Internal error", (Throwable)exception);
            throw new ASelectException("0001", (Throwable)exception);
        }
    }

    private void handleLogin3(Hashtable hashtable, HttpServletResponse httpServletResponse, PrintWriter printWriter) throws ASelectException {
        String string = null;
        String string2 = null;
        String string3 = "handleL ogin3()";
        String string4 = null;
        String string5 = null;
        try {
            string = (String)hashtable.get("rid");
            string2 = (String)hashtable.get("authsp");
            if (string2 == null) {
                this._systemLogger.log(Level.WARNING, this._sModule, string3, "Invalid request, missing parmeter 'authsp'");
                throw new ASelectCommunicationException("0030");
            }
            string4 = this.startAuthentication(string, hashtable);
            try {
                Object object = this._configManager.getSection(this._configManager.getSection(null, "authsps"), "authsp", "id=" + string2);
                try {
                    string5 = this._configManager.getParam(object, "popup");
                }
                catch (ASelectConfigException aSelectConfigException) {
                    // empty catch block
                }
                if (string5 == null || string5.equalsIgnoreCase("false")) {
                    httpServletResponse.sendRedirect(string4);
                    return;
                }
                String string6 = this._configManager.getForm("popup");
                string6 = Utils.replaceString((String)string6, (String)"[authsp_url]", (String)string4);
                String string7 = this._configManager.getParam(object, "friendly_name");
                string6 = Utils.replaceString((String)string6, (String)"[authsp]", (String)string7);
                string6 = this._configManager.updateTemplate(string6, this._htSessionContext);
                printWriter.println(string6);
                return;
            }
            catch (ASelectConfigException aSelectConfigException) {
                this._systemLogger.log(Level.WARNING, this._sModule, string3, "Failed to retrieve config for AuthSPs.", (Throwable)aSelectConfigException);
                throw new ASelectException(aSelectConfigException.getMessage());
            }
            catch (IOException iOException) {
                this._systemLogger.log(Level.WARNING, this._sModule, string3, "Failed to redirect user.", (Throwable)iOException);
                throw new ASelectException("4006");
            }
        }
        catch (ASelectException aSelectException) {
            throw aSelectException;
        }
        catch (Exception exception) {
            this._systemLogger.log(Level.WARNING, this._sModule, string3, "Internal error", (Throwable)exception);
            throw new ASelectException("0001", (Throwable)exception);
        }
    }

    private void handleCrossLogin(Hashtable hashtable, HttpServletResponse httpServletResponse, PrintWriter printWriter) throws ASelectException {
        String string = null;
        String string2 = null;
        String string3 = null;
        String string4 = "handleCrossLogin()";
        try {
            String string5;
            String string6;
            SAMResource sAMResource;
            CharSequence charSequence;
            Object object;
            String string7;
            Object object2;
            String string8;
            if (!this._crossASelectManager.remoteServersEnabled()) {
                this._systemLogger.log(Level.WARNING, this._sModule, string4, "Cross A-Select is disabled since it is not (properly) configured.");
                throw new ASelectException("0034");
            }
            String string9 = (String)hashtable.get("rid");
            Integer n = (Integer)this._htSessionContext.get("level");
            if (n == null) {
                this._systemLogger.log(Level.WARNING, this._sModule, string4, "could not fetch level from session context.");
                throw new ASelectException("0070");
            }
            string = (String)this._htSessionContext.get("forced_organization");
            string3 = (String)hashtable.get("home_organization");
            if (string3 != null) {
                string3 = URLDecoder.decode(string3, "UTF-8");
            }
            if ((string8 = (String)hashtable.get("user_id")) != null && !string8.trim().equals("")) {
                string2 = (String)hashtable.get("user_id");
            }
            if (string == null) {
                if (!this._crossASelectManager.isCrossSelectorEnabled()) {
                    this._systemLogger.log(Level.WARNING, this._sModule, string4, "Dynamic 'cross_selector' is disabled, parameter 'remote_organization' is required but not found.");
                    throw new ASelectException("0034");
                }
                if (string2 != null) {
                    hashtable.put("user_id", string2);
                }
                object2 = this._servletRequest.getCookies();
                string7 = null;
                if (object2 != null) {
                    for (int i = 0; i < ((Cookie[])object2).length; ++i) {
                        if (!object2[i].getName().equals("aselect_home_idp")) continue;
                        string7 = object2[i].getValue();
                        int n2 = string7.length();
                        if (string7.charAt(0) != '\"' || string7.charAt(n2 - 1) != '\"') continue;
                        string7 = string7.substring(1, n2 - 1);
                    }
                }
                if (string7 != null) {
                    hashtable.put("aselect_home_idp", string7);
                }
                try {
                    object = this._crossASelectManager.getSelectorHandler().getRemoteServerId(hashtable, httpServletResponse, printWriter);
                }
                catch (ASelectException aSelectException) {
                    this._systemLogger.log(Level.WARNING, this._sModule, string4, "Failed to retrieve the remote server id.", (Throwable)aSelectException);
                    throw new ASelectCommunicationException("0034", (Throwable)aSelectException);
                }
                if (object == null) {
                    return;
                }
                string = (String)((Hashtable)object).get("organization_id");
                charSequence = (String)((Hashtable)object).get("user_id");
                string3 = (String)((Hashtable)object).get("home_idp");
                if (charSequence != null) {
                    string2 = (String)((Hashtable)object).get("user_id");
                }
            }
            this._htSessionContext.put("remote_organization", string);
            if (!this._sessionManager.updateSession(string9, this._htSessionContext)) {
                this._systemLogger.log(Level.WARNING, this._sModule, string4, "could not update session context");
                throw new ASelectException("0001");
            }
            try {
                charSequence = this._crossASelectManager.getRemoteParam(string, "resourcegroup");
                if (charSequence == null) {
                    String string10 = ASelectBrowserHandler.getSFSRelay(string);
                    if (string10 != null) {
                        charSequence = this._crossASelectManager.getRemoteParam(string10, "resourcegroup");
                        string3 = string;
                        string = string10;
                    } else {
                        this._systemLogger.log(Level.SEVERE, this._sModule, string4, "No remote server and no relay found for: " + string);
                    }
                }
                sAMResource = ASelectSAMAgent.getHandle().getActiveResource((String)charSequence);
                object = sAMResource.getAttributes();
                object2 = this._configManager.getParam(object, "url");
                string7 = this._crossASelectManager.getRemoteParam(string, "server");
            }
            catch (ASelectSAMException aSelectSAMException) {
                this._systemLogger.log(Level.SEVERE, this._sModule, string4, "Failed to read SAM.", (Throwable)aSelectSAMException);
                throw aSelectSAMException;
            }
            catch (ASelectConfigException aSelectConfigException) {
                this._systemLogger.log(Level.SEVERE, this._sModule, string4, "Failed to read config.", (Throwable)aSelectConfigException);
                throw aSelectConfigException;
            }
            charSequence = new StringBuffer();
            ((StringBuffer)charSequence).append((String)hashtable.get("my_url"));
            ((StringBuffer)charSequence).append("?local_rid=").append(string9);
            sAMResource = new RawCommunicator((SystemLogger)this._systemLogger);
            Hashtable<String, String> hashtable2 = new Hashtable<String, String>();
            Hashtable hashtable3 = new Hashtable();
            hashtable2.put("request", "authenticate");
            Boolean bl = (Boolean)this._htSessionContext.get("forced_authenticate");
            hashtable2.put("forced_logon", bl.toString());
            hashtable2.put("local_as_url", ((StringBuffer)charSequence).toString());
            Object object3 = this._configManager.getSection(null, "aselect");
            String string11 = this._configManager.getParam(object3, "organization");
            hashtable2.put("local_organization", string11);
            Integer n3 = (Integer)this._htSessionContext.get("level");
            hashtable2.put("required_level", n3.toString());
            hashtable2.put("a-select-server", string7);
            if (string2 != null && !string2.trim().equals("")) {
                hashtable2.put("uid", string2);
            }
            if ((string6 = (String)this._htSessionContext.get("country")) != null) {
                hashtable2.put("country", string6);
            }
            if ((string5 = (String)this._htSessionContext.get("language")) != null) {
                hashtable2.put("language", string5);
            }
            if (string3 != null && !string3.equals(string)) {
                hashtable2.put("remote_organization", string3);
            }
            if ((String)this._htSessionContext.get("arp_target") != null) {
                hashtable2.put("arp_target", (String)this._htSessionContext.get("arp_target"));
            }
            if (!this._sessionManager.createSession(string9, this._htSessionContext)) {
                throw new ASelectException("0070");
            }
            if (this._crossASelectManager.useRemoteSigning()) {
                this._cryptoEngine.signRequest(hashtable2);
            }
            if ((hashtable3 = sAMResource.sendMessage(hashtable2, (String)object2)).isEmpty()) {
                this._systemLogger.log(Level.WARNING, this._sModule, string4, "Could not reach remote A-Select Server: " + (String)object2);
                throw new ASelectException("0001");
            }
            String string12 = (String)hashtable3.get("result_code");
            if (string12 == null) {
                StringBuffer stringBuffer = new StringBuffer("Invalid response from remote A-Select Server '");
                stringBuffer.append(string7);
                stringBuffer.append("' (missing: 'result_code')");
                this._systemLogger.log(Level.WARNING, this._sModule, string4, stringBuffer.toString());
                throw new ASelectException("0001");
            }
            if (!string12.equals("0000")) {
                StringBuffer stringBuffer = new StringBuffer("A-Select Server '");
                stringBuffer.append(string7);
                stringBuffer.append("' returned error: '");
                stringBuffer.append(string12);
                stringBuffer.append("'.");
                this._systemLogger.log(Level.WARNING, this._sModule, string4, stringBuffer.toString());
                throw new ASelectException(string12);
            }
            String string13 = (String)hashtable3.get("rid");
            String string14 = (String)hashtable3.get("as_url");
            if (string13 == null || string14 == null) {
                StringBuffer stringBuffer = new StringBuffer("Invalid response from remote A-Select Server: ");
                stringBuffer.append(string7);
                this._systemLogger.log(Level.WARNING, this._sModule, string4, stringBuffer.toString());
                throw new ASelectCommunicationException("0001");
            }
            try {
                StringBuffer stringBuffer = new StringBuffer(string14);
                stringBuffer.append("&rid=").append(string13);
                stringBuffer.append("&a-select-server=").append(string7);
                httpServletResponse.sendRedirect(stringBuffer.toString());
            }
            catch (IOException iOException) {
                StringBuffer stringBuffer = new StringBuffer("Failed to redirect user to: ");
                stringBuffer.append(string7);
                this._systemLogger.log(Level.WARNING, this._sModule, string4, stringBuffer.toString(), (Throwable)iOException);
                throw new ASelectCommunicationException("4006", (Throwable)iOException);
            }
        }
        catch (ASelectException aSelectException) {
            throw aSelectException;
        }
        catch (Exception exception) {
            this._systemLogger.log(Level.WARNING, this._sModule, string4, "Internal error", (Throwable)exception);
            throw new ASelectException("0001", (Throwable)exception);
        }
    }

    private void handleIPLogin1(Hashtable hashtable, HttpServletResponse httpServletResponse, PrintWriter printWriter) throws ASelectException {
        String string = "handleIPLogin1()";
        String string2 = null;
        Integer n = null;
        String string3 = null;
        Hashtable hashtable2 = new Hashtable();
        try {
            StringBuffer stringBuffer;
            String string4;
            String string5;
            Object object;
            string2 = (String)hashtable.get("rid");
            if (this._configManager.isSingleSignOn() && hashtable.containsKey("aselect_credentials_tgt") && hashtable.containsKey("aselect_credentials_uid") && hashtable.containsKey("aselect_credentials_server_id") && this.checkCredentials((String)(object = (String)hashtable.get("aselect_credentials_tgt")), string5 = (String)hashtable.get("aselect_credentials_uid"), string4 = (String)hashtable.get("aselect_credentials_server_id"))) {
                if (this._htSessionContext.get("cross_authenticate") != null && this._htSessionContext.get("cross_authenticate") != null) {
                    this._htSessionContext.put("user_id", string5);
                    this._sessionManager.createSession(string2, this._htSessionContext);
                    Hashtable hashtable3 = this._tgtManager.getTGT((String)object);
                    String string6 = (String)hashtable3.get("authsp");
                    this._tgtManager.remove(object);
                    Hashtable hashtable4 = new Hashtable();
                    TGTIssuer tGTIssuer = new TGTIssuer(this._sMyServerId);
                    tGTIssuer.issueTGT(string2, string6, hashtable4, httpServletResponse, null, this._servletRequest);
                    return;
                }
                try {
                    String string7 = (String)this._htSessionContext.get("app_url");
                    string7 = URLDecoder.decode(string7, "UTF-8");
                    stringBuffer = new StringBuffer(string7);
                    if (string7.indexOf("?") > 0) {
                        stringBuffer.append("&");
                    } else {
                        stringBuffer.append("?");
                    }
                    string5 = URLEncoder.encode(string5, "UTF-8");
                    string5 = URLEncoder.encode(string5, "UTF-8");
                    String string8 = CryptoEngine.getHandle().encryptTGT(Utils.stringToHex((String)object));
                    stringBuffer.append("aselect_credentials=").append(string8);
                    stringBuffer.append("_").append(string5).append("_");
                    stringBuffer.append(string4);
                    stringBuffer.append("&rid=").append(string2);
                    this._sessionManager.killSession(string2);
                    httpServletResponse.sendRedirect(stringBuffer.toString());
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    this._systemLogger.log(Level.WARNING, this._sModule, string, "Failed to encode user id.", (Throwable)unsupportedEncodingException);
                    throw new ASelectException("0001", (Throwable)unsupportedEncodingException);
                }
                catch (IOException iOException) {
                    this._systemLogger.log(Level.WARNING, this._sModule, string, "Failed to redirect user.", (Throwable)iOException);
                    throw new ASelectException("4006", (Throwable)iOException);
                }
            }
            n = this._applicationManager.getRequiredLevel((String)this._htSessionContext.get("app_id"));
            object = this._configManager.getSection(this._configManager.getSection(null, "authsps"), "authsp", "id=Ip");
            string3 = this._configManager.getParam(object, "level");
            if (string3 == null || Integer.parseInt(string3) < n) {
                stringBuffer = new StringBuffer(string);
                stringBuffer.append("Could not perform IP authentication. Reason : ");
                if (string3 == null) {
                    stringBuffer.append("The IP AuthSP is not (properly) configured.");
                } else {
                    stringBuffer.append("The IP authsp security level is too low for application '" + (String)this._htSessionContext.get("app_id") + "'.");
                }
                this._systemLogger.log(Level.INFO, this._sModule, string, stringBuffer.toString());
                throw new ASelectException("000a");
            }
            hashtable2.put("Ip", hashtable.get("client_ip"));
            this._htSessionContext.put("allowed_user_authsps", hashtable2);
            this._htSessionContext.put("user_id", hashtable.get("client_ip"));
            this._sessionManager.createSession(string2, this._htSessionContext);
            hashtable.put("authsp", "Ip");
            this.handleLogin3(hashtable, httpServletResponse, printWriter);
        }
        catch (ASelectException aSelectException) {
            throw aSelectException;
        }
        catch (Exception exception) {
            this._systemLogger.log(Level.WARNING, this._sModule, string, "Internal error", (Throwable)exception);
            throw new ASelectException("0001", (Throwable)exception);
        }
    }

    private void handleLogout(Hashtable hashtable, HttpServletResponse httpServletResponse, PrintWriter printWriter) throws ASelectException {
        String string = "handleLogout()";
        String string2 = this._configManager.getForm("loggedout");
        try {
            String string3 = (String)hashtable.get("aselect_credentials_tgt");
            Hashtable hashtable2 = this._tgtManager.getTGT(string3);
            if (hashtable2 != null) {
                Object object;
                this._tgtManager.remove((Object)string3);
                Cookie cookie = new Cookie("aselect_credentials", "jimmmorrisonisalive");
                String string4 = this._configManager.getCookieDomain();
                if (string4 != null) {
                    cookie.setDomain(string4);
                }
                httpServletResponse.addCookie(cookie);
                String string5 = null;
                String string6 = null;
                string6 = (String)hashtable2.get("proxy_organization");
                if (string6 == null) {
                    string6 = (String)hashtable2.get("organization");
                }
                if (!string6.equals(this._sMyOrg)) {
                    try {
                        String string7;
                        object = CrossASelectManager.getHandle();
                        String string8 = object.getRemoteParam(string6, "resourcegroup");
                        if (string8 == null) {
                            string7 = ASelectBrowserHandler.getSFSRelay(string6);
                            if (string7 != null) {
                                string8 = this._crossASelectManager.getRemoteParam(string7, "resourcegroup");
                                string6 = string7;
                            } else {
                                this._systemLogger.log(Level.SEVERE, this._sModule, string, "No remote server and no relay found for: " + string6);
                            }
                        }
                        string7 = ASelectSAMAgent.getHandle().getActiveResource(string8);
                        Object object2 = string7.getAttributes();
                        string5 = this._configManager.getParam(object2, "url");
                    }
                    catch (ASelectException aSelectException) {
                        this._systemLogger.log(Level.SEVERE, this._sModule, string, "Failed to read SAM.", (Throwable)aSelectException);
                        string5 = null;
                    }
                }
                if (string5 != null) {
                    object = (String)hashtable.get("request");
                    if (((String)object).equals("cross_logout")) {
                        string5 = string5 + "?request=cross_logout";
                    }
                    httpServletResponse.sendRedirect(string5);
                    return;
                }
            }
            string2 = this._configManager.updateTemplate(string2, hashtable2);
            printWriter.println(string2);
        }
        catch (Exception exception) {
            this._systemLogger.log(Level.WARNING, this._sModule, string, "Internal error", (Throwable)exception);
            throw new ASelectException("0001", (Throwable)exception);
        }
    }

    private void handleCreateTGT(Hashtable hashtable, HttpServletResponse httpServletResponse) throws ASelectException {
        String string = "handleCreateTGTRequest()";
        ASelectAuthenticationLogger aSelectAuthenticationLogger = ASelectAuthenticationLogger.getHandle();
        try {
            String string2 = (String)hashtable.get("rid");
            String string3 = (String)hashtable.get("uid");
            String string4 = (String)hashtable.get("app_id");
            String string5 = (String)hashtable.get("signature");
            String string6 = (String)hashtable.get("level");
            if (string2 == null || string3 == null || string4 == null || string5 == null || string6 == null) {
                this._systemLogger.log(Level.WARNING, this._sModule, string, "Invalid request received: one or more parameters are missing.");
                throw new ASelectCommunicationException("0030");
            }
            try {
                string5 = URLDecoder.decode(string5, "UTF-8");
                string3 = URLDecoder.decode(string3, "UTF-8");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                this._systemLogger.log(Level.WARNING, this._sModule, string, "Internal error: request could not be decoded", (Throwable)unsupportedEncodingException);
                throw new ASelectException("0001");
            }
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(string2).append(string3);
            stringBuffer.append(string4).append(string6);
            if (!CryptoEngine.getHandle().verifyPrivilegedSignature(string4, stringBuffer.toString(), string5)) {
                this._systemLogger.log(Level.WARNING, this._sModule, string, "Invalid request received: invalid signature.");
                throw new ASelectCommunicationException("0030");
            }
            Hashtable hashtable2 = this._sessionManager.getSessionContext(string2);
            if (hashtable2 == null) {
                this._systemLogger.log(Level.WARNING, this._sModule, string, "Invalid request received: invalid session.");
                throw new ASelectException("0070");
            }
            try {
                int n = Integer.parseInt(string6);
                if (n < 0) {
                    this._systemLogger.log(Level.WARNING, this._sModule, string, "Invalid request received: invalid AuthSP level.");
                    throw new ASelectException("0030");
                }
            }
            catch (NumberFormatException numberFormatException) {
                this._systemLogger.log(Level.WARNING, this._sModule, string, "Invalid request received: invalid AuthSP level.");
                throw new ASelectException("0030", (Throwable)numberFormatException);
            }
            IUDBConnector iUDBConnector = null;
            try {
                iUDBConnector = UDBConnectorFactory.getUDBConnector();
            }
            catch (ASelectException aSelectException) {
                this._systemLogger.log(Level.WARNING, this._sModule, string, "Failed to connect with UDB.", (Throwable)aSelectException);
                throw aSelectException;
            }
            if (!iUDBConnector.isUserEnabled(string3)) {
                this._systemLogger.log(Level.WARNING, this._sModule, string, "Invalid request received: Unknown UID.");
                throw new ASelectException("0002");
            }
            hashtable2.put("user_id", string3);
            hashtable2.put("authsp", string4);
            hashtable2.put("authsp_level", string6);
            if (!this._sessionManager.updateSession(string2, hashtable2)) {
                this._systemLogger.log(Level.WARNING, this._sModule, string, "Invalid request received: could not update session.");
                throw new ASelectException("0070");
            }
            aSelectAuthenticationLogger.log(new Object[]{"Login", string3, (String)hashtable.get("client_ip"), this._sMyOrg, string4, "granted"});
            TGTIssuer tGTIssuer = new TGTIssuer(this._sMyServerId);
            tGTIssuer.issueTGT(string2, string4, null, httpServletResponse, null, this._servletRequest);
        }
        catch (ASelectException aSelectException) {
            throw aSelectException;
        }
        catch (Exception exception) {
            this._systemLogger.log(Level.WARNING, this._sModule, string, "Internal error", (Throwable)exception);
            throw new ASelectException("0001", (Throwable)exception);
        }
    }

    private void getAuthsps(String string, String string2) throws ASelectException {
        Vector vector;
        Integer n = null;
        Integer n2 = null;
        Hashtable hashtable = new Hashtable();
        Hashtable hashtable2 = new Hashtable();
        String string3 = "getAuthsps()";
        IUDBConnector iUDBConnector = null;
        try {
            iUDBConnector = UDBConnectorFactory.getUDBConnector();
        }
        catch (ASelectException aSelectException) {
            this._systemLogger.log(Level.WARNING, this._sModule, string3, "Failed to connect with UDB.", (Throwable)aSelectException);
            throw aSelectException;
        }
        Hashtable hashtable3 = iUDBConnector.getUserProfile(string2);
        if (!((String)hashtable3.get("result_code")).equals("0000")) {
            this._systemLogger.log(Level.WARNING, this._sModule, string3, "Failed to get user profile.");
            throw new ASelectException((String)hashtable3.get("result_code"));
        }
        hashtable = (Hashtable)hashtable3.get("user_authsps");
        if (hashtable == null) {
            this._systemLogger.log(Level.SEVERE, this._sModule, string3, "INTERNAL ERROR");
            throw new ASelectException("0001");
        }
        n = (Integer)this._htSessionContext.get("level");
        if (n == null) {
            n = this._applicationManager.getRequiredLevel((String)this._htSessionContext.get("app_id"));
        }
        if ((vector = this._authspHandlerManager.getConfiguredAuthSPs(n, n2 = (Integer)this._htSessionContext.get("max_level"))) == null) {
            this._systemLogger.log(Level.WARNING, this._sModule, string3, "INTERNAL ERROR" + string2);
            throw new ASelectException("0001");
        }
        for (int i = 0; i < vector.size(); ++i) {
            String string4 = (String)vector.elementAt(i);
            if (!hashtable.containsKey(string4)) continue;
            hashtable2.put(string4, hashtable.get(string4));
        }
        if (hashtable2.size() == 0) {
            this._systemLogger.log(Level.WARNING, this._sModule, string3, "No valid AuthSPs found for user: " + string2);
            throw new ASelectException("0009");
        }
        this._htSessionContext.put("allowed_user_authsps", hashtable2);
        this._htSessionContext.put("user_id", string2);
        if (!this._sessionManager.createSession(string, this._htSessionContext)) {
            throw new ASelectException("0003");
        }
        return;
    }

    private String startAuthentication(String string, Hashtable hashtable) throws ASelectException {
        IAuthSPProtocolHandler iAuthSPProtocolHandler;
        String string2;
        Object object;
        String string3 = null;
        String string4 = "startAuthentication()";
        string3 = (String)hashtable.get("authsp");
        Hashtable hashtable2 = (Hashtable)this._htSessionContext.get("allowed_user_authsps");
        if (hashtable2 == null) {
            this._systemLogger.log(Level.WARNING, this._sModule, string4, "allowed_user_authsps not found in session context");
            throw new ASelectException("0001");
        }
        if (!hashtable2.containsKey(string3)) {
            StringBuffer stringBuffer = new StringBuffer("Invalid/unknown authsp id in request: ");
            stringBuffer.append(string3);
            this._systemLogger.log(Level.WARNING, this._sModule, string4, stringBuffer.toString());
            throw new ASelectException("0030");
        }
        this._htSessionContext.put("authsp", string3);
        this._htSessionContext.put("my_url", hashtable.get("my_url"));
        if (!this._sessionManager.createSession(string, this._htSessionContext)) {
            this._systemLogger.log(Level.WARNING, this._sModule, string4, "could not update session context");
            throw new ASelectException("0001");
        }
        try {
            object = this._configManager.getSection(this._configManager.getSection(null, "authsps"), "authsp", "id=" + string3);
            string2 = this._configManager.getParam(object, "handler");
            Class<?> clazz = Class.forName(string2);
            iAuthSPProtocolHandler = (IAuthSPProtocolHandler)clazz.newInstance();
            String string5 = this._configManager.getParam(object, "resourcegroup");
            SAMResource sAMResource = ASelectSAMAgent.getHandle().getActiveResource(string5);
            Object object2 = sAMResource.getAttributes();
            iAuthSPProtocolHandler.init(object, object2);
        }
        catch (ASelectConfigException aSelectConfigException) {
            this._systemLogger.log(Level.SEVERE, this._sModule, string4, "Failed to retrieve config for AuthSPs.", (Throwable)aSelectConfigException);
            throw new ASelectException(aSelectConfigException.getMessage());
        }
        catch (Exception exception) {
            this._systemLogger.log(Level.SEVERE, this._sModule, string4, "Failed to initialize handler AuthSPHandler.", (Throwable)exception);
            throw new ASelectException("0001");
        }
        object = iAuthSPProtocolHandler.computeAuthenticationRequest(string);
        string2 = (String)((Hashtable)object).get("result");
        if (string2.equals("0000")) {
            return (String)((Hashtable)object).get("redirect_url");
        }
        this._systemLogger.log(Level.WARNING, this._sModule, string4, "Failed to create redirect url.");
        throw new ASelectException(string2);
    }

    private boolean checkCredentials(String string, String string2, String string3) {
        Hashtable hashtable = this._tgtManager.getTGT(string);
        if (hashtable == null) {
            return false;
        }
        if (!((String)hashtable.get("uid")).equals(string2)) {
            return false;
        }
        if (!string3.equals(this._sMyServerId)) {
            return false;
        }
        Vector vector = (Vector)this._htSessionContext.get("sso_groups");
        Vector vector2 = (Vector)hashtable.get("sso_groups");
        if (!(vector == null || vector2 == null || vector.isEmpty() || vector2.isEmpty() || this._applicationManager.isValidSSOGroup(vector, vector2))) {
            return false;
        }
        Integer n = (Integer)this._htSessionContext.get("level");
        String string4 = (String)hashtable.get("authsp_level");
        return Integer.parseInt(string4) >= n;
    }

    private void showUserInfo(Hashtable hashtable, HttpServletResponse httpServletResponse) throws ASelectException {
        String string = "showUserInfo()";
        PrintWriter printWriter = null;
        try {
            Object object;
            String string2;
            printWriter = httpServletResponse.getWriter();
            String string3 = (String)hashtable.get("aselect_credentials_uid");
            String string4 = (String)hashtable.get("my_url");
            String string5 = (String)hashtable.get("aselect_credentials_tgt");
            String string6 = this._configManager.getForm("userinfo");
            string6 = Utils.replaceString((String)string6, (String)"[uid]", (String)string3);
            string6 = Utils.replaceString((String)string6, (String)"[a-select-server]", (String)this._sMyServerId);
            string6 = Utils.replaceString((String)string6, (String)"[aselect_url]", (String)string4);
            Hashtable hashtable2 = this._tgtManager.getTGT(string5);
            try {
                long l = this._tgtManager.getExpirationTime((Object)string5);
                string2 = new Date(l).toString();
                string6 = Utils.replaceString((String)string6, (String)"[tgt_exp_time]", (String)string2);
            }
            catch (ASelectStorageException aSelectStorageException) {
                string6 = Utils.replaceString((String)string6, (String)"[tgt_exp_time]", (String)"[unknown]");
            }
            string2 = (String)hashtable2.get("app_id");
            if (string2 == null) {
                string2 = "[unknown]";
            }
            string6 = Utils.replaceString((String)string6, (String)"[app]", (String)string2);
            string6 = this._configManager.updateTemplate(string6, hashtable2);
            string2 = (String)hashtable2.get("authsp");
            if (string2 != null) {
                try {
                    Object object2 = this._configManager.getSection(this._configManager.getSection(null, "authsps"), "authsp", "id=" + string2);
                    string2 = this._configManager.getParam(object2, "friendly_name");
                }
                catch (ASelectConfigException aSelectConfigException) {
                    string2 = "[unknown]";
                }
            } else {
                string2 = "[unknown]";
            }
            string6 = Utils.replaceString((String)string6, (String)"[authsp]", (String)string2);
            string2 = (String)hashtable2.get("authsp_level");
            string6 = Utils.replaceString((String)string6, (String)"[tgt_level]", (String)string2);
            string2 = (String)hashtable2.get("proxy_organization");
            if (string2 == null) {
                string2 = (String)hashtable2.get("organization");
            }
            String string7 = null;
            if (!string2.equals(this._sMyOrg)) {
                try {
                    String string8;
                    object = CrossASelectManager.getHandle();
                    String string9 = object.getRemoteParam(string2, "resourcegroup");
                    if (string9 == null) {
                        string8 = ASelectBrowserHandler.getSFSRelay(string2);
                        if (string8 != null) {
                            string9 = this._crossASelectManager.getRemoteParam(string8, "resourcegroup");
                            string2 = string8;
                        } else {
                            this._systemLogger.log(Level.SEVERE, this._sModule, string, "No remote server and no relay found for: " + string2);
                        }
                    }
                    string8 = ASelectSAMAgent.getHandle().getActiveResource(string9);
                    Object object3 = string8.getAttributes();
                    string7 = this._configManager.getParam(object3, "url");
                }
                catch (ASelectException aSelectException) {
                    this._systemLogger.log(Level.SEVERE, this._sModule, string, "Failed to read SAM.", (Throwable)aSelectException);
                    string7 = null;
                }
            }
            if (string7 == null) {
                string6 = Utils.replaceString((String)string6, (String)"[org]", (String)string2);
            } else {
                object = "<A HREF=\"" + string7 + "\">" + string2 + "</A>";
                string6 = Utils.replaceString((String)string6, (String)"[org]", (String)object);
            }
            printWriter.println(string6);
        }
        catch (IOException iOException) {
            this._systemLogger.log(Level.WARNING, this._sModule, string, "Error writing output", (Throwable)iOException);
            throw new ASelectException("0001");
        }
    }
}

