/*
 * Decompiled with CFR 0.152.
 */
package org.aselect.server.request.handler.sfs.authentication;

import javax.servlet.http.HttpServletRequest;

public class RequestParser {
    private String _sMethod = null;
    private String _sRequest = null;
    private int _iRequestType = -1;
    private int _iRequestOrigin = -1;
    private int _iRequestProtocol = -1;
    public static final int REQTYPE_UNKNOWN = -1;
    public static final int REQTYPE_API_CALL = 0;
    public static final int REQTYPE_BROWSER = 1;
    public static final int ORIGIN_UNKNOWN = -1;
    public static final int ORIGIN_APPLICATION = 0;
    public static final int ORIGIN_AUTHSP = 1;
    public static final int ORIGIN_ASELECTSERVER = 2;
    public static final int ORIGIN_USER = 3;
    public static final int PROTOCOL_UNKNOWN = -1;
    public static final int PROTOCOL_CGI = 0;
    public static final int PROTOCOL_SOAP11 = 1;
    public static final int PROTOCOL_SOAP12 = 2;

    public RequestParser(HttpServletRequest httpServletRequest) {
        this.parseRequest(httpServletRequest);
    }

    public int getRequestType() {
        return this._iRequestType;
    }

    public int getRequestOrigin() {
        return this._iRequestOrigin;
    }

    public int getRequestProtocol() {
        return this._iRequestProtocol;
    }

    public String getRequest() {
        return this._sRequest;
    }

    private void parseRequest(HttpServletRequest httpServletRequest) {
        this._sMethod = httpServletRequest.getMethod();
        if (this._sMethod.equalsIgnoreCase("GET")) {
            this._iRequestProtocol = 0;
            this._sRequest = httpServletRequest.getParameter("request");
            if (this._sRequest == null) {
                this._iRequestOrigin = httpServletRequest.getParameter("authsp") != null ? 1 : (httpServletRequest.getParameter("aselect_credentials") != null ? 2 : 3);
                this._iRequestType = 1;
            } else {
                if (this._sRequest.equals("verify_credentials") || this._sRequest.equals("authenticate")) {
                    this._iRequestOrigin = httpServletRequest.getParameter("local_organization") != null ? 2 : 0;
                    this._iRequestType = 0;
                }
                if (this._sRequest.equals("kill_tgt") || this._sRequest.equals("get_app_level")) {
                    this._iRequestOrigin = 0;
                    this._iRequestType = 0;
                } else if (this._sRequest.equals("login1")) {
                    this._iRequestOrigin = 0;
                    this._iRequestType = 1;
                } else if (this._sRequest.equals("cross_login")) {
                    this._iRequestOrigin = 0;
                    this._iRequestType = 1;
                }
                if (this._sRequest.equals("logout")) {
                    this._iRequestOrigin = 0;
                    this._iRequestType = 1;
                } else if (this._sRequest.equals("cross_logout")) {
                    this._iRequestOrigin = 0;
                    this._iRequestType = 1;
                } else if (this._sRequest.equals("direct_login1")) {
                    this._iRequestOrigin = 0;
                    this._iRequestType = 1;
                } else if (this._sRequest.equals("direct_login2")) {
                    this._iRequestOrigin = 0;
                    this._iRequestType = 1;
                } else if (this._sRequest.equals("error")) {
                    this._iRequestOrigin = 1;
                    this._iRequestType = 1;
                } else if (this._sRequest.equals("create_tgt")) {
                    this._iRequestOrigin = 0;
                    this._iRequestType = 1;
                } else if (this._sRequest.equals("kill_session")) {
                    this._iRequestOrigin = 1;
                    this._iRequestType = 0;
                }
            }
        } else if (this._sMethod.equalsIgnoreCase("POST")) {
            String string = httpServletRequest.getContentType();
            if (string.indexOf("text/xml") > -1) {
                this._iRequestType = 0;
                this._iRequestOrigin = 0;
                this._iRequestProtocol = 1;
            } else if (string.indexOf("application/soap+xml") > -1) {
                this._iRequestType = 0;
                this._iRequestOrigin = 0;
                this._iRequestProtocol = 2;
            } else {
                this._sRequest = httpServletRequest.getParameter("request");
                this._iRequestOrigin = this._sRequest != null && this._sRequest.indexOf("login") > -1 ? 3 : (httpServletRequest.getParameter("authsp") != null ? 1 : 3);
                this._iRequestType = 1;
                this._iRequestProtocol = 0;
            }
        }
        if (this._sRequest == null) {
            this._sRequest = "";
        }
    }
}

