/*
 * Decompiled with CFR 0.152.
 */
package org.aselect.authspserver.authsp.ldap;

import java.util.Hashtable;
import java.util.logging.Level;
import org.aselect.authspserver.authsp.ldap.ILDAPProtocolHandler;
import org.aselect.authspserver.config.AuthSPConfigManager;
import org.aselect.authspserver.log.AuthSPSystemLogger;
import org.aselect.system.exception.ASelectConfigException;
import org.aselect.system.exception.ASelectException;
import org.aselect.system.logging.SystemLogger;

public class LDAPProtocolHandlerFactory {
    public static final String MODULE = "LDAPProtocolHandlerFactory";

    public static ILDAPProtocolHandler instantiateProtocolHandler(Object object, String string, AuthSPSystemLogger authSPSystemLogger) throws ASelectException {
        String string2 = "instantiateProtocolHandler()";
        try {
            Hashtable hashtable = LDAPProtocolHandlerFactory.getContext(object, string, (SystemLogger)authSPSystemLogger);
            if (hashtable == null) {
                authSPSystemLogger.log(Level.WARNING, MODULE, string2, "Could not initialize LDAP protocol handler: no context available.");
                throw new ASelectException("900");
            }
            String string3 = (String)hashtable.get("url");
            String string4 = (String)hashtable.get("driver");
            String string5 = (String)hashtable.get("users_dn");
            String string6 = (String)hashtable.get("uid_dn");
            String string7 = (String)hashtable.get("handler");
            String string8 = (String)hashtable.get("security_principal_dn");
            String string9 = (String)hashtable.get("security_principal_password");
            Boolean bl = (Boolean)hashtable.get("full_uid");
            Class<?> clazz = Class.forName(string7);
            ILDAPProtocolHandler iLDAPProtocolHandler = (ILDAPProtocolHandler)clazz.newInstance();
            if (!iLDAPProtocolHandler.init(string3, string4, string5, string6, bl, string, string8, string9, authSPSystemLogger)) {
                authSPSystemLogger.log(Level.WARNING, MODULE, string2, "Could not initialize LDAP protocol handler.");
                throw new ASelectException("900");
            }
            return iLDAPProtocolHandler;
        }
        catch (ASelectException aSelectException) {
            authSPSystemLogger.log(Level.WARNING, MODULE, string2, "Could not instantiate LDAP protocol handler", (Throwable)aSelectException);
            throw aSelectException;
        }
        catch (ClassNotFoundException classNotFoundException) {
            authSPSystemLogger.log(Level.SEVERE, MODULE, string2, "Could not instantiate LDAP protocol handler. Class was not found", (Throwable)classNotFoundException);
            throw new ASelectException("900", (Throwable)classNotFoundException);
        }
        catch (Exception exception) {
            authSPSystemLogger.log(Level.SEVERE, MODULE, string2, "Could not instantiate LDAP protocol handler due to internal error", (Throwable)exception);
            throw new ASelectException("100", (Throwable)exception);
        }
    }

    public static Hashtable getContext(Object object, String string, SystemLogger systemLogger) throws ASelectException {
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        StringBuffer stringBuffer = null;
        String string2 = "getContext()";
        String string3 = null;
        AuthSPConfigManager authSPConfigManager = AuthSPConfigManager.getHandle();
        try {
            String string4 = null;
            int n = string.indexOf(64);
            if (n > -1 && (string4 = string.substring(n)).length() <= 0) {
                stringBuffer = new StringBuffer("Could not determine realm for user id '");
                stringBuffer.append(string);
                stringBuffer.append("' User id should be [user]@[realm].");
                systemLogger.log(Level.WARNING, MODULE, string2, stringBuffer.toString());
                throw new ASelectException("900");
            }
            Object object2 = null;
            try {
                object2 = authSPConfigManager.getSection(object, "back-end_server", "realm=" + string4);
            }
            catch (ASelectConfigException aSelectConfigException) {
                object2 = null;
            }
            try {
                if (object2 == null) {
                    object2 = authSPConfigManager.getSection(object, "back-end_server", "realm=*");
                }
            }
            catch (ASelectConfigException aSelectConfigException) {
                object2 = null;
            }
            if (object2 == null) {
                try {
                    object2 = authSPConfigManager.getSection(object, "back-end_server");
                }
                catch (ASelectConfigException aSelectConfigException) {
                    object2 = null;
                }
                while (object2 != null) {
                    try {
                        authSPConfigManager.getParam(object2, "realm");
                    }
                    catch (ASelectConfigException aSelectConfigException) {
                        break;
                    }
                    object2 = authSPConfigManager.getNextSection(object2);
                }
                if (object2 == null) {
                    stringBuffer = new StringBuffer("no ldap server defined for realm ");
                    stringBuffer.append(string4).append(" while authenticating ");
                    stringBuffer.append(string);
                    systemLogger.log(Level.SEVERE, MODULE, string2, stringBuffer.toString());
                    return null;
                }
            }
            String string5 = null;
            try {
                string5 = authSPConfigManager.getParam(object2, "url");
            }
            catch (ASelectConfigException aSelectConfigException) {
                stringBuffer = new StringBuffer("No url defined for realm '");
                stringBuffer.append(string4);
                stringBuffer.append("' while authenticating '");
                stringBuffer.append(string).append("'");
                systemLogger.log(Level.WARNING, MODULE, string2, stringBuffer.toString(), (Throwable)aSelectConfigException);
                throw new ASelectException("900", (Throwable)aSelectConfigException);
            }
            String string6 = null;
            try {
                string6 = authSPConfigManager.getParam(object2, "driver");
            }
            catch (ASelectConfigException aSelectConfigException) {
                stringBuffer = new StringBuffer("No driver defined for realm ");
                stringBuffer.append(string4);
                stringBuffer.append(" while authenticating '");
                stringBuffer.append(string).append("'");
                systemLogger.log(Level.WARNING, MODULE, string2, stringBuffer.toString(), (Throwable)aSelectConfigException);
                throw new ASelectException("900", (Throwable)aSelectConfigException);
            }
            String string7 = null;
            try {
                string7 = authSPConfigManager.getParam(object2, "base_dn");
            }
            catch (ASelectConfigException aSelectConfigException) {
                stringBuffer = new StringBuffer("No base_dn defined for realm '");
                stringBuffer.append(string4);
                stringBuffer.append("' while authenticating '");
                stringBuffer.append(string).append("'");
                systemLogger.log(Level.WARNING, MODULE, string2, stringBuffer.toString(), (Throwable)aSelectConfigException);
                throw new ASelectException("900", (Throwable)aSelectConfigException);
            }
            String string8 = null;
            try {
                string8 = authSPConfigManager.getParam(object2, "user_dn");
            }
            catch (ASelectConfigException aSelectConfigException) {
                stringBuffer = new StringBuffer("No user_dn defined for realm '");
                stringBuffer.append(string4);
                stringBuffer.append("' while authenticating '");
                stringBuffer.append(string).append("'");
                systemLogger.log(Level.WARNING, MODULE, string2, stringBuffer.toString(), (Throwable)aSelectConfigException);
                throw new ASelectException("900", (Throwable)aSelectConfigException);
            }
            try {
                string3 = authSPConfigManager.getParam(object2, "method");
            }
            catch (ASelectConfigException aSelectConfigException) {
                stringBuffer = new StringBuffer("No method setting defined for realm '");
                stringBuffer.append(string4);
                stringBuffer.append("' while authenticating '");
                stringBuffer.append(string).append("'");
                systemLogger.log(Level.WARNING, MODULE, string2, stringBuffer.toString(), (Throwable)aSelectConfigException);
                throw new ASelectException("900", (Throwable)aSelectConfigException);
            }
            String string9 = null;
            try {
                string9 = authSPConfigManager.getParam(object, string3 + "_protocolhandler");
            }
            catch (ASelectConfigException aSelectConfigException) {
                stringBuffer = new StringBuffer("No protocol handler defined for method '");
                stringBuffer.append(string3);
                stringBuffer.append("' while authenticating '");
                stringBuffer.append(string).append("'");
                systemLogger.log(Level.WARNING, MODULE, string2, stringBuffer.toString(), (Throwable)aSelectConfigException);
                throw new ASelectException("900", (Throwable)aSelectConfigException);
            }
            String string10 = null;
            try {
                string10 = authSPConfigManager.getParam(object2, "security_principal_dn");
            }
            catch (ASelectConfigException aSelectConfigException) {
                string10 = "";
            }
            String string11 = null;
            try {
                string11 = authSPConfigManager.getParam(object2, "security_principal_password");
            }
            catch (ASelectConfigException aSelectConfigException) {
                string11 = "";
            }
            boolean bl = false;
            String string12 = null;
            try {
                string12 = authSPConfigManager.getParam(object2, "full_uid");
            }
            catch (ASelectConfigException aSelectConfigException) {
                string12 = "false";
                StringBuffer stringBuffer2 = new StringBuffer("No 'full_uid' defined for realm ");
                stringBuffer2.append(string4);
                stringBuffer2.append("; using default: full_uid = ");
                stringBuffer2.append(string12);
                systemLogger.log(Level.CONFIG, MODULE, string2, stringBuffer2.toString(), (Throwable)aSelectConfigException);
            }
            if (string12.equalsIgnoreCase("true")) {
                bl = true;
            } else if (string12.equalsIgnoreCase("false")) {
                bl = false;
            } else {
                StringBuffer stringBuffer3 = new StringBuffer("Invalid 'full_uid' config item defined for realm ");
                stringBuffer3.append(string4);
                stringBuffer3.append(" : ");
                stringBuffer3.append(string12);
                stringBuffer3.append("; using default: full_uid = false");
                systemLogger.log(Level.CONFIG, MODULE, string2, stringBuffer3.toString());
            }
            hashtable.put("url", string5);
            hashtable.put("driver", string6);
            hashtable.put("users_dn", string7);
            hashtable.put("uid_dn", string8);
            hashtable.put("handler", string9);
            hashtable.put("security_principal_dn", string10);
            hashtable.put("security_principal_password", string11);
            hashtable.put("full_uid", new Boolean(bl));
            return hashtable;
        }
        catch (ASelectException aSelectException) {
            throw aSelectException;
        }
        catch (Exception exception) {
            systemLogger.log(Level.SEVERE, MODULE, string2, "Could not retrieve context due to internal error", (Throwable)exception);
            throw new ASelectException("100", (Throwable)exception);
        }
    }
}

