/*
 * Decompiled with CFR 0.152.
 */
package org.aselect.authspserver.authsp.ldap;

import java.util.Hashtable;
import java.util.logging.Level;
import javax.naming.AuthenticationException;
import javax.naming.CommunicationException;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.InitialDirContext;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import org.aselect.authspserver.authsp.ldap.AbstractLDAPProtocolHandler;
import org.aselect.system.exception.ASelectException;

public class LDAPSimpleProtocolHandler
extends AbstractLDAPProtocolHandler {
    public LDAPSimpleProtocolHandler() {
        this._sModule = "LDAPSimpleProtocolHandler";
    }

    protected void doBind(String string) throws ASelectException {
        String string2 = "doBind()";
        StringBuffer stringBuffer = null;
        InitialDirContext initialDirContext = null;
        String string3 = null;
        String string4 = null;
        NamingEnumeration<SearchResult> namingEnumeration = null;
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        if (this._sPrincipalDn.equals("")) {
            hashtable.put("java.naming.provider.url", this._sLDAPUrl);
            hashtable.put("java.naming.factory.initial", this._sDriver);
            hashtable.put("java.naming.security.authentication", "simple");
            stringBuffer = new StringBuffer(this._sUserDn);
            stringBuffer.append("=");
            stringBuffer.append(this._sUid);
            stringBuffer.append(", ");
            stringBuffer.append(this._sBaseDn);
            hashtable.put("java.naming.security.principal", stringBuffer.toString());
            hashtable.put("java.naming.security.credentials", string);
            try {
                initialDirContext = new InitialDirContext(hashtable);
            }
            catch (AuthenticationException authenticationException) {
                StringBuffer stringBuffer2 = new StringBuffer("Could not authenticate user (invalid password): ");
                stringBuffer2.append(this._sUid);
                this._systemLogger.log(Level.FINE, this._sModule, string2, stringBuffer2.toString(), (Throwable)authenticationException);
                throw new ASelectException("400", (Throwable)authenticationException);
            }
            catch (CommunicationException communicationException) {
                this._systemLogger.log(Level.WARNING, this._sModule, string2, "A communication error has occured", (Throwable)communicationException);
                throw new ASelectException("300", (Throwable)communicationException);
            }
            catch (NamingException namingException) {
                this._systemLogger.log(Level.WARNING, this._sModule, string2, "An naming error has occured", (Throwable)namingException);
                throw new ASelectException("100", (Throwable)namingException);
            }
            try {
                initialDirContext.close();
            }
            catch (Exception exception) {
                stringBuffer = new StringBuffer("Could not close connection with '");
                stringBuffer.append(this._sLDAPUrl);
                stringBuffer.append("'");
                this._systemLogger.log(Level.WARNING, this._sModule, string2, stringBuffer.toString(), (Throwable)exception);
            }
        } else {
            hashtable.put("java.naming.provider.url", this._sLDAPUrl);
            hashtable.put("java.naming.factory.initial", this._sDriver);
            hashtable.put("java.naming.security.authentication", "simple");
            hashtable.put("java.naming.security.principal", this._sPrincipalDn);
            hashtable.put("java.naming.security.credentials", this._sPrincipalPwd);
            try {
                initialDirContext = new InitialDirContext(hashtable);
            }
            catch (AuthenticationException authenticationException) {
                this._systemLogger.log(Level.WARNING, this._sModule, string2, "Could not bind to LDAP server", (Throwable)authenticationException);
                throw new ASelectException("900", (Throwable)authenticationException);
            }
            catch (CommunicationException communicationException) {
                this._systemLogger.log(Level.WARNING, this._sModule, string2, "An communication error has occured", (Throwable)communicationException);
                throw new ASelectException("300", (Throwable)communicationException);
            }
            catch (NamingException namingException) {
                this._systemLogger.log(Level.WARNING, this._sModule, string2, "An naming error has occured", (Throwable)namingException);
                throw new ASelectException("100", (Throwable)namingException);
            }
            stringBuffer = new StringBuffer("(");
            stringBuffer.append(this._sUserDn);
            stringBuffer.append("=");
            stringBuffer.append(this._sUid);
            stringBuffer.append(")");
            string3 = stringBuffer.toString();
            SearchControls searchControls = new SearchControls();
            searchControls.setSearchScope(2);
            try {
                namingEnumeration = initialDirContext.search(this._sBaseDn, string3, searchControls);
            }
            catch (NamingException namingException) {
                stringBuffer = new StringBuffer("User '");
                stringBuffer.append(this._sUid);
                stringBuffer.append("' is unknown");
                this._systemLogger.log(Level.WARNING, this._sModule, string2, stringBuffer.toString(), (Throwable)namingException);
                throw new ASelectException("900");
            }
            finally {
                try {
                    if (initialDirContext != null) {
                        initialDirContext.close();
                        initialDirContext = null;
                    }
                }
                catch (Exception exception) {
                    stringBuffer = new StringBuffer("Could not close connection with '");
                    stringBuffer.append(this._sLDAPUrl);
                    stringBuffer.append("'");
                    this._systemLogger.log(Level.WARNING, this._sModule, string2, stringBuffer.toString(), (Throwable)exception);
                }
            }
            try {
                if (!namingEnumeration.hasMore()) {
                    stringBuffer = new StringBuffer("User '");
                    stringBuffer.append(this._sUid);
                    stringBuffer.append("' not found during LDAP search. The filter was: '");
                    stringBuffer.append(string3).append("'.");
                    this._systemLogger.log(Level.WARNING, this._sModule, string2, stringBuffer.toString());
                    throw new ASelectException("900");
                }
                SearchResult searchResult = namingEnumeration.next();
                string4 = searchResult.getName();
                namingEnumeration.close();
                if (string4 == null) {
                    stringBuffer = new StringBuffer("no user dn was returned for '");
                    stringBuffer.append(this._sUid);
                    stringBuffer.append("'.");
                    this._systemLogger.log(Level.WARNING, this._sModule, string2, stringBuffer.toString());
                    throw new ASelectException("900");
                }
            }
            catch (NamingException namingException) {
                stringBuffer = new StringBuffer("failed to fetch profile of user '");
                stringBuffer.append(this._sUid);
                stringBuffer.append("'");
                this._systemLogger.log(Level.WARNING, this._sModule, string2, stringBuffer.toString(), (Throwable)namingException);
                throw new ASelectException("900");
            }
            stringBuffer = new StringBuffer(string4);
            stringBuffer.append(",");
            stringBuffer.append(this._sBaseDn);
            hashtable = new Hashtable();
            hashtable.put("java.naming.provider.url", this._sLDAPUrl);
            hashtable.put("java.naming.factory.initial", this._sDriver);
            hashtable.put("java.naming.security.authentication", "simple");
            hashtable.put("java.naming.security.principal", stringBuffer.toString());
            hashtable.put("java.naming.security.credentials", string);
            try {
                initialDirContext = new InitialDirContext(hashtable);
            }
            catch (AuthenticationException authenticationException) {
                StringBuffer stringBuffer3 = new StringBuffer("Could not authenticate user (invalid password): ");
                stringBuffer3.append(this._sUid);
                this._systemLogger.log(Level.FINE, this._sModule, string2, stringBuffer3.toString(), (Throwable)authenticationException);
                throw new ASelectException("400", (Throwable)authenticationException);
            }
            catch (CommunicationException communicationException) {
                this._systemLogger.log(Level.WARNING, this._sModule, string2, "An communication error has occured", (Throwable)communicationException);
                throw new ASelectException("300", (Throwable)communicationException);
            }
            catch (NamingException namingException) {
                this._systemLogger.log(Level.WARNING, this._sModule, string2, "An naming error has occured", (Throwable)namingException);
                throw new ASelectException("100", (Throwable)namingException);
            }
            try {
                initialDirContext.close();
            }
            catch (Exception exception) {
                stringBuffer = new StringBuffer("Could not close connection with '");
                stringBuffer.append(this._sLDAPUrl);
                stringBuffer.append("'");
                this._systemLogger.log(Level.WARNING, this._sModule, string2, stringBuffer.toString(), (Throwable)exception);
            }
        }
    }
}

