/*
 * Decompiled with CFR 0.152.
 */
package org.aselect.server.authspprotocol.handler;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.Hashtable;
import java.util.logging.Level;
import org.aselect.server.authspprotocol.IAuthSPProtocolHandler;
import org.aselect.server.config.ASelectConfigManager;
import org.aselect.server.crypto.CryptoEngine;
import org.aselect.server.log.ASelectAuthenticationLogger;
import org.aselect.server.log.ASelectSystemLogger;
import org.aselect.server.session.SessionManager;
import org.aselect.system.exception.ASelectAuthSPException;
import org.aselect.system.exception.ASelectConfigException;

public class DBAuthSPHandler
implements IAuthSPProtocolHandler {
    private final String MODULE = "DBAuthSPHandler";
    private ASelectConfigManager _configManager;
    private SessionManager _sessionManager;
    private ASelectSystemLogger _systemLogger;
    private ASelectAuthenticationLogger _authenticationLogger;
    private String _sAuthsp;
    private String _sAuthspUrl;
    private static final String ERROR_DB_OK = "000";
    private static final String ERROR_DB_ACCESS_DENIED = "800";
    private static final String ERROR_DB_INVALID_CREDENTIALS = "400";
    private static final String ERROR_DB_PREFIX = "DB";

    public void init(Object object, Object object2) throws ASelectAuthSPException {
        String string = "init()";
        this._configManager = ASelectConfigManager.getHandle();
        this._sessionManager = SessionManager.getHandle();
        this._authenticationLogger = ASelectAuthenticationLogger.getHandle();
        this._systemLogger = ASelectSystemLogger.getHandle();
        try {
            try {
                this._sAuthsp = this._configManager.getParam(object, "id");
            }
            catch (ASelectConfigException aSelectConfigException) {
                this._systemLogger.log(Level.WARNING, "DBAuthSPHandler", "init()", "Parameter 'id' not found in DB AuthSP configuration", (Throwable)aSelectConfigException);
                throw new ASelectAuthSPException("4009", (Throwable)aSelectConfigException);
            }
            try {
                this._sAuthspUrl = this._configManager.getParam(object2, "url");
            }
            catch (ASelectConfigException aSelectConfigException) {
                this._systemLogger.log(Level.WARNING, "DBAuthSPHandler", "init()", "Parameter 'url' not found in DB AuthSP configuration", (Throwable)aSelectConfigException);
                throw new ASelectAuthSPException("4009", (Throwable)aSelectConfigException);
            }
        }
        catch (ASelectAuthSPException aSelectAuthSPException) {
            this._systemLogger.log(Level.SEVERE, "DBAuthSPHandler", "init()", "Initialisation failed due to configuration error", (Throwable)aSelectAuthSPException);
            throw aSelectAuthSPException;
        }
        catch (Exception exception) {
            this._systemLogger.log(Level.SEVERE, "DBAuthSPHandler", "init()", "Initialisation failed due to internal error", (Throwable)exception);
            throw new ASelectAuthSPException("0001", (Throwable)exception);
        }
    }

    public Hashtable computeAuthenticationRequest(String string) {
        String string2 = "computeAuthenticationRequest()";
        StringBuffer stringBuffer = null;
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        hashtable.put("result", "0001");
        try {
            String string3;
            String string4;
            Hashtable hashtable2 = this._sessionManager.getSessionContext(string);
            if (hashtable2 == null) {
                stringBuffer = new StringBuffer("Could not fetch session context for rid='");
                stringBuffer.append(string).append("'.");
                this._systemLogger.log(Level.WARNING, "DBAuthSPHandler", string2, stringBuffer.toString());
                throw new ASelectAuthSPException("0003");
            }
            Hashtable hashtable3 = (Hashtable)hashtable2.get("allowed_user_authsps");
            if (hashtable3 == null) {
                this._systemLogger.log(Level.WARNING, "DBAuthSPHandler", string2, "Allowed_user_authsps missing in session context.");
                throw new ASelectAuthSPException("0003");
            }
            String string5 = (String)hashtable3.get(this._sAuthsp);
            if (string5 == null) {
                this._systemLogger.log(Level.WARNING, "DBAuthSPHandler", string2, "Missing DB user attributes.");
                throw new ASelectAuthSPException("0003");
            }
            stringBuffer = new StringBuffer((String)hashtable2.get("my_url"));
            stringBuffer.append("?authsp=").append(this._sAuthsp);
            String string6 = stringBuffer.toString();
            String string7 = (String)hashtable2.get("country");
            if (string7 == null || string7.trim().length() < 1) {
                string7 = null;
            }
            if ((string4 = (String)hashtable2.get("language")) == null || string4.trim().length() < 1) {
                string4 = null;
            }
            String string8 = this._configManager.getParam(this._configManager.getSection(null, "aselect"), "server_id");
            StringBuffer stringBuffer2 = new StringBuffer(string);
            stringBuffer2.append(string6);
            stringBuffer2.append(string5);
            stringBuffer2.append(string8);
            if (string7 != null) {
                stringBuffer2.append(string7);
            }
            if (string4 != null) {
                stringBuffer2.append(string4);
            }
            if ((string3 = CryptoEngine.getHandle().generateSignature(this._sAuthsp, stringBuffer2.toString())) == null) {
                this._systemLogger.log(Level.WARNING, "DBAuthSPHandler", string2, "Could not sign DB AuthSP request.");
                throw new ASelectAuthSPException("0003");
            }
            string3 = URLEncoder.encode(string3, "UTF-8");
            string5 = URLEncoder.encode(string5, "UTF-8");
            string6 = URLEncoder.encode(string6, "UTF-8");
            StringBuffer stringBuffer3 = new StringBuffer(this._sAuthspUrl);
            stringBuffer3.append("?as_url=").append(string6);
            stringBuffer3.append("&rid=").append(string);
            stringBuffer3.append("&uid=").append(string5);
            stringBuffer3.append("&a-select-server=").append(string8);
            if (string7 != null) {
                stringBuffer3.append("&country=").append(string7);
            }
            if (string4 != null) {
                stringBuffer3.append("&language=").append(string4);
            }
            stringBuffer3.append("&signature=").append(string3);
            hashtable.put("redirect_url", stringBuffer3.toString());
            hashtable.put("result", "0000");
        }
        catch (ASelectAuthSPException aSelectAuthSPException) {
            hashtable.put("result", aSelectAuthSPException.getMessage());
        }
        catch (Exception exception) {
            this._systemLogger.log(Level.SEVERE, "DBAuthSPHandler", string2, "Could not compute authentication request due to internal error", (Throwable)exception);
            hashtable.put("result", "0003");
        }
        return hashtable;
    }

    public Hashtable verifyAuthenticationResponse(Hashtable hashtable) {
        String string = "verifyAuthenticationResponse()";
        StringBuffer stringBuffer = null;
        Hashtable<String, String> hashtable2 = new Hashtable<String, String>();
        hashtable2.put("result", "0001");
        try {
            String string2 = (String)hashtable.get("rid");
            String string3 = (String)hashtable.get("my_url");
            String string4 = (String)hashtable.get("result_code");
            String string5 = (String)hashtable.get("a-select-server");
            String string6 = (String)hashtable.get("signature");
            if (string2 == null || string4 == null || string5 == null || string6 == null) {
                this._systemLogger.log(Level.WARNING, "DBAuthSPHandler", string, "Incorrect AuthSP response: one or more parameters missing.");
                throw new ASelectAuthSPException("000a");
            }
            stringBuffer = new StringBuffer(string3);
            stringBuffer.append("?authsp=");
            stringBuffer.append(this._sAuthsp);
            string3 = stringBuffer.toString();
            string6 = URLDecoder.decode(string6, "UTF-8");
            StringBuffer stringBuffer2 = new StringBuffer(string2);
            stringBuffer2.append(string3);
            stringBuffer2.append(string4);
            stringBuffer2.append(string5);
            boolean bl = CryptoEngine.getHandle().verifySignature(this._sAuthsp, stringBuffer2.toString(), string6);
            if (!bl) {
                this._systemLogger.log(Level.WARNING, "DBAuthSPHandler", string, "invalid signature in response from AuthSP.");
                throw new ASelectAuthSPException("000a");
            }
            Hashtable hashtable3 = this._sessionManager.getSessionContext(string2);
            if (hashtable3 == null) {
                this._systemLogger.log(Level.WARNING, "DBAuthSPHandler", string, "Incorrect AuthSP response: invalid Session (could be expired)");
                throw new ASelectAuthSPException("0102");
            }
            String string7 = (String)hashtable3.get("user_id");
            String string8 = (String)hashtable3.get("organization");
            if (string4.equalsIgnoreCase(ERROR_DB_ACCESS_DENIED)) {
                this._authenticationLogger.log(new Object[]{"DBAuthSPHandler", string7, hashtable.get("client_ip"), string8, (String)hashtable3.get("app_id"), "denied"});
                throw new ASelectAuthSPException("000b");
            }
            if (!string4.equalsIgnoreCase(ERROR_DB_OK)) {
                StringBuffer stringBuffer3 = new StringBuffer("AuthSP returned errorcode: ");
                stringBuffer3.append(string4);
                this._systemLogger.log(Level.WARNING, "DBAuthSPHandler", string, stringBuffer3.toString());
                throw new ASelectAuthSPException("0003");
            }
            this._authenticationLogger.log(new Object[]{"DBAuthSPHandler", string7, hashtable.get("client_ip"), string8, (String)hashtable3.get("app_id"), "granted"});
            hashtable2.put("rid", string2);
            hashtable2.put("result", "0000");
        }
        catch (ASelectAuthSPException aSelectAuthSPException) {
            hashtable2.put("result", aSelectAuthSPException.getMessage());
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            this._systemLogger.log(Level.SEVERE, "DBAuthSPHandler", string, "Could not decode signature", (Throwable)unsupportedEncodingException);
            hashtable2.put("result", "0003");
        }
        catch (Exception exception) {
            this._systemLogger.log(Level.SEVERE, "DBAuthSPHandler", string, "Could not verify authentication response due to internal error", (Throwable)exception);
            hashtable2.put("result", "0003");
        }
        return hashtable2;
    }
}

