/*
* Copyright (c) Stichting SURF. All rights reserved.
* 
* A-Select is a trademark registered by SURFnet bv.
* 
* This program is distributed under the A-Select license.
* See the included LICENSE file for details.
* 
* If you did not receive a copy of the LICENSE 
* please contact SURFnet bv. (http://www.surfnet.nl)
*
* This scanner is generated by JLex
*
* Copyright 1996-2003 by Elliot Joel Berk and C. Scott Ananian
*
* Permission to use, copy, modify, and distribute this software and 
* its documentation for any purpose and without fee is hereby granted, 
* provided that the above copyright notice appear in all copies and that 
* both the copyright notice and this permission notice and warranty disclaimer 
* appear in supporting documentation, and that the name of the authors or their 
* employers not be used in advertising or publicity pertaining to distribution 
* of the software without specific, written prior permission.
* 
* The authors and their employers disclaim all warranties with regard to this 
* software, including all implied warranties of merchantability and fitness. 
* In no event shall the authors or their employers be liable for any special, 
* indirect or consequential damages or any damages whatsoever resulting from 
* loss of use, data or profits, whether in an action of contract, negligence 
* or other tortious action, arising out of or in connection with the use or 
* performance of this software. 
*/
/* 
 * $Id: AuthorizationRuleScanner.java,v 1.4 2006/04/14 13:42:48 tom Exp $ 
 * 
 * Changelog:
 * $Log: AuthorizationRuleScanner.java,v $
 * Revision 1.4  2006/04/14 13:42:48  tom
 * QA: removed javadoc version tag, minor javadoc fixes
 *
 * Revision 1.3  2005/08/24 08:55:48  erwin
 * Improved error handling and Javadoc.
 *
 * 
 */
package org.aselect.agent.authorization.parsing;
import java.util.Vector;
import java.io.IOException;
/**
 * Scanner for evaluation rules.
 * <br><br>
 * <b>Description:</b><br>
 * This scanner is generated with JLex and can be used to scan authorization rules 
 * with the following syntax:
 * <br><br><code><pre>
 * AuthorizationRule		::=	Expression
 * 
 * Expression			::=	SimpleExpression {LogicExpression}
 * Expression			::=	'!' Expression { LogicExpression }
 * Expression			::=	'(' Expression ')' { LogicExpression }
 * 
 * LogicExpression		::=	'&amp;' Expression | '|' Expression
 * 
 * SimpleExpression		::=	Key { Operator Value }
 * SimpleExpression		::=	Key '=r' RegularExpression
 * SimpleExpression		::=	Key '=w' WildcardExpression
 * SimpleExpression		::=	Key 'in' ValueList
 * 
 * Key				::=	UnquotedString
 * Value				::=	String
 * Operator				::=	'&lt;' | '&lt;=' | '&gt;' | '&gt;=' | '=' | '!=' 
 * ValueList			::=	'[' Value { ',' Value } ']'
 * RegularExpression		::=	String 
 * WildcardExpression		::=	String
 * Number				::=	[0-9] { Number }
 * String				::=	UnquotedString | QuotedString
 * UnquotedString 		::=	[0-9a-zA-Z_.@*?/] { UnquotedString }
 * QuotedString			::=	'' . '' | '&quot;' . '&quot;'
 * </pre></code><br>
 * The scanner creates {@link AuthorizationRuleToken}  tokens.
 * <br><br>
 * <b>Concurrency issues:</b>
 * <br>
 * -
 * <br>
 * @author Alfa & Ariss
 * 
 */
public class AuthorizationRuleScanner {
	private final int YY_BUFFER_SIZE = 512;
	private final int YY_F = -1;
	private final int YY_NO_STATE = -1;
	private final int YY_NOT_ACCEPT = 0;
	private final int YY_START = 1;
	private final int YY_END = 2;
	private final int YY_NO_ANCHOR = 4;
	private final int YY_BOL = 65536;
	private final int YY_EOF = 65537;
 
	/** A buffer for ValueLists. */
	private Vector vBuffer;
	/** The index whitin the authorization rule. */
	private int iIndex;
	/**
     * Strip quotes from the beginning and end a <code>String</code>.
     * <br><br>
     * <b>Description:</b>
     * <br>
     * Strip the quotes from a <code>String</code>. the quotes should be located 
     * at index 0 and index <code>length() - 1</code>.
     * <br><br>
     * <b>Concurrency issues:</b>
     * <br>
     * -
     * <br><br>
     * <b>Preconditions:</b>
     * <br>
     * -
     * <br><br>
     * <b>Postconditions:</b>
     * <br>
     * -
     * <br>
     * @param s The input <code>String</code>.
     * @return The input <code>String</code> minus the quotes.
     */
	private String stripQuotes(String s)
	{
		try
		{
		 	s = s.trim();
			return s.substring(1,s.length()-1);
		}
		catch(Exception e)
		{
			return s;
		}
	}
	/**
     * Removes the final chacacter of a <code>String</code>.
     * <br><br>
     * <b>Description:</b>
     * <br>
     * Removes the character at index <code>length() - 1</code> from the string.  
     * <br><br>
     * <b>Concurrency issues:</b>
     * <br>
     * -
     * <br><br>
     * <b>Preconditions:</b>
     * <br>
     * -
     * <br><br>
     * <b>Postconditions:</b>
     * <br>
     * -
     * <br>
     * @param s The input <code>String</code>.
     * @return The input <code>String</code> minus the last character.
     */
	private String stripFinalChar(String s)
	{
		try
		{
			return s.substring(0, s.length()-1);
		}
		catch(Exception e)
		{
			return s;
		}
	}
	private java.io.BufferedReader yy_reader;
	private int yy_buffer_index;
	private int yy_buffer_read;
	private int yy_buffer_start;
	private int yy_buffer_end;
	private char yy_buffer[];
	private int yychar;
	private boolean yy_at_bol;
	private int yy_lexical_state;

	public AuthorizationRuleScanner (java.io.Reader reader) {
		this ();
		if (null == reader) {
			throw (new Error("Error: Bad input stream initializer."));
		}
		yy_reader = new java.io.BufferedReader(reader);
	}

	public AuthorizationRuleScanner (java.io.InputStream instream) {
		this ();
		if (null == instream) {
			throw (new Error("Error: Bad input stream initializer."));
		}
		yy_reader = new java.io.BufferedReader(new java.io.InputStreamReader(instream));
	}

	private AuthorizationRuleScanner () {
		yy_buffer = new char[YY_BUFFER_SIZE];
		yy_buffer_read = 0;
		yy_buffer_index = 0;
		yy_buffer_start = 0;
		yy_buffer_end = 0;
		yychar = 0;
		yy_at_bol = true;
		yy_lexical_state = YYINITIAL;
	}

	private boolean yy_eof_done = false;
	private final int LIST = 1;
	private final int YYINITIAL = 0;
	private final int yy_state_dtrans[] = {
		0,
		43
	};
	private void yybegin (int state) {
		yy_lexical_state = state;
	}
	private int yy_advance ()
		throws java.io.IOException {
		int next_read;
		int i;
		int j;

		if (yy_buffer_index < yy_buffer_read) {
			return yy_buffer[yy_buffer_index++];
		}

		if (0 != yy_buffer_start) {
			i = yy_buffer_start;
			j = 0;
			while (i < yy_buffer_read) {
				yy_buffer[j] = yy_buffer[i];
				++i;
				++j;
			}
			yy_buffer_end = yy_buffer_end - yy_buffer_start;
			yy_buffer_start = 0;
			yy_buffer_read = j;
			yy_buffer_index = j;
			next_read = yy_reader.read(yy_buffer,
					yy_buffer_read,
					yy_buffer.length - yy_buffer_read);
			if (-1 == next_read) {
				return YY_EOF;
			}
			yy_buffer_read = yy_buffer_read + next_read;
		}

		while (yy_buffer_index >= yy_buffer_read) {
			if (yy_buffer_index >= yy_buffer.length) {
				yy_buffer = yy_double(yy_buffer);
			}
			next_read = yy_reader.read(yy_buffer,
					yy_buffer_read,
					yy_buffer.length - yy_buffer_read);
			if (-1 == next_read) {
				return YY_EOF;
			}
			yy_buffer_read = yy_buffer_read + next_read;
		}
		return yy_buffer[yy_buffer_index++];
	}
	private void yy_move_end () {
		if (yy_buffer_end > yy_buffer_start &&
		    '\n' == yy_buffer[yy_buffer_end-1])
			yy_buffer_end--;
		if (yy_buffer_end > yy_buffer_start &&
		    '\r' == yy_buffer[yy_buffer_end-1])
			yy_buffer_end--;
	}
	private boolean yy_last_was_cr=false;
	private void yy_mark_start () {
		yychar = yychar
			+ yy_buffer_index - yy_buffer_start;
		yy_buffer_start = yy_buffer_index;
	}
	private void yy_mark_end () {
		yy_buffer_end = yy_buffer_index;
	}
	private void yy_to_mark () {
		yy_buffer_index = yy_buffer_end;
		yy_at_bol = (yy_buffer_end > yy_buffer_start) &&
		            ('\r' == yy_buffer[yy_buffer_end-1] ||
		             '\n' == yy_buffer[yy_buffer_end-1] ||
		             2028/*LS*/ == yy_buffer[yy_buffer_end-1] ||
		             2029/*PS*/ == yy_buffer[yy_buffer_end-1]);
	}
	private java.lang.String yytext () {
		return (new java.lang.String(yy_buffer,
			yy_buffer_start,
			yy_buffer_end - yy_buffer_start));
	}
	private int yylength () {
		return yy_buffer_end - yy_buffer_start;
	}
	private char[] yy_double (char buf[]) {
		int i;
		char newbuf[];
		newbuf = new char[2*buf.length];
		for (i = 0; i < buf.length; ++i) {
			newbuf[i] = buf[i];
		}
		return newbuf;
	}
	private final int YY_E_INTERNAL = 0;
	private final int YY_E_MATCH = 1;
	private java.lang.String yy_error_string[] = {
		"Error: Internal error.\n",
		"Error: Unmatched input.\n"
	};
	private void yy_error (int code,boolean fatal) {
		java.lang.System.out.print(yy_error_string[code]);
		java.lang.System.out.flush();
		if (fatal) {
			throw new Error("Fatal Error.\n");
		}
	}
	private int[][] unpackFromString(int size1, int size2, String st) {
		int colonIndex = -1;
		String lengthString;
		int sequenceLength = 0;
		int sequenceInteger = 0;

		int commaIndex;
		String workString;

		int res[][] = new int[size1][size2];
		for (int i= 0; i < size1; i++) {
			for (int j= 0; j < size2; j++) {
				if (sequenceLength != 0) {
					res[i][j] = sequenceInteger;
					sequenceLength--;
					continue;
				}
				commaIndex = st.indexOf(',');
				workString = (commaIndex==-1) ? st :
					st.substring(0, commaIndex);
				st = st.substring(commaIndex+1);
				colonIndex = workString.indexOf(':');
				if (colonIndex == -1) {
					res[i][j]=Integer.parseInt(workString);
					continue;
				}
				lengthString =
					workString.substring(colonIndex+1);
				sequenceLength=Integer.parseInt(lengthString);
				workString=workString.substring(0,colonIndex);
				sequenceInteger=Integer.parseInt(workString);
				res[i][j] = sequenceInteger;
				sequenceLength--;
			}
		}
		return res;
	}
	private int yy_acpt[] = {
		/* 0 */ YY_NOT_ACCEPT,
		/* 1 */ YY_NO_ANCHOR,
		/* 2 */ YY_NO_ANCHOR,
		/* 3 */ YY_NO_ANCHOR,
		/* 4 */ YY_NO_ANCHOR,
		/* 5 */ YY_NO_ANCHOR,
		/* 6 */ YY_NO_ANCHOR,
		/* 7 */ YY_NO_ANCHOR,
		/* 8 */ YY_NO_ANCHOR,
		/* 9 */ YY_NO_ANCHOR,
		/* 10 */ YY_NO_ANCHOR,
		/* 11 */ YY_NO_ANCHOR,
		/* 12 */ YY_NO_ANCHOR,
		/* 13 */ YY_NO_ANCHOR,
		/* 14 */ YY_NO_ANCHOR,
		/* 15 */ YY_NO_ANCHOR,
		/* 16 */ YY_NO_ANCHOR,
		/* 17 */ YY_NO_ANCHOR,
		/* 18 */ YY_NO_ANCHOR,
		/* 19 */ YY_NO_ANCHOR,
		/* 20 */ YY_NO_ANCHOR,
		/* 21 */ YY_NO_ANCHOR,
		/* 22 */ YY_NO_ANCHOR,
		/* 23 */ YY_NO_ANCHOR,
		/* 24 */ YY_NO_ANCHOR,
		/* 25 */ YY_NO_ANCHOR,
		/* 26 */ YY_NO_ANCHOR,
		/* 27 */ YY_NO_ANCHOR,
		/* 28 */ YY_NO_ANCHOR,
		/* 29 */ YY_NO_ANCHOR,
		/* 30 */ YY_NOT_ACCEPT,
		/* 31 */ YY_NO_ANCHOR,
		/* 32 */ YY_NO_ANCHOR,
		/* 33 */ YY_NO_ANCHOR,
		/* 34 */ YY_NO_ANCHOR,
		/* 35 */ YY_NO_ANCHOR,
		/* 36 */ YY_NO_ANCHOR,
		/* 37 */ YY_NO_ANCHOR,
		/* 38 */ YY_NOT_ACCEPT,
		/* 39 */ YY_NO_ANCHOR,
		/* 40 */ YY_NO_ANCHOR,
		/* 41 */ YY_NOT_ACCEPT,
		/* 42 */ YY_NO_ANCHOR,
		/* 43 */ YY_NOT_ACCEPT,
		/* 44 */ YY_NO_ANCHOR,
		/* 45 */ YY_NOT_ACCEPT,
		/* 46 */ YY_NO_ANCHOR,
		/* 47 */ YY_NOT_ACCEPT,
		/* 48 */ YY_NO_ANCHOR,
		/* 49 */ YY_NOT_ACCEPT,
		/* 50 */ YY_NO_ANCHOR,
		/* 51 */ YY_NOT_ACCEPT,
		/* 52 */ YY_NO_ANCHOR,
		/* 53 */ YY_NOT_ACCEPT,
		/* 54 */ YY_NO_ANCHOR,
		/* 55 */ YY_NOT_ACCEPT,
		/* 56 */ YY_NOT_ACCEPT,
		/* 57 */ YY_NOT_ACCEPT,
		/* 58 */ YY_NOT_ACCEPT,
		/* 59 */ YY_NO_ANCHOR,
		/* 60 */ YY_NO_ANCHOR,
		/* 61 */ YY_NOT_ACCEPT,
		/* 62 */ YY_NOT_ACCEPT
	};
	private int yy_cmap[] = unpackFromString(1,65538,
"3:10,4,3:2,4,3:18,1,12,2,3:3,17,6,19,20,7,3,5,3,7:12,3:2,9,10,11,7:28,21,3," +
"8,3,7,3,7:8,13,7:4,14,7:3,15,7:4,16,7:3,3,18,3:65411,0:2")[0];

	private int yy_rmap[] = unpackFromString(1,63,
"0,1,2,3,4,5,6,7,8,1:4,9,1:5,4,1:3,10,1:6,11,10,1,12,13,14,15,16,17,13,1,9,1" +
"3,18,5,19,6,20,7,21,8,22,23,24,9,25,14,26,15,27,28,26,29")[0];

	private int yy_nxt[][] = unpackFromString(30,22,
"1,2,3,32,-1,32,59,4,32,5,6,7,8,33,4:3,9,10,11,12,13,-1:23,2,-1:21,30:3,-1,3" +
"0:17,-1:7,4,-1:5,4:4,-1:15,14,-1:26,15,16,-1:15,17,-1:21,18,-1:12,41,-1:6,2" +
"0,-1:14,31,45,-1:3,62,47,-1:5,47:4,-1:6,30,21,30:19,-1:7,4,-1:5,4,19,4:2,-1" +
":6,53,-1:3,24,-1,39,25,-1:4,39:4,-1:6,56,-1:3,26,-1:2,27,-1:14,58,-1:3,28,-" +
"1:2,29,-1:14,49:3,-1,49:17,-1,38:5,22,38:15,1,23,37,40,-1,40,60,42,40,44,46" +
",48,50,52,42:3,40:4,54,-1,55:3,-1,55:17,-1,53,-1:3,24,-1,47,25,-1:4,47:4,-1" +
":6,49,35,49:19,-1,51:5,36,51:15,-1,53,-1:3,24,-1,39,25,-1:4,39,34,39:2,-1:6" +
",53,-1:3,24,-1:2,25,-1:14,55,56,55:19,-1,57:5,58,57:15,-1,38:3,-1,38:17,-1," +
"51:3,-1,51:17,-1,61:3,-1,61:17");

	public AuthorizationRuleToken scan ()
		throws java.io.IOException {
		int yy_lookahead;
		int yy_anchor = YY_NO_ANCHOR;
		int yy_state = yy_state_dtrans[yy_lexical_state];
		int yy_next_state = YY_NO_STATE;
		int yy_last_accept_state = YY_NO_STATE;
		boolean yy_initial = true;
		int yy_this_accept;

		yy_mark_start();
		yy_this_accept = yy_acpt[yy_state];
		if (YY_NOT_ACCEPT != yy_this_accept) {
			yy_last_accept_state = yy_state;
			yy_mark_end();
		}
		while (true) {
			if (yy_initial && yy_at_bol) yy_lookahead = YY_BOL;
			else yy_lookahead = yy_advance();
			yy_next_state = YY_F;
			yy_next_state = yy_nxt[yy_rmap[yy_state]][yy_cmap[yy_lookahead]];
			if (YY_EOF == yy_lookahead && true == yy_initial) {
				return null;
			}
			if (YY_F != yy_next_state) {
				yy_state = yy_next_state;
				yy_initial = false;
				yy_this_accept = yy_acpt[yy_state];
				if (YY_NOT_ACCEPT != yy_this_accept) {
					yy_last_accept_state = yy_state;
					yy_mark_end();
				}
			}
			else {
				if (YY_NO_STATE == yy_last_accept_state) {
					throw (new Error("Lexical Error: Unmatched Input."));
				}
				else {
					yy_anchor = yy_acpt[yy_last_accept_state];
					if (0 != (YY_END & yy_anchor)) {
						yy_move_end();
					}
					yy_to_mark();
					switch (yy_last_accept_state) {
					case 1:
						
					case -2:
						break;
					case 2:
						{ iIndex++; /* ignore whitespace*/ }
					case -3:
						break;
					case 3:
						{ 
	StringBuffer sbError = new StringBuffer("Unexpected character near index ");
	sbError.append(iIndex+yychar).append(": '");
	sbError.append(yytext()).append("'");
	throw new IOException(sbError.toString()); 
}
					case -4:
						break;
					case 4:
						{ 
	return new AuthorizationRuleToken(AuthorizationRuleToken.DATA_GROUP,
							          AuthorizationRuleToken.UNQUOTED_STRING, 
							          yytext()); 
}
					case -5:
						break;
					case 5:
						{ 
	return new AuthorizationRuleToken(AuthorizationRuleToken.OPERATOR_GROUP,
							          AuthorizationRuleToken.LESS_THEN, 
							          "<");
}
					case -6:
						break;
					case 6:
						{ 
	return new AuthorizationRuleToken(AuthorizationRuleToken.OPERATOR_GROUP,
							          AuthorizationRuleToken.EQUAL_TO, 
							          "=");
}
					case -7:
						break;
					case 7:
						{ 
	return new AuthorizationRuleToken(AuthorizationRuleToken.OPERATOR_GROUP,
							          AuthorizationRuleToken.GREATER_THEN, 
							          ">");
}
					case -8:
						break;
					case 8:
						{ 
	return new AuthorizationRuleToken(AuthorizationRuleToken.LOGIC_OPERATOR_GROUP,
							          AuthorizationRuleToken.NOT, 
							          "!");
}
					case -9:
						break;
					case 9:
						{ 
	return new AuthorizationRuleToken(AuthorizationRuleToken.LOGIC_OPERATOR_GROUP,
							          AuthorizationRuleToken.AND, 
							          "&");
}
					case -10:
						break;
					case 10:
						{ 
	return new AuthorizationRuleToken(AuthorizationRuleToken.LOGIC_OPERATOR_GROUP,
							          AuthorizationRuleToken.OR, 
							          "|");
}
					case -11:
						break;
					case 11:
						{ 
	return new AuthorizationRuleToken(AuthorizationRuleToken.LOGIC_OPERATOR_GROUP,
							          AuthorizationRuleToken.GROUP_START, 
							          "(");
}
					case -12:
						break;
					case 12:
						{ 
	return new AuthorizationRuleToken(AuthorizationRuleToken.LOGIC_OPERATOR_GROUP,
							          AuthorizationRuleToken.GROUP_END, 
							          ")");
}
					case -13:
						break;
					case 13:
						{ 
	/* not empty list */
	yybegin(LIST); 
	vBuffer = new Vector(); 
}
					case -14:
						break;
					case 14:
						{ 
	return new AuthorizationRuleToken(AuthorizationRuleToken.OPERATOR_GROUP,
							          AuthorizationRuleToken.LESS_THEN_OR_EQUAL_TO, 
							          "<=");
}
					case -15:
						break;
					case 15:
						{ 
	return new AuthorizationRuleToken(AuthorizationRuleToken.OPERATOR_GROUP,
							          AuthorizationRuleToken.MATCH_REGULAR_EXPRESSION, 
							          "=r");
}
					case -16:
						break;
					case 16:
						{ 
	return new AuthorizationRuleToken(AuthorizationRuleToken.OPERATOR_GROUP,
							          AuthorizationRuleToken.MATCH_WILDCARD_EXPRESSION, 
							          "=w");
}
					case -17:
						break;
					case 17:
						{ 
	return new AuthorizationRuleToken(AuthorizationRuleToken.OPERATOR_GROUP,
							          AuthorizationRuleToken.GREATER_THEN_OR_EQUAL_TO, 
							          ">=");
}
					case -18:
						break;
					case 18:
						{ 
	return new AuthorizationRuleToken(AuthorizationRuleToken.OPERATOR_GROUP,
							          AuthorizationRuleToken.NOT_EQUAL_TO, 
							          "!=");
}
					case -19:
						break;
					case 19:
						{ 
	return new AuthorizationRuleToken(AuthorizationRuleToken.OPERATOR_GROUP,
							          AuthorizationRuleToken.IN, 
							          "in");
}
					case -20:
						break;
					case 20:
						{ 
	/* empty list */
	return new AuthorizationRuleToken(
		AuthorizationRuleToken.DATA_GROUP,
		AuthorizationRuleToken.LIST, 
		new Vector()); 
}
					case -21:
						break;
					case 21:
						{ 
	return new AuthorizationRuleToken(AuthorizationRuleToken.DATA_GROUP,
							          AuthorizationRuleToken.QUOTED_STRING, 
							          stripQuotes(yytext())); 
}
					case -22:
						break;
					case 22:
						{ 
	return new AuthorizationRuleToken(AuthorizationRuleToken.DATA_GROUP,
							          AuthorizationRuleToken.SINGLE_QUOTED_STRING, 
							          stripQuotes(yytext()));  
}
					case -23:
						break;
					case 23:
						{ 
	StringBuffer sbError = new StringBuffer("Unexpected character near index ");
	sbError.append(iIndex+yychar).append(": '");
	sbError.append(yytext()).append("'");
	throw new IOException(sbError.toString());
}
					case -24:
						break;
					case 24:
						{ 
	vBuffer.add(stripFinalChar(yytext()).trim()); 
}
					case -25:
						break;
					case 25:
						{ 
	vBuffer.add(stripFinalChar(yytext()).trim()); 
	yybegin(YYINITIAL); 
	return new AuthorizationRuleToken(AuthorizationRuleToken.DATA_GROUP,
							          AuthorizationRuleToken.LIST, 
							          vBuffer); 
}
					case -26:
						break;
					case 26:
						{ 
	vBuffer.add(stripQuotes(stripFinalChar(yytext()))); 
}
					case -27:
						break;
					case 27:
						{ 
	vBuffer.add(stripQuotes(stripFinalChar(yytext()))); 
	yybegin(YYINITIAL); 
	return new AuthorizationRuleToken(AuthorizationRuleToken.DATA_GROUP,
							          AuthorizationRuleToken.LIST, 
							          vBuffer); 
}
					case -28:
						break;
					case 28:
						{ 
	vBuffer.add(stripQuotes(stripFinalChar(yytext())));  
}
					case -29:
						break;
					case 29:
						{ 
	vBuffer.add(stripQuotes(stripFinalChar(yytext()))); 
	yybegin(YYINITIAL); 
	return new AuthorizationRuleToken(AuthorizationRuleToken.DATA_GROUP,
							          AuthorizationRuleToken.LIST, 
							          vBuffer); 
}
					case -30:
						break;
					case 31:
						{ iIndex++; /* ignore whitespace*/ }
					case -31:
						break;
					case 32:
						{ 
	StringBuffer sbError = new StringBuffer("Unexpected character near index ");
	sbError.append(iIndex+yychar).append(": '");
	sbError.append(yytext()).append("'");
	throw new IOException(sbError.toString()); 
}
					case -32:
						break;
					case 33:
						{ 
	return new AuthorizationRuleToken(AuthorizationRuleToken.DATA_GROUP,
							          AuthorizationRuleToken.UNQUOTED_STRING, 
							          yytext()); 
}
					case -33:
						break;
					case 34:
						{ 
	return new AuthorizationRuleToken(AuthorizationRuleToken.OPERATOR_GROUP,
							          AuthorizationRuleToken.IN, 
							          "in");
}
					case -34:
						break;
					case 35:
						{ 
	return new AuthorizationRuleToken(AuthorizationRuleToken.DATA_GROUP,
							          AuthorizationRuleToken.QUOTED_STRING, 
							          stripQuotes(yytext())); 
}
					case -35:
						break;
					case 36:
						{ 
	return new AuthorizationRuleToken(AuthorizationRuleToken.DATA_GROUP,
							          AuthorizationRuleToken.SINGLE_QUOTED_STRING, 
							          stripQuotes(yytext()));  
}
					case -36:
						break;
					case 37:
						{ 
	StringBuffer sbError = new StringBuffer("Unexpected character near index ");
	sbError.append(iIndex+yychar).append(": '");
	sbError.append(yytext()).append("'");
	throw new IOException(sbError.toString());
}
					case -37:
						break;
					case 39:
						{ 
	return new AuthorizationRuleToken(AuthorizationRuleToken.DATA_GROUP,
							          AuthorizationRuleToken.UNQUOTED_STRING, 
							          yytext()); 
}
					case -38:
						break;
					case 40:
						{ 
	StringBuffer sbError = new StringBuffer("Unexpected character near index ");
	sbError.append(iIndex+yychar).append(": '");
	sbError.append(yytext()).append("'");
	throw new IOException(sbError.toString());
}
					case -39:
						break;
					case 42:
						{ 
	StringBuffer sbError = new StringBuffer("Unexpected character near index ");
	sbError.append(iIndex+yychar).append(": '");
	sbError.append(yytext()).append("'");
	throw new IOException(sbError.toString());
}
					case -40:
						break;
					case 44:
						{ 
	StringBuffer sbError = new StringBuffer("Unexpected character near index ");
	sbError.append(iIndex+yychar).append(": '");
	sbError.append(yytext()).append("'");
	throw new IOException(sbError.toString());
}
					case -41:
						break;
					case 46:
						{ 
	StringBuffer sbError = new StringBuffer("Unexpected character near index ");
	sbError.append(iIndex+yychar).append(": '");
	sbError.append(yytext()).append("'");
	throw new IOException(sbError.toString());
}
					case -42:
						break;
					case 48:
						{ 
	StringBuffer sbError = new StringBuffer("Unexpected character near index ");
	sbError.append(iIndex+yychar).append(": '");
	sbError.append(yytext()).append("'");
	throw new IOException(sbError.toString());
}
					case -43:
						break;
					case 50:
						{ 
	StringBuffer sbError = new StringBuffer("Unexpected character near index ");
	sbError.append(iIndex+yychar).append(": '");
	sbError.append(yytext()).append("'");
	throw new IOException(sbError.toString());
}
					case -44:
						break;
					case 52:
						{ 
	StringBuffer sbError = new StringBuffer("Unexpected character near index ");
	sbError.append(iIndex+yychar).append(": '");
	sbError.append(yytext()).append("'");
	throw new IOException(sbError.toString());
}
					case -45:
						break;
					case 54:
						{ 
	StringBuffer sbError = new StringBuffer("Unexpected character near index ");
	sbError.append(iIndex+yychar).append(": '");
	sbError.append(yytext()).append("'");
	throw new IOException(sbError.toString());
}
					case -46:
						break;
					case 59:
						{ 
	StringBuffer sbError = new StringBuffer("Unexpected character near index ");
	sbError.append(iIndex+yychar).append(": '");
	sbError.append(yytext()).append("'");
	throw new IOException(sbError.toString()); 
}
					case -47:
						break;
					case 60:
						{ 
	StringBuffer sbError = new StringBuffer("Unexpected character near index ");
	sbError.append(iIndex+yychar).append(": '");
	sbError.append(yytext()).append("'");
	throw new IOException(sbError.toString());
}
					case -48:
						break;
					default:
						yy_error(YY_E_INTERNAL,false);
					case -1:
					}
					yy_initial = true;
					yy_state = yy_state_dtrans[yy_lexical_state];
					yy_next_state = YY_NO_STATE;
					yy_last_accept_state = YY_NO_STATE;
					yy_mark_start();
					yy_this_accept = yy_acpt[yy_state];
					if (YY_NOT_ACCEPT != yy_this_accept) {
						yy_last_accept_state = yy_state;
						yy_mark_end();
					}
				}
			}
		}
	}
}
