/*
 * Copyright (c) Stichting SURF. All rights reserved.
 * 
 * A-Select is a trademark registered by SURFnet bv.
 * 
 * This program is distributed under the A-Select license.
 * See the included LICENSE file for details.
 * 
 * If you did not receive a copy of the LICENSE 
 * please contact SURFnet bv. (http://www.surfnet.nl)
 */
package org.aselect.server.processor;

import java.util.Hashtable;

import javax.servlet.http.HttpServletResponse;

import org.aselect.server.config.ASelectConfigManager;
import org.aselect.system.exception.ASelectException;

/**
 * Interface for a processor.
 * <br><br>
 * <b>Description:</b><br>
 * A processor will process a request and can choose to perform an action based 
 * on the supplied information and the location. 
 * <br><br>
 * <b>Concurrency issues:</b> <br> - <br>
 * @author Alfa & Ariss
 */
public interface IProcessor
{
	
	/** 
	 * Initializes the processor component.
	 * <br><br>
	 * <b>Description:</b>
	 * <br>
	 * Reads the specific configuration.
	 * <br><br>
	 * <b>Concurrency issues:</b> <br> - <br>
	 * <br>
	 * <b>Preconditions:</b> <br> - <br>
	 * <br>
	 * <b>Postconditions:</b> <br> - <br>
	 * @param configManager the A-Select configuration manager.
	 * @param config the specific configuration for the processor.
	 * @throws ASelectException if the configuration is invalid.
	 */
	public void init(ASelectConfigManager configManager, Object config) throws ASelectException;

	
	/**
	 * Removes the processor from memory.
	 * <br><br>
	 * <b>Description:</b>
	 * <br>
	 * Removes if needed the class variables from memory.
	 * <br><br>
	 * <b>Concurrency issues:</b> <br> - <br>
	 * <br>
	 * <b>Preconditions:</b> <br> - <br>
	 * <br>
	 * <b>Postconditions:</b> <br> - <br>
	 */
	public void destroy();
	
	/**
	 * Processes the request.
	 * <br><br>
	 * <b>Description:</b>
	 * <br>
	 * Will process the request with the supplied information.<br>
	 * If the method returns TRUE then the process must proceed as normal. 
	 * <br><br>
	 * <b>Concurrency issues:</b> <br> - <br>
	 * <br>
	 * <b>Preconditions:</b> <br> - <br>
	 * <br>
	 * <b>Postconditions:</b> <br> - <br>
	 * @param servletResponse response object
	 * @param sRid the A-Select request id
	 * @param serviceRequest the service request parameters
	 * @param additional location dependent information
	 * @return boolean FALSE if the processor has send the response to the user.
	 * @throws ASelectException if an runtime error occurs during process.
	 */
	public boolean process(HttpServletResponse servletResponse, 
	    String sRid, Hashtable serviceRequest, Hashtable additional) 
	    throws ASelectException;
	
}
