/*****************************************************************************

	boushi.h - header file for the libboushi shared library

	Copyright (c) 2009-2010  Wessel Dankers <wsl@fruit.je>

	This file is part of boushi.

	boushi is free software: you can redistribute it and/or modify
	it under the terms of the GNU Lesser General Public License as
	published by the Free Software Foundation, either version 3 of
	the License, or (at your option) any later version.

	boushi is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU Lesser General Public License for more details.

	You should have received a copy of the GNU General Public License
	and a copy of the GNU Lesser General Public License along with
	boushi.  If not, see <http://www.gnu.org/licenses/>.

*****************************************************************************/

#ifndef LIBBOUSHI_H
#define LIBBOUSHI_H

#include <stdbool.h>
#include <sys/types.h>

typedef struct boushi boushi_t;
typedef struct boushi_cursor boushi_cursor_t;

extern size_t boushi_size(void);
extern bool boushi_init(struct boushi *, const char *dbdir);
extern bool boushi_exit(struct boushi *);
extern int boushi_errno(struct boushi *);
extern const char *boushi_error(struct boushi *);

extern bool boushi_get(boushi_t *, const char *name, void **buf, size_t *len);
extern bool boushi_put(boushi_t *, const char *name, const void *buf, size_t len);
extern bool boushi_del(boushi_t *, const char *name, bool *found);
extern bool boushi_has(boushi_t *, const char *name, bool *found);

extern size_t boushi_cursor_size(void);
extern bool boushi_cursor_init(boushi_t *, boushi_cursor_t *, const char *, bool);
extern bool boushi_cursor_next(boushi_cursor_t *, char **name);
extern bool boushi_cursor_exit(boushi_cursor_t *);

#endif
