/*****************************************************************************

	io.c - source code for libboushi and the boushi command line tool

	Copyright (c) 2010  Wessel Dankers <wsl@fruit.je>

	This file is part of boushi.

	boushi is free software: you can redistribute it and/or modify
	it under the terms of the GNU Lesser General Public License as
	published by the Free Software Foundation, either version 3 of
	the License, or (at your option) any later version.

	boushi is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU Lesser General Public License for more details.

	You should have received a copy of the GNU General Public License
	and a copy of the GNU Lesser General Public License along with
	boushi.  If not, see <http://www.gnu.org/licenses/>.

*****************************************************************************/

#include "config.h"
#include "io.h"

#include <poll.h>
#include <unistd.h>
#include <errno.h>
#include <stdio.h>

bool safewrite(int fd, const char *data, size_t size) {
	ssize_t r;
	struct pollfd p = {fd, POLLOUT|POLLERR|POLLHUP|POLLNVAL, 0};

	while(size) {
		r = write(fd, data, size);
		if(r == -1) {
			switch(errno) {
				default:
					perror("write()");
					return false;
				case EAGAIN:
					poll(&p, 1, -1);
					break;
				case EINTR:
					break;
			}
		} else if(r == 0) {
			/* huh? */
			return false;
		} else {
			size -= r;
			data += r;
		}
	}
	return true;
}
