import urllib
from glob import glob
from lxml.etree import parse, tostring, XSLT
from os import chdir, getcwd, mkdir
from os.path import join, basename
from shutil import rmtree

class ConfigMaker:
    def __init__(self, config):
        self.config = config
        self.xslt = self.config.get('main', 'xslt')
        self.configDirectory = self.config.get('harvester', 'configDirectory')
        self.harvesterDirectory = self.config.get('harvester', 'harvesterDirectory')
        self.domain = self.config.get('harvester', 'domain')
        self.target_id = self.config.get("target", "id")
        self.target_port = self.config.get("target", "port")

        self.BEGIN_DOMAIN = """<?xml version="1.0" encoding="UTF-8"?>
<domain>
  <id>%(domain)s</id>
  <mappingId>default</mappingId>
  <targetId>%(target_id)s</targetId>""" %{'domain':self.domain, 'target_id':self.target_id}

    def makeEoRepoFiles(self):
        baseURL = self.config.get('eo admin module', 'baseURL')
        # FIXME configuratie
        NOT = self.config.get("main", "not") 
        # NOT = ('Warwick-uk', 'columbia-university-us', 'ucl-ac-uk', 'www-sciences-po-fr')
        ns = {'nereus':"http://www.nereus4economics.info/"}
        xslt_tree = parse(join(self.xslt, "admin2config.xsl"))
        transform = XSLT(xslt_tree)
        try:
            rmtree(self.configDirectory)
        except OSError:
            pass
        mkdir(self.configDirectory)

        self.targetFile()

        domainFile = self.configFile(self.domain + ".domain")
        domainFile.write(self.BEGIN_DOMAIN)

        partnerslist = parse(baseURL + "?request=listPartners")

        partners = partnerslist.xpath("/nereus:partners/nereus:partner", namespaces=ns)
        for partner in partners:
            id = partner.xpath("@id", namespaces=ns)[0]
            status = partner.xpath('properties/entry[@key="neeo.partner.status"]/text()')[0]
            if status == "new" or status == "valid" or id in NOT: continue
            refreshClear = partner.xpath('properties/entry[@key="neeo.partner.refresh-clear"]/text()')
            if not refreshClear: refreshClear = "false"
            else: refreshClear = refreshClear[0]
            if status == "inactive" and refreshClear == "false": continue
            domainFile.write("  <repositoryGroupId>" + id + "</repositoryGroupId>\n")
            adminfileUrl = baseURL + "?request=getPartner&partnerId=" + id
            tree = parse(adminfileUrl)
            qdomain = "\'" + self.domain + "\'"
            qtarget_id = "\'" + self.target_id + "\'"
            config = transform(tree, domain=qdomain, target_id=qtarget_id)
            files = config.xpath('/configfiles/file')
            for file in files:
                xml = tostring(file[0], xml_declaration=True, encoding='UTF-8', pretty_print=True)
                self.writeFile(file.xpath("@name")[0], xml)

        existing = map(basename, glob(join(self.harvesterDirectory, self.domain+".*.repository")))
        new = map(basename, glob(join(self.configDirectory, self.domain+".*.repository")))
        oldRepos = set(existing) - set(new)
        if oldRepos:
            domainFile.write("  <repositoryGroupId>old-repositories</repositoryGroupId>\n")
            groupFile = self.configFile(self.domain + ".old-repositories.repositoryGroup")
            groupFile.write("""<?xml version='1.0' encoding='UTF-8'?>
<repositoryGroup>
  <id>old-repositories</id>
  <name xml:lang="nl">Oude repositories</name>
  <name xml:lang="en">Old repositories</name>
""")
            for repo in oldRepos:
                repoId = repo.split('.', 2)[1]
                groupFile.write("  <repositoryId>" + repoId + "</repositoryId>\n")
                self.writeFile(repo, """<?xml version='1.0' encoding='UTF-8'?>
<repository>
  <id>%s</id>
  <repositoryGroupId>old-repositories</repositoryGroupId>
  <use/>
  <action>clear</action>
  <collection>eo-repo</collection>
  <targetId>eo</targetId>
</repository>""" %repoId)
            groupFile.write("</repositoryGroup>\n")
            groupFile.close()

        domainFile.write("</domain>\n")
        domainFile.close()
        if oldRepos: return oldRepos
        else: return [] 

    def makeRepecFiles(self):
        try:
            rmtree(self.configDirectory)
        except OSError:
            pass
        mkdir(self.configDirectory)

        self.targetFile()

        domainFile = self.configFile(self.domain + ".domain")
        domainFile.write(self.BEGIN_DOMAIN)

        s = """ <repositoryGroupId>repec-org</repositoryGroupId>
</domain>
"""
        domainFile.write(s)

        groupFile = self.configFile("repec.repec-org.repositoryGroup")
        s = '<?xml version="1.0" encoding="UTF-8"?>\n<repositoryGroup>' + \
        "\n <id>repec-org</id>" + \
        "\n <name xml:lang=\"nl\">RePEc</name>" + \
        "\n <name xml:lang=\"en\">RePEc</name>"
        groupFile.write(s)

        seriesURL = self.config.get("repec-gateway", "series")
        seriess = urllib.urlopen(seriesURL)
        count = 0
        NOT = tuple(self.config.get("repec", "NOT").split())
        for series in seriess:
            cont = False
            for n in NOT:
                if series.startswith(n):
                    cont = True
                    break
            if cont: continue
            if series.endswith('\n'): series = series[:-1]
            repo = series.replace(':', '-')
            s = "\n <repositoryId>" + repo + "</repositoryId>"
            groupFile.write(s)
            self.repoFile("", repo, "true", "")
            count = count + 1
            print count

        existing = map(basename, glob(join(self.harvesterDirectory, "repec.*.repository")))
        new = map(basename, glob(join(self.configDirectory, "repec.*.repository")))
        oldRepos = set(existing) - set(new)
        for repo in oldRepos:
            repoId = repo.split('.', 2)[1]
            groupFile.write("\n <repositoryId>" + repoId + "</repositoryId>")
            #f = join(self.harvesterDirectory, f).split(".")
            #repo = f[1]
            #s = "\n <repositoryId>" + repoId + "</repositoryId>"
            #groupFile.write(s)
            self.repoFile("", repoId, "", "clear")
            count = count + 1
            print count

        groupFile.write("\n</repositoryGroup>\n")
        groupFile.close()
        if oldRepos: return oldRepos
        else: return []

    def configFile(self, name):
        return open(join(self.configDirectory, name), "w")
    
    def writeFile(self, name, data):
        f = self.configFile(name)
        f.write(data)
        f.write("\n")
        f.close()

    def targetFile(self):
        data = """<?xml version="1.0"?>
<target>
  <id>%(target_id)s</id>
  <name>localhost</name>
  <username></username>
  <port>%(target_port)s</port>
  <targetType>sruUpdate</targetType>
  <path>/update</path>
  <baseurl>localhost</baseurl>
</target>""" %{'target_id':self.target_id, 'target_port': self.target_port}
        self.writeFile(self.target_id + ".target", data)

    def repoFile(self, dir, repo, use, action):
        ### only for repec ###
        baseurl = self.config.get("repec-gateway", "baseurl")
        fileName = dir + "repec." + repo + ".repository"
        s = '<?xml version="1.0"?>\n<repository>' + \
        "\n <id>" + repo + "</id>" + \
        "\n <repositoryGroupId>repec-org</repositoryGroupId>" + \
        "\n <use>" + use + "</use>" + \
        "\n <action>" + action + "</action>" + \
        "\n <complete>true</complete>" + \
        "\n <baseurl>" + baseurl + repo.replace('-', ':') + "/</baseurl>" + \
        "\n <set></set>" + \
        "\n <collection>repec</collection>" + \
        "\n <targetId>" + self.target_id + "</targetId>" + \
        "\n <metadataPrefix>mods</metadataPrefix>" + \
        "\n <mappingId>default</mappingId>" + \
        "\n</repository>"
        self.writeFile(fileName, s)
