#! /usr/bin/perl

use strict;
use warnings FATAL => 'all';

use Test::More;

package Dingdong;

use Clarity -self;

sub ding {
	return "ding!";
}

sub noise {
	return "wat een herrie!";
}

package Boom;

package Frobozz;

use Clarity -self;

sub noise {
	return "preparing to make noise";
}

sub frog { 'ribbit' }

package Frobber;

our @EXPORT = qw(bananen);

use Frobozz -self;
use Dingdong -mixin;

field pig => 'oink';
field cow => 'moo';
weakfield bird => bless(['tweet'], 'Boom');
field frog => sub { super };

field foo => bless(\my $x, 'oink');
field bar => [undef];
field baz => qr{^};

sub noise {
	super;
	$self->{cat} = 'meow';
	return join(', ', $self->pig, $self->cow, @{$self->bird}, $self->frog, $self->cat);
}

sub bananen {
	return "krom";
}

package main;

my $f = new Frobber;

is($f->noise, "oink, moo, tweet, ribbit, meow", "noise");
is($f->bananen, "krom", "bananen");

done_testing();
