# $Id: Kiki.pm 37720 2012-08-31 10:01:10Z wsl $
# $URL: https://svn.uvt.nl/its-id/trunk/sources/kiki/lib/UvT/Kiki.pm $

use utf8;
use strict;
use warnings FATAL => 'all';

package UvT::Kiki;

use Xyzzy::Database;
use Xyzzy::ReST;
use Xyzzy::Method;

use UvT::Kiki::ACL;
use UvT::Kiki::Activator;
use UvT::Kiki::CAS;
use UvT::Kiki::Database;
use UvT::Kiki::UI::Export;
use UvT::Kiki::UI::Main;
use UvT::Kiki::UI::Static;
use UvT::Kiki::WS::Alias::Delete;
use UvT::Kiki::WS::Alias::Get;
use UvT::Kiki::WS::Alias::Post;
use UvT::Kiki::WS::Domains;
use UvT::Kiki::WS::Nonce;
use UvT::Kiki::WS::Search;

use Xyzzy -self;
use Xyzzy::Crypto::Config -mixin;
use Xyzzy::Database::Config -mixin;
use UvT::Kiki::Config -mixin;
use UvT::Kiki::ACL::Config -mixin;
use UvT::Kiki::CAS::Config -mixin;

sub handler {
	my $static = new UvT::Kiki::UI::Static(cfg => $self);
	my $postalias = new UvT::Kiki::WS::Alias::Post(cfg => $self);

	my $handler = new Xyzzy::ReST(cfg => $self,
		handler => new UvT::Kiki::UI::Main(cfg => $self),
		generic => {
			search => new UvT::Kiki::WS::Search(cfg => $self),
			domains => new UvT::Kiki::WS::Domains(cfg => $self),
			nonce => new UvT::Kiki::WS::Nonce(cfg => $self),
			export => new UvT::Kiki::UI::Export(cfg => $self),
			alias => new Xyzzy::Method(methods => {
				POST => $postalias,
			})
		},
		specific => {
			alias => new Xyzzy::Method(methods => {
				DELETE => new UvT::Kiki::WS::Alias::Delete(cfg => $self),
				GET => new UvT::Kiki::WS::Alias::Get(cfg => $self),
				POST => $postalias,
			})
		},
		fallback => $static,
	);

	$handler = new UvT::Kiki::Database(cfg => $self, handler => $handler);
	$handler = new Xyzzy::Database(cfg => $self, handler => $handler);
	$handler = new UvT::Kiki::Activator(cfg => $self, handler => $handler);
	$handler = new UvT::Kiki::ACL(cfg => $self, handler => $handler);
	$handler = new UvT::Kiki::CAS(cfg => $self, handler => $handler);

	return $handler;
}

__END__

=pod

=encoding utf8

=head1 NAME

UvT::Kiki - Tilburg University specific tool to manage email aliases

=head1 Configuration options

=over

=item Languages

List of languages codes that are supported. Correspond with directories under
F</etc/kiki/stylesheets> and F</etc/kiki/content>.

=item NotificationSender

From-address for notification e-mails. May include a name. Should be valid
RFC2822-syntax.

=item NotificationRecipients

Destination addresses for notification e-mails. May include names.

=item ActivateCommand

Command that is run every time the database is modified. Use this to sync your LDAP.

=item SessionTimeout

Session timeout for CAS sessions. Use ns/us/ms/s/m/h/d/w suffixes for
nanoseconds/microseconds/milliseconds/seconds/hours/days/weeks.

=item RequestTimeout

Timeout for CSRF nonces. Syntax like SessionTimeout.

=item CASBaseURL

Base URL for the CAS server.

=item CASLoginURL

Login URL for the CAS server. Defaults to $CASBaseURL/login.

=item CASValidateURL

Ticket validation URL for the CAS server. Defaults to $CASBaseURL/validate.

=item AllowedUsers

List of CAS principal names that are allowed to log in.

=cut
