use utf8;
use strict;
use warnings FATAL => 'all';

package UvT::Kiki::CAS;

use Xyzzy::Crypto;
use UvT::Kiki::CAS::Request;
use UvT::Kiki::CAS::Document;

use Xyzzy::Handler -self;

field login_url => sub { shift->cfg->cas_login_url };
field validate_url => sub { shift->cfg->cas_validate_url };
field crypto => sub { new Xyzzy::Crypto(cfg => shift->cfg) };

sub handle {
	my $req = new UvT::Kiki::CAS::Request(ctx => shift, cfg => $self);
	return super($req, @_);
}
