use utf8;
use strict;
use warnings FATAL => 'all';

package UvT::Kiki::CAS::Config;

use Xyzzy::Util qw(parse_time);

use Xyzzy -self;

field cas_base_url => sub { die "Missing configuration value CASbaseURL\n" };
field cas_login_url => sub { shift->cas_base_url . '/login' };
field cas_validate_url => sub { shift->cas_base_url . '/validate' };

*set_casbaseurl = *cas_base_url;
*set_casloginurl = *cas_login_url;
*set_casvalidateurl = *cas_validate_url;

field session_timeout => 36000;
field request_timeout => 3600;

sub set_sessiontimeout {
	$self->session_timeout(parse_time(shift));
}

sub set_requesttimeout {
	$self->request_timeout(parse_time(shift));
}
