<?xml version="1.0" encoding="UTF-8"?>

<!--

alias        = een alternatieve naam voor één of meerdere email-adressen. Deze
               term wordt ook wel gebruikt voor geheel van naam en bestemmingen.
aliasId      = numeriek aanduiding voor een alias
destination  = de bestemming(en) die aan een alias zijn gekoppeld
destinationT = tekstveld met een of meerdere bestemmingen
destinationC = checkbox om destinationT te wissen
domain       = ieder alias bestaat binnen een of meerdere internetdomein
domains      = alle domeinen die gebruikt kunnen worden voor aliassen
summary      = korte samenvatting van een alias. Als je op een 'summary' klikt
               wordt deze automatisch uitgeklapt tot 'expanded'.
expanded     = editbaar formulier met 1 alias
foldimage    = het icoontje voor het inklappen en uitklappen van aliassen
newAlias     = een nieuwe alias toevoegen (naam + bestemmingen)
newTo        = een nieuwe bestemming voor een bestaand alias
row          = horizontale sectie van de site; bevat bv een alias of de zoek-box
column       = de site is in 4 kolommen verdeeld: 'left', 'from', 'to' en
               'right' . Iedere kolom zit in een container (containerL,
               containerF, containerT en containerR). Deze kolommen worden
               op iedere rij opnieuw aangemaakt.
userType     = er zijn drie soorten bestemmingen:
               - extern (domeinen die niet door ons worden beheerd)
               - persoonlijk (mensen binnen onze organisatie)
               - functioneel (gebonden aan taken binnen de organisatie)
-->

<xsl:transform version="1.0"
	xmlns="http://www.w3.org/1999/xhtml"
	xmlns:xhtml="http://www.w3.org/1999/xhtml"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
	xmlns:ss="http://tilburguniversity.edu/stylesheets">

	<!-- 
	<xsl:output methode="html" media-type="text/html" cdata-section-elements="script" doctype-public="-//W3C//DTD XHTML 1.1//EN" doctype-system="http://www.w3.org/TR/xhtml11/DTD/xhtml11.dtd"/>
	     niet handig bij het debuggen
	-->
	<xsl:import href="common.xsl"/>


	<!-- The domain that is used on most addresses. 
	     This name will be hidden from the output.
	-->
	<xsl:variable name="primaryDomain">uvt.nl</xsl:variable>
	<xsl:variable name="tooltip1">Geef 1 of meer bestemmingen op, gescheiden door spaties.</xsl:variable>
	
	<xsl:template match="alias" mode="title">
		<xsl:text>Mailaliasbeheer</xsl:text>
	</xsl:template>


	<xsl:template match="/alias">
		<html>
		<head>
			<!-- todo: minimize -->
			<script src="/javascript/jquery/jquery.min.js" type="text/javascript" language="javascript"/>
			<script src="/javascript/jquery-tipsy/jquery.tipsy.min.js" type="text/javascript" language="javascript"/>
			<script src="/static/alias.js" type="text/javascript" language="javascript" />
			<link rel="stylesheet" href="/static/alias.css" type="text/css"  /> 
		</head>
		<body>

		<xsl:call-template name="search"/>
		<xsl:call-template name="kopjerow"/>
		<xsl:call-template name="explanationrow"/>
		<xsl:apply-templates select="alias"/> 
		<xsl:call-template name="newAliasrow"/>
		<xsl:call-template name="log"/>
		</body>
		</html>
	</xsl:template>

	<!-- kolomkopjes -->
	<xsl:template name="kopjerow">
		<div id="columnNames" class="row kopje">
			<div id="containerR"> <div id="containerT"> <div id="containerF"> <div id="containerL">
					<div class="column left">
						&#160;	
					</div>
					<div class="column from">
						From
					</div>
					<div class="column to">
						To
					</div>
					<div class="column right">
						&#160;	
					</div>
			</div> </div> </div> </div>
		</div>
	</xsl:template>

	<!-- beetje uitleg -->
	<xsl:template name="explanationrow">
		<div class="row kopje">
			<div id="containerR"> <div id="containerT"> <div id="containerF"> <div id="containerL">
				<div class="column left">
					&#160;	
				</div>
				<div class="column from">
					<xsl:text>Adressen die naar deze alias toe wijzen</xsl:text>
				</div>
				<div class="column to">
					<xsl:text>Adressen waar dit alias naar toe gaat.</xsl:text>
				</div>
				<div class="column right">
					&#160;	
				</div>
			</div> </div> </div> </div>
		</div>
	</xsl:template>

	<!-- deze row gaat over het aanmaken van een helemaal nieuwe alias -->
	<xsl:template name="newAliasrow">
		<xsl:variable name="aliasId" select="'new'"/>

		<div class="entry">
		<form class="newAliasAction" action="">
			<div id="containerR"> <div id="containerT"> <div id="containerF"> <div id="containerL">
			<!-- short version -->
			<div class="row summary" onclick="ToggleBox('alias{$aliasId}');">
				<div class="column left">
					<xsl:call-template name="foldImages">
						<xsl:with-param name="aliasId" select="$aliasId" />
					</xsl:call-template>
					new:
				</div>
				<div class="column from">
					<input type="text" name="newFrom" />
				</div>
				<div class="column to">
					<input type="text" name="newTo" class="tooltip" title="{$tooltip1}"/>
				</div>
				<div class="column right">
					<button type="button" target="addAlias">add</button>
				</div>
			</div>
			<!-- expanded information -->
			<div class="row expanded newAlias alias{$aliasId}">
				<div class="column left">
					&#160;	
				</div>
				<div class="column from">
					<xsl:apply-templates select="/alias/domains"/>
				</div>
				<div class="column to">
					<ul class="destinations">
						<xsl:call-template name="newTo"/>
						<xsl:call-template name="newTo"/>
						<xsl:call-template name="newTo"/>
					</ul>
				</div>
				<div class="column right">
					&#160;	
				</div>
			</div>
			</div> </div> </div> </div>
		</form>
		</div> <!-- entry -->
	</xsl:template>


	<xsl:template name='newTo'>
		<li>
			<input type="checkbox" disabled="disabled" title="{$tooltip1}"/>
			<input type="text" name="newTo" />
		</li>
	</xsl:template>

	<!-- one alias. This is the primary object.
	     It creates two divs:
             - a summary of the alias
             - a hidden row with the rest of the information
	-->
	<xsl:template match="/alias/alias">
		<xsl:variable name="aliasId" select="id"/>

		<div class="entry">
		<form class="editAlias" action="edit">
			<input type="hidden" class="aliasId" value="{$aliasId}" />
			<div id="containerR"> <div id="containerT"> <div id="containerF"> <div id="containerL">
	
			<!-- the summary -->
			<div class="row summary" onclick="ToggleBox('alias{$aliasId}');">
				<div class="column left">
					<xsl:call-template name="foldImages">
						<xsl:with-param name="aliasId" select="$aliasId" />
					</xsl:call-template>
				</div>
				<div class="column from">
					<strong>
						<xsl:call-template name="hideLocalDomain"/>
					</strong>
				</div>
				<div class="column to">
					<xsl:apply-templates select="destinations" mode="summary"/>
				</div>
				<div class="column right">
					<button type="button" target="?delAlias={$aliasId}">del</button>
				</div>
			</div>
			<!-- expanded information -->
			<div class="row expanded alias{$aliasId}">
				<div class="column left">
					&#160;	
					<!-- fixme: positionering sucks
					<xsl:call-template name="foldImages">
						<xsl:with-param name="aliasId" select="$aliasId" />
					</xsl:call-template>
					-->
				</div>
				<div class="column from">
					<xsl:apply-templates select="/alias/domains"/>
				</div>
				<div class="column to">
					<xsl:apply-templates select="destinations" mode="expanded">
						<xsl:with-param name="aliasId" select="$aliasId" />
					</xsl:apply-templates>
				</div>
				<div class="column right">
					<button type="submit" class="saveButton" id="saveAlias{$aliasId}" target="?saveAlias={$aliasId}">save</button>
					<button type="reset" class="resetButton" id="resetAlias{$aliasId}">reset</button>
				</div>
			</div> <!-- row expanded -->
			</div> </div> </div> </div>
		</form>
		</div> <!-- entry -->
	</xsl:template>


	<!-- list of all addresses this alias is forwarded to -->
	<xsl:template match="/alias/alias/destinations" mode="summary">
		<xsl:apply-templates select="destination" mode="summary"/>
	</xsl:template>


	<!-- one address that this alias forwards to, summary -->
	<xsl:template match="/alias/alias/destinations/destination" mode="summary">
		<span class="user">
			<xsl:apply-templates select="." mode="userTypeImage"/>
			<xsl:call-template name="hideLocalDomain"/>
		</span>

		<!-- space seperated -->
		<xsl:if test="position() != last()">
			<xsl:text> </xsl:text>
		</xsl:if>
	</xsl:template>

	<!-- plaatje dat het type gebruiker aangeeft -->
	<xsl:template match="/alias/alias/destinations/destination" mode="userTypeImage">
		<span class="userTypeImage {type}"><!-- nop --></span>
	</xsl:template>

	<!-- list of all addresses this alias is forwarded to -->
	<xsl:template match="/alias/alias/destinations" mode="expanded">
		<xsl:param name="aliasId"/>
		<ul class="destinations">
			<xsl:apply-templates select="destination" mode="expanded">
				<xsl:with-param name="aliasId" select="$aliasId" />
			</xsl:apply-templates>
			<li>
				<input type="checkbox" name="destinationC" class="boxes{$aliasId}" />
				<input type="text" name="newTo" class="tooltip" title="{$tooltip1}"/>
			</li>
		</ul>
		<ul>
			<li>
				<input type="checkbox" name="selectAll" onclick="CheckAll('boxes{$aliasId}');" id="controllerboxes{$aliasId}" />
				<button type="button" class="delDestinationButton" target="delTo">delete</button>
				<button type="button" class="addDestinationButton" target="addTo">add</button>
			</li>
		</ul>
	</xsl:template>

	<!-- one address that this alias forwards to, expanded information -->
	<xsl:template match="/alias/alias/destinations/destination" mode="expanded">
		<xsl:param name="aliasId"/>
		<!--
		<xsl:variable name="address"> 
			<xsl:call-template name="hideLocalDomain"/>
		</xsl:variable> 
		-->
		<li>
			<input type="checkbox" name="destinationC" class="boxes{$aliasId}" />
			<input type="text" name="destinationT" value="{full}" />
			<xsl:apply-templates select="." mode="userTypeImage"/>
			&#160;	
			<xsl:if test="anr">
				anr: <xsl:value-of select="anr"/>
			</xsl:if>
		</li>
	</xsl:template>


	<!-- hide the domain if an e-mail-address is local, that is, if it ends in .uvt.nl -->
	<xsl:template name="hideLocalDomain">
		<xsl:choose>
			<xsl:when test="domain = $primaryDomain">
				<xsl:value-of select="local"/>
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="full"/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>

	<!-- hide the primary domain (uvt.nl) from the output -->
	<!--
	<xsl:template name="atSecondaryDomain">
		<xsl:if test=". != primaryDomain">
			@<xsl:value-of select="."/>
		</xsl:if>
	</xsl:template>
	-->



	<!-- list of all adresses that refer _to_ this alias -->
	<xsl:template match="/alias/alias/referrers">
		<table>
			<xsl:apply-templates select="referrer"/>
		</table>
	</xsl:template>


	<!-- selectable list of all managed domains for use in forms-->
	<xsl:template match="/alias/domains">
		<select multiple="1">
			<xsl:for-each select="domain">
				<xsl:sort select="name"/>
				<xsl:apply-templates select="."/>
			</xsl:for-each>
		</select>
	</xsl:template>

	<!-- one domain and its aliases for use in select -->
	<xsl:template match="/alias/domains/domain">
		<!--		<xsl:variable name="id"> <xsl:value-of select="id"/> </xsl:variable> -->
		<xsl:choose>
			<xsl:when test="contains(/alias/alias/domains, name)">
				<option value="{id}" selected="selected"> <xsl:call-template name="aDomain"/> </option>
			</xsl:when>
			<xsl:otherwise>
				<option value="{id}"> <xsl:call-template name="aDomain"/> </option>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>

	<!-- Create a list of a domain and its aliases 
	     eg: uvt.nl (tilburguniversity.edu tiu.nl ...)
	     -->
	<xsl:template name="aDomain">
		<xsl:value-of select="name"/>

		<!-- if there are other domains -->
		<xsl:if test="count(names/name) &gt; 1">
			(<xsl:for-each select="names/name">
				<!-- if this is not the primary domain -->
				<xsl:if test=". != ../../name">
					<xsl:value-of select="."/>
					<!-- space seperated -->
					<xsl:if test="position() != last()">
						<xsl:text> </xsl:text>
					</xsl:if>
				</xsl:if>
			</xsl:for-each>)
		</xsl:if>
	</xsl:template>


	<!-- spacer -->
	<xsl:template name="spacer">
		<div id="containerR"> <div id="containerT"> <div id="containerF"> <div id="containerL">
			<div class="row">
				<div class="column left"> <hr/> </div>
				<div class="column from"> <hr/> </div>
				<div class="column to"> <hr/> </div>
				<div class="column right"> <hr/> </div>
			</div>
		</div> </div> </div> </div>
	</xsl:template>

	<xsl:template name="search" match="search">
		<div id="searchAlias">
			<div class="row">
				<form action="search" method="get">
					
					<!-- HTML sucks.
					 De volgorde van onderstaande elementen wordt met CSS omgedraaid.
					 Eerst wordt het tekstveld getoond, dan pas de knop. 
					 Deze truuk is nodig om het textveld alle over de volledige breedte te krijgen
					 maar toch ruimte te laten voor de knop.
					-->

					<button id="searchSubmitButton" type="submit">Zoek</button>
					<span id="searchSpan"><input id="searchTextInput" type="text" name="q" value="{query}"/></span>
				</form>
			</div> <!--row -->
		</div> <!--searchAlias -->
	</xsl:template>

	<!--
	Log of recent actions.
	-->
	<xsl:template name="log" match="log">
		<div id="log">
			<h3>Recent actions</h3>
			<ul>
				<li>
					<button type="submit">Undo</button>
					<xsl:text>konijn@uvt.nl: new alias</xsl:text>
				</li>
				<li>
					<button type="submit">Undo</button>
					<xsl:text>rund@tilburguniversity.edu: kalf@gmail.com added</xsl:text>
				</li>
				<li>
					<button type="submit">Undo</button>
					<xsl:text>rund@tilburguniversity.edu: calf@gmail.com deleted</xsl:text>
				</li>
				<li>
					<button type="submit">Undo</button>
					<xsl:text>rund@tilburguniversity.edu: calf@gmail.com added</xsl:text>
				</li>
				<li>
					<button type="submit">Undo</button>
					<xsl:text>schaap@tilburguniversity.edu: lam@gmail.com added</xsl:text>
				</li>
				<li>
					<button type="submit">Undo</button>
					<xsl:text>olifant@tilburguniversity.edu: deleted alias</xsl:text>
				</li>
			</ul>
		</div>
	</xsl:template>
	
	<!--
	Icons for the "expand" and "collopse" actions.
	-->
	<xsl:template name="foldImages">
		<xsl:param name="aliasId"/>
		<div class="foldImages">
			<img	src="static/expand.png" 
				alt="view"
				class="foldimg foldimgalias{$aliasId}"
			/>
			<img	src="static/collapse.png" 
				alt="view"
				class="foldimg foldimgalias{$aliasId}"
				style="display: none"
			/>
		</div>
	</xsl:template>

</xsl:transform>
