<?xml version="1.0" encoding="UTF-8"?>

<xsl:stylesheet version="1.0"
		xmlns="http://www.w3.org/1999/xhtml"
		xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

	<xsl:import href="common.xsl"/>

	<!-- browse, create, modify, delete entries -->
	<xsl:template match="manage" mode="title">
		<xsl:text>Maak een nieuwe URL aan</xsl:text>
	</xsl:template>

	<xsl:template match="manage[mode='edit']" mode="title">
		<xsl:text>Pas een URL aan</xsl:text>
	</xsl:template>

	<xsl:template match="manage[mode='remove' and stage='input']" mode="title">
		<xsl:text>URL verwijderen</xsl:text>
	</xsl:template>

	<xsl:template match="manage">
		<form action="." method="post">
			<table>
				<tr>
					<th>Naam:</th>
					<td><input name="name" type="text" size="15" value="{random}"/></td>
				</tr>
				<tr>
					<th>URL:</th>
					<td><input name="url" type="text" size="60"/></td>
				</tr>
				<tr>
					<th>Privé:</th>
					<td><input name="private" type="checkbox"/></td>
				</tr>
			</table>
			<p><button type="submit" name="submit" value="1"><strong>Voeg toe</strong></button></p>
			<input type="hidden" name="nonce" value="{nonce}"/>
		</form>

		<xsl:apply-templates select="urls"/>
	</xsl:template>

	<xsl:template match="manage[stage='done' and mode!='remove']">
		<h2>Je URL is opgeslagen</h2>
		<p>De verkorte URL is <strong><xsl:value-of select="$script_url"/>/<xsl:value-of select="entry/name"/></strong> (<a href="{entry/name}">link</a>).</p>
		<p>Deze URL stuurt je door naar <xsl:value-of select="entry/url"/>.</p>
		<p><a href=".">Voeg nog een URL toe.</a></p>
	</xsl:template>

	<xsl:template match="manage[stage='input' and mode='remove']">
		<p>De URL is niet verwijderd.</p>
		<xsl:apply-templates select="feedback"/>
		<p><a href=".">Terug naar het overzicht.</a></p>
	</xsl:template>

	<xsl:template match="manage[stage='input' and entry]">
		<form action="." method="post">
			<table>
				<tr>
					<th>Naam:</th>
					<td><input name="name" type="text" size="15" value="{entry/name}"/></td>
				</tr>
				<tr>
					<th>URL:</th>
					<td><input name="url" type="text" size="60" value="{entry/url}"/></td>
				</tr>
				<tr>
					<th>Privé:</th>
					<td>
						<input name="private" type="checkbox"/>
						<xsl:if test="not(entry/private='false')">
							<xsl:attribute name="checked">checked</xsl:attribute>
						</xsl:if>
					</td>
				</tr>
			</table>
			<xsl:apply-templates select="feedback"/>
			<p><button type="submit" name="submit" value="1">
				<xsl:choose>
					<xsl:when test="mode='edit'">
						<strong>Pas aan</strong>
					</xsl:when>
					<xsl:otherwise>
						<strong>Voeg toe</strong>
					</xsl:otherwise>
				</xsl:choose>
			</button></p>
			<xsl:apply-templates select="edit/num"/>
			<input type="hidden" name="nonce" value="{nonce}"/>
		</form>
	</xsl:template>

	<xsl:template match="edit/num">
		<input type="hidden" name="edit" value="{.}"/>
	</xsl:template>

	<xsl:template match="feedback">
		<xsl:apply-templates/>
	</xsl:template>

	<xsl:template match="feedback/name-tweaked">
		<p>⚠ De opgegeven naam is enigszins aangepast. Controleer of de voorgestelde naam voldoet.</p>
	</xsl:template>

	<xsl:template match="feedback/edit-notyours">
		<p>⚠ De ingang die je probeert te bewerken, is van iemand anders. Je kunt wel een nieuwe ingang toevoegen.</p>
	</xsl:template>

	<xsl:template match="feedback/edit-deleted">
		<p>⚠ De ingang die je probeert te bewerken, bestaat niet meer. Je kunt wel een nieuwe ingang toevoegen.</p>
	</xsl:template>

	<xsl:template match="feedback/edit-overwrite">
		<p>⚠ De opgegeven naam bestaat al.
		<form action="." method="post" style="display: inline">
			<input type="hidden" name="name" value="{/manage/entry/name}"/>
			<input type="hidden" name="url" value="{/manage/entry/url}"/>
			<input type="hidden" name="private" value="{/manage/entry/private}"/>
			<button type="submit">Nieuw toevoegen</button>
		</form></p>
	</xsl:template>

	<xsl:template match="feedback/name-exists">
		<p>⚠ De naam ‘<xsl:value-of select="/manage/entry/name"/>’ bestaat al.
		<form action="." method="post" style="display: inline">
			<input type="hidden" name="edit" value="{num}"/>
			<input type="hidden" name="name" value="{/manage/entry/name}"/>
			<input type="hidden" name="url" value="{/manage/entry/url}"/>
			<input type="hidden" name="private" value="{/manage/entry/private}"/>
			<button type="submit">Bewerken</button>
		</form></p>
	</xsl:template>

	<xsl:template match="feedback/name-notyours">
		<p>⚠ De opgegeven naam bestaat al. Kies een andere naam.</p>
	</xsl:template>

	<xsl:template match="feedback/name-invalid">
		<p>⚠ De opgegeven naam is helaas niet mogelijk. Kies een andere naam.</p>
	</xsl:template>

	<xsl:template match="feedback/name-missing">
		<p>⚠ Kies een naam.</p>
	</xsl:template>

	<xsl:template match="feedback/url-tweaked">
		<p>⚠ De opgegeven URL is enigszins aangepast. <a href="{/manage/entry/url}" target="_new">Controleer of de URL het nog doet.</a></p>
	</xsl:template>

	<xsl:template match="feedback/url-invalid">
		<p>⚠ De opgegeven URL kan helaas niet gebruikt worden.</p>
	</xsl:template>

	<xsl:template match="feedback/url-missing">
		<p>⚠ Geef een URL op.</p>
	</xsl:template>

	<xsl:template match="feedback/delete-notyours">
		<p>⚠ De opgegeven ingang is van iemand anders.</p>
	</xsl:template>

	<xsl:template match="feedback/delete-nonexistent">
		<p>⚠ De opgegeven ingang bestond niet (meer).</p>
	</xsl:template>

	<xsl:template match="urls">
		<xsl:if test="url">
			<h2>Beheer je bestaande URLs</h2>
			<table>
				<tr>
					<th>Naam</th>
					<th>Hits</th>
					<th>Laatste hit</th>
					<th>Privé?</th>
					<th>Bewerken</th>
					<th>Verwijderen</th>
				</tr>
				<xsl:for-each select="url">
					<xsl:sort data-type="number" select="mtime/unix"/>
					<xsl:apply-templates select="."/>
				</xsl:for-each>
			</table>
		</xsl:if>
	</xsl:template>

	<xsl:template match="url">
		<tr>
			<td><a href="{name}" title="{destination}"><xsl:value-of select="name"/></a></td>
			<td><xsl:value-of select="visits"/></td>
			<td><xsl:apply-templates select="atime"/></td>
			<td><xsl:apply-templates select="private"/></td>
			<td><form action="." method="post" style="display: inline">
				<input type="hidden" name="edit" value="{num}"/>
				<input type="hidden" name="name" value="{name}"/>
				<input type="hidden" name="url" value="{destination}"/>
				<input type="hidden" name="private" value="{private}"/>
				<button type="submit">Bewerken</button>
			</form></td>
			<td><form action="." method="post" style="display: inline">
				<input type="hidden" name="nonce" value="{../../nonce}"/>
				<input type="hidden" name="remove" value="{name}"/>
				<button type="submit" name="submit" value="1">Verwijderen</button>
			</form></td>
		</tr>
	</xsl:template>

	<xsl:template match="atime|mtime|ctime">—</xsl:template>

	<xsl:template match="atime[unix]|mtime[unix]|ctime[unix]">
		<xsl:value-of select="year"/>–<xsl:value-of select="month"/>–<xsl:value-of select="day"/>
		<xsl:text>&#160;</xsl:text>
		<xsl:value-of select="hour"/>:<xsl:value-of select="minute"/>:<xsl:value-of select="second"/>
	</xsl:template>


	<xsl:template match="private[.='true']">
		<xsl:text>Ja</xsl:text>
	</xsl:template>

	<xsl:template match="private[.='false']">
		<xsl:text>Nee</xsl:text>
	</xsl:template>
</xsl:stylesheet>
