use utf8;
use strict;
use warnings FATAL => 'all';

package KUB::Aselect::Document;

use KUB::Document -self;

sub build {
	$self->setDocumentElement($self->construct(aselect => [url => $self->req->aselect_url]));
}

sub response {
	my $req = $self->req;
	my $res = super;
	$res->status(302);
	$res->setheader(Location => $req->aselect_url);
	if($req->cur_aselect_ticket ne (my $ticket = $req->new_aselect_ticket)) {
		my $cookie = $self->bakecookie(aselect => $ticket);
		$cookie->setparameter(HttpOnly => 1);
		$res->setcookie($cookie);
	}
	return $res;
}
