<?xml version="1.0" encoding="UTF-8"?>

<xsl:stylesheet version="1.0"
		xmlns="http://www.w3.org/1999/xhtml"
		xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

	<xsl:import href="common.xsl"/>

	<xsl:template match="rid" mode="title">
		<xsl:text>Invalid rid parameter</xsl:text>
	</xsl:template>

	<xsl:template match="rid">
		<p>Your login request may have expired. Please return to the application and retry the login.</p>
		<p>If that doesn't help, contact your helpdesk or the maintainer of the application.</p>
	</xsl:template>

	<xsl:template match="service" mode="title">
		<xsl:text>Invalid service parameter</xsl:text>
	</xsl:template>

	<xsl:template match="service">
		<p>There's a problem with the application you are trying to log in to.</p>
		<p>Please contact your helpdesk or the maintainer of the application.</p>
	</xsl:template>

	<xsl:template match="backend" mode="title">
		<xsl:text>Trouble contacting the authentication backend</xsl:text>
	</xsl:template>

	<xsl:template match="backend">
		<p>There's a problem with a backend system of the Single Sign On server.</p>
		<p>There is little you can do about this except retry after a few minutes. Please contact your helpdesk if the problem persists.</p>
		<p>Apologies for the inconvenience.</p>
	</xsl:template>

	<xsl:template match="app_id" mode="title">
		<xsl:text>Application ID unknown</xsl:text>
	</xsl:template>

	<xsl:template match="app_id">
		<p>The application ID ‘<xsl:value-of select="app_id"/>’ does not exist.</p>
	</xsl:template>

	<xsl:template match="internal" mode="title">
		<xsl:text>A problem occurred inside the Single Sign On server</xsl:text>
	</xsl:template>

	<xsl:template match="internal">
		<p>There appears to be a problem inside the Single Sign On server.</p>
		<p>There is little you can do about this except retry after a few minutes. Please contact your helpdesk if the problem persists.</p>
		<p>Apologies for the inconvenience.</p>
	</xsl:template>
</xsl:stylesheet>
