use utf8;
use strict;
use warnings FATAL => 'all';

package KUB::Redirect::Request;

use KUB::Request -self;

field name => sub {
	my $self = shift;
	my $p = $self->path_components;
	die "internal error" unless @$p;
	return join('/', @$p);
};

field url => sub {
	my $self = shift;
	my $name = $self->name;
	return undef unless defined $name;

	my $db = $self->db;
	my $q = $db->prepare_cached('UPDATE urls SET atime = CURRENT_TIMESTAMP, visits = visits + 1 WHERE name = ? RETURNING destination, private');
	$q->execute($name);
	my $res = $q->fetchrow_arrayref;
	$q->finish;

	return undef unless $res && @$res;

	my ($url, $private) = @$res;

	$self->aselect_force_login if $private;

	return $url;
};
