use utf8;
use strict;
use warnings FATAL => 'all';

package KUB::Aselect::Request;

use Aselect::Client;
use Aselect::Util qw(aselect_split);

use KUB::Request -self;

field crypto => sub { shift->cfg->crypto };

field cur_aselect_ticket => sub {
	my $self = shift;
	if(my $ticket = $self->cookie('aselect')) {
		my ($uid, $org) = eval { aselect_verify_ticket($ticket) };
		if($@) {
			warn "aselect_verify_ticket: $@";
		} else {
			$self->aselect_login($uid);
			return $ticket;
		}
	}
	return '';
};

field new_aselect_ticket => sub { shift->cur_aselect_ticket };

sub aselect_self_url {
	my $url = $self->self_url;
	$url =~ s/^http:/https:/i;
	$url =~ s/([?&;])aselect_credentials=[^&;#]*[&;]?/$1/;
	$url =~ s/([?&;])rid=[^&;#]*\&?/$1/;
	$url =~ s/([?&;])a-select-server=[^&;#]*[&;]?/$1/;
	$url =~ s/\?$//;
	return $url;
}

field aselect_url => \&aselect_self_url;

param rid;
param aselect_credentials => sub {
	return undef unless defined;
	my $self = shift;

	my $cred = $_;
	my $rid = $self->rid;
	die $self->error('aselect_rid') unless defined $rid;
	my $ticket = eval { aselect_verify_credentials($rid, $cred) };
	if($@) {
		warn "aselect_verify_credentials: $@";
	} else {
		my %ticket = aselect_split($ticket);
		$self->aselect_login($ticket{uid});
		$self->new_aselect_ticket($ticket);
	}
	$_ = 1;
};

field aselect_login => sub {
	my $self = shift;

	if(my $ticket = $self->cookie('aselect')) {
		my ($uid, $org) = eval { aselect_verify_ticket($ticket) };
		return $uid unless $@;
		warn "aselect_verify_ticket: $@";
	}

	return undef;
};

sub aselect_force_login {
	if(my $uid = $self->aselect_login) {
		return $uid;
	}
	my $cfg = $self->cfg;
	my $sso = aselect_authenticate($cfg->aselect_id, $self->aselect_self_url);
	$self->aselect_url($sso);
	my $doc = new KUB::Aselect::Document(req => $self);
	die $doc->response;
}

param nonce => sub {
	my $self = shift;
	my $ticket = $self->cur_aselect_ticket;
	if($ticket eq '') {
		$self->aselect_force_login;
		confess("internal error: unable to acquire valid ticket");
	}
	my $noise = 'n'.$self->remote_addr.$;.$ticket;
	$_ = eval { $self->crypto->check_token($noise, $_, $self->cfg->nonce_expiry); 1 };
};

sub create_nonce {
	my $ticket = $self->new_aselect_ticket;
	if($ticket eq '') {
		$self->aselect_force_login;
		confess("internal error: unable to acquire valid ticket");
	}
	my $noise = 'n'.$self->remote_addr.$;.$ticket;
	return scalar $self->crypto->create_token($noise);
}
