use utf8;
use strict;
use warnings FATAL => 'all';

package KUB::Config;

use Xyzzy::Util;
use KUB::URL qw(valid_fqdn);

use Xyzzy -self;

field nonce_expiry => 300;
sub set_nonceexpiry { $self->nonce_expiry(parse_time(@_)) }

field languages => ['en'];
sub set_languages { $self->languages([split(' ', $_[0])]) }

field httpsdomain => undef;
sub set_httpsdomain {
	my $domain = lc(shift);
	die "Invalid HTTPS domain '$domain'\n"
		unless valid_fqdn($domain);
	$self->httpsdomain($domain);
}
