use utf8;
use strict;
use warnings FATAL => 'all';

package KUB::Redirect;

use KUB::Redirect::Request;
use KUB::Redirect::Document;

use Xyzzy::Handler -self;

field fallback;

sub handle {
	my $req = new KUB::Redirect::Request(ctx => shift, cfg => $self);
	return $self->fallback->handle($req)
		unless $req->url;
	my $doc = new KUB::Redirect::Document(req => $req);
	return $doc->response;
}
