use utf8;
use strict;
use warnings FATAL => 'all';

package KUB::Request::Error;

use KUB::Document -self;

field type;
field args;

sub build {
	my $root = $self->construct('error', [code => $self->type]);
	$self->setDocumentElement($root);
	my $args = $self->args;
	if(%$args) {
		my $arglist = $self->construct('args');
		while(my ($key, $val) = each(%$args)) {
			$arglist->appendChild($self->construct($key, "$val"));
		}
		$root->appendChild($arglist);
	}
}
