use utf8;
use strict;
use warnings FATAL => 'all';

package KUB::URL;

use Exporter qw(import);
use Encode qw(_utf8_off);

our @EXPORT = qw(normalize_url valid_http_url valid_host valid_fqdn $host $fqdn);

our $host = qr{(?:xn--)?[a-z0-9]+(?:-[a-z0-9]+)*}i;
our $fqdn = qr{$host(?:\.$host)+};

sub normalize_url {
	my $url = shift;
	return undef unless defined $url;
	_utf8_off($url);
	$url =~ s/^\s+|\s+$//g;
	return ''
		if $url eq '';
	$url = 'http://'.$url
		if $url =~ m{^$fqdn(?:[/?#]|$)};
	$url =~ s{^([^/:.]+://$fqdn(?:[/?#]|$))}{lc($1)}egi;
	$url =~ s{([^!-~])}{sprintf('%%%02X', ord($1))}eg;
	return $url;
}

sub valid_http_url {
	my $url = shift;
	return undef unless defined $url;
	return $url =~ m{^https?://$fqdn(?:[/?#][!-~]*)?$};
};

sub valid_host {
	my $name = shift;
	return undef unless defined $name;
	return $name =~ m{^$host$}o;
};

sub valid_fqdn {
	my $name = shift;
	return undef unless defined $name;
	return $name =~ m{^$fqdn$}o;
};

1;
