#  Heavily modified by Anton Sluijtman, 2003-2004
#
#  Copyright (c) 2000 by Ron Wantock. All rights reserved.
#  This program is free software; you can redistribute it and/or modify
#  it under the same terms as Perl itself.


package Errorlog::TeeOutput;
use strict;
use Carp;

require Exporter;

use vars qw(@ISA @EXPORT);
@ISA = ('Exporter');
@EXPORT = ('openTee', 'closeTee','leadingTee');


sub new {
	my $self=bless {},shift;
	warn "what if i do not HAVE a new?, fooling the tester \n";
	warn "NEVER CALL ME PLEASE, I AM A FAKE \n";
	return $self;
}

sub openTee {
    # anton:  I can only determine wether the
    # source filehandle ($_[0]) is eq to *STDERR at this location.
    # After the tie is made the test always fails.
    # so just save the testresult for later usage.

    my $setsignal=0;
    $setsignal = 1 if ($_[0] eq *STDERR) ;

    #tie the handler
    my $tiedhandle=tie $_[0] , 'Errorlog::TeeOutput::NewTee', @_[1..$#_];

    carp "tie failed: $!" unless $tiedhandle;

    # react on the test later
    $tiedhandle->setsignal() if $setsignal;
}


sub closeTee {
	untie $_[0];
}

1;

#-------------------------------------------------------------

package Errorlog::TeeOutput::NewTee;
use strict;
use Symbol;
use Carp;

sub TIEHANDLE {
	my $pkg = shift;
	my $self ;
	my @params = @_;

	foreach my $param (@params) {
		my $fh = gensym();

		if (ref(\$param) eq 'GLOB') {
			open($fh, ">>&$param") or do {
				carp "Could not open &$param: $!";
				return 0;
			};
		}
		elsif (ref ($param) eq 'HASH') {
			foreach my $key (keys (%$param)) {
				if ($key eq 'callback') {
					$self->{callback}=$param->{callback};
					next;
				} elsif ($key eq 'syslog') {
					$self->{filehandles}->{syslog}->{stderr}=0;
					$self->{filehandles}->{syslog}->{value}='syslog';
					next;
				} elsif ($key eq 'logbuffer') {
					$self->{filehandles}->{logbuffer}->{stderr}=0;
					$self->{filehandles}->{logbuffer}->{value}='logbuffer';
					next;
				} else {
					carp "Invalid key in TIEHANDLE config hash: $key, valid keys are: 'callback' and 'syslog'";
					next;
				}
			}
			next;
		} else {
			# it's a FILEHANDLE
			#
			$param =~ s/^>>// ;
			open($fh, ">>$param") or do {
				carp "Could not open $param: $!";
				return 0;
			};
		}

		select((select($fh), $|=1)[0]);
		$self->{filehandles}->{"$fh"}->{stderr} = ($param eq *STDERR);
		$self->{filehandles}->{"$fh"}->{value} = $fh;

	}

	$self->{myprint} = sub {print @_};
	$self->{myprintf}= sub {printf @_};

	bless $self, $pkg;
	return $self;
}


sub PRINT {
	my $self = shift;
	$self->myprint("myprint",@_);
}

sub PRINTF {
	my $self = shift;
	$self->myprint("myprintf",@_);
}



sub myprint {
	my ($self, $fun,@string) = @_;

	my $key = '';
	my $oldWarnSig = $SIG{__WARN__};
	$SIG{__WARN__} = sub { print STDERR Carp::shortmess(@_); };

	foreach $key (keys(%{$self->{filehandles}})) {
#    my $mycount=0;
		my $fh = $self->{filehandles}->{$key}->{value};

		if ($self->{callback}) {
			my $stderr=$self->{filehandles}->{$key}->{stderr};

			# call the optional callbackfunction, with extra
			# parameter to let it determine wheter the handler
			# is stderr. if ($fh eq *STDERR) just wont work here.
			# "Undefined value assigned to typeglob"
			#
#        print $fh "$$ mycount is: $mycount @string";
#	$mycount++;
			unless (&{$self->{callback}}($fh,$stderr,@string)) {
				$SIG{__WARN__} = $oldWarnSig;
				return 0;
			}
		} else {
			#call the original print/printf
			unless (&{$self->{$fun}}($fh, @string)) {
				$SIG{__WARN__} = $oldWarnSig;
				return 0;
			}
		}
	}
	$SIG{__WARN__} = $oldWarnSig;
	1;
}


sub resetsignal {
	my $self = shift;

	# reset handlers only if needed
	return unless (defined ($self->{'handlers'}));

	$SIG{__WARN__} = 'DEFAULT' ;
	$SIG{__DIE__} = 'DEFAULT' ;

	delete $self->{'handlers'};
}

sub setsignal {
	my $self = shift;

	# set the handlers only once, not realy necessary,
	# because it is called only once
	return if (defined ($self->{'handlers'}));

	$self->{'sigset'}=1;

#  $SIG{__DIE__} = sub { print STDERR @_; };
	$SIG{__WARN__} = sub { print STDERR @_; };
}



# added the fetch to fix a bug that arrises when you try to tee
# STDERR and STDOUT both to the same file at the same time.
# It doen't do anything, but the module dies without it.
sub FETCH {
}

sub DESTROY
{
	my ($self) = @_;

	$self->resetsignal();

	foreach my $key (keys(%{$self->{filehandles}})) {
		close ($self->{filehandles}->{"$key"}->{value});
	}
}
42;
