use strict;
use warnings FATAL => 'all';

package UvT::NOC::InfraStructure::AccessPointList;

use Clarity -base;

use UvT::NOC::InfraStructure::AccessPoint;

field aps => {};

sub addAccessPoint
{ 
	my ($self, $ap) = @_;

	return unless defined $ap;

	if ($self->hasAccessPoint($ap))
	{
		warn("### WARNING : Access point '" . $ap->name . "' already exists in list! Access point not added!");
		return;
	}

	$self->aps->{$ap->name} = $ap;
}

sub hasAccessPoint
{
	my ($self, $ap) = @_;

	return defined $self->getAccessPointByName($ap->name);
}

sub getAccessPointByName
{
	my ($self, $name) = @_;

	return unless defined $name;
	return $self->aps->{$name};
}

sub getAccessPointByID
{
	my ($self, $id) = @_;

	if (defined($id))
	{
		foreach my $ap ($self->getAccessPoints())
		{
			if ($ap->id eq $id) { return $ap };
		}
	}
}

sub getAccessPointByMACAddress
{
        my ($self, $macaddress) = @_;

        if (defined($macaddress))
        {
                foreach my $ap ($self->getAccessPoints())
                {
                        if ($ap->mac eq $macaddress) { return $ap };
                }
        }
}

sub getAccessPoints
{
	my ($self) = @_;
	
	return values %{self->aps};
}

sub removeAccessPoint
{
	my ($self, $ap) = @_;

	return unless defined $ap;

	my $name = ref $ap ? $ap->name : $ap;

	delete $self->aps->{$name};
}

sub removeAllAccessPoints
{
	my ($self) = @_;

	delete $self->{aps};
}

sub size
{
	my ($self) = @_;

	return scalar keys %{$self->aps};
}

1;
