# $Id$
# $URL$

use strict;
use warnings FATAL => 'all';

package UvT::NOC::MacRegistration::UvTRegistration;

use Clarity -base;

field mac;
field department;
field vlanId;
field vlanCode;
field vlanName;
field hostname;
field username;
field description;
field trackingData;

sub new
{
	my($class, $mac, $department, $vlanId, $vlanCode, $vlanName, $hostname, $username, $description) = @_;

	return super(
				mac => $mac,
				department => $department,
				vlanId => $vlanId,
				vlanCode => $vlanCode,
				vlanName => $vlanName,
				hostname => $hostname,
				username => $username,
				description => $description,
				trackingData => undef,
	);
}

sub toString
{
	my ($self) = @_;

	return "mac=" . $self->mac . ", department=" . $self->department . ", vlanId=" . $self->vlanId . ", vlanCode=" . $self->vlanCode . ", vlanName=" . $self->vlanName . ", hostname=" . $self->hostname . ", username=" . $self->username;
}

sub toPipedString
{
	my ($self, $prefix) = @_;

	my $mac = $self->mac;							$mac =~ s/..\K(?=.)/-/g;
	my $department = $self->department;
	my $vlanId = $self->vlanId;
	my $hostname = $self->hostname;
	my $username = $self->username;
	my $description = $self->description;

	return (defined($prefix) ? $prefix . " " : "") . "$mac|$department|$vlanId|$hostname|$username|$description";
}

use overload '""' => \&toString;

1;
