# $Id$
# $URL$

use strict;
use warnings FATAL => 'all';

package UvT::NOC::MacRegistration::WMBRegList;

use UvT::NOC::MacRegistration::WMBAddress;
use UvT::NOC::MacRegistration::WMBRegistration;

use Clarity -base;

use constant false => 0;
use constant true  => 1;

field addresses => {};

sub addRegistration
{
	my ($self, $street, $number, $name, $mac1, $mac2, $regDate, $vlanName) = @_;

	if (ref $name)
	{
		$self->addRegistrationObject($street, $number, $name);
	}
	else
	{
		my $registration = new UvT::NOC::MacRegistration::WMBRegistration($name, $mac1, $mac2, $regDate, $vlanName);
		$self->addRegistrationObject($street, $number, $registration);
	}
}

sub addRegistrationObject
{
	my ($self, $street, $number, $registration) = @_;

	unless ($self->hasAddress($street, $number))
	{
		my $newAddress = new UvT::NOC::MacRegistration::WMBAddress($street, $number);
		$self->addAddress($newAddress);
	}
	# adddress exists now

	# check registrations
	if ($self->hasMACAddress($registration->mac1))
	{
		warn("### Warning : Duplicate mac address detected : " . $registration->mac1 . " ! MAC address not added!");
		return;
	}
	if ($self->hasMACAddress($registration->mac2)) 
	{
		warn("### Warning : Duplicate mac address detected : " . $registration->mac1 . "! MAC address not added!");
		return;
	}

	# add registration
	my $newRegistration = new UvT::NOC::MacRegistration::WMBRegistration($registration->name, $registration->mac1, $registration->mac2, $registration->regDate, $registration->vlanName);
	$self->getAddress($street, $number)->addRegistration($newRegistration);
}

sub addRegistrations
{
	my ($self, $street, $number, @registrations) = @_;

	unless ($self->hasAddress($street, $number))
	{
		my $newAddress = new UvT::NOC::MacRegistration::WMBAddress($street, $number);
		$self->addAddress($newAddress);
	}

	$self->getAddress($street, $number)->addRegistrations(@registrations);
}

sub addAddress
{
	my ($self, $address) = @_;

	return unless defined $address;

	if ($self->hasAddress($address->street, $address->number))
	{
		warn("### Warning : WMB Address 'street=" . $address->street . ", number=" . $address->number . "' already exists in WMBRegList! Address not added!");
		return;
	}

	$self->addresses->{$address->street . " " . $address->number} = $address;
}

sub hasAddress
{
	my ($self, $street, $number) = @_;

	return $self->getAddress($street, $number);
}

sub getAddress
{
	my ($self, $street, $number) = @_;

        if (defined($street) && defined($number))
        {
                foreach my $address ($self->getAddresses())
                {
                        if ($address->street eq $street && $address->number eq $number) { return $address };
                }
        }
}

sub getAddresses
{
	my ($self) = @_;

	return values %{$self->addresses};
}

sub removeAllAddresses
{
	my ($self) = @_;

	delete $self->{addresses};
}

sub countWMBRegistrations
{
        my ($self) = @_;

        my $nRegistrations = 0;

        my @addresses = $self->getAddresses();
        for my $i (0..$#addresses)
        {
                $nRegistrations += $addresses[$i]->size();
        }

		return $nRegistrations;
}

sub hasMACAddress
{
        my ($self, $mac) = @_;

		return unless defined $mac;

        my @addresses = $self->getAddresses();
        for my $i (0..$#addresses)
        {
				if ($addresses[$i]->hasMACAddress($mac))
				{
						return defined $mac;
				}
        }
}

sub size
{
	my ($self) = @_;

	return scalar keys %{$self->addresses};
}

sub toString
{
	my($self) = @_;
	my $string = "";  #"[ ";

	my @addresses = $self->getAddresses();
	for my $i (0..$#addresses)
	{
		$string .= "address=[" . $addresses[$i]->toString() . "]" . ( $i < $#addresses ? "\n" : ""); 
	}

	#$string .= " ]";
	return $string;
}

sub toPipedString
{
	my($self) = @_;

	my $string = "";

	my @addresses = $self->getAddresses();
	for my $i (0..$#addresses)
	{
		$string .= $addresses[$i]->toPipedString();
	}

	return $string;
}

use overload '""' => \&toString;

1;

